*pinc92.do

*Last modified by JRC on 9/19/2000.

*Uses data on per-capita personal income in ca1_3msa.dta to construct a data file with that variable for each MSA in 1992.

version 10

*Clear and set memory.
clear
set memory 4m

*Load the data
insheet using ca1_3msa.prn, comma names
forvalues x=8/37{
	local y=1961+`x'
	rename v`x' y`y'
}


*Drop the first three observations, which correspond to U.S. totals
drop in 1/3

*Keep only those observations that correspond to per-captia personal income.
keep if linecode==30

*Generate an MSA code by stripping the first digit off of the variable fips.
gen temp=string(fips)
drop fips
gen fips=temp
drop temp
gen str4 msa=substr(fips,2,4)

*Generate a CMSA = indicator by stripping the last four digits off of the variable fips.
*Drop the CMSA observations.
gen str1 cmsa = substr(fips,1,1)
gen cmsadum = cond(cmsa=="8",1,0)
drop if cmsadum==1
drop cmsa cmsadum

*Generate a new variable to measure per-capita personal income, pinc.
gen pinc=y1992

*Add a variable giving the data's reference year.
gen str2 yr = "92"
label var yr "Reference Year"

*Delete those variables that will not be used.
keep msa pinc yr

*Label the remaining variables and data
label var msa "MSA/PMSA Code"
label var pinc "Per capita Personal Income, 1992"
label data "Per capita Personal Income, 1992, for MSA's/PMSA's"

notes: Original source: BEA file ca1_3msa.prn, Local area personal income, Regional Accounts data.
notes: URL: http://www.bea.doc.gov/bea/regional/data.htm
notes: Data downloaded by JRC on 9/19/2000.

*Sort the data by MSA for later linking.
sort msa

*Save the data.
save pinc92, replace
