*pdense92.do

*Last modified by JRC on 9/19/2000.

*Uses the data file cof01.dta to form the population weighted density measure, pdense.

version 10

*Clear and set memory
clear
set mem 4m


*Load in the data from cof01.dta
use ../../../CCDB_94_STATA/COF01.dta

*Keep only those observations from MSA counties.
keep if sumlev=="3"

*Drop variables that will not be used later.
drop sumlev pmsa areaname flag003-item008

*Sort the data by state and county.
sort state county

*For each county, calculate population density
gen cdense = item002/item001

*For each MSA, calculate total population
egen msapop = sum(item002), by(metro)

*Calculate the employment weighted employment density for each county, then sum them within MSA's.
gen wcdense = item002*cdense/msapop
egen pdense = sum(wcdense), by(metro)

*Drop variables that will not be used.
drop state county item001 flag001 item002 flag002 cdense msapop wcdense

*Eliminate duplicate observations for each MSA.
sort metro
quietly by metro: gen dup=cond(_N==1,0,_n)
drop if dup>1
drop dup

*Add a variable giving the data's reference year.
gen str2 yr = "92"
label var yr "Reference Year"

*Rename metro as "msa"
rename metro msa
label var msa "MSA Code"
notes msa: In original data file, the MSA code is called metro

label var pdense "Population Density (people/mile sq.), 1992"
notes pdense: Population weighted average of population density for multi-county MSA's.
notes pdense: Source: Area from Item 001 in file 1, CCDB.
notes pdense: Source: Population from Item 002 in file 1, CCDB.

label data "Population Density for MSA's, 1992"

*Sort the data by msa.
sort msa

*Save the data
save pdense92, replace
