*pctcol92.do


/* This file uses the data on college attainment in cof07.dta to construct the percentage of the MSA's population over 25 years of age with a college degree.   */

version 10

*Clear and set memory.
clear
set mem 4m

*Load the data
use ../../../CCDB_94_STATA/COF07.dta

*Throw out counties that are not in MSA's.
keep if sumlev=="3"

*Drop variables that will not be used.
drop flag064-item068 flag070-item070

*For each MSA, construct total population over age 25 in 1990.
egen pop90 = sum(item069), by(metro)

*Construct the percentage of MSA population over 25 with a college degree.
egen pctcol = sum(item069*item071/pop90), by(metro)

*Drop variables that will not be used.
drop item069 flag069 item071 flag071 state county sumlev pmsa areaname pop90

*Keep a single observation of housing unit sum.
sort metro
quietly by metro: gen dup=cond(_N==1,0,_n)
drop if dup>1
drop dup

*Add a variable giving the data's reference year.
gen str2 yr = "92"
label var yr "Reference Year"

*Rename metro as "msa"
rename metro msa
label var msa "MSA Code"
notes msa: In original data file, the MSA code is called metro

*Label the data and variables.

label data "College Attainment for MSA's, 1990"
label var pctcol "Pct. of Population older than 25 with College Degree, 1990"
notes pctcol: Source, Persons 25 years or older, Percent w/ Bachelor's Degree or Higher, 1990 (Item 071), 1994 CCDB.
notes pctcol: Weighted average across counties using persons 25 years or older as weights (Item 069), 1994 CCDB.

*Sort by MSA.
sort msa

*Save the data.
save pctcol92, replace

