*pctblk92.do

/*
*This file uses the data on Black population in cof02.dta and the data on total population in cof01.dta to construct the percentage of each MSA's 1990 population that is Black.
*/

version 10

*Clear and set memory.
clear
set mem 4m

*Change the working directory and load the data.

use ../../../CCDB_94_STATA/COF02.dta

*Throw out counties that are not in MSA's.
keep if sumlev=="3"

*Drop variables that will not be used.
drop flag009-item009 flag011-item024x

*Join with cof01.
joinby state county using ../../../CCDB_94_STATA/COF01.dta

*Drop variables that will not be used
drop flag001-item004 flag006-item008

*For each MSA, construct population and black population in 1990.
egen pop90 = sum(item005), by(metro)
egen bpop90 = sum(item010), by(metro)

*Form the percentage of MSA population that is black.
gen pctblk = 100*bpop90/pop90

*Drop variables that will not be used.
drop item005 flag005 item010 flag010 pop90 bpop90 state county sumlev pmsa areaname

*Keep a single observation of housing unit sum.
sort metro
quietly by metro: gen dup=cond(_N==1,0,_n)
drop if dup>1
drop dup

*Add a variable giving the data's reference year.
gen str2 yr = "92"
label var yr "Reference Year"

*Rename metro as "msa"
rename metro msa
label var msa "MSA Code"
notes msa: In original data file, the MSA code is called metro

*Label the data and variables.

label data "Black Population Percentage for MSA's, 1990"
label var pctblk "Population Pct. Black, 1990"
notes pctblk: Source, Population by Race, Black, 1990 (Item 010) divided by Population, 1990 (Item 005), both from the 1994 CCDB
notes pctblk: All population data first summed across the MSA's constituent counties.

*Sort by MSA.
sort msa

*Save the data.
save pctblk92, replace

