*nprate92.do

*Last modified by JRC on 9/20/2000.

*Generates the data file nprate.dta from the data contained in eandp92.dta

version 10

*Load the data
use eandp92

*Rename the variables in eandp92
rename newspape name
rename sau_rate rate
rename circulat circ

*To generate a circulation-weighted average advertising rate, sum both circulation and rates and divide the latter by the former.

egen tcirc = sum(circ), by(msa)
egen trate = sum(rate), by(msa)
gen nprate = 1000*trate/tcirc

*Drop unneeded variables and duplicate observations.
sort msa
quietly by msa: gen dup = cond(_N==1,0,_n)
drop if dup>1
drop city state name circ rate tcirc trate dup
label var nprate "Circulation-weighted Advertising Rate (/1000 exposures)"
notes: Averages formed by JRC in September, 2000.

*Add a variable giving the data's reference year.
gen str2 yr = "92"
label var yr "Reference Year"

label data "Sunday Newspaper Advertising Rates by MSA, 1992"

*Rename msa rmsa because it is a real number.
rename msa rmsa
label var rmsa "MSA Code (Real Number)"

*Sort the data by MSA.
sort rmsa

save nprate92, replace

