*n92.do

version 10

*Clear and set memory
clear
set mem 4m


*Load in the data from cof01.dta
use ../../../CCDB_94_STATA/COF12

*Keep only those observations from MSA counties.
keep if sumlev=="3"

*For each MSA, calculate total employment
egen lf = sum(item125), by(metro)
egen unemp=sum(item126), by(metro)
gen n=lf-unemp

*Eliminate duplicate observations for each MSA.
sort metro
quietly by metro: gen dup=cond(_N==1,0,_n)
drop if dup>1
drop dup

*Add a variable giving the data's reference year.
gen str2 yr = "92"
label var yr "Reference Year"

*Rename metro as "msa"
rename metro msa
label var msa "MSA Code"
notes msa: In original data file, the MSA code is called metro

label var n "Employment of Residents, 1991"
notes n: Source: 1994 County and City Data Book

label data "MSA Employment 1991"

*Sort the data by MSA.
sort msa

*Save the data
keep msa n yr
order msa n yr
save n92, replace





