*msalst.do


*This file creates a data-set of MSA codes and names from the file 1992 Economic census file geogref.dta  
*The resulting list contains MSA's inside New England.

version 10

*Clear and set memory.
clear
set mem 50m


*Load the data.
use ../../../EC_92_STATA/GEOREF92

*Drop variables that will not be used.
drop st county place conscity pop92-earnmean

*Keep only observations corresponding to MSA's/PMSA's/CMSA's.
keep if geotype=="6"

*Get rid of PMSA's.
keep if pmsa=="9999"

*Get rid of non-MSA area observations.
drop if msa=="9999"

*Get rid of MSA state parts.
drop if part=="P"

*Drop variables that will not be used.
drop geotype pmsa part note

label data "MSA Names"
rename text name
label var name "MSA Name"
label var msa "MSA Code"

notes name: Names from georef92.dta.

*Create a variable which is the msa code expressed as a real number.
gen rmsa = real(msa)
label var rmsa "MSA Code (Real Number)"

*Sort by msa.
sort msa

*Save the data.
save msalst, replace



