*mchh92.do


*This file aggregates county-level data from the 1994 CCDB on Married-Couple Family Households to the MSA level.
*Married-Couple Family Households, 1990, Item 042, file 4

version 10

*Clear and set memory
clear
set mem 4m

*Load file 4
use ../../../CCDB_94_STATA/COF04

*Keep only observations from MSA counties.
keep if sumlev=="3"

*Drop variables that won't be used.
drop flag035-item041
drop flag043-item046

*For each MSA, construct the total number of married-couple family households
egen mchh = sum(item042), by(metro)


*Drop variables that will not be used.
drop item042 flag042 state county sumlev pmsa areaname

*Keep a single observation of housing unit sum.
sort metro
quietly by metro: gen dup=cond(_N==1,0,_n)
drop if dup>1
drop dup

*Add a variable giving the data's reference year.
gen str2 yr = "92"
label var yr "Reference Year"

*Rename metro as "msa"
rename metro msa
label var msa "MSA Code"
notes msa: In original data file, the MSA code is called metro

*Label the data and variables.

label data "Married-Couple Family Households for MSA's, 1990"
label var mchh "Married-Couple Family Households, 1990"
notes mchh: Source, 1994 CCDB Item 042 file 4.
*Sort by MSA.
sort msa

*Save the data.
save mchh92, replace
