*hv92.do


*Aggregates county-level data on the values of owner-occupied housing units from the 1994 County and City Data Book into MSA totals.
*The output data file is called hv92.dta

version 10

*Clear and set memory.
clear
set mem 4m

*Change the working directory and load the data.
use ../../../CCDB_94_STATA/COF11

*Drop variables that will not be used.
drop flag101-item102
drop flag104-item104
drop flag106-item112x
drop state county areaname pmsa

*Drop observations that are not part of MSA counties outside of New England.
*This also drops PMSA counties.
keep if sumlev=="3"
drop sumlev

*Sum owner-occupied housing units across MSA counties.
egen huoo=sum(item103), by(metro)

*Create the weighted median value variable.
gen whv = item103*item105/huoo

*Create the weighted average median rent.
egen hv = sum(whv), by(metro)

*Drop variables that are not part of the final data set.
drop flag103 item103 flag105 item105 huoo whv 

*Keep a single observation of housing unit sum.
sort metro
quietly by metro: gen dup=cond(_N==1,0,_n)
drop if dup>1
drop dup

*Add a variable giving the data's reference year.
gen str2 yr = "92"
label var yr "Reference Year"

*Rename metro as "msa"
rename metro msa
label var msa "MSA Code"
notes msa: In original data file, the MSA code is called metro

label var hv "Median Value, Owner-Occupied Housing Unit"
notes hv: Source, 1990 Decennial Census of Population and Housing.
notes hv: Item 105 in file 11, CCDB.
notes hv: Weighted average across counties in MSA using total number of owner-occupied units, Item 103 in file 11, CCDB.

label data "Median Value of Owner-Occupied Housing Units for MSA's, 1990"

*Sort the data by MSA.
sort msa

*Save the data
save hv92, replace


