*hu92.do

*Aggregates county-level data on housing units from the 1994 County and City Data Book into MSA totals.
*The output data file is called hu92.dat

version 10

*Clear and set memory.
clear
set mem 4m

*Change the working directory and load the data.
use ../../../CCDB_94_STATA/COF10

*Drop variables that will not be used.
drop flag090-item100x
drop state county areaname pmsa

*Drop observations that are not part of MSA counties outside of New England.
*This also drops PMSA counties.
keep if sumlev=="3"
drop sumlev

*Sum housing units across MSA counties.
egen hu=sum(item089), by(metro)
drop item089 flag089

*Keep a single observation of housing unit sum.
sort metro
quietly by metro: gen dup=cond(_N==1,0,_n)
drop if dup>1
drop dup

*Add a variable giving the data's reference year.
gen str2 yr = "92"
label var yr "Reference Year"

*Rename metro as "msa"
rename metro msa
label var msa "MSA Code"
notes msa: In original data file, the MSA code is called metro

label var hu "Total Housing Units, 1990"
notes hu: Source, 1990 Decennial Census of Population and Housing.
notes hu: Item 089 in file 10, CCDB.

label data "Total Housing Units for MSA's, 1990"

*Sort the data by MSA.
sort msa

*Save the data
save hu92, replace


