*hr92.do

/* This program constructs an estimate of the median rent of renter-occupied housing by MSA in 1990.
The original data source is the 1994 County and City Data Book. This source reports the median rent by county. This program aggregates 
these observations to the MSA level using the number of renter-occupied units in each county to construct a weighted average of the median.
*/

version 10

*Clear and set memory.
clear
set mem 4m

*Load the data
use ../../../CCDB_94_STATA/COF11

*Drop variables that will not be used.
drop flag101-item106
drop flag109-item112x
drop state county areaname pmsa

*Drop observations that are not part of MSA counties outside of New England.
*This also drops PMSA counties.
keep if sumlev=="3"
drop sumlev

*Sum renter-occupied housing units across MSA counties.
egen huro=sum(item107), by(metro)

*Create the weighted median value variable.
gen whr = item107*item108/huro

*Create the weighted average median rent.
egen hr = sum(whr), by(metro)

*Drop variables that are not part of the final data set.
drop flag107 item107 flag108 item108 huro whr 

*Keep a single observation of housing unit sum.
sort metro
quietly by metro: gen dup=cond(_N==1,0,_n)
drop if dup>1
drop dup

*Add a variable giving the data's reference year.
gen str2 yr = "92"
label var yr "Reference Year"

*Rename metro as "msa"
rename metro msa
label var msa "MSA Code"
notes msa: In original data file, the MSA code is called metro

label var hr "Median Rent, Renter-Occupied Housing Unit"
notes hr: Source, 1990 Decennial Census of Population and Housing.
notes hr: Item 108 in file 11, 1994 CCDB.
notes hr: Weighted average across counties in MSA using total number of renter-occupied units, Item 107 in file 11, 1994 CCDB.

label data "Median Rent of Renter-Occupied Housing Units for MSA's, 1990"

*Sort the data by MSA.
sort msa

*Save the data
save hr92, replace
