*hotel92.do


/* Creates the data file hotel92.dta using data on hotels and motels from the 1992 Census of Services. */

version 10

*Clear and increase memory to hold the data.
clear
set mem 40m

*First, change the working directory and load in the data.

use ../../../EC_92_STATA/SC92A1

*First, keep only those observations which correspond to MSA areas.
keep if geotype=="6"

*Get rid of areas in New England.
drop if msa=="0000"
drop if pmsa=="0000"

*Get rid of statewide totals for non-MSA areas.
drop if msa=="9999"

*Drop those variables that we will not be using. These are mostly geographic descriptors.
drop geotype st county place conscity part tradekey

*Code the zeros in emp and value as missing values, which they are.
mvdecode emp value, mv(0)

*Keep only those observations that correspond to the lodging industry
keep if sickey=="0003"

*Drop variables that will not be used.
keep msa value
rename value hotel

*Label the data
label data "Hotel and Motel Revenues, 1992"
label var hotel "Hotel and Motel Revenues ($1,000), 1992"

*Annotate the data
notes drop _all
notes: Constructed from the 1992 Census of Services.
notes: Created by hotel2.do.

*Sort the data by MSA.
sort msa

save hotel92, replace
