*highinc92.do

/* This program measures the fraction of high-income households by MSA in 1990.
The original data source is the 1994 County and City Data Book. 
*/

version 10

*Clear and set memory.
clear
set mem 4m

*Load the data
use ../../../CCDB_94_STATA/COF08

*Drop observations that are not part of MSA counties outside of New England.
*This also drops PMSA counties.
keep if sumlev=="3"
drop sumlev

*Measure total high-income households in each county
gen highinccounty=item078*item078x

*Sum high-income and total households across MSA counties.
egen highinchouseholds=sum(highinccounty), by(metro)
egen households=sum(item078x), by(metro)

*Create the high-income household percentage.
gen highinc=highinchouseholds/households

*Keep one observation for each msa
bysort metro: gen dup=_n>1
drop if dup==1

*Create the final data set.
keep metro highinc

*Add a variable giving the data's reference year.
gen str2 yr = "92"
label var yr "Reference Year"

*Rename metro as "msa"
rename metro msa
label var msa "MSA Code"
notes msa: In original data file, the MSA code is called metro

label var highinc "High-Income Household Percentage"
notes highinc: Source, 1990 Decennial Census of Population and Housing.
notes highinc: Items 078 (Households, Percent with Money Income 75,000 or more), 078x (Households) in file 8, 1994 CCDB.

label data "High-Income Household Percentage for MSA's, 1990"

*Sort the data by MSA.
sort msa

*Save the data
save highinc92, replace
