*female92.do

/* This program constructs an estimate of female labor force participation by MSA in 1990.
The original data source is the 1994 County and City Data Book. This source reports female labor force and female population by county. This program aggregates 
these observations to the MSA level and divides by the number of females in the MSA.
*/

version 10

*Clear and set memory.
clear
set mem 4m

*Load the data
use ../../../CCDB_94_STATA/COF13

*Drop observations that are not part of MSA counties outside of New England.
*This also drops PMSA counties.
keep if sumlev=="3"
drop sumlev

*Sum females in labor force across MSA counties.
egen workingfemales=sum(item131x), by(metro)
egen females=sum(item133x), by(metro)
gen female=100*workingfemales/females

*Keep one observation for each msa
bysort metro: gen dup=_n>1
drop if dup==1

*Create the final data set.
keep metro female

*Add a variable giving the data's reference year.
gen str2 yr = "92"
label var yr "Reference Year"

*Rename metro as "msa"
rename metro msa
label var msa "MSA Code"
notes msa: In original data file, the MSA code is called metro

label var female "Female Labor-Force Participation Rate"
notes female: Source, 1990 Decennial Census of Population and Housing.
notes female: Items 131x (Female labor force) and 133x (Females 16 and over) in file 13, 1994 CCDB.

label data "Female Labor Force Participation Rate for MSA's, 1990"

*Sort the data by MSA.
sort msa

*Save the data
save female92, replace
