*elderly92.do

/* This program measures the fraction of elderly residents by MSA in 1990.
The original data source is the 1994 County and City Data Book. 
*/

version 10

*Clear and set memory.
clear
set mem 4m

*Load the data
use ../../../CCDB_94_STATA/COF02


*Drop observations that are not part of MSA counties outside of New England.
*This also drops PMSA counties.
keep if sumlev=="3"
drop sumlev

*Measure total elderly in each county
gen elderlycounty=item024x*item023+item024x*item024

*Sum elderly and total population across MSA counties
egen elderlypeople=sum(elderlycounty), by(metro)
egen people=sum(item024x), by(metro)

*Create the elderly population percentage.
gen elderly=elderlypeople/people


*Keep one observation for each msa
bysort metro: gen dup=_n>1
drop if dup==1

*Create the final data set.
keep metro elderly

*Add a variable giving the data's reference year.
gen str2 yr = "92"
label var yr "Reference Year"

*Rename metro as "msa"
rename metro msa
label var msa "MSA Code"
notes msa: In original data file, the MSA code is called metro

label var elderly "Elderly Population Percentage"
notes elderly: Source, 1990 Decennial Census of Population and Housing.
notes elderly: Items 023 (Population Percent 65 to 74), 024 (Population Percent 75 and older) and 024x (population) in file 2, 1994 CCDB.

label data "Elderly Population Percentage for MSA's, 1990"

*Sort the data by MSA.
sort msa

*Save the data
save elderly92, replace
