*data92.do


*This file links the 1992 Census of Retail Trade data from ./rc92s04/table17.dta and ./rc92s04/table15.dta with the MSA characteristics data
*in ./rhs92/rhs92.dta. The resulting data set is saved as two comma-separated values files, one for each industry.

*Clear and set memory
version 10
clear
set mem 4m
set more off

*Load in the 1992 Census of Retail Trade data.
use ./rc92s04/table17

*Label the variables.
label var msa "MSA Code"
label var nestab "Number of Establishments - Any Time of Year"
label var value "Value of Industry Sales"
label var n2 "Number of Establishments w/ p<$2.00"
label var v2 "Sales of Establishments w/ p<$2.00"
label var n499 "Number of Establishments w/ $2.00<=p<=$4.99"
label var v499 "Sales of Establishments w/ $2.00<=p<=$4.99"
label var n699 "Number of Establishments w/ $5.00<=p<=$6.99"
label var v699 "Sales of Establishments w/ $5.00<=p<=$6.99"
label var n999 "Number of Establishments w/ $7.00<=p<=$9.99"
label var v999 "Sales of Establishments w/ $7.00<=p<=$9.99"
label var n1499 "Number of Establishments w/ $10.00<=p<=$14.99"
label var v1499 "Sales of Establishments w/ $10.00<=p<=$14.99"
label var n2999 "Number of Establishments w/ $15.00<=p<=$29.99"
label var v2999 "Sales of Establishments w/ $15.00<=p<=$29.99"
label var n30 "Number of Establishments w/ p>=$30.00"
label var v30 "Sales of Establishments w/ p>=$30.00"
label var rrateprice "Response Rate for Pricing Question"

*Join this data set with the seating data, Table 15.
sort msa sicname
joinby msa sicname using ./rc92s04/table15

*Label the variables
label var msaname "MSA Name"
label var nestabend "Number of Establishments - End of Year"
label var nestabseat "Number of Establishments w/ Seats"
label var vseat "Value of Sales for Establishments w/ Seats"
label var nseat "Number of Seats"
label var rrateseat "Response Rate for Seating Question"
order msa msaname sicname nestab nestabend value nestabseat vseat nseat n2 v2 n499 v499 n699 v699 n999 v999 n1499 v1499 n2999 v2999 n30 v30 r*

rename msa rmsa

*Join this data set with the MSA characteristics data.
sort rmsa sicname
joinby rmsa using ./rhs92/rhs92

*Rename the population from pop to pop92 to not conflict with the GAUSS command POP.
rename pop pop92

*Relabel the data.
label data "MSA Eating Places Industry Data Set, 1992"

*Modify the data set's notes.
notes drop _dta
notes: Retail Trade industry observations from the 1992 Census of Retail Trade.
notes: Source: 1992 Subject Series, Special Subjects
notes: See notes for individual data items for sources of MSA characteristics.
notes: This data set covers all MSA's outside of New-England.
notes: This data excludes PMSA's/CMSA's.
notes: Created by data92.do on $S_DATE at $S_TIME.

notes drop msa
notes msa: On the 1994 County and City Data Book compact disk, this variable is called metro.

*Save the data set in spreadsheet files
tempfile TEMP
save `TEMP'

keep if sicname=="Restaurants"
drop sicname msa msaname
outsheet using data92rst.csv, comma replace

clear
use `TEMP'
keep if sicname=="Refreshment Places"
drop sicname msa msaname
outsheet using data92rfp.csv, comma replace




