=>    ALL MANUFACTURING INDUSTRIES
The manufacturing division includes establishments engaged in the
mechanical or chemical transformation of materials or substances into new
products.  These establishments are usually described as plants, factories,
or mills and characteristically use power driven machines and materials
handling equipment.  Establishments engaged in assembing component parts of
manufactured products are also considered manufacturing if the new product
is neither a structure nor other fixed improvement.  Also included is the
blending of materials, such as lubricating oils, plastics resins, or
liquors.

The materials processed by manufacturing establishments include products of
agriculture, forestry, fishing, mining, and quarrying as well as products
of other manufacturing establishments.  The new product of a manufacturing
establishment may be finished in the sense that it is ready for utilization
or consumption, or it may be semifinished to become a raw material for an
establishment engaged in further manufacturing.  For example, the product
of the copper smelter is the raw material used in electrolytic refineries;
refined copper is the raw material used by copper wire mills; and copper
wire is the raw material used by certain electrical equipment
manufacturers.

The materials used by manufacturing establishments may be purchased
directly from producers, obtained through customary trade channels, or
secured without recourse to the market by transfering the product from one
establishment to another which is under the same ownership.  Manufacturing
production is usually carried on for the wholesale market, for interplant
transfer, or to order for industrial users, rather than for direct sale to
the domestic consumer.

=>20  FOOD AND KINDRED PRODUCTS
This major group includes establishments manufacturing or processing foods
and beverages for human consumption, and certain related products, such as
manufactured ice, chewing gum, vegetable and animal fats and oils, and
prepared feeds for animals and fowls. Products described as dietetic are
classified in the same manner as nondietetic products (e.g., as candy,
canned fruits, cookies). Chemical sweeteners are classified in major group
28.

201  MEAT PRODUCTS
This industry group includes establishments primarily engaged in the
operation of meat packing plants; manufacturing sausages and other prepared
meat products; and poultry slaughtering and processing.

2011  Meat Packing Plants
Establishments primarily engaged in the slaughtering, for their own account
or on a contract basis for the trade, of cattle, hogs, sheep, lambs, and
calves for meat to be sold or to be used on the same premises in caning,
cooking, curing, and freezing, and in making sausage, lard, and other
products. Also included in this industry are establishments primarily
engaged in slaughtering horses for human consumption.  Establishments
primarily engaged in slaughtering, dressing, and packing poultry, rabbits,
and other small game are classified in industry 2015; and those primarily
engaged in slaughtering and processing animals not for human consumption
are classified in industry 2048. Establishments primarily engaged in
manufacturing sausages and meat specialties from purchased meats are
classified in industry 2013; and establishments primarily engaged in
caning meat for baby food are classified in industry 2032.

2013  Sausages and Other Prepared Meat Products
Establishments primarily engaged in manufacturing sausages, cured meats,
smoked meats, canned meats, frozen meats, and other prepared meats and meat
specialties, from purchased carcasses and other materials. Prepared meat
plants operated by packing houses as separate establishments are also
included in this industry. Establishments primarily engaged in caning or
otherwise processing poultry, rabbits, and other small game are classified
in industry 2015. Establishments primarily engaged in caning meat for baby
food are classified in industry 2032.  Establishments primarily engaged in
the cutting up and resale of purchased fresh carcasses, for the trade,
(including boxed beef) are classified in Wholesale Trade, industry 5147.

2015  Poultry Slaughtering and Processing
Establishments primarily engaged in slaughtering, dressing, packing,
freezing, and caning poultry, rabbits, and other small game, or in
manufacturing products from such meats, for their own account or on a
contract basis for the trade. This industry also includes the drying,
freezing, and breaking of eggs. Establishments primarily engaged in
cleaning, oil treating, packing, and grading of eggs are classified in
Wholesale Trade, industry 5144; and those engaged in the cutting up and
resale of purchased fresh carcasses are classified in Wholesale and Retail
Trade.

202  DAIRY PRODUCTS
This industry group includes establishments primarily engaged in: (1)
manufacturing creamery butter; natural, processed, and imitation cheese;
dry, condensed, and evaporated milk; ice cream and frozen dairy desserts;
and special dairy products, such as yogurt and malted milk; and (2)
processing (pasteurizing, homogenizing, vitaminizing, bottling) fluid milk
and cream for wholesale or retail distribution.  Independently operated
milk receiving stations primarily engaged in the assembly and reshipment of
bulk milk for use in manufacturing or processing plants are classified in
industry 5143.

2021  Creamery Butter
Establishments primarily engaged in manufacturing creamery butter.

2022  Natural, Processed, and Imitation Cheese
Establishments primarily engaged in manufacturing natural cheese (except
cottage cheese), processed cheese, cheese foods, cheese spreads, and cheese
analogs (imitations and substitutes). These establishments also produce
byproducts, such as raw liquid whey.  Establishments primarily engaged in
manufacturing cottage cheese are classified in industry 2026, and those
manufacturing cheese-based salad dressings are classified in industry 2035.

2023  Dry, Condensed, and Evaporated Dairy Products
Establishments primarily engaged in manufacturing dry, condensed, and
evaporated dairy products. Included in this industry are establishments
primarily engaged in manufacturing mixes for the preparation of frozen ice
cream and ice milk and dairy and nondairy base cream substitutes and
dietary supplements.

2024  Ice Cream and Frozen Desserts
Establishments primarily engaged in manufacturing ice cream and other
frozen desserts. Establishments primarily engaged in manufacturing frozen
bakery products, such as cakes and pies, are classified in industry 2053.

2026  Fluid Milk
Establishments primarily engaged in processing (e.g., pasteurizing,
homogenizing, vitaminizing, bottling) fluid milk and cream, and related
products, including cottage cheese, yogurt (except frozen), and other
fermented milk. Establishments primarily engaged in manufacturing dry
mix whipped toppings are classified in industry 2023; those producing
frozen whipped toppings are classified in industry 2038; and those
producing frozen yogurt are classified in industry 2024.

203  CANNED, FROZEN, AND PRESERVED FRUITS, VEGETABLES, AND FOOD
     SPECIALTIES
The canned products of this industry group are distinguished by their
processing rather than by the container. The products may be shipped in
bulk or in individual cans, bottles, retort pouch packages, or other
containers.

2032  Canned Specialties
Establishments primarily engaged in caning specialty products, such as baby
foods, nationality specialty foods, and soups, except seafood.
Establishments primarily engaged in caning seafoods are classified in
industry 2091.

2033  Canned Fruits, Vegetables, Preserves, Jams, and Jellies
Establishments primarily engaged in caning fruits, vegetables, and fruit
and vegetable juices; and in manufacturing catsup and similar tomato
sauces, or natural and imitation preserves, jams, and jellies.
Establishments primarily engaged in caning seafoods are classified in
industry 2091; and those manufacturing canned specialties, such as baby
foods and soups, except seafood, are classified in industry 2032.

2034  Dried and Dehydrated Fruits, Vegetables, and Soup Mixes
Establishments primarily engaged in sun drying or artificially dehydrating
fruits and vegetables, or in manufacturing packaged soup mixes from
dehydrated ingredients. Establishments primarily engaged in the grading and
marketing of farm dried fruits, such as prunes and raisins, are classified
in Wholesale Trade, industry 5149.

2035  Pickled Fruits & Vegetables, Vegetable Sauces & Seasonings, & Salad
      Dressings
Establishments primarily engaged in pickling and brining fruits and
vegetables, and in manufacturing salad dressings, vegetable relishes,
sauces, and seasonings. Establishments primarily engaged in manufacturing
catsup and similar tomato sauces are classified in industry 2033, and those
packing purchased pickles and olives are classified in Wholesale or Retail
Trade. Establishments primarily engaged in manufacturing dry salad dressing
and dry sauce mixes are classified in industry 2099.

2037  Frozen Fruits, Fruit Juices, and Vegetables
Establishments primarily engaged in freezing fruits, fruit juices, and
vegetables. These establishments also produce important byproducts such as
fresh or dried citrus pulp.

2038  Frozen Specialties, Not Elsewhere Classified
Establishments primarily engaged in manufacturing frozen food specialties,
not elsewhere classified, such as frozen dinners and frozen pizza. The
manufacture of some important frozen foods and specialties is classified
elsewhere. For example, establishments primarily engaged in manufacturing
frozen dairy specialties are classified in industry group 202, those
manufacturing frozen bakery products are classified in industry group 205,
those manufacturing frozen fruits and vegetables are classified in industry
2037, and those manufacturing frozen fish and seafood specialties are
classified in industry 2092.

204  GRAIN MILL PRODUCTS
This industry group includes establishments primarily engaged in
manufacturing flour and other grain mill products; manufacturing cereal
breakfast foods; rice milling; manufacturing prepared flour mixes and
doughs; wet corn milling; manufacturing dog and cat food; and manufacturing
prepared feeds and feed ingredients for animals and fowls, except dogs and
cats.

2041  Flour and Other Grain Mill Products
Establishments primarily engaged in milling flour or meal from grain,
except rice. The products of flour mills may be sold plain or in the form
of prepared mixes or doughs for specific purposes. Establishments primarily
engaged in manufacturing prepared flour mixes or doughs from purchased
ingredients are classified in industry 2045, and those milling rice are
classified in industry 2044.

2043  Cereal Breakfast Foods
Establishments primarily engaged in manufacturing cereal breakfast foods
and related preparations, except breakfast bars. Establishments primarily
engaged in manufacturing granola bars and other types of breakfast bars are
classified in industry 2064.

2044  Rice Milling
Establishments primarily engaged in cleaning and polishing rice, and in
manufacturing rice flour or meal. Other important products of this industry
include brown rice, milled rice (including polished rice), rice polish, and
rice bran.

2045  Prepared Flour Mixes and Doughs
Establishments primarily engaged in preparing flour mixes or doughs from
purchased flour. Establishments primarily engaged in milling flour from
grain and producing mixes or doughs are classified in industry 2041.

2046  Wet Corn Milling
Establishments primarily engaged in milling corn or sorghum grain (milo) by
the wet process, and producing starch, syrup, oil, sugar, and byproducts,
such as gluten feed and meal. Also included in this industry are
establishments primarily engaged in manufacturing starch from other
vegetable sources (e.g., potatoes, wheat). Establishments primarily engaged
in manufacturing table syrups from corn syrup and other ingredients, and
those manufacturing starch base dessert powders, are classified in industry
2099.

2047  Dog and Cat Food
Establishments primarily engaged in manufacturing dog and cat food from
cereal, meat, and other ingredients. These preparations may be canned,
frozen, or dry. Establishments primarily engaged in manufacturing feed for
animals other than dogs and cats are classified in industry 2048.

2048  Prepared Feeds & Feed Ingredients for Animals & Fowl, Exc Dogs & Cats
Establishments primarily engaged in manufacturing prepared feeds and feed
ingredients and adjuncts for animals and fowls, except dogs and cats.
Included in this industry are poultry and livestock feed and feed
ingredients, such as alfalfa meal, feed supplements, and feed concentrates
and feed premixes. Also included are establishments primarily engaged in
slaughtering animals for animal feed.  Establishments primarily engaged in
slaughtering animals for human consumption are classified in industry group
201. Establishments primarily engaged in manufacturing dog and cat foods
are classified in industry 2047.

205  BAKERY PRODUCTS
This industry group includes establishments primarily engaged in
manufacturing bread and other bakery products; manufacturing cookies and
crackers; and manufacturing frozen bakery products, except bread.

2051  Bread and Other Bakery Products, Except Cookies and Crackers
Establishments primarily engaged in manufacturing fresh or frozen bread and
bread-type rolls and fresh cakes, pies, pastries and other similar
"perishable" bakery products. Establishments primarily engaged in producing
"dry" bakery products, such as biscuits, crackers, and cookies, are
classified in industry 2052. Establishments primarily engaged in
manufacturing frozen bakery products, except bread and bread-type rolls,
are classified in industry 2053. Establishments producing bakery products
primarily for direct sale on the premises to household consumers are
classified in Retail Trade, industry 5461.

2052  Cookies and Crackers
Establishments primarily engaged in manufacturing fresh cookies, crackers,
pretzels, and similar "dry" bakery products.  Establishments primarily
engaged in producing other fresh bakery products are classified in industry
2051.

2053  Frozen Bakery Products, Except Bread
Establishments primarily engaged in manufacturing frozen bakery products,
except bread and bread-type rolls. Establishments primarily engaged in
manufacturing frozen bread and bread-type rolls are classified in industry
2051.

206  SUGAR AND CONFECTIONERY PRODUCTS
This industry group includes establishments primarily engaged in
manufacturing cane sugar; cane sugar refining; manufacturing beet sugar;
manufacturing candy and other confectionery products; manufacturing
chocolate and cocoa products; manufacturing chewing gum; and manufacturing
salted and roasted nuts and seeds.

2061  Cane Sugar, Except Refining
Establishments primarily engaged in manufacturing raw sugar, syrup, or
finished (granulated or clarified) cane sugar from sugarcane.
Establishments primarily engaged in refining sugar from purchased raw cane
sugar or sugar syrup are classified in industry 2062.

2062  Cane Sugar Refining
Establishments primarily engaged in refining purchased raw cane sugar and
sugar syrup.

2063  Beet Sugar
Establishments primarily engaged in manufacturing sugar from sugar beets.

2064  Candy and Other Confectionery Products, and 2067 Chewing Gum
      Candy and Other Confectionery Products
Establishments primarily engaged in manufacturing candy, including
chocolate candy, other confections, and related products.  Establishments
primarily engaged in manufacturing solid chocolate bars from cacao beans
are classified in industry 2066, those manufacturing chewing gum are
classified in industry 2067, and those primarily engaged in roasting and
salting nuts are classified in industry 2068.  Establishments primarily
engaged in manufacturing confectionery for direct sale on the premises to
household consumers are classified in Retail Trade, industry 5441.
      Chewing Gum
Establishments primarily engaged in manufacturing chewing gum or chewing
gum base.

2066  Chocolate and Cocoa Products
Establishments primarily engaged in shelling, roasting, and grinding cacao
beans for the purpose of making chocolate liquor, from which cocoa powder
and cocoa butter are derived, and in the further manufacture of solid
chocolate bars, chocolate coatings, and other chocolate and cocoa products.
Also included is the manufacture of similar products, except candy, from
purchased chocolate or cocoa.  Establishments primarily engaged in
manufacturing candy from purchased cocoa products are classified in
industry 2064.

2067  Chewing Gum
Establishments primarily engaged in manufacturing chewing gum or chewing
gum base.

2068  Salted and Roasted Nuts and Seeds
Establishments primarily engaged in manufacturing salted, roasted, dried,
cooked, or canned nuts or in processing grains or seeds in a similar manner
for snack purposes. Establishments primarily engaged in manufacturing
confectionery-coated nuts are classified in industry 2064, and those
manufacturing peanut butter are classified in industry 2099.

207  FATS AND OILS
This industry group includes establishments primarily classified as
cottonseed oil mills; soybean oil mills; vegetable oils mills, except corn;
and establishments primarily engaged in manufacturing animal and marine
fats and oils, and those manufacturing shortening, table oils, margarine,
and other edible fats and oils, not elsewhere classified.

2074  Cottonseed Oil Mills
Establishments primarily engaged in manufacturing cottonseed oil, cake,
meal, and linters, or in processing purchased cottonseed oil other than
into edible cooking oils. Establishments primarily engaged in refining
cottonseed oil into edible cooking oils are classified in industry 2079.

2075  Soybean Oil Mills
Establishments primarily engaged in manufacturing soybean oil, cake, and
meal, and soybean protein isolates and concentrates, or in processing
purchased soybean oil other than into edible cooking oils.  Establishments
primarily engaged in refining soybean oil into edible cooking oils are
classified in industry 2079.

2076  Vegetable Oil Mills, Except Corn, Cottonseed, and Soybean
Establishments primarily engaged in manufacturing vegetable oils, cake and
meal, except corn, cottonseed, and soybean, or in processing similar
purchased oils other than into edible cooking oils.  Establishments
primarily engaged in manufacturing corn oil and its byproducts are
classified in industry 2046, those which are refining vegetable oils into
edible cooking oils are classified in industry 2079, and those refining
these oils for medicinal purposes are classified in industry 2833.

2077  Animal and Marine Fats and Oils
Establishments primarily engaged in manufacturing animal oils, including
fish oil and other marine animal oils, and fish and animal meal; and those
rendering inedible stearin, grease, and tallow from animal fat, bones, and
meat scraps. Establishments primarily engaged in manufacturing lard and
edible tallow and stearin are classified in industry group 201; those
refining marine animal oils for medicinal purposes are classified in
industry 2833; and those manufacturing fatty acids are classified in
industry 2899.

2079  Shortening, Table Oils, Margarine, & Other Edible Fats & Oils, N.E.C.
Establishments primarily engaged in manufacturing shortening, table oils,
margarine, and other edible fats and oils, not elsewhere classified.
Establishments primarily engaged in producing corn oil are classified in
industry 2046.

208  BEVERAGES
This industry group includes establishments primarily engaged in
manufacturing malt beverages; malt; wines, brandy, and brandy spirits;
distilled and blended liquors; bottled and canned soft drinks and
carbonated waters; and flavoring extracts and syrups, not elsewhere
classified.

2082  Malt Beverages
Establishments primarily engaged in manufacturing malt beverages.
Establishments primarily engaged in bottling purchased malt beverages are
classified in industry 5181.

2083  Malt
Establishments primarily engaged in manufacturing malt or malt byproducts
from barley or other grains.

2084  Wines, Brandy, and Brandy Spirits
Establishments primarily engaged in manufacturing wines, brandy, and brandy
spirits. This industry also includes bonded wine cellars which are engaged
in blending wines. Establishments primarily bottling purchased wines,
brandy, and brandy spirits, but which do not manufacture wines and brandy,
are classified in Wholesale Trade, industry 5182.

2085  Distilled and Blended Liquors
Establishments primarily engaged in manufacturing alcoholic liquors by
distillation, and in manufacturing cordials and alcoholic cocktails by
blending processes or by mixing liquors and other ingredients.
Establishments primarily engaged in manufacturing industrial alcohol are
classified in industry 2869, and those only bottling purchased liquors are
classified in Wholesale Trade, industry 5182.

2086  Bottled and Canned Soft Drinks and Carbonated Waters
Establishments primarily engaged in manufacturing soft drinks and
carbonated waters. Establishments primarily engaged in manufacturing fruit
and vegetable juices are classified in industry group 203; those
manufacturing fruit syrups for flavoring are classified in industry 2087;
and those manufacturing nonalcoholic cider are classified in industry 2099.
Establishments primarily engaged in bottling natural spring waters are
classified in Wholesale Trade, industry 5149.

2087  Flavoring Extracts and Flavoring Syrups, Not Elsewhere Classified
Establishments primarily engaged in manufacturing flavoring extracts,
syrups, powders, and related products, not elsewhere classified, for soda
fountain use or for the manufacture of soft drinks, and colors for bakers'
and confectioners' use. Establishments primarily engaged in manufacturing
chocolate syrup are classified in industry 2066.

209  MISCELLANEOUS FOOD PREPARATIONS AND KINDRED PRODUCTS
This industry group includes establishments primarily engaged in
manufacturing canned and cured fish and seafoods; prepared fresh or frozen
fish and seafoods; roasting coffee; manufacturing potato chips, corn chips,
and similar snacks; ice; macaroni, spaghetti, vermicelli, and noodles; and
manufacturing food preparations not elsewhere classified.

2091  Canned and Cured Fish and Seafoods
Establishments primarily engaged in cooking and caning fish, shrimp,
oysters, clams, crabs, and other seafoods, including soups; and those
engaged in smoking, salting, drying, or otherwise curing fish and other
seafoods for the trade. Establishments primarily engaged in shucking
and packing fresh oysters in nonsealed containers, or in freezing or
preparing fresh fish, are classified in industry 2092.

2092  Prepared Fresh or Frozen Fish and Seafoods
Establishments primarily engaged in preparing fresh and raw or cooked
frozen fish and other seafoods and seafood preparations, such as soups,
stews, chowders, fishcakes, crabcakes, and shrimpcakes. Prepared fresh fish
are eviscerated or processed by removal of heads, fins, or scales.  This
industry also includes establishments primarily engaged in the shucking and
packing of fresh oysters in nonsealed containers.

2095  Roasted Coffee
Establishments primarily engaged in roasting coffee, and in manufacturing
coffee concentrates and extracts in powdered, liquid, or frozen form,
including freeze-dried. Coffee roasting by wholesale grocers is classified
in Wholesale Trade, industry 5149.

2096  Potato Chips, Corn Chips, and Similar Snacks
Establishments primarily engaged in manufacturing potato chips, corn chips,
and similar snacks. Establishments primarily engaged in manufacturing
pretzels and crackers are classified in industry 2052; those manufacturing
candy covered popcorn are classified in industry 2064; those manufacturing
salted, roasted, cooked or canned nuts and seeds are classified in industry
2068; and those manufacturing packaged unpopped popcorn are classified in
industry 2099.

2097  Manufactured Ice
Establishments primarily engaged in manufacturing ice for sale.
Establishments primarily engaged in manufacturing dry ice are classified in
industry 2813.

2098  Macaroni, Spaghetti, Vermicelli, and Noodles
Establishments primarily engaged in manufacturing dry macaroni, spaghetti,
vermicelli, and noodles. Establishments primarily engaged in manufacturing
canned macaroni and spaghetti are classified in industry 2032, and those
manufacturing fried noodles, such as Chinese noodles, are classified in
industry 2099.

2099  Food Preparations, Not Elsewhere Classified
Establishments primarily engaged in manufacturing prepared foods and
miscellaneous food specialties, not elsewhere classified, such as baking
powder, yeast, and other leavening compounds; peanut butter; packaged tea,
including instant; ground spices; and vinegar and cider.  Also included in
this industry are establishments primarily engaged in manufacturing dry
preparations, except flour mixes, consisting of pasta, rice, potatoes,
textured vegetable protein, and similar products which are packaged with
other ingredients to be prepared and cooked by the consumer. Establishments
primarily engaged in manufacturing flour mixes are classified in industry
group 204.

=>21  TOBACCO PRODUCTS
This major group includes establishments engaged in manufacturing
cigarettes, cigars, smoking and chewing tobacco, snuff, and reconstituted
tobacco and in stemming and redrying tobacco. Also included in this major
group is the manufacture of nontobacco cigarettes. The manufacture of
insecticides from tobacco byproducts is included in major group 28.

211   CIGARETTES
Establishments primarily engaged in manufacturing cigarettes from tobacco
or other materials.

2111  Cigarettes
Establishments primarily engaged in manufacturing cigarettes from tobacco
or other materials.

212  CIGARS
Establishments primarily engaged in manufacturing cigars.

2121  Cigars
Establishments primarily engaged in manufacturing cigars.

213  CHEWING AND SMOKING TOBACCO AND SNUFF
Establishments primarily engaged in manufacturing chewing and smoking
tobacco and snuff.

2131  Chewing and Smoking Tobacco and Snuff
Establishments primarily engaged in manufacturing chewing and smoking
tobacco and snuff.

214  TOBACCO STEMMING AND REDRYING
Establishments primarily engaged in the stemming and redrying of tobacco or
in manufacturing reconstituted tobacco. Establishments which sell leaf
tobacco as merchant wholesalers, agents, or brokers, and which also may be
engaged in stemming tobacco, are classified in Wholesale Trade, industry
5159. Leaf tobacco warehouses which also may be engaged in stemming tobacco
are classified in Transportation and Public Utilities, industry 4221.

2141  Tobacco Stemming and Redrying
Establishments primarily engaged in the stemming and redrying of tobacco or
in manufacturing reconstituted tobacco. Establishments which sell leaf
tobacco as merchant wholesalers, agents, or brokers, and which also may be
engaged in stemming tobacco, are classified in Wholesale Trade, industry
5159. Leaf tobacco warehouses which also may be engaged in stemming tobacco
are classified in Transportation and Public Utilities, industry 4221.

=>22  TEXTILE MILL PRODUCTS
This major group includes establishments engaged in performing any of the
following operations: (1) preparation of fiber and subsequent manufacturing
of yarn, thread, braids, twine, and cordage; (2) manufacturing broadwoven
fabrics, narrow woven fabrics, knit fabrics, and carpets and rugs from
yarn; (3) dyeing and finishing fiber, yarn, fabrics, and knit apparel; (4)
coating, waterproofing, or otherwise treating fabrics; (5) the integrated
manufacture of knit apparel and other finished articles from yarn; and (6)
the manufacture of felt goods, lace goods, nonwoven fabrics, and
miscellaneous textiles.

This classification makes no distinction between the two types of
organizations which operate in the textile industry: (1) the integrated
mill which purchases materials, produces textiles and related articles
within the establishment, and sells the finished products; and (2) the
contract or commission mill which processes materials owned by others.
Converters or other nonmanufacturing establishments which assign materials
to contract mills for processing, other than knitting, are classified in
nonmanufacturing industries; establishments which assign yarns to outside
contractors or commission knitters for the production of knit products are
classified in industry group 225.

221  BROADWOVEN FABRIC MILLS, COTTON
Establishments primarily engaged in weaving fabrics more than 12 inches
(30.48 centimeters) in width, wholly or chiefly by weight of cotton.
Establishments primarily engaged in weaving or tufting carpet and rugs are
classified in industry 2273; those making tire cord and fabrics are
classified in industry 2296; and those engaged in finishing cotton
broadwoven fabrics are classified in industry 2261.

2211  Broadwoven Fabric Mills, Cotton
Establishments primarily engaged in weaving fabrics more than 12 inches
(30.48 centimeters) in width, wholly or chiefly by weight of cotton.
Establishments primarily engaged in weaving or tufting carpet and rugs are
classified in industry 2273; those making tire cord and fabrics are
classified in industry 2296; and those engaged in finishing cotton
broadwoven fabrics are classified in industry 2261.

222  BROADWOVEN FABRIC MILLS, MANMADE FIBER AND SILK
Establishments primarily engaged in weaving fabrics more than 12 inches
(30.48 centimeters) in width, wholly or chiefly by weight of silk and
manmade fibers including glass. Establishments primarily engaged in weaving
or tufting carpets and rugs from these fibers are classified in industry
2273; those manufacturing tire cord and fabrics are classified in industry
2296; and those engaged in finishing manmade fiber and silk broadwoven
goods are classified in industry 2262.

2221  Broadwoven Fabric Mills, Manmade Fiber and Silk
Establishments primarily engaged in weaving fabrics more than 12 inches
(30.48 centimeters) in width, wholly or chiefly by weight of silk and
manmade fibers including glass. Establishments primarily engaged in weaving
or tufting carpets and rugs from these fibers are classified in industry
2273; those manufacturing tire cord and fabrics are classified in industry
2296; and those engaged in finishing manmade fiber and silk broadwoven
goods are classified in industry 2262.

223  BROADWOVEN FABRIC MILLS, WOOL (INCLUDING DYEING AND FINISHING)
Establishments primarily engaged in weaving fabrics more than 12 inches
(30.48 centimeters) in width, wholly or chiefly by weight of wool, mohair,
or similar animal fibers; dyeing and finishing all woven wool fabrics or
dyeing wool, tops, or yarn; and those shrinking and sponging wool goods for
the trade. Establishments primarily engaged in weaving or tufting wool
carpets and rugs are classified in industry 2273.

2231  Broadwoven Fabric Mills, Wool (Including Dyeing and Finishing)
Establishments primarily engaged in weaving fabrics more than 12 inches
(30.48 centimeters) in width, wholly or chiefly by weight of wool, mohair,
or similar animal fibers; dyeing and finishing all woven wool fabrics or
dyeing wool, tops, or yarn; and those shrinking and sponging wool goods for
the trade. Establishments primarily engaged in weaving or tufting wool
carpets and rugs are classified in industry 2273.

224  NARROW FABRIC & OTHER SMALLWARES MILLS: COTTON, WOOL, SILK, &
     MANMADE FIBER
Establishments primarily engaged in weaving or braiding narrow fabrics of
cotton, wool, silk, and manmade fibers, including glass fibers.  These
fabrics are generally 12 inches or less in width in their final form but
may be made initially in wider widths that are specially constructed for
cutting to narrower widths. Also included in this industry are
establishments primarily engaged in producing fabric-covered elastic yarn
or thread.

2241  Narrow Fabric & Other Smallwares Mills: Cotton, Wool, Silk, & Manmade
      Fiber
Establishments primarily engaged in weaving or braiding narrow fabrics of
cotton, wool, silk, and manmade fibers, including glass fibers.  These
fabrics are generally 12 inches or less in width in their final form but
may be made initially in wider widths that are specially constructed for
cutting to narrower widths. Also included in this industry are
establishments primarily engaged in producing fabric-covered elastic yarn
or thread.

225  KNITTING MILLS
This industry group includes three types of organizations which operate in
the knitting mill industry: (1) the integrated mill which purchases
materials, produces textiles and related articles within the establishment,
and sells the finished products; (2) the contract or commission mill which
processes materials owned by others; and (3) establishments commonly known
as jobbers or converters of knit goods which perform the entrepreneurial
functions of a manufacturing company, such as buying the raw material,
designing and preparing samples, and assigning yarns to others for knitting
products on their account.

2251  Women's Full-Length and Knee-Length Hosiery, Except Socks
Establishments primarily engaged in knitting, dyeing, or finishing women's
and misses' full-length and knee-length hosiery (except socks) both
seamless and full-fashion, and panty hose. Establishments primarily engaged
in knitting, dyeing, or finishing women's and misses' knee-length socks and
anklets are classified in industry 2252.  Establishments primarily engaged
in manufacturing elastic (orthopedic) hosiery are classified in industry
3842.

2252  Hosiery, Not Elsewhere Classified
Establishments primarily engaged in knitting, dyeing, or finishing hosiery,
not elsewhere classified. Establishments primarily engaged in manufacturing
women's full-length and knee-length hosiery (except socks), and panty hose
are classified in industry 2251. Establishments primarily engaged in
manufacturing elastic (orthopedic) hosiery are classified in industry 3842.

2253  Knit Outerwear Mills
Establishments primarily engaged in knitting outerwear from yarn or in
manufacturing outerwear from knit fabrics produced in the same
establishment. Establishments primarily engaged in hand knitting outerwear
for the trade are included in this industry. Establishments primarily
engaged in knitting gloves and mittens are classified in industry 2259, and
those manufacturing outerwear from purchased knit fabrics are classified in
major group 23.

2254  Knit Underwear and Nightwear Mills
Establishments primarily engaged in knitting underwear and nightwear from
yarn or in manufacturing underwear and nightwear from knit fabrics produced
in the same establishment. Establishments primarily engaged in
manufacturing underwear and nightwear from purchased knit fabrics are
classified in major group 23. Establishments primarily engaged in knitting
robes are classified in industry 2253.

2257  Weft Knit Fabric Mills
Establishments primarily engaged in knitting weft (circular) fabrics or in
dyeing, or finishing weft (circular) knit fabrics.

2258  Lace and Warp Knit Fabric Mills
Establishments primarily engaged in knitting, dyeing, or finishing warp
(flat) knit fabrics, or in manufacturing, dyeing, or finishing lace goods.

2259  Knitting Mills, Not Elsewhere Classified
Establishments primarily engaged in knitting gloves and other articles, not
elsewhere classified. Establishments primarily engaged in manufacturing
woven or knit fabric gloves and mittens from purchased fabrics are
classified in industry 2381.

226  DYEING AND FINISHING TEXTILES, EXCEPT WOOL FABRICS AND KNIT GOODS
This industry group includes establishments primarily engaged in finishing
broadwoven fabrics of cotton; finishing broadwoven fabrics of manmade fiber
and silk; and finishing textiles, not elsewhere classified.

2261  Finishers of Broadwoven Fabrics of Cotton
Establishments primarily engaged in finishing purchased cotton broadwoven
fabrics, or finishing such fabrics, on a commission basis.  These finishing
operations include bleaching, dyeing, printing (roller, screen, flock,
plisse), and other mechanical finishing, such as preshrinking, calendering,
and napping. Also included in this industry are establishments primarily
engaged in shrinking and sponging of cotton broadwoven fabrics for the
trade and chemical finishing for water repellency, fire resistance, and
mildew proofing. Establishments primarily engaged in finishing wool
broadwoven fabrics are classified in industry 2231; those finishing knit
goods are classified in industry group 225; and those coating or
impregnating fabrics are classified in industry 2295.

2262  Finishers of Broadwoven Fabrics of Manmade Fiber and Silk
Establishments primarily engaged in finishing purchased manmade fiber and
silk broadwoven fabrics or finishing such fabrics on a commission basis.
These finishing operations include bleaching, dyeing, printing (roller,
screen, flock, plisse), and other mechanical finishing, such as
preshrinking, calendering, and napping. Establishments primarily engaged in
finishing wool broadwoven fabrics are classified in industry 2231; those
finishing knit goods are classified in industry group 225; and those
coating or impregnating fabrics are classified in industry 2295.

2269  Finishers of Textiles, Not Elsewhere Classified
Establishments primarily engaged in dyeing and finishing textiles, not
elsewhere classified, such as bleaching, dyeing, printing, and finishing of
raw stock, yarn, braided goods, and narrow fabrics, except wool and knit
fabrics. These establishments perform finishing operations on purchased
textiles or on a commission basis.

227  CARPETS AND RUGS
Establishments primarily engaged in manufacturing woven, tufted, and other
carpets and rugs, such as art squares, floor mattings, needle punch
carpeting, and door mats and mattings, from textile materials or from
twisted paper, grasses, reeds, coir, sisal, jute, or rags.

2273  Carpets and Rugs
Establishments primarily engaged in manufacturing woven, tufted, and other
carpets and rugs, such as art squares, floor mattings, needle punch
carpeting, and door mats and mattings, from textile materials or from
twisted paper, grasses, reeds, coir, sisal, jute, or rags.

228  YARN AND THREAD MILLS
This industry group includes establishments primarily classified as yarn
spinning mills; yarn texturizing, throwing, twisting, and winding mills;
and thread mills.

2281  Yarn Spinning Mills
Establishments primarily engaged in spinning yarn wholly or chiefly by
weight of cotton, manmade fibers, silk, wool, mohair, or similar animal
fibers. Establishments primarily engaged in dyeing or finishing purchased
yarns or finishing yarns on a commission basis are classified in industry
2231 if the yarns are of wool and in industry 2269 if they are of other
fibers. Establishments primarily engaged in producing specialty yarns or
producing spun yarns of other fibers are classified in industry 2299.

2282  Yarn Texturizing, Throwing, Twisting, and Winding Mills
Establishments primarily engaged in texturizing, throwing, twisting,
winding, or spooling purchased yarns or manmade fiber filaments wholly
or chiefly by weight of cotton, manmade fibers, silk, or wool, mohair
or similar animal fibers, or in performing such activities on a commission
basis. Establishments primarily engaged in dyeing or finishing purchased
yarns or finishing yarns on a commission basis are classified in industry
2231 if the yarns are of wool and in industry 2269 if they are of other
fibers. Establishments primarily engaged in producing and texturizing
manmade fiber filaments and yarns in the same plant are classified in
industries 2823 or 2824.

2284  Thread Mills
Establishments primarily engaged in manufacturing thread of cotton, silk,
manmade fibers, wool or similar animal fibers. Important products of this
industry include sewing, crochet, darning, embroidery, tatting, hand-
knitting, and other handicraft threads. Establishments primarily engaged in
manufacturing thread of flax, hemp, and ramie are classified in industry
2299.

229  MISCELLANEOUS TEXTILE GOODS
This industry group includes establishments primarily engaged in
manufacturing coated fabrics, not rubberized; tire cord and fabrics;
nonwoven fabrics; cordage and twine; and textile goods, not elsewhere
classified.

2295  Coated Fabrics, Not Rubberized
Establishments primarily engaged in manufacturing coated, impregnated, or
laminated textiles, and in the special finishing of textiles, such as
varnishing and waxing. Establishments primarily engaged in rubberizing
purchased fabrics are classified in industry 3069, and those engaged in
dyeing and finishing textiles are classified in industry group 226 or
industry 2231.

2296  Tire Cord and Fabrics
Establishments primarily engaged in manufacturing cord and fabric of
manmade fibers, cotton, glass, steel, or other materials for use in
reinforcing rubber tires, industrial belting, fuel cells, and similar uses.

2297  Nonwoven Fabrics
Establishments primarily engaged in manufacturing nonwoven fabrics (by
bonding and/or interlocking of fibers) by mechanical, chemical, thermal or
solvent means, or by combinations thereof. Establishments primarily engaged
in producing woven felts are classified in industry 2231; and those
producing other felts are classified in industry 2299.

2298  Cordage and Twine
Establishments primarily engaged in manufacturing rope, cable, cordage,
twine, and related products from abaca (Manila), sisal, henequen, hemp,
cotton, paper, jute, flax, manmade fibers including glass, and other
fibers.

2299  Textile Goods, Not Elsewhere Classified
Establishments primarily engaged in manufacturing textile goods, not
elsewhere classified, including linen goods, jute goods, felt goods,
padding and upholstery filling and processed waste and recovered fibers and
flock. Establishments primarily engaged in processing textile fibers to
prepare them for spinning, such as wool scouring and carbonizing and
combing and converting tow to top, are also classified here. Establishments
primarily engaged in manufacturing woven wool felts and wool haircloth are
classified in industry 2231, and those manufacturing needle punch carpeting
are classified in industry 2273.  Establishments primarily engaged in
manufacturing embroideries are classified in industry group 239.
Establishments primarily engaged in manufacturing lace goods are classified
in industry 2258.  Establishments primarily engaged in sorting wiping rags
or waste are classified in Wholesale Trade, industry 5093.

=>23  APPAREL & OTHER FINISHED PRODS MADE FROM FABRICS & SIMILAR MATERIALS
This major group, known as the cutting-up and needle trades, includes
establishments producing clothing and fabricating products by cutting
and sewing purchased woven or knit textile fabrics and related materials,
such as leather, rubberized fabrics, plastics, and furs.  Also included are
establishments that manufacture clothing by cutting and joining (for
example, by adhesives) materials such as paper and nonwoven textiles.
Included in the apparel industries are three types of establishments: (1)
the regular or inside factories; (2) contract factories; and (3) apparel
jobbers. The regular factories perform all of the usual manufacturing
functions within their own plant; the contract factories manufacture
apparel from materials owned by others; and apparel jobbers perform the
entrepreneurial functions of a manufacturing company, such as buying raw
materials, designing and preparing samples, arranging for the manufacture
of clothing from their materials, and selling of the finished apparel.

Knitting mills are classified in industry 2253 if primarily knitting
outerwear, and in industry 2254 if primarily knitting underwear and
nightwear. Custom tailors and dressmakers not operating on a factory basis
are classified in Retail Trade, industry 5699; and establishments which
purchase and resell finished garments but do not perform the functions of
the apparel jobbers are classified in Wholesale Trade, industry group 513.

231  MEN'S AND BOYS' SUITS, COATS, AND OVERCOATS
Establishments primarily engaged in manufacturing men's and boys' tailored
suits, coats, and overcoats from purchased woven or knit fabrics.
Establishments primarily engaged in manufacturing uniforms (except athletic
and work uniforms) are also included in this industry.  Establishments
primarily engaged in manufacturing men's work uniforms and clothing are
classified in industry 2326, and those manufacturing men's and boys'
athletic uniforms are classified in industry 2329.  Knitting mills
primarily engaged in manufacturing suits and coats are classified in
industry 2253.

2311  Men's and Boys' Suits, Coats, and Overcoats
Establishments primarily engaged in manufacturing men's and boys' tailored
suits, coats, and overcoats from purchased woven or knit fabrics.
Establishments primarily engaged in manufacturing uniforms (except athletic
and work uniforms) are also included in this industry.  Establishments
primarily engaged in manufacturing men's work uniforms and clothing are
classified in industry 2326, and those manufacturing men's and boys'
athletic uniforms are classified in industry 2329.  Knitting mills
primarily engaged in manufacturing suits and coats are classified in
industry 2253.

232  MEN'S AND BOYS' FURNISHINGS, WORK CLOTHING, AND ALLIED GARMENTS
This industry group includes establishments primarily engaged in
manufacturing men's and boys' shirts; men's and boys' underwear and
nightwear; men's and boys' neckwear; men's and boys' separate trousers and
slacks; men's and boys' work clothing; and men's and boys' clothing, not
elsewhere classified.

2321  Men's and Boys' Shirts, Except Work Shirts
Establishments primarily engaged in manufacturing men's and boys' shirts
(including polo and sport shirts) from purchased woven or knit fabrics.
Establishments primarily engaged in manufacturing work shirts are
classified in industry 2326. Knitting mills primarily engaged in
manufacturing outerwear are classified in industry 2253.

2322  Men's and Boys' Underwear and Nightwear
Establishments primarily engaged in manufacturing men's and boys' underwear
and nightwear from purchased woven or knit fabrics. Knitting mills
primarily engaged in manufacturing underwear and nightwear are classified
in industry 2254; and those manufacturing men's and boys' robes are
classified in industry 2384.

2323  Men's and Boys' Neckwear
Establishments primarily engaged in manufacturing men's and boys' neckties,
scarves, and mufflers from purchased woven or knit fabrics.  Knitting mills
primarily engaged in manufacturing neckties, scarves, and mufflers are
classified in industry 2253.

2325  Men's and Boys' Separate Trousers and Slacks
Establishments primarily engaged in manufacturing men's and boys' separate
trousers and slacks from purchased woven or knit fabrics, including jeans,
dungarees, and jean-cut casual slacks. Establishments primarily engaged in
manufacturing complete suits are classified in industry 2311; those
manufacturing workpants (excluding jeans and dungarees) are classified in
industry 2326. Knitting mills primarily engaged in manufacturing men's and
boys' separate trousers and slacks are classified in industry 2253.

2326  Men's and Boys' Work Clothing
Establishments primarily engaged in manufacturing men's and boys' work
shirts, workpants (excluding jeans and dungarees), other work clothing, and
washable service apparel. Establishments primarily engaged in manufacturing
separate trousers and slacks are classified in industry 2325.

2329  Men's and Boys' Clothing, Not Elsewhere Classified
Establishments primarily engaged in manufacturing men's and boys' clothing,
not elsewhere classified, from purchased woven or knit fabrics.
Establishments primarily engaged in manufacturing leather and sheep-lined
garments are classified in industry 2386. Knitting mills primarily engaged
in manufacturing outerwear are classified in industry 2253.

233  WOMEN'S, MISSES', AND JUNIORS' OUTERWEAR
This industry group includes establishments primarily engaged in
manufacturing women's, misses', and juniors' blouses and shirts; women's
misses', and juniors' dresses; women's, misses', and juniors' suits,
skirts, and coats; and women's, misses', and juniors' outerwear, not
elsewhere classified.

2331  Women's, Misses', and Juniors' Blouses and Shirts
Establishments primarily engaged in manufacturing women's, misses', and
juniors' blouses and shirts from purchased woven or knit fabrics.  Knitting
mills primarily engaged in manufacturing outerwear are classified in
industry 2253. Establishments primarily engaged in manufacturing girls',
children's, and infants' blouses and shirts are classified in industry
2361.

2335  Women's, Misses', and Juniors' Dresses
Establishments primarily engaged in manufacturing women's, misses', and
juniors' dresses (including ensemble dresses), from purchased woven or knit
fabrics, including woven or knit fabrics of paper, whether sold by the
piece or by the dozen. Establishments primarily engaged in manufacturing
girls', children's, and infants' dresses are classified in industry 2361.
Knitting mills primarily engaged in manufacturing knit dresses are
classified in industry 2253.

2337  Women's, Misses', and Juniors' Suits, Skirts, and Coats
Establishments primarily engaged in manufacturing women's, misses', and
juniors' suits, pantsuits, skirts, coats, except fur coats and raincoats,
and tailored jackets and vests, from purchased woven or knit fabrics. These
garments are generally tailored and usually lined.  Establishments
primarily engaged in manufacturing fur clothing are classified in industry
2371; and those manufacturing raincoats are classified in industry 2385.
Knitting mills primarily engaged in manufacturing knit outerwear are
classified in industry 2253.

2339  Women's, Misses', and Juniors' Outerwear, Not Elsewhere Classified
Establishments primarily engaged in manufacturing women's, misses', and
juniors' outerwear, not elsewhere classified, from purchased woven or knit
fabrics. Knitting mills primarily engaged in manufacturing outerwear are
classified in industry 2253.

234  WOMEN'S, MISSES', CHILDREN'S, AND INFANTS' UNDERGARMENTS
This industry group includes establishments primarily engaged in
manufacturing women's, misses', children's, and infants' underwear and
nightwear, and brassieres, girdles, and allied garments.

2341  Women's, Misses', Children's, and Infants' Underwear and Nightwear
Establishments primarily engaged in manufacturing women's, misses',
children's, and infants' underwear and nightwear from purchased woven
or knit fabrics. Knitting mills primarily engaged in manufacturing
underwear and nightwear are classified in industry 2254. Establishments
primarily engaged in manufacturing women's and misses' robes and dressing
gowns are classified in industry 2384, and those manufacturing children's
and infants' robes are classified in industry 2369.  Establishments
primarily engaged in manufacturing brassieres, girdles, and allied garments
are classified in industry 2342.

2342  Brassieres, Girdles, and Allied Garments
Establishments primarily engaged in manufacturing brassieres, girdles,
corsets, corset accessories, and allied garments. Establishments primarily
engaged in manufacturing surgical and orthopedic appliances are classified
in industry 3842.

235  HATS, CAPS, AND MILLINERY
Establishments primarily engaged in manufacturing hats, caps, and
millinery, and hat bodies. Establishments primarily engaged in
manufacturing millinery trimmings are classified in industry 2396.
Establishments primarily engaged in manufacturing hats and caps of paper
are classified in industry 2679; those manufacturing caps of rubber are
classified in industry 3069; those manufacturing caps of plastics are
classified in industry 3089; and those manufacturing fur hats are
classified in industry 2371.

2353  Hats, Caps, and Millinery
Establishments primarily engaged in manufacturing hats, caps, and
millinery, and hat bodies. Establishments primarily engaged in
manufacturing millinery trimmings are classified in industry 2396.
Establishments primarily engaged in manufacturing hats and caps of paper
are classified in industry 2679; those manufacturing caps of rubber are
classified in industry 3069; those manufacturing caps of plastics are
classified in industry 3089; and those manufacturing fur hats are
classified in industry 2371.

236  GIRLS', CHILDREN'S, AND INFANTS' OUTERWEAR
This industry group includes establishments primarily engaged in
manufacturing girls', children's, and infants' dresses, blouses, and shirts
and girls', children's, and infants' outerwear, not elsewhere classified.

2361  Girls', Children's, and Infants' Dresses, Blouses, and Shirts
Establishments primarily engaged in manufacturing girls', children's, and
infants' dresses, blouses, and shirts from purchased woven or knit fabrics.
Knitting mills primarily engaged in manufacturing outerwear are classified
in industry 2253.

2369  Girls', Children's, and Infants' Outerwear, Not Elsewhere Classified
Establishments primarily engaged in manufacturing girls', children's, and
infants' outerwear, not elsewhere classified, from purchased woven or knit
fabrics. Knitting mills primarily engaged in manufacturing outerwear are
classified in industry 2253.

237  FUR GOODS
Establishments primarily engaged in manufacturing fur coats, and other
clothing, accessories, and trimmings made of fur. Establishments primarily
engaged in manufacturing sheep-lined clothing are classified in industry
2386, and those engaged in dyeing and dressing of furs are classified in
industry 3999.

2371  Fur Goods
Establishments primarily engaged in manufacturing fur coats, and other
clothing, accessories, and trimmings made of fur. Establishments primarily
engaged in manufacturing sheep-lined clothing are classified in industry
2386, and those engaged in dyeing and dressing of furs are classified in
industry 3999.

238  MISCELLANEOUS APPAREL AND ACCESSORIES
This industry group includes establishments primarily engaged in
manufacturing dress and work gloves, except knit and all-leather; robes and
dressing gowns; waterproof outerwear; leather and sheep-lined clothing; and
apparel belts.

2381  Dress and Work Gloves, Except Knit and All-Leather
Establishments primarily engaged in manufacturing dress, semidress, and
work gloves and mittens from purchased woven or knit fabrics, or from these
materials combined with leather or plastics. Knitting mills primarily
engaged in manufacturing gloves and mittens are classified in industry
2259; establishments primarily engaged in manufacturing leather gloves are
classified in industry 3151; those manufacturing sporting and athletic
gloves are classified in industry 3949; and those manufacturing safety
gloves are classified in industry 3842.

2384  Robes and Dressing Gowns
Establishments primarily engaged in manufacturing men's, boys', and women's
robes and dressing gowns from purchased woven or knit fabrics.
Establishments primarily engaged in manufacturing girls', children's, and
infants' robes from purchased fabric are classified in industry 2369.
Knitting mills primarily engaged in manufacturing knit robes and dressing
gowns are classified in industry 2253.

2385  Waterproof Outerwear
Establishments primarily engaged in manufacturing raincoats and other
waterproof outerwear from purchased rubberized fabrics, plastics, and
similar materials. Included in this industry are establishments primarily
engaged in manufacturing waterproof or water-repellant outerwear from
purchased woven or knit fabrics other than wool.  Establishments primarily
engaged in manufacturing men's and boys' oiled-fabric work clothing are
classified in industry 2326, and those manufacturing vulcanized rubber
clothing and clothing made from rubberized fabrics produced in the same
establishment are classified in industry 3069.

2386  Leather and Sheep-Lined Clothing
Establishments primarily engaged in manufacturing leather and sheep-lined
clothing. Establishments primarily engaged in manufacturing leather gloves
and mittens are classified in industry 3151, and those manufacturing fur
clothing are classified in industry 2371.

2387  Apparel Belts
Establishments primarily engaged in manufacturing apparel belts of any
material.

2389  Apparel and Accessories, Not Elsewhere Classified
Establishments primarily engaged in manufacturing suspenders, garters,
handkerchiefs, and other apparel, not elsewhere classified, such as
academic caps and gowns, vestments, and theatrical costumes. Also included
are establishments primarily engaged in manufacturing clothing by cutting
and joining (for example, by adhesives) materials such as paper and
nonwoven textiles.

239  MISCELLANEOUS FABRICATED TEXTILE PRODUCTS
This industry group includes establishments primarily engaged in
manufacturing curtains and draperies; housefurnishings; textile bags;
canvas and related products; performing pleating, decorative and novelty
stitching, and tucking for the trade; manufacturing automotive trimmings,
apparel findings, and related products; Schiffli machine embroideries; and
manufacturing fabricated textile products, not elsewhere classified.

2391  Curtains and Draperies
Establishments primarily engaged in manufacturing curtains and draperies
from purchased materials. Establishments primarily engaged in manufacturing
lace curtains on lace machines are classified in industry 2258, and those
manufacturing shower curtains are classified in industry 2392.

2392  Housefurnishings, Except Curtains and Draperies
Establishments primarily engaged in manufacturing housefurnishings, such as
blankets, bedspreads, sheets, tablecloths, towels, and shower curtains from
purchased materials. Establishments primarily engaged in manufacturing
curtains and draperies are classified in industry 2391.  Establishments
producing housefurnishings primarily of fabric woven at the same
establishment are classified in industries 2211, 2221, 2231, or 2299
according to fiber.

2393  Textile Bags
Establishments primarily engaged in manufacturing shipping and other
industrial bags from purchased fabrics. Establishments primarily engaged in
manufacturing plastics bags are classified in industry 2673; those
manufacturing laundry, wardrobe, shoe, and other textile housefurnishing
bags are classified in industry 2392; and those manufacturing luggage are
classified in industry 3161.

2394  Canvas and Related Products
Establishments primarily engaged in manufacturing awnings, tents, and
related products from purchased fabrics. Establishments primarily engaged
in manufacturing canvas bags are classified in industry 2393.

2395  Pleating, Decorative and Novelty Stitching, and Tucking for the Trade
Establishments primarily engaged in pleating, decorative and novelty
stitching, and tucking for the trade. Establishments primarily engaged
in performing similar services for individuals are classified in service
industries. Establishments primarily engaged in manufacturing trimmings are
classified in industry 2396.

2396  Automotive Trimmings, Apparel Findings, and Related Products
Establishments primarily engaged in manufacturing automotive trimmings,
apparel findings, and related products. Included in this industry are
establishments primarily engaged in printing and stamping on fabric
articles.

2397  Schiffli Machine Embroideries
Establishments primarily engaged in manufacturing Schiffli machine
embroideries.

2399  Fabricated Textile Products, Not Elsewhere Classified
Establishments primarily engaged in manufacturing fabricated textile
products, not elsewhere classified.

=>24  LUMBER AND WOOD PRODUCTS, EXCEPT FURNITURE
This major group includes establishments engaged in cutting timber and
pulpwood; merchant sawmills, lath mills, shingle mills, cooperage stock
mills, planing mills, and plywood mills and veneer mills engaged in
producing lumber and wood basic materials; and establishments engaged
in manufacturing finished articles made entirely or mainly of wood or
related materials. Certain types of establishments producing wood products
are classified elsewhere. For example, furniture and office and store
fixtures are classified in major group 25; musical instruments, toys and
playground equipment, and caskets are classified in major group 39.
Woodworking in connection with construction, in the nature of
reconditioning and repair, or performed to individual order, is classified
in nonmanufacturing industries. Establishments engaged in integrated
operations of logging combined with sawmills, pulp mills, or other
converting activity, with the logging not separately reported, are
classified according to the primary product shipped.

241  LOGGING
Establishments primarily engaged in cutting timber and in producing rough,
round, hewn, or riven primary forest or wood raw materials, or in producing
wood chips in the field. Independent contractors engaged in estimating or
trucking timber, but who perform no cutting operations, are classified in
nonmanufacturing industries.  Establishments primarily engaged in the
collection of bark, sap, gum, and other forest products are classified in
Forestry, major group 08.

2411  Logging
Establishments primarily engaged in cutting timber and in producing rough,
round, hewn, or riven primary forest or wood raw materials, or in producing
wood chips in the field. Independent contractors engaged in estimating or
trucking timber, but who perform no cutting operations, are classified in
nonmanufacturing industries.  Establishments primarily engaged in the
collection of bark, sap, gum, and other forest products are classified in
Forestry, major group 08.

242  SAWMILLS AND PLANING MILLS
This industry group includes establishments primarily classified as general
sawing and planing mills; hardwood dimension and flooring mills; and
special product sawmills, not elsewhere classified.

2421  Sawmills and Planing Mills, General
Establishments primarily engaged in sawing rough lumber and timber from
logs and bolts, or resawing cants and flitches into lumber, including box
lumber and softwood cut stock; planing mills combined with sawmills; and
separately operated planing mills which are engaged primarily in producing
surfaced lumber and standard workings or patterns of lumber. This industry
includes establishments primarily engaged in sawing lath and railroad ties
and in producing tobacco hogshead stock, wood chips, and snow fence lath.
Establishments primarily engaged in manufacturing box shook or boxes are
classified in industry group 244; those manufacturing sash, doors, wood
molding, window and door frames, and other fabricated millwork are
classified in industry group 243; and those manufacturing hardwood
dimension and flooring are classified in industry 2426.

2426  Hardwood Dimension and Flooring Mills
Establishments primarily engaged in manufacturing hardwood dimension lumber
and workings therefrom; and other hardwood dimension, semifabricated or
ready for assembly; hardwood flooring; and wood frames for household
furniture. Establishments primarily engaged in manufacturing stairwork,
molding, and trim are classified in industry 2431; and those manufacturing
textile machinery bobbins, picker sticks, and shuttles are classified in
industry 3552.

2429  Special Product Sawmills, Not Elsewhere Classified
Mills primarily engaged in manufacturing excelsior, wood shingles, and
cooperage stock; and in sawing special products, not elsewhere classified.

243  MILLWORK, VENEER, PLYWOOD, AND STRUCTURAL WOOD MEMBERS
This industry group includes establishments primarily engaged in
manufacturing millwork; wood kitchen cabinets; hardwood veneer and plywood;
softwood veneer and plywood; and structural wood members, not elsewhere
classified.

2431  Millwork
Establishments primarily engaged in manufacturing fabricated wood millwork,
including wood millwork covered with materials such as metal and plastics.
Planing mills primarily engaged in producing millwork are included in this
industry, but planing mills primarily producing standard workings or
patterns of lumber are classified in industry 2421. Establishments
primarily manufacturing wood kitchen cabinets and bathroom vanities for
permanent installation are classified in industry 2434.

2434  Wood Kitchen Cabinets
Establishments primarily engaged in manufacturing wood kitchen cabinets and
wood bathroom vanities, generally for permanent installation.
Establishments primarily engaged in manufacturing free-standing cabinets
and vanities are classified in major group 25. Establishments primarily
engaged in building custom cabinets for individuals are classified in
Retail Trade, industry 5712.

2435  Hardwood Veneer and Plywood
Establishments primarily engaged in producing commercial hardwood veneer
and those primarily engaged in manufacturing commercial plywood or
prefinished hardwood plywood. This includes nonwood backed or faced veneer
and nonwood faced plywood, from veneer produced in the same establishment
or from purchased veneer. Establishments primarily engaged in the
production of veneer which is used in the same establishment for the
manufacture of wood containers, such as fruit and vegetable baskets and
wood boxes are classified in industry group 244.

2436  Softwood Veneer and Plywood
Establishments primarily engaged in producing commercial softwood veneer
and plywood, from veneer produced in the same establishment or from
purchased veneer. Establishments primarily engaged in producing commercial
hardwood veneer and plywood are classified in industry 2435. Establishments
primarily engaged in the production of veneer which is used in the same
establishment for the manufacture of wood containers such as fruit and
vegetable baskets and wood boxes are classified in industry group 244.

2439  Structural Wood Members, Not Elsewhere Classified
Establishments primarily engaged in producing laminated or fabricated
trusses, arches, and other structural members of lumber. Establishments
primarily engaged in fabrication on the site of construction are classified
in Division C, Construction. Establishments primarily engaged in producing
prefabricated wood buildings, sections, and panels are classified in
industry 2452.

244  WOOD CONTAINERS
This industry group includes establishments primarily engaged in
manufacturing nailed and lock corner wood boxes and shook; wood pallets and
skids; and wood containers, not elsewhere classified.

2441  Nailed and Lock Corner Wood Boxes and Shook
Establishments primarily engaged in manufacturing nailed and lock corner
wood boxes (lumber or plywood), and shook for nailed and lock corner boxes.

2448  Wood Pallets and Skids
Establishments primarily engaged in manufacturing wood or wood and metal
combination pallets and skids.

2449  Wood Containers, Not Elsewhere Classified
Establishments primarily engaged in manufacturing wood containers, not
elsewhere classified, such as cooperage, wirebound boxes and crates,
and other veneer and plywood containers. Establishments primarily engaged
in manufacturing tobacco hogshead stock are classified in industry 2421,
and those manufacturing cooperage stock are classified in industry 2429.

245  WOOD BUILDINGS AND MOBILE HOMES
This industry group includes establishments primarily engaged in
manufacturing mobile homes and prefabricated wood buildings and components.

2451  Mobile Homes
Establishments primarily engaged in manufacturing mobile homes and
nonresidential mobile buildings. These units are generally more than 35
feet long, at least 8 feet wide, do not have facilities for storage of
water or waste, and are equipped with wheels. Trailers that are generally
35 feet long or less, 8 feet wide or less, and with self-contained
facilities are classified in industry 3792. Portable wood buildings not
equipped with wheels are classified in industry 2452.

2452  Prefabricated Wood Buildings and Components
Establishments primarily engaged in manufacturing prefabricated wood
buildings, sections, and panels. Establishments primarily engaged in
fabricating buildings on the site of construction are classified in
Division C, Construction.

249  MISCELLANEOUS WOOD PRODUCTS
This industry group includes establishments primarily engaged in wood
preserving; manufacturing reconstituted wood products; and manufacturing
wood products, not elsewhere classified.

2491  Wood Preserving
Establishments primarily engaged in treating wood, sawed or planed in other
establishments, with creosote or other preservatives to prevent decay and
to protect against fire and insects. This industry also includes the
cutting, treating, and selling of poles, posts, and piling, but
establishments primarily engaged in manufacturing other wood products,
which they may also treat with preservatives, are not included.

2493  Reconstituted Wood Products
Establishments primarily engaged in manufacturing reconstituted wood
products. Important products of this industry are hardboard, particleboard,
insulation board, medium density fiberboard, waferboard, and oriented
strandboard.

2499  Wood Products, Not Elsewhere Classified
Establishments primarily engaged in manufacturing miscellaneous wood
products, not elsewhere classified, and products from rattan, reed, splint,
straw, veneer, veneer strips, wicker, and willow.

=>25  FURNITURE AND FIXTURES
This major group includes establishments engaged in manufacturing
household, office, public building, and restaurant furniture; and office
and store fixtures. Establishments primarily engaged in the production of
millwork are classified in industry 2431; those manufacturing wood kitchen
cabinets are classified in industry 2434; those manufacturing cut stone and
concrete furniture are classified in major group 32; those manufacturing
laboratory and hospital furniture, except hospital beds, are classified in
major group 38; those manufacturing beauty and barber shop furniture are
classified in major group 39; and those engaged in woodworking to
individual order or in the nature of reconditioning and repair are
classified in nonmanufacturing industries.

251  HOUSEHOLD FURNITURE
This industry group includes establishments primarily engaged in
manufacturing wood household furniture, including upholstered; metal
household furniture; mattresses, foundations, and convertible beds; wood
television, radio, phonograph, and sewing machines cabinets; and household
furniture, not elsewhere classified.

2511  Wood Household Furniture, Except Upholstered
Establishments primarily engaged in manufacturing wood household furniture
commonly used in dwellings. This industry also includes establishments
manufacturing camp furniture. Establishments engaged in manufacturing
upholstered furniture are classified in industry 2512; those manufacturing
reed, rattan, and similar furniture are classified in industry 2519; those
manufacturing television, radio, phonograph, and sewing machine cabinets
are classified in industry 2517; and those manufacturing kitchen cabinets
and bathroom vanities are classified in industry 2434.

2512  Wood Household Furniture, Upholstered
Establishments primarily engaged in manufacturing upholstered furniture on
wood frames. Shops primarily engaged in reupholstering furniture, or
upholstering frames to individual order, are classified in Services,
industry 7641, or Retail Trade, industry 5712. Establishments primarily
engaged in manufacturing dual-purpose sleep furniture, such as convertible
sofas and chair beds, are classified in industry 2515, regardless of the
material used in the frame. Establishments primarily engaged in
manufacturing wood frames for upholstered furniture are classified in
industry 2426.

2514  Metal Household Furniture
Establishments primarily engaged in manufacturing metal household furniture
of a type commonly used in dwellings. Establishments primarily engaged in
manufacturing dual-purpose sleep furniture, such as convertible sofas and
chair beds, are classified in industry 2515, regardless of the material
used in the frame.

2515  Mattresses, Foundations, and Convertible Beds
Establishments primarily engaged in manufacturing innerspring mattresses,
box spring mattresses, and noninnerspring mattresses containing felt, foam
rubber, urethane, hair, or any other filling material; and assembled wire
springs (fabric, coil, or box) for use on beds, couches, and cots. This
industry also includes establishments primarily engaged in manufacturing
dual-purpose sleep furniture, such as convertible sofas and chair beds,
regardless of the material used in the frame. Establishments primarily
engaged in manufacturing automobile seats and backs are classified in
industry 2531; those manufacturing individual wire springs are classified
in industry 3495; and those manufacturing paddings and upholstery filling
are classified in industry 2299.

2517  Wood Television, Radio, Phonograph, and Sewing Machine Cabinets
Establishments primarily engaged in manufacturing wood cabinets for radios,
television sets, phonographs, and sewing machines.

2519  Household Furniture, Not Elsewhere Classified
Establishments primarily engaged in manufacturing reed, rattan, and other
wicker furniture, plastics and fiberglass household furniture and cabinets,
and household furniture, not elsewhere classified.

252  OFFICE FURNITURE
This industry group includes establishments primarily engaged in
manufacturing wood and nonwood office furniture.

2521  Wood Office Furniture
Establishments primarily engaged in manufacturing office furniture, chiefly
of wood.

2522  Office Furniture, Except Wood
Establishments primarily engaged in manufacturing office furniture, except
furniture chiefly of wood. Establishments primarily engaged in
manufacturing safes and vaults are classified in industry 3499.

253  PUBLIC BUILDING AND RELATED FURNITURE
Establishments primarily engaged in manufacturing furniture for schools,
theaters, assembly halls, churches, and libraries.  Establishments
primarily engaged in manufacturing seats for public conveyances, as well as
seats for automobiles and aircraft, are included in this industry.
Establishments primarily engaged in manufacturing stone furniture are
classified in industry 3281, and those manufacturing concrete furniture are
classified in industry 3272.

2531  Public Building and Related Furniture
Establishments primarily engaged in manufacturing furniture for schools,
theaters, assembly halls, churches, and libraries.  Establishments
primarily engaged in manufacturing seats for public conveyances, as well as
seats for automobiles and aircraft, are included in this industry.
Establishments primarily engaged in manufacturing stone furniture are
classified in industry 3281, and those manufacturing concrete furniture are
classified in industry 3272.

254  PARTITIONS, SHELVING, LOCKERS, AND OFFICE AND STORE FIXTURES
This industry group includes establishments primarily engaged in
manufacturing wood and nonwood office and store fixtures, partitions,
shelving, and lockers.

2541  Wood Office and Store Fixtures, Partitions, Shelving, and Lockers
Establishments primarily engaged in manufacturing shelving, lockers, and
office and store fixtures, plastics laminated fixture tops, and related
fabricated products, chiefly of wood. Prefabricated partitions are included
in this industry if designed to be attached to the floor and are classified
in industry 2521 if designed to be free-standing or part of an office
furniture panel system. Establishments primarily engaged in manufacturing
refrigerated cabinets, showcases, and display cases are classified in
industry 3585.

2542  Office & Store Fixtures, Partitions, Shelving, & Lockers, Except Wood
Establishments primarily engaged in manufacturing office and store
fixtures, shelving, storage racks, lockers, and related fabricated
products, chiefly of materials other than wood. Prefabricated partitions
are included in this industry if designed to be attached to the floor and
are classified in industry 2522 if designed to be free-standing or part of
an office furniture panel system.  Establishments primarily engaged in
manufacturing refrigerated cabinets, showcases, and display cases are
classified in industry 3585 and those manufacturing safes and vaults are
classified in industry 3499.

259  MISCELLANEOUS FURNITURE AND FIXTURES
This industry group includes establishments primarily engaged in
manufacturing drapery hardware and window blinds and shades, and furniture
and fixtures, not elsewhere classified.

2591  Drapery Hardware and Window Blinds and Shades
Establishments primarily engaged in manufacturing curtain and drapery rods,
poles, and fixtures; and venetian blinds and other window blinds and
shades, except of canvas. Establishments primarily engaged in manufacturing
canvas shades and awnings are classified in industry 2394.

2599  Furniture and Fixtures, Not Elsewhere Classified
Establishments primarily engaged in manufacturing furniture and fixtures,
not elsewhere classified, including hospital beds and furniture specially
designed for use in restaurants, bars, cafeterias, bowling centers, and
ships.

=>26  PAPER AND ALLIED PRODUCTS
This major group includes establishments primarily engaged in the
manufacture of pulps from wood and other cellulose fibers, and from rags;
the manufacture of paper and paperboard; and the manufacture of paper and
paperboard into converted products, such as paper coated off the paper
machine, paper bags, paper boxes, and envelopes. Also included are
establishments primarily engaged in manufacturing bags of plastics film and
sheet. Certain types of converted paper products are classified elsewhere,
such as abrasive paper which is in industry 3291; carbon paper in industry
3955; and photosensitized and blueprint paper in industry 3861.

261  PULP MILLS
Establishments primarily engaged in manufacturing pulp from wood or from
other materials, such as rags, linters, wastepaper, and straw.
Establishments engaged in integrated logging and pulp mill operations
are classified according to the primary products shipped.  Establishments
engaged in integrated operations of producing pulp and manufacturing paper,
paperboard, or products thereof are classified in industry 2621 if
primarily shipping paper or paper products; in industry 2631 if primarily
shipping paperboard or paperboard products; and in industry 2611 if
primarily shipping pulp. Establishments primarily engaged in cutting
pulpwood are classified in industry 2411.

2611  Pulp Mills
Establishments primarily engaged in manufacturing pulp from wood or from
other materials, such as rags, linters, wastepaper, and straw.
Establishments engaged in integrated logging and pulp mill operations
are classified according to the primary products shipped.  Establishments
engaged in integrated operations of producing pulp and manufacturing paper,
paperboard, or products thereof are classified in industry 2621 if
primarily shipping paper or paper products; in industry 2631 if primarily
shipping paperboard or paperboard products; and in industry 2611 if
primarily shipping pulp. Establishments primarily engaged in cutting
pulpwood are classified in industry 2411.

262  PAPER MILLS
Establishments primarily engaged in manufacturing paper from wood pulp and
other fiber pulp, and which may also manufacture converted paper products.
Establishments primarily engaged in integrated operations of producing pulp
and manufacturing paper are included in this industry if primarily shipping
paper or paper products. Establishments primarily engaged in manufacturing
converted paper products from purchased paper stock are classified in
industry group 265 or 267.

2621  Paper Mills
Establishments primarily engaged in manufacturing paper from wood pulp and
other fiber pulp, and which may also manufacture converted paper products.
Establishments primarily engaged in integrated operations of producing pulp
and manufacturing paper are included in this industry if primarily shipping
paper or paper products. Establishments primarily engaged in manufacturing
converted paper products from purchased paper stock are classified in
industry group 265 or 267.

263  PAPERBOARD MILLS
Establishments primarily engaged in manufacturing paperboard, including
paperboard coated on the paperboard machine, from wood pulp and other fiber
pulp; and which may also manufacture converted paperboard products.
Establishments primarily engaged in integrated operations of producing pulp
and manufacturing paperboard are included in this industry if primarily
shipping paperboard or paperboard products.  Establishments primarily
engaged in manufacturing converted paperboard products from purchased
paperboard are classified in industry group 265 or 267. Establishments
primarily engaged in manufacturing insulation board and other reconstituted
wood fiberboard are classified in industry 2493.

2631  Paperboard Mills
Establishments primarily engaged in manufacturing paperboard, including
paperboard coated on the paperboard machine, from wood pulp and other fiber
pulp; and which may also manufacture converted paperboard products.
Establishments primarily engaged in integrated operations of producing pulp
and manufacturing paperboard are included in this industry if primarily
shipping paperboard or paperboard products.  Establishments primarily
engaged in manufacturing converted paperboard products from purchased
paperboard are classified in industry group 265 or 267. Establishments
primarily engaged in manufacturing insulation board and other reconstituted
wood fiberboard are classified in industry 2493.

265  PAPERBOARD CONTAINERS and BOXES
This industry group includes establishments primarily engaged in
manufacturing setup paperboard boxes; corrugated and solid fiber boxes;
fiber cans, tubes, drums, and similar products; nonfolding sanitary food
containers; and folding paperboard boxes, including sanitary.

2652  Setup Paperboard Boxes
Establishments primarily engaged in manufacturing setup paperboard boxes
from purchased paperboard.

2653  Corrugated and Solid Fiber Boxes
Establishments primarily engaged in manufacturing corrugated and solid
fiber boxes and related products from purchased paperboard of fiber stock.
Important products of this industry include corrugated and solid fiberboard
boxes, pads, partitions, display items, pallets, single face products, and
corrugated sheets.

2655  Fiber Cans, Tubes, Drums, and Similar Products
Establishments primarily engaged in manufacturing from purchased materials
fiber cans, cones, drums, and similar products, with or without metal ends,
and vulcanized fiber boxes.

2656  Sanitary Food Containers, Except Folding
Establishments primarily engaged in manufacturing nonfolding food
containers from special foodboard. Important products of this industry
include fluid milk containers, round nested food containers, paper cups for
hot or cold drinks, and stamped plates, dishes, spoons, and similar
products. Establishments primarily engaged in manufacturing similar items
of plastics materials are classified in industry group 308 and those making
folding sanitary cartons are classified in industry 2657.

2657  Folding Paperboard Boxes, Including Sanitary
Establishments primarily engaged in manufacturing folding paperboard boxes
from purchased paperboard, including folding sanitary food boxes or cartons
except milk cartons.

267  CONVERTED PAPER AND PAPERBOARD PRODUCTS, EXCEPT CONTAINERS
AND BOXES
This industry group includes establishments primarily engaged in
manufacturing coated and laminated packaging paper and plastics film;
coated and laminated paper, not elsewhere classified; plastics, foil, and
coated paper bags; uncoated paper and multiwall bags; die-cutting paper and
paperboard and cardboard; manufacturing sanitary paper products;
manufacturing envelopes; manufacturing stationery, tablets, and related
products; and manufacturing converted paper and paperboard products, not
elsewhere classified.

2671  Packaging Paper and Plastics Film, Coated and Laminated
Establishments primarily engaged in manufacturing coated or laminated
flexible materials made of combinations of paper, plastics film, metal
foil, and similar materials (excluding textiles) for packaging purposes.
These are made from purchased sheet materials or plastics resins and may be
printed in the same establishment. Establishments primarily engaged in
manufacturing coated or laminated paper for other purposes are classified
in industry 2672, including establishments manufacturing all gummed or
pressure sensitive tape; those manufacturing unsupported plastics film are
classified in industry 3081; those manufacturing aluminum foil are
classified in industry 3497; and those manufacturing paper from pulp are
classified in industry 2621.

2672  Coated and Laminated Paper, Not Elsewhere Classified
Establishments primarily engaged in manufacturing coated, laminated, or
processed paper and film from purchased paper, except for packaging.  Also
included are establishments primarily manufacturing gummed paper products
and pressure sensitive tape with backing of any material other than rubber,
for any application. Establishments primarily engaged in manufacturing
coated and laminated paper for packaging are classified in industry 2671;
those manufacturing carbon paper are classified in industry 3955; and those
manufacturing photographic and blueprint paper are classified in industry
3861.

2673  Plastics, Foil, and Coated Paper Bags
Establishments primarily engaged in manufacturing bags of unsupported
plastics film, coated paper, metal foil, or laminated combinations of these
materials, whether or not printed. Establishments primarily engaged in
manufacturing uncoated paper bags and multiwall bags and sacks are
classified in industry 2674; those manufacturing textile bags are
classified in industry 2393; and those manufacturing garment storage bags,
except of plastics film and paper, are classified in industry 2392.

2674  Uncoated Paper and Multiwall Bags
Establishments primarily engaged in manufacturing uncoated paper bags, or
manufacturing multiwall bags and sacks, whether or not coated or containing
plastics film or metal foil. Establishments primarily engaged in
manufacturing bags from plastics, unsupported film, foil, coated paper, or
laminated or coated combinations of these materials, are classified in
industry 2673; and those manufacturing textile bags are classified in
industry 2393.

2675  Die-Cut Paper and Paperboard and Cardboard
Establishments primarily engaged in die-cutting purchased paper and
paperboard; and in manufacturing cardboard by laminating, lining, or
surface-coating paperboard. Establishments primarily engaged in laminating
building paper from purchased paper are classified in industry 2679.

2676  Sanitary Paper Products
Establishments primarily engaged in manufacturing sanitary paper products
from purchased paper, such as facial tissues and handkerchiefs, table
napkins, toilet paper, towels, disposable diapers, and sanitary napkins and
tampons.

2677  Envelopes
Establishments primarily engaged in manufacturing envelopes of any
description from purchased paper and paperboard. Establishments primarily
engaged in manufacturing stationery are classified in industry 2678.

2678  Stationery, Tablets, and Related Products
Establishments primarily engaged in manufacturing stationery, tablets,
looseleaf fillers, and related items from purchased paper.  Establishments
primarily engaged in manufacturing envelopes are classified in industry
2677.

2679  Converted Paper and Paperboard Products, Not Elsewhere Classified
Establishments primarily engaged in manufacturing miscellaneous converted
paper or paperboard products, not elsewhere classified, from purchased
paper or paperboard. Also included in this industry are pressed and molded
pulp goods, such as papier-mache articles, other than statuary and art
goods.

=>27  PRINTING, PUBLISHING, AND ALLIED INDUSTRIES
This major group includes establishments engaged in printing by one or more
common processes, such as letterpress; lithography (including offset),
gravure, or screen; and those establishments which perform services for the
printing trade, such as bookbinding and platemaking.  This major group also
includes establishments engaged in publishing newspapers, books, and
periodicals, regardless of whether or not they do their own printing. News
syndicates are classified in Services, industry 7383. Establishments
primarily engaged in textile printing and finishing fabrics are classified
in major group 22, and those engaged in printing and stamping on fabric
articles are classified in industry 2396. Establishments manufacturing
products that contain incidental printing, such as advertising or
instructions, are classified according to the nature of the products for
example, as cartons, bags, plastics film, or paper.

271  NEWSPAPERS: PUBLISHING, OR PUBLISHING AND PRINTING
Establishments primarily engaged in publishing newspapers, or in publishing
and printing newspapers. These establishments carry on the various
operations necessary for issuing newspapers, including the gathering of
news and the preparation of editorials and advertisements, but may or may
not perform their own printing. Commercial printing is frequently carried
on by establishments engaged in publishing and printing newspapers, but,
even though the commercial printing may be of major importance, such
establishments are included in this industry.  Establishments not engaged
in publishing newspapers, but which print newspapers for publishers, are
classified in industry group 275. News syndicates are classified in
Services, industry 7383.

2711  Newspapers: Publishing, or Publishing and Printing
Establishments primarily engaged in publishing newspapers, or in publishing
and printing newspapers. These establishments carry on the various
operations necessary for issuing newspapers, including the gathering of
news and the preparation of editorials and advertisements, but may or may
not perform their own printing. Commercial printing is frequently carried
on by establishments engaged in publishing and printing newspapers, but,
even though the commercial printing may be of major importance, such
establishments are included in this industry.  Establishments not engaged
in publishing newspapers, but which print newspapers for publishers, are
classified in industry group 275. News syndicates are classified in
Services, industry 7383.

272  PERIODICALS: PUBLISHING, OR PUBLISHING AND PRINTING
Establishments primarily engaged in publishing periodicals, or in
publishing and printing periodicals. These establishments carry on the
various operations necessary for issuing periodicals, but may or may
not perform their own printing. Establishments not engaged in publishing
periodicals, but which print periodicals for publishers, are classified in
industry group 275.

2721  Periodicals: Publishing, or Publishing and Printing
Establishments primarily engaged in publishing periodicals, or in
publishing and printing periodicals. These establishments carry on the
various operations necessary for issuing periodicals, but may or may
not perform their own printing. Establishments not engaged in publishing
periodicals, but which print periodicals for publishers, are classified in
industry group 275.

273  BOOKS
Establishments primarily engaged in publishing, or in publishing and
printing, books and pamphlets. Establishments primarily engaged in printing
or in printing and binding (but not publishing) books and pamphlets are
classified in industry 2732.

Establishments primarily engaged in printing, or in printing and binding,
books and pamphlets, but not engaged in publishing.  Establishments
primarily engaged in publishing, or in publishing and printing, books and
pamphlets are classified in industry 2731.  Establishments engaged in both
printing and binding books, but primarily binding books printed elsewhere,
are classified in industry 2789.

2731  Books: Publishing, or Publishing and Printing
Establishments primarily engaged in publishing, or in publishing and
printing, books and pamphlets. Establishments primarily engaged in printing
or in printing and binding (but not publishing) books and pamphlets are
classified in industry 2732.

2732  Book Printing
Establishments primarily engaged in printing, or in printing and binding,
books and pamphlets, but not engaged in publishing.  Establishments
primarily engaged in publishing, or in publishing and printing, books and
pamphlets are classified in industry 2731.  Establishments engaged in both
printing and binding books, but primarily binding books printed elsewhere,
are classified in industry 2789.

274  MISCELLANEOUS PUBLISHING
Establishments primarily engaged in miscellaneous publishing activities,
not elsewhere classified, whether or not engaged in printing.
Establishments primarily engaged in offering financial, credit, or other
business services, and which may publish directories as part of this
service, are classified in Division I, Services.

2741  Miscellaneous Publishing
Establishments primarily engaged in miscellaneous publishing activities,
not elsewhere classified, whether or not engaged in printing.
Establishments primarily engaged in offering financial, credit, or other
business services, and which may publish directories as part of this
service, are classified in Division I, Services.

275  COMMERCIAL PRINTING
This industry group includes establishments primarily engaged in commercial
lithographic printing; commercial gravure printing; and commercial
printing, not elsewhere classified.

2752  Commercial Printing, Lithographic
Establishments primarily engaged in printing by the lithographic process.
The greater part of the work in this industry is performed on a job or
custom basis; but in some cases lithographed calendars, maps, posters,
decalcomanias, or other products are made for sale. Offset printing, photo-
offset printing, and photolithographing are also included in this industry.
Establishments primarily engaged in lithographing books and pamphlets,
without publishing, are classified in industry 2732. Establishments
primarily engaged in publishing or printing greeting cards are classified
in industry 2771. Establishments primarily engaged in preparing
lithographic or offset plates and in related services are classified in
industry 2796. Establishments primarily engaged in providing photocopying
services are classified in Services, industry 7334.

2754  Commercial Printing, Gravure
Establishments primarily engaged in gravure printing. Establishments
primarily engaged in making and preparing plates for printing are
classified in industry 2796.

2759  Commercial Printing, Not Elsewhere Classified
Establishments primarily engaged in commercial or job printing, not
elsewhere classified. This industry includes general printing shops, not
elsewhere classified, as well as shops specializing in printing newspapers
and periodicals for others.

276  MANIFOLD BUSINESS FORMS
Establishments primarily engaged in designing and printing, by any process,
special forms for use in the operation of a business, in single and
multiple sets, including carbonized or interleaved with carbon or otherwise
processed for multiple reproduction.

2761  Manifold Business Forms
Establishments primarily engaged in designing and printing, by any process,
special forms for use in the operation of a business, in single and
multiple sets, including carbonized or interleaved with carbon or otherwise
processed for multiple reproduction.

277  GREETING CARDS
Establishments primarily engaged in publishing, printing by any process, or
both, of greeting cards for all occasions. Establishments primarily engaged
in producing hand painted greeting cards are classified in Services,
industry 8999.

2771  Greeting Cards
Establishments primarily engaged in publishing, printing by any process, or
both, of greeting cards for all occasions. Establishments primarily engaged
in producing hand painted greeting cards are classified in Services,
industry 8999.

278  BLANKBOOKS, LOOSELEAF BINDERS, AND BOOKBINDING AND RELATED WORK
This industry group includes establishments primarily engaged in
manufacturing blankbooks, looseleaf binders and devices; and bookbinding
and related work.

2782  Blankbooks, Looseleaf Binders and Devices
Establishments primarily engaged in manufacturing blankbooks, looseleaf
devices, and library binders; and in ruling paper.

2789  Bookbinding and Related Work
Establishments primarily engaged in edition, trade, job, and library
bookbinding. Also included in this industry are establishments primarily
engaged in book or paper bronzing, gilding, and edging; in map and sample
mounting; and in other services related to bookbinding.  Establishments
primarily binding books printed elsewhere are classified in this industry,
but those primarily binding books printed in the same establishment are
classified in industry group 273.

279  SERVICE INDUSTRIES FOR THE PRINTING TRADE
This industry group includes establishments primarily engaged in
typesetting, and platemaking and related services.

2791  Typesetting
Establishments primarily engaged in typesetting for the trade, including
advertisement typesetting.

2796  Platemaking and Related Services
Establishments primarily engaged in making plates for printing purposes and
in related services. Also included are establishments primarily engaged in
making positives or negatives from which offset lithographic plates are
made. These establishments do not print from the plates which they make,
but prepare them for use by others. Engraving for purposes other than
printing is classified in industry 3479.

=>28  CHEMICALS AND ALLIED PRODUCTS
This major group includes establishments producing basic chemicals, and
establishments manufacturing products by predominantly chemical processes.
Establishments classified in this major group manufacture three general
classes of products: (1) basic chemicals, such as acids, alkalies, salts,
and organic chemicals; (2) chemical products to be used in further
manufacture, such as synthetic fibers, plastics materials, dry colors, and
pigments; and (3) finished chemical products to be used for ultimate
consumption, such as drugs, cosmetics, and soaps; or to be used as
materials or supplies in other industries, such as paints, fertilizers, and
explosives. The mining of natural alkalies and other natural potassium,
sodium, and boron compounds, of natural rock salt, and of other natural
chemicals and fertilizers are classified in Mining, industry group 147.
Establishments primarily engaged in manufacturing nonferrous metals and
highpercentage ferroalloys are classified in major group 33; those
manufacturing silicon carbide are classified in major group 32; those
manufacturing baking powder, other leavening compounds, and starches are
classified in major group 20; and those manufacturing artists' colors are
classified in major group 39. Establishments primarily engaged in
packaging, repackaging, and bottling of purchased chemical products,
but not engaged in manufacturing chemicals and allied products, are
classified in Wholesale or Retail Trade industries.

281  INDUSTRIAL INORGANIC CHEMICALS
This industry group includes establishments primarily engaged in
manufacturing basic industrial inorganic chemicals. Establishments
primarily engaged in manufacturing formulated agricultural pesticides
are classified in industry 2879; those manufacturing medicinal chemicals,
drugs, and medicines are classified in industry group 283; and those
manufacturing soap and cosmetics are classified in industry group 284.

2812  Alkalies and Chlorine
Establishments primarily engaged in manufacturing alkalies and chlorine.
Establishments primarily engaged in mining natural alkalies are classified
in Mining, industry 1474.

2813  Industrial Gases
Establishments primarily engaged in manufacturing industrial gases
(including organic) for sale in compressed, liquid, and solid forms.
Establishments primarily engaged in manufacturing fluorine and sulfur
dioxide are classified in industry 2819; those manufacturing household
ammonia are classified in industry 2842; those manufacturing other ammonia
are classified in industry 2873; those manufacturing chlorine are
classified in industry 2812; and those manufacturing fluorocarbon gases are
classified in industry 2869. Distributors of industrial gases and
establishments primarily engaged in shipping liquid oxygen are classified
in Wholesale Trade, industry 5169.

2816  Inorganic Pigments
Establishments primarily engaged in manufacturing inorganic pigments.
Important products of this industry include black pigments, except carbon
black, white pigments, and color pigments. Organic color pigments, except
animal black and bone black, are classified in industry 2865, and those
manufacturing carbon black are classified in industry 2895.

2819  Industrial Inorganic Chemicals, Not Elsewhere Classified
Establishments primarily engaged in manufacturing industrial inorganic
chemicals, not elsewhere classified. Establishments primarily engaged
in mining, milling, or otherwise preparing natural potassium, sodium, or
boron compounds (other than common salt) are classified in industry 1474.
Establishments primarily engaged in manufacturing household bleaches are
classified in industry 2842; those manufacturing phosphoric acid are
classified in industry 2874; and those manufacturing nitric acid, anhydrous
ammonia, and other nitrogenous fertilizer materials are classified in
industry 2873.

282  PLASTICS MATERIALS & SYNTHETIC RESINS, SYNTHETIC RUBBER, CELLULOSIC
     & OTHER MANMADE FIBERS, EXCEPT GLASS
This group includes chemical establishments primarily engaged in
manufacturing plastics materials and synthetic resins, synthetic rubbers,
and cellulosic and other manmade fibers. Establishments primarily engaged
in the manufacture of rubber products, and those primarily engaged in the
compounding of purchased resins or the fabrication of plastics sheets,
rods, and miscellaneous plastics products, are classified in major group
30; and textile mills primarily engaged in throwing, spinning, weaving, or
knitting textile products from manufactured fibers are classified in major
group 22.

2821  Plastics Materials, Synthetic Resins, and Nonvulcanizable Elastomers
Establishments primarily engaged in manufacturing synthetic resins,
plastics materials, and nonvulcanizable elastomers. Important products
of this industry include: cellulose plastics materials; phenolic and other
tar acid resins; urea and melamine resins; vinyl resins; styrene resins;
alkyd resins; acrylic resins; polyethylene resins; polypropylene resins;
rosin modified resins; coumarone-indene and petroleum polymer resins;
miscellaneous resins, including polyamide resins, silicones,
polyisobutylenes, polyesters, polycarbonate resins, acetal resins, and
fluorohydrocarbon resins; and casein plastics.  Establishments primarily
engaged in manufacturing fabricated plastics products or plastics film,
sheet, rod, nontextile monofilaments and regenerated cellulose products,
and vulcanized fiber are classified in industry group 308, whether from
purchased resins or from resins produced in the same plant. Establishments
primarily engaged in compounding purchased resins are classified in
industry 3087.  Establishments primarily manufacturing adhesives are
classified in industry 2891.

2822  Synthetic Rubber (Vulcanizable Elastomers)
Establishments primarily engaged in manufacturing synthetic rubber by
polymerization or copolymerization. An elastomer for the purpose of this
classification is a rubber-like material capable of vulcanization, such as
copolymers of butadiene and styrene, or butadiene and acrylonitrile,
polybutadienes, chloroprene rubbers, and isobutylene-isoprene copolymers.
Butadiene copolymers containing less than 50 percent butadiene are
classified in industry 2821. Natural chlorinated rubbers and cyclized
rubbers are considered as semifinished products and are classified in
industry 3069.

2823  Cellulosic Manmade Fibers
Establishments primarily engaged in manufacturing cellulosic fibers
(including cellulose acetate and regenerated cellulose such as rayon by the
viscose or cuprammonium process) in the form of monofilament, yarn, staple,
or tow suitable for further manufacturing on spindles, looms, knitting
machines, or other textile processing equipment.

2824  Manmade Organic Fibers, Except Cellulosic
Establishments primarily engaged in manufacturing manmade organic fibers,
except cellulosic (including those of regenerated proteins, and of polymers
or copolymers of such components as vinyl chloride, vinylidene chloride,
linear esters, vinyl alcohols, acrylonitrile, ethylenes, amides, and
related polymeric materials), in the form of monofilament, yarn, staple, or
tow suitable for further manufacturing on spindles, looms, knitting
machines, or other textile processing equipment. Establishments primarily
engaged in manufacturing textile glass fibers are classified in industry
3229.

283  DRUGS
This group includes establishments primarily engaged in manufacturing,
fabricating, or processing medicinal chemicals and pharmaceutical products.
Also included in this group are establishments primarily engaged in the
grading, grinding, and milling of botanicals.

2833  Medicinal Chemicals and Botanical Products
Establishments primarily engaged in: (1) manufacturing bulk organic and
inorganic medicinal chemicals and their derivatives and (2) processing
(grading, grinding, and milling) bulk botanical drugs and herbs.  Included
in this industry are establishments primarily engaged in manufacturing
agar-agar and similar products of natural origin, endocrine products,
manufacturing or isolating basic vitamins, and isolating active medicinal
principals such as alkaloids from botanical drugs and herbs.

2834  Pharmaceutical Preparations
Establishments primarily engaged in manufacturing, fabricating, or
processing drugs in pharmaceutical preparations for human or veterinary
use. The greater part of the products of these establishments are finished
in the form intended for final consumption, such as ampoules, tablets,
capsules, vials, ointments, medicinal powders, solutions, and suspensions.
Products of this industry consist of two important lines, namely: (1)
pharmaceutical preparations promoted primarily to the dental, medical, or
veterinary professions, and (2) pharmaceutical preparations promoted
primarily to the public.

2835  In Vitro and In Vivo Diagnostic Substances
Establishments primarily engaged in manufacturing in vitro and in vivo
diagnostic substances, whether or not packaged for retail sale. These
materials are chemical, biological, and radioactive substances used in
diagnosing or monitoring the state of human or veterinary health by
identifying and measuring normal or abnormal constituents of body fluids or
tissues.

2836  Biological Products, Except Diagnostic Substances
Establishments primarily engaged in the production of bacterial and virus
vaccines, toxoids, and analogous products (such as allergenic extracts),
serums, plasmas, and other blood derivatives for human or veterinary use,
other than in vitro and in vivo diagnostic substances.  Establishments
primarily engaged in manufacturing in vitro and in vivo diagnostic
substances are classified in industry 2835.

284  SOAP, DETERGENTS, & CLEANING PREPARATIONS; PERFUMES, COSMETICS, &
     OTHER TOILET PREPARATIONS
This industry group includes establishments primarily engaged in
manufacturing soap and other detergents and in producing glycerin from
vegetable and animal fats and oils; specialty cleaning, polishing, and
sanitation preparations; and surface active preparations used as
emulsifiers, wetting agents, and finishing agents, including sulfonated
oils; and perfumes, cosmetics, and other toilet preparations.

2841  Soap and Other Detergents, Except Specialty Cleaners
Establishments primarily engaged in manufacturing soap, synthetic organic
detergents, inorganic alkaline detergents, or any combination thereof, and
establishments producing crude and refined glycerin from vegetable and
animal fats and oils. Establishments primarily engaged in manufacturing
shampoos or shaving products, whether from soap or synthetic detergents,
are classified in industry 2844; and those manufacturing synthetic glycerin
are classified in industry 2869.

2842  Specialty Cleaning, Polishing, and Sanitation Preparations
Establishments primarily engaged in manufacturing furniture, metal, and
other polishes; waxes and dressings for fabricated leather and other
materials; household, institutional, and industrial plant disinfectants;
nonpersonal deodorants; drycleaning preparations; household bleaches; and
other sanitation preparations. Establishments primarily engaged in
manufacturing industrial bleaches are classified in industry 2819, and
those manufacturing household pesticidal preparations are classified in
industry 2879.

2843 Surface Active Agents, Finishing Agents, Sulfonated Oils, & Assistants
Establishments primarily engaged in producing surface active preparations
for use as wetting agents, emulsifiers, and penetrants.  Establishments
engaged in producing sulfonated oils and fats and related products are also
included.

2844  Perfumes, Cosmetics, and Other Toilet Preparations
Establishments primarily engaged in manufacturing perfumes (natural and
synthetic), cosmetics, and other toilet preparations. This industry
also includes establishments primarily engaged in blending and compounding
perfume bases; and those manufacturing shampoos and shaving products,
whether from soap or synthetic detergents. Establishments primarily engaged
in manufacturing synthetic perfume and flavoring materials are classified
in industry 2869, and those manufacturing essential oils are classified in
industry 2899.

285  PAINTS, VARNISHES, LACQUERS, ENAMELS, AND ALLIED PRODUCTS
Establishments primarily engaged in manufacturing paints (in paste and
ready-mixed form); varnishes; lacquers; enamels and shellac; putties, wood
fillers, and sealers; paint and varnish removers; paint brush cleaners; and
allied paint products. Establishments primarily engaged in manufacturing
carbon black are classified in industry 2895; those manufacturing bone
black, lamp black, and inorganic color pigments are classified in industry
2816; those manufacturing organic color pigments are classified in industry
2865; those manufacturing plastics materials are classified in industry
2821; those manufacturing printing ink are classified in industry 2893;
those manufacturing caulking compounds and sealants are classified in
industry 2891; those manufacturing artists' paints are classified in
industry 3952; and those manufacturing turpentine are classified in
industry 2861.

2851  Paints, Varnishes, Lacquers, Enamels, and Allied Products
Establishments primarily engaged in manufacturing paints (in paste and
ready-mixed form); varnishes; lacquers; enamels and shellac; putties, wood
fillers, and sealers; paint and varnish removers; paint brush cleaners; and
allied paint products. Establishments primarily engaged in manufacturing
carbon black are classified in industry 2895; those manufacturing bone
black, lamp black, and inorganic color pigments are classified in industry
2816; those manufacturing organic color pigments are classified in industry
2865; those manufacturing plastics materials are classified in industry
2821; those manufacturing printing ink are classified in industry 2893;
those manufacturing caulking compounds and sealants are classified in
industry 2891; those manufacturing artists' paints are classified in
industry 3952; and those manufacturing turpentine are classified in
industry 2861.

286  INDUSTRIAL ORGANIC CHEMICALS
Establishments primarily engaged in manufacturing industrial organic
chemicals. Important products of this group include: (1) noncyclic organic
chemicals, such as acetic, chloroacetic, adipic, formic, oxalic and
tartaric acids, and their metallic salts; chloral, formaldehyde, and
methylamine; (2) solvents such as amyl, butyl, and ethyl alcohols;
methanol; amyl, butyl and ethyl acetates; ethyl ether, ethylene glycol
ether, and diethylene glycol ether; acetone, carbon disulfide, and
chlorinated solvents, such as carbon tetrachloride, perchloroethylene, and
trichloroethylene; (3) polyhydric alcohols, such as ethylene glycol,
sorbitol, pentaerythritol, synthetic glycerin; (4) synthetic perfume and
flavoring materials, such as coumarin, methyl salicylate, saccharin,
citral, citronellal, synthetic geraniol, ionone, terpineol, and synthetic
vanillin; (5) rubber processing chemicals, such as accelerators and
antioxidants, both cyclic and acyclic; (6) plasticizers, both cyclic and
acyclic, such as esters of phosphoric acid, phthalic anhydride, adipic
acid, lauric acid, oleic acid, sebacic acid, and stearic acid; (7)
synthetic tanning agents, such as naphthalene sulfonic acid condensates;
(8) chemical warfare gases; (9) esters, amines, etc., of polyhydric
alcohols and fatty and other acids; (10) cyclic crudes and intermediates;
(11) cyclic dyes and organic pigments; and (12) natural gum and wood
chemicals.

Establishments primarily engaged in manufacturing plastics materials and
nonvulcanizable elastomers are classified in industry 2821; those
manufacturing synthetic rubber are classified in industry 2822; those
manufacturing essential oils are classified in industry 2899; those
manufacturing rayon and other manmade fibers are classified in
industries 2823 and 2824; those manufacturing specialty cleaning,
polishing, and sanitation preparations are classified in industry 2842;
those manufacturing paints are classified in industry 2851; and those
manufacturing inorganic pigments are classified in industry 2816.
Distillers engaged in the manufacture of grain alcohol for beverage
purposes are classified in industry 2085.

2861  Gum and Wood Chemicals
Establishments primarily engaged in manufacturing hardwood and softwood
distillation products, wood and gum naval stores, charcoal, natural
dyestuffs, and natural tanning materials. Establishments primarily engaged
in manufacturing synthetic organic tanning materials are classified in
industry 2869, and those manufacturing synthetic organic dyes are
classified in industry 2865.

2865  Cyclic Organic Crudes & Intermediates, and Organic Dyes and Pigments
Establishments primarily engaged in manufacturing cyclic organic crudes and
intermediates, and organic dyes and pigments. Important products of this
industry include: (1) aromatic chemicals, such as benzene, toluene, mixed
xylenes naphthalene; (2) synthetic organic dyes; and (3) synthetic organic
pigments. Establishments primarily engaged in manufacturing coal tar crudes
in chemical recovery ovens are classified in industry 3312, and petroleum
refineries which produce such products as byproducts of petroleum refining
are classified in industry 2911.

2869  Industrial Organic Chemicals, Not Elsewhere Classified
Establishments primarily engaged in manufacturing industrial organic
chemicals, not elsewhere classified. Important products of this industry
include: (1) aliphatic and other acyclic organic chemicals, such as
ethylene, butylene, and butadiene; acetic, chloroacetic, adipic, formic,
oxalic, and tartaric acids and their metallic salts; chloral, formaldehyde,
and methylamine; (2) solvents, such as amyl, butyl, and ethyl alcohols;
methanol; amyl, butyl, and ethyl acetates; ethyl ether, ethylene glycol
ether, and diethylene glycol ether; acetone, carbon disulfide and
chlorinated solvents, such as carbon tetrachloride, perchloroethylene, and
trichloroethylene; (3) polyhydric alcohols, such as ethylene glycol,
sorbitol, pentaerythritol, synthetic glycerin; (4) synthetic perfume and
flavoring materials, such as coumarin, methyl salicylate, saccharin,
citral, citronellal, synthetic geraniol, ionone, terpineol, and synthetic
vanillin; (5) rubber processing chemicals, such as accelerators and
antioxidants, both cyclic and acyclic; (6) plasticizers, both cyclic and
acyclic, such as esters of phosphoric acid, phthalic anhydride, adipic
acid, lauric acid, oleic acid, sebacic acid, and stearic acid; (7)
synthetic tanning agents, such as naphthalene sulfonic acid condensates;
(8) chemical warfare gases; and (9) esters, amines, etc., of polyhydric
alcohols and fatty and other acids.

Establishments primarily engaged in manufacturing plastics materials and
nonvulcanizable elastomers are classified in industry 2821; those
manufacturing synthetic rubber are classified in industry 2822; those
manufacturing essential oils are classified in industry 2899; those
manufacturing wood distillation products, naval stores and natural
dyeing and tanning materials are classified in industry 2861; those
manufacturing manmade textile fibers are classified in industries 2823 and
2824; those manufacturing specialty cleaning, polishing, and sanitation
preparations are classified in industry 2842; those manufacturing paints
are classified in industry 2851; those manufacturing urea are classified in
industry 2873; those manufacturing organic pigments are classified in
industry 2865; those manufacturing inorganic pigments are classified in
industry 2816 and those manufacturing aliphatics and aromatics as
byproducts of petroleum refining are classified in industry 2911.
Distilleries engaged in the manufacture of grain alcohol for beverage
purposes are classified in industry 2085.

287  AGRICULTURAL CHEMICALS
This group includes establishments primarily engaged in manufacturing
nitrogenous and phosphatic basic fertilizers, mixed fertilizers,
pesticides, and other agricultural chemicals. Establishments primarily
engaged in manufacturing basic chemicals, which require further processsing
or formulation before use as agricultural pest control agents, are
classified in industry groups 281 or 286.

2873  Nitrogenous Fertilizers
Establishments primarily engaged in manufacturing nitrogenous fertilizer
materials or mixed fertilizers from nitrogenous materials produced in the
same establishment. Included are ammonia fertilizer compounds and anhydrous
ammonia, nitric acid, ammonium nitrate, ammonium sulfate and nitrogen
solutions, urea, and natural organic fertilizers (except compost) and
mixtures.

2874  Phosphatic Fertilizers
Establishments primarily engaged in manufacturing phosphatic fertilizer
materials, or mixed fertilizers from phosphatic materials produced in
the same establishment. Included are phosphoric acid; normal, enriched, and
concentrated superphosphates; ammonium phosphates; nitro-phosphates; and
calcium meta-phosphates.

2875  Fertilizers, Mixing Only
Establishments primarily engaged in mixing fertilizers from purchased
fertilizer materials.

2879  Pesticides and Agricultural Chemicals, Not Elsewhere Classified
Establishments primarily engaged in the formulation and preparation of
ready-to-use agricultural and household pest control chemicals, including
insecticides, fungicides, and herbicides, from technical chemicals or
concentrates; and the production of concentrates which require further
processing before use as agricultural pesticides.  This industry also
includes establishments primarily engaged in manufacturing or formulating
agricultural chemicals, not elsewhere classified, such as minor or trace
elements and soil conditioners.  Establishments primarily engaged in
manufacturing basic or technical agricultural pest control chemicals are
classified in industry group 281 if the chemicals are inorganic and in
industry group 286 if they are organic.  Establishments primarily engaged
in manufacturing agricultural lime products are classified in major group
32.

289  MISCELLANEOUS CHEMICAL PRODUCTS
This industry group includes establishments primarily engaged in
manufacturing adhesives and sealants; explosives; printing ink; carbon
black; and chemicals and chemical preparations, not elsewhere classified.

2891  Adhesives and Sealants
Establishments primarily engaged in manufacturing industrial and household
adhesives, glues, caulking compounds, sealants, and linoleum, tile, and
rubber cements from vegetable, animal, or synthetic plastics materials,
purchased or produced in the same establishment.  Establishments primarily
engaged in manufacturing gelatin and sizes are classified in industry 2899,
and those manufacturing vegetable gelatin or agar-agar are classified in
industry 2833.

2892  Explosives
Establishments primarily engaged in manufacturing explosives.
Establishments primarily engaged in manufacturing ammunition for small arms
are classified in industry 3482, and those manufacturing fireworks are
classified in industry 2899.

2893  Printing Ink
Establishments primarily engaged in manufacturing printing ink, including
gravure ink, screen process ink, and lithographic ink.  Establishments
primarily engaged in manufacturing writing ink and fluids are classified in
industry 2899, and those manufacturing drawing ink are classified in
industry 3952.

2895  Carbon Black
Establishments primarily engaged in manufacturing carbon black (channel and
furnace black). Establishments primarily engaged in manufacturing bone and
lamp black are classified in industry 2816.

2899  Chemicals and Chemical Preparations, Not Elsewhere Classified
Establishments primarily engaged in manufacturing miscellaneous chemical
preparations, not elsewhere classified, such as fatty acids, essential
oils, gelatin (except vegetable), sizes, bluing, laundry sours, writing and
stamp pad ink, industrial compounds, such as boiler and heat insulating
compounds, metal, oil, and water treating compounds, water-proofing
compounds, and chemical supplies for foundries. Establishments primarily
engaged in manufacturing vegetable gelatin (agar-agar) are classified in
industry 2833; those manufacturing dessert preparations based on gelatin
are classified in industry 2099; those manufacturing printing ink are
classified in industry 2893; and those manufacturing drawing ink are
classified in industry 3952.

=>29  PETROLEUM REFINING AND RELATED INDUSTRIES
This major group includes establishments primarily engaged in petroleum
refining, manufacturing paving and roofing materials, and compounding
lubricating oils and greases from purchased materials. Establishments
manufacturing and distributing gas to consumers are classified in public
utilities industries, and those primarily engaged in producing coke and
byproducts are classified in major group 33.

291  PETROLEUM REFINING
Establishments primarily engaged in producing gasoline, kerosene,
distillate fuel oils, residual fuel oils, and lubricants, through
fractionation or straight distillation of crude oil, redistillation of
unfinished petroleum derivatives, cracking or other processes.
Establishments of this industry also produce aliphatic and aromatic
chemicals as byproducts. Establishments primarily engaged in producing
natural gasoline from natural gas are classified in mining industries.
Those manufacturing lubricating oils and greases by blending and
compounding purchased materials are included in industry 2992.
Establishments primarily re-refining used lubricating oils are classified
in industry 2992. Establishments primarily engaged in manufacturing cyclic
and acyclic organic chemicals are classified in major group 28.

2911  Petroleum Refining
Establishments primarily engaged in producing gasoline, kerosene,
distillate fuel oils, residual fuel oils, and lubricants, through
fractionation or straight distillation of crude oil, redistillation of
unfinished petroleum derivatives, cracking or other processes.
Establishments of this industry also produce aliphatic and aromatic
chemicals as byproducts. Establishments primarily engaged in producing
natural gasoline from natural gas are classified in mining industries.
Those manufacturing lubricating oils and greases by blending and
compounding purchased materials are included in industry 2992.
Establishments primarily re-refining used lubricating oils are classified
in industry 2992. Establishments primarily engaged in manufacturing cyclic
and acyclic organic chemicals are classified in major group 28.

295  ASPHALT PAVING AND ROOFING MATERIALS
This industry group includes establishments primarily engaged in
manufacturing asphalt paving mixtures and blocks, and asphalt felts and
coatings.

2951  Asphalt Paving Mixtures and Blocks
Establishments primarily engaged in manufacturing asphalt and tar paving
mixtures; and paving blocks made of asphalt and various compositions of
asphalt or tar with other materials. Establishments primarily engaged in
manufacturing brick, concrete, granite, and stone paving blocks are
classified in major group 32.

2952  Asphalt Felts and Coatings
Establishments primarily engaged in manufacturing, from purchased
materials, asphalt and other saturated felts in roll or shingle form,
either smooth or faced with grit, and in manufacturing roofing cements and
coatings. Establishments primarily engaged in manufacturing paint are
classified in industry 2851, and those manufacturing linoleum and tile
cement are classified in industry 2891.

299  MISCELLANEOUS PRODUCTS OF PETROLEUM AND COAL
This industry group includes establishments primarily engaged in
manufacturing lubricating oils and greases, and products of petroleum and
coal, not elsewhere classified.

2992  Lubricating Oils and Greases
Establishments primarily engaged in blending, compounding, and re-refining
lubricating oils and greases from purchased mineral, animal, and vegetable
materials. Petroleum refineries engaged in the production of lubricating
oils and greases are classified in industry 2911.

2999  Products of Petroleum and Coal, Not Elsewhere Classified
Establishments primarily engaged in manufacturing packaged fuel, powdered
fuel, and other products of petroleum and coal, not elsewhere classified.

=>30  RUBBER AND MISCELLANEOUS PLASTICS PRODUCTS
This major group includes establishments manufacturing products, not
elsewhere classified, from plastics resins and from natural, synthetic, or
reclaimed rubber, gutta percha, balata, or gutta siak. Numerous products
made from these materials are included in other major groups, such as boats
in major group 37, and toys, buckles, and buttons in major group 39. This
group includes establishments primarily manufacturing tires, but
establishments primarily recapping and retreading automobile tires are
classified in Services, industry 7534.  Establishments primarily engaged in
manufacturing synthetic rubber and synthetic plastics resins are classified
in industry group 282.

301  TIRES AND INNER TUBES
Establishments primarily engaged in manufacturing pneumatic casings, inner
tubes, and solid and cushion tires for all types of vehicles, airplanes,
farm equipment, and children's vehicles; tiring; camelback; and tire repair
and retreading materials. Establishments primarily engaged in retreading
tires are classified in Services, industry 7534.

3011  Tires and Inner Tubes
Establishments primarily engaged in manufacturing pneumatic casings, inner
tubes, and solid and cushion tires for all types of vehicles, airplanes,
farm equipment, and children's vehicles; tiring; camelback; and tire repair
and retreading materials. Establishments primarily engaged in retreading
tires are classified in Services, industry 7534.

302  RUBBER AND PLASTICS FOOTWEAR
Establishments primarily engaged in manufacturing fabric upper footwear
having rubber or plastics soles vulcanized, injection molded, or cemented
to the uppers, and rubber and plastics protective footwear.  Establishments
primarily engaged in manufacturing rubber, composition, and fiber heels,
soles, soling strips, and related shoe making and repairing materials are
classified in industry 3069; those manufacturing plastics soles and soling
strips are classified in industry 3089; and those manufacturing other
footwear of rubber or plastics are classified in industry group 314.

3021  Rubber and Plastics Footwear
Establishments primarily engaged in manufacturing fabric upper footwear
having rubber or plastics soles vulcanized, injection molded, or cemented
to the uppers, and rubber and plastics protective footwear.  Establishments
primarily engaged in manufacturing rubber, composition, and fiber heels,
soles, soling strips, and related shoe making and repairing materials are
classified in industry 3069; those manufacturing plastics soles and soling
strips are classified in industry 3089; and those manufacturing other
footwear of rubber or plastics are classified in industry group 314.

305  GASKETS, PACKING, & SEALING DEVICES & RUBBER & PLASTICS HOSE & BELTING
This industry group includes establishments primarily engaged in
manufacturing rubber and plastics hose and belting; and gaskets, packing,
and sealing devices.

3052  Rubber and Plastics Hose and Belting
Establishments primarily engaged in manufacturing rubber and plastics hose
and belting, including garden hose. Establishments primarily engaged in
manufacturing rubber tubing are classified in industry group 306; those
manufacturing plastics tubing are classified in industry 3082; and those
manufacturing flexible metallic hose are classified in industry 3599.

3053  Gaskets, Packing, and Sealing Devices
Establishments primarily engaged in manufacturing gaskets, gasketing
materials, compression packings, mold packings, oil seals, and mechanical
seals. Included are gaskets, packing, and sealing devices made of leather,
rubber, metal, asbestos, and plastics.

306  FABRICATED RUBBER PRODUCTS, NOT ELSEWHERE CLASSIFIED
This industry group includes establishments primarily engaged in
manufacturing molded, extruded, and lathe-cut mechanical rubber goods; and
fabricated rubber products, not elsewhere classified.

3061  Molded, Extruded, and Lathe-Cut Mechanical Rubber Goods
Establishments primarily engaged in manufacturing molded, extruded, and
lathe-cut mechanical rubber goods. The products are generally parts for
machinery and equipment. Establishments primarily engaged in manufacturing
other industrial rubber goods, rubberized fabric, and miscellaneous rubber
specialties and sundries are classified in industry 3069.

3069  Fabricated Rubber Products, Not Elsewhere Classified
Establishments primarily engaged in manufacturing industrial rubber goods,
rubberized fabrics, and vulcanized rubber clothing, and miscellaneous
rubber specialties and sundries, not elsewhere classified. Included in this
industry are establishments primarily engaged in reclaiming rubber and
rubber articles. Establishments primarily engaged in the wholesale
distribution of scrap rubber are classified in Wholesale Trade, industry
5093. Establishments primarily engaged in rebuilding and retreading tires
are classified in Services, industry 7534; those manufacturing rubberized
clothing from purchased materials are classified in industry 2385; and
those manufacturing gaskets and packing are classified in industry 3053.

308  MISCELLANEOUS PLASTICS PRODUCTS
This industry group includes establishments primarily engaged in
manufacturing unsupported plastics film and sheet; unsupported plastics
profile shapes; laminated plastics plate, sheet, and profile shapes;
plastics pipe; plastics bottles; and plastics foam products; custom
compounding of purchased plastics resins; and manufacturing plastics
plumbing fixtures and plastics products, not elsewhere classified.

3081  Unsupported Plastics Film and Sheet
Establishments primarily engaged in manufacturing unsupported plastics film
and sheet, from purchased resins or from resins produced in the same plant.
Establishments primarily engaged in manufacturing plastics film and sheet
for blister and bubble formed packaging are classified in industry 3089.

3082  Unsupported Plastics Profile Shapes
Establishments primarily engaged in manufacturing unsupported plastics
profiles, rods, tubes, and other shapes. Establishments primarily
engaged in manufacturing plastics hose are classified in industry 3052.

3083  Laminated Plastics Plate, Sheet, and Profile Shapes
Establishments primarily engaged in manufacturing laminated plastics plate,
sheet, profiles, rods, and tubes. Establishments primarily engaged in
manufacturing laminated flexible packaging are classified in industry group
267.

3084  Plastics Pipe
Establishments primarily engaged in manufacturing plastics pipe.
Establishments primarily engaged in manufacturing plastics pipe fittings
are classified in industry 3089.

3085  Plastics Bottles
Establishments primarily engaged in manufacturing plastics bottles.

3086  Plastics Foam Products
Establishments primarily engaged in manufacturing plastics foam products.

3087  Custom Compounding of Purchased Plastics Resins
Establishments primarily engaged in custom compounding of purchased
plastics resins.

3088  Plastics Plumbing Fixtures
Establishments primarily engaged in manufacturing plastics plumbing
fixtures. Establishments primarily engaged in assembling plastics plumbing
fixture fittings are classified in industry 3432.  Establishments primarily
engaged in manufacturing plastics plumbing fixture components are
classified in industry 3089.

3089  Plastics Products, Not Elsewhere Classified
Establishments primarily engaged in manufacturing plastics products, not
elsewhere classified. Establishments primarily engaged in manufacturing
artificial leather are classified in industry 2295.

=>31  LEATHER AND LEATHER PRODUCTS
This major group includes establishments engaged in tanning, currying, and
finishing hides and skins, leather converters, and establishments
manufacturing finished leather and artificial leather products and some
similar products made of other materials.

311  LEATHER TANNING AND FINISHING
Establishments primarily engaged in tanning, currying, and finishing hides
and skins into leather. This industry also includes leather converters, who
buy hides and skins and have them processed into leather on a contract
basis by others.

3111  Leather Tanning and Finishing
Establishments primarily engaged in tanning, currying, and finishing hides
and skins into leather. This industry also includes leather converters, who
buy hides and skins and have them processed into leather on a contract
basis by others.

313  BOOT AND SHOE CUT STOCK AND FINDINGS
Establishments primarily engaged in manufacturing leather soles, inner
soles, and other boot and shoe cut stock and findings. This industry also
includes finished wood heels. Establishments primarily engaged in
manufacturing heels, soling strips, and soles made of rubber, composition,
plastics, and fiber are classified in major group 30.

3131  Boot and Shoe Cut Stock and Findings
Establishments primarily engaged in manufacturing leather soles, inner
soles, and other boot and shoe cut stock and findings. This industry also
includes finished wood heels. Establishments primarily engaged in
manufacturing heels, soling strips, and soles made of rubber, composition,
plastics, and fiber are classified in major group 30.

314  FOOTWEAR, EXCEPT RUBBER
This industry group includes establishments primarily engaged in
manufacturing house slippers; men's footwear; women's footwear; and non-
rubber footwear, not elsewhere classified.

3142  House Slippers
Establishments primarily engaged in manufacturing house slippers of leather
or other materials.

3143  Men's Footwear, Except Athletic
Establishments primarily engaged in the production of men's footwear
designed primarily for dress, street, and work. Establishments primarily
engaged in the production of such protective footwear as rubbers, rubber
boots, storm shoes, galoshes, and other footwear with rubber soles
vulcanized to the uppers are classified in industry 3021.  Establishments
primarily engaged in the production of athletic shoes and youths' and boys'
shoes are classified in industry 3149, and those manufacturing orthopedic
extension shoes are classified in industry 3842.

3144  Women's Footwear, Except Athletic
Establishments primarily engaged in the production of women's footwear
designed primarily for dress, street, and work. Establishments primarily
engaged in the production of athletic shoes and misses', children's,
infants', and babies' footwear are classified in industry 3149.
Establishments primarily engaged in the production of rubber or plastics
footwear are classified in industry 3021, and those manufacturing
orthopedic extension shoes are classified in industry 3842.

3149  Footwear, Except Rubber, Not Elsewhere Classified
Establishments primarily engaged in the production of shoes, not elsewhere
classified, such as misses', youths', boys', children's, and infants'
footwear and athletic footwear. Establishments primarily engaged in the
production of rubber or plastics footwear are classified in industry 3021,
and those manufacturing orthopedic extension shoes are classified in
industry 3842.

315  LEATHER GLOVES AND MITTENS
Establishments primarily engaged in manufacturing dress, semidress, and
work gloves exclusively of leather or leather with lining of other
material. Establishments primarily engaged in manufacturing sporting
and athletic gloves are classified in industry 3949; those manufacturing
dress, semidress, and work gloves and mittens of cloth or cloth and leather
combined are classified in industry 2381; and those manufacturing safety
gloves are classified in industry 3842.

3151  Leather Gloves and Mittens
Establishments primarily engaged in manufacturing dress, semidress, and
work gloves exclusively of leather or leather with lining of other
material. Establishments primarily engaged in manufacturing sporting
and athletic gloves are classified in industry 3949; those manufacturing
dress, semidress, and work gloves and mittens of cloth or cloth and leather
combined are classified in industry 2381; and those manufacturing safety
gloves are classified in industry 3842.

316  LUGGAGE
Establishments primarily engaged in manufacturing luggage of leather or
other materials.

3161  Luggage
Establishments primarily engaged in manufacturing luggage of leather or
other materials.

317  HANDBAGS AND OTHER PERSONAL LEATHER GOODS
This industry group includes establishments primarily engaged in
manufacturing women's handbags and purses; and personal leather goods.

3171  Women's Handbags and Purses
Establishments primarily engaged in manufacturing women's handbags and
purses of leather or other materials, except precious metal. Establishments
primarily engaged in manufacturing precious metal handbags and purses are
classified in industry 3911.

3172  Personal Leather Goods, Except Women's Handbags and Purses
Establishments primarily engaged in manufacturing small articles normally
carried on the person or in a handbag, such as billfolds, key cases, and
coin purses of leather or other materials, except precious metal.
Establishments primarily engaged in manufacturing similar personal goods of
precious metals are classified in industry 3911.

319  LEATHER GOODS, NOT ELSEWHERE CLASSIFIED
Establishments primarily engaged in manufacturing leather goods, not
elsewhere classified, such as saddlery, harnesses, whips, embossed leather
goods, leather desk sets, razor strops, and leather belting. Establishments
primarily engaged in manufacturing gaskets and packing are classified in
industry 3053. Establishments primarily engaged in manufacturing leather
and sheep-lined clothing are classified in industry 2386.

3199  Leather Goods, Not Elsewhere Classified
Establishments primarily engaged in manufacturing leather goods, not
elsewhere classified, such as saddlery, harnesses, whips, embossed leather
goods, leather desk sets, razor strops, and leather belting. Establishments
primarily engaged in manufacturing gaskets and packing are classified in
industry 3053. Establishments primarily engaged in manufacturing leather
and sheep-lined clothing are classified in industry 2386.

=>32  STONE, CLAY, GLASS, AND CONCRETE PRODUCTS
This major group includes establishments engaged in manufacturing flat
glass and other glass products, cement, structural clay products, pottery,
concrete and gypsum products, cut stone, abrasive and asbestos products,
and other products from materials taken principally from the earth in the
form of stone, clay, and sand. When separate reports are available for
mines and quarries operated by manufacturing establishments classified in
this major group, the mining and quarrying activities are classified in
Division B, Mining. When separate reports are not available, the mining and
quarrying activities, other than those of industry 3295, are classified
herein with the manufacturing operations.

If separate reports are not available for crushing, grinding, and other
preparation activities of industry 3295, these establishments are
classified in Division B, Mining.

321  FLAT GLASS
Establishments primarily engaged in manufacturing flat glass. This industry
also produces laminated glass, but establishments primarily engaged in
manufacturing laminated glass from purchased flat glass are classified in
industry 3231.

3211  Flat Glass
Establishments primarily engaged in manufacturing flat glass. This industry
also produces laminated glass, but establishments primarily engaged in
manufacturing laminated glass from purchased flat glass are classified in
industry 3231.

322  GLASS AND GLASSWARE, PRESSED OR BLOWN
This group includes establishments primarily engaged in manufacturing glass
and glassware, pressed, blown, or shaped from glass produced in the same
establishment. Establishments primarily engaged in manufacturing glass
products made from purchased glass are classified in industry 3231.

3221  Glass Containers
Establishments primarily engaged in manufacturing glass containers for
commercial packing and bottling, and for home canning.

3229  Pressed and Blown Glass and Glassware, Not Elsewhere Classified
Establishments primarily engaged in manufacturing glass and glassware, not
elsewhere classified, pressed, blown, or shaped from glass produced in the
same establishment. Establishments primarily engaged in manufacturing
textile glass fibers are also included in this industry, but establishments
primarily engaged in manufacturing glass wool insulation products are
classified in industry 3296. Establishments primarily engaged in
manufacturing fiber optic cables are classified in industry 3357, and those
manufacturing fiber optic medical devices are classified in industry group
384. Establishments primarily engaged in the production of pressed lenses
for vehicular lighting, beacons, and lanterns are also included in this
industry, but establishments primarily engaged in the production of optical
lenses are classified in industry 3827. Establishments primarily engaged in
manufacturing glass containers are classified in industry 3221, and those
manufacturing complete electric light bulbs are classified in industry
3641.

323  GLASS PRODUCTS, MADE OF PURCHASED GLASS
Establishments primarily engaged in manufacturing glass products from
purchased glass. Establishments primarily engaged in manufacturing optical
lenses, except ophthalmic, are classified in industry 3827, and those
manufacturing ophthalmic lenses are classified in industry 3851.

3231  Glass Products, Made of Purchased Glass
Establishments primarily engaged in manufacturing glass products from
purchased glass. Establishments primarily engaged in manufacturing optical
lenses, except ophthalmic, are classified in industry 3827, and those
manufacturing ophthalmic lenses are classified in industry 3851.

324  CEMENT, HYDRAULIC
Establishments primarily engaged in manufacturing hydraulic cement,
including portland, natural, masonry, and pozzolana cements.

3241  Cement, Hydraulic
Establishments primarily engaged in manufacturing hydraulic cement,
including portland, natural, masonry, and pozzolana cements.

325  STRUCTURAL CLAY PRODUCTS
This industry group includes establishments primarily engaged in
manufacturing brick and structural clay tile; ceramic wall and floor tile;
clay refractories; and structural clay products, not elsewhere classified.

3251  Brick and Structural Clay Tile
Establishments primarily engaged in manufacturing brick and structural clay
tile. Establishments primarily engaged in manufacturing clay firebrick are
classified in industry 3255; those manufacturing nonclay firebrick are
classified in industry 3297; those manufacturing sand lime brick are
classified in industry 3299; and those manufacturing glass brick are
classified in industry 3229.

3253  Ceramic Wall and Floor Tile
Establishments primarily engaged in manufacturing ceramic wall and floor
tile. Establishments primarily engaged in manufacturing structural clay
tile are classified in industry 3251, and those manufacturing drain tile
are classified in industry 3259.

3255  Clay Refractories
Establishments primarily engaged in manufacturing clay firebrick and other
heat resisting clay products. Establishments primarily engaged in
manufacturing nonclay refractories and all graphite refractories,
whether of carbon bond or ceramic bond, are classified in industry 3297.

3259  Structural Clay Products, Not Elsewhere Classified
Establishments primarily engaged in manufacturing clay sewer pipe and
structural clay products, not elsewhere classified.

326  POTTERY AND RELATED PRODUCTS
This industry group includes establishments primarily engaged in
manufacturing vitreous china plumbing fixtures and china and earthenware
fittings and bathroom accessories; vitreous china table and kitchen
articles; fine earthenware table and kitchen articles; porcelain electrical
supplies; and pottery products, not elsewhere classified.

3261  Vitreous China Plumbing Fixtures & China & Earthenware Fittings &
      Bathroom Accessories
Establishments primarily engaged in manufacturing vitreous china plumbing
fixtures and china and earthenware fittings and bathroom accessories.

3262  Vitreous China Table and Kitchen Articles
Establishments primarily engaged in manufacturing vitreous china table and
kitchen articles for use in households and in hotels, restaurants, and
other commercial institutions for preparing, serving, or storing food or
drink. Establishments primarily engaged in manufacturing fine
(semivitreous) earthenware (whiteware) table and kitchen articles are
classified in industry 3263.

3263  Fine Earthenware (Whiteware) Table and Kitchen Articles
Establishments primarily engaged in manufacturing fine (semivitreous)
earthenware table and kitchen articles for preparing, serving, or storing
food or drink. Establishments primarily engaged in manufacturing vitreous
china table and kitchen articles are classified in industry 3262.

3264  Porcelain Electrical Supplies
Establishments primarily engaged in manufacturing porcelain electronic and
other electrical insulators, molded porcelain parts for electrical devices,
spark plug and steatitic porcelain, and electronic and electrical supplies
from clay and other ceramic materials.

3269  Pottery Products, Not Elsewhere Classified
Establishments primarily engaged in firing and decorating white china and
earthenware for the trade and manufacturing art and ornamental pottery,
industrial and laboratory pottery, stoneware and coarse earthenware table
and kitchen articles, unglazed red earthenware florists' articles, and
other pottery products, not elsewhere classified.

327  CONCRETE, GYPSUM, AND PLASTER PRODUCTS
This industry group includes establishments primarily engaged in
manufacturing concrete block and brick and other concrete products; ready-
mixed concrete; lime; and gypsum products.

3271  Concrete Block and Brick
Establishments primarily engaged in manufacturing concrete building block
and brick from a combination of cement and aggregate. Contractors engaged
in concrete construction work are classified in Division C, Construction,
and establishments primarily engaged in mixing and delivering ready-mixed
concrete are classified in industry 3273.

3272  Concrete Products, Except Block and Brick
Establishments primarily engaged in manufacturing concrete products, except
block and brick, from a combination of cement and aggregate.  Contractors
engaged in concrete construction work are classified in Division C,
Construction, and establishments primarily engaged in mixing and delivering
ready-mixed concrete are classified in industry 3273.

3273  Ready-Mixed Concrete
Establishments primarily engaged in manufacturing portland cement concrete
manufactured and delivered to a purchaser in a plastic and unhardened
state. This industry includes production and sale of central-mixed
concrete, shrink-mixed concrete, and truck-mixed concrete.

3274  Lime
Establishments primarily engaged in manufacturing quicklime, hydrated lime,
and ""dead-burned" dolomite from limestone, dolomite shells, or other
substances.

3275  Gypsum Products
Establishments primarily engaged in manufacturing plaster, plasterboard,
and other products composed wholly or chiefly of gypsum, except articles of
plaster of paris and papier-mache.

328  CUT STONE AND STONE PRODUCTS
Establishments primarily engaged in cutting, shaping, and finishing
granite, marble, limestone, slate, and other stone for building and
miscellaneous uses. Establishments primarily engaged in buying or selling
partly finished monuments and tombstones, but performing no work on the
stones other than lettering, finishing, or shaping to custom order, are
classified in Division F, Wholesale Trade or Division G, Retail Trade. The
cutting of grindstones, pulpstones, and whetstones at the quarry is
classified in Division B, Mining.

3281  Cut Stone and Stone Products
Establishments primarily engaged in cutting, shaping, and finishing
granite, marble, limestone, slate, and other stone for building and
miscellaneous uses. Establishments primarily engaged in buying or selling
partly finished monuments and tombstones, but performing no work on the
stones other than lettering, finishing, or shaping to custom order, are
classified in Division F, Wholesale Trade or Division G, Retail Trade. The
cutting of grindstones, pulpstones, and whetstones at the quarry is
classified in Division B, Mining.

329  ABRASIVE, ASBESTOS, AND MISCELLANEOUS NONMETALLIC MINERAL
PRODUCTS
This industry group includes establishments primarily engaged in
manufacturing abrasive products; asbestos products; ground or otherwise
treated minerals and earths; mineral wool; nonclay refractories; and
nonmetallic mineral products, not elsewhere classified.

3291  Abrasive Products
Establishments primarily engaged in manufacturing abrasive grinding wheels
of natural or synthetic materials, abrasive-coated products, and other
abrasive products. The cutting of grindstones, pulpstones, and whetstones
at the quarry is classified in Division B, Mining .

3292  Asbestos Products
Establishments primarily engaged in manufacturing asbestos textiles,
asbestos building materials, except asbestos paper, insulating materials
for covering boilers and pipes, and other products composed wholly or
chiefly of asbestos. Establishments primarily engaged in manufacturing
asbestos paper are classified in industry 2621, and those manufacturing
gaskets and packing are classified in industry 3053.

3295  Minerals and Earths, Ground or Otherwise Treated
Establishments operating without a mine or quarry and primarily engaged in
crushing, grinding, pulverizing, or otherwise preparing clay, ceramic, and
refractory minerals; barite; and miscellaneous nonmetallic minerals, except
fuels. These minerals are the crude products mined by establishments of
industry groups 145 and 149, and by those of industry 1479 mining barite.
Also included are establishments primarily crushing slag and preparing
roofing granules. The beneficiation or preparation of other minerals and
metallic ores, and the cleaning and grading of coal, are classified in
Division B, Mining, whether or not the operation is associated with a mine.

3296  Mineral Wool
Establishments primarily engaged in manufacturing mineral wool and mineral
wool insulation products made of such siliceous materials as rock, slag,
and glass, or combinations thereof. Establishments primarily engaged in
manufacturing asbestos insulation products are classified in industry 3292,
and those manufacturing textile glass fibers are classified in industry
3229.

3297  Nonclay Refractories
Establishments primarily engaged in manufacturing refractories and
crucibles made of materials other than clay. This industry includes
establishments primarily engaged in manufacturing all graphite
refractories, whether of carbon bond or ceramic bond. Establishments
primarily engaged in manufacturing clay refractories are classified in
industry 3255.

3299  Nonmetallic Mineral Products, Not Elsewhere Classified
Establishments primarily engaged in the factory production of goods made of
plaster of paris and papier-mache, and in manufacturing sand lime products
and other nonmetallic mineral products, not elsewhere classified.

=>33  PRIMARY METAL INDUSTRIES
This major group includes establishments engaged in smelting and refining
ferrous and nonferrous metals from ore, pig, or scrap; in rolling, drawing,
and alloying metals; in manufacturing castings and other basic metal
products; and in manufacturing nails, spikes, and insulated wire and cable.
This major group includes the production of coke. Establishments primarily
engaged in manufacturing metal forgings or stampings are classified in
industry group 346.


331  STEEL WORKS, BLAST FURNACES, AND ROLLING AND FINISHING MILLS
This industry group includes establishments primarily classified as steel
works, blast furnaces (including coke ovens), and rolling mills;
establishments primarily engaged in manufacturing electrometallurgical
products, except steel; establishments primarily engaged in steel
wiredrawing and manufacturing steel nails and spikes; manufacturing cold-
rolled steel sheet, strip, and bars; and establishments primarily engaged
in the manufacture of steel pipe and tubes.

3312  Steel Works, Blast Furnaces (Including Coke Ovens), and Rolling Mills
Establishments primarily engaged in manufacturing hot metal, pig iron, and
silvery pig iron from iron ore and iron and steel scrap; converting pig
iron, scrap iron, and scrap steel into steel; and in hot-rolling iron and
steel into basic shapes, such as plates, sheets, strips, rods, bars, and
tubing. Merchant blast furnaces and byproduct or beehive coke ovens are
also included in this industry. Establishments primarily engaged in
manufacturing ferro and nonferrous additive alloys by electrometallurgical
processes are classified in industry 3313.

3313  Electrometallurgical Products, Except Steel
Establishments primarily engaged in manufacturing ferro and nonferrous
metal additive alloys by electrometallurgical or metallothermic processes,
including high percentage ferroalloys and high percentage nonferrous
additive alloys. Establishments primarily engaged in manufacturing
electrometallurgical steel are classified in industry 3312.

3315  Steel Wiredrawing and Steel Nails and Spikes
Establishments primarily engaged in drawing wire from purchased iron or
steel rods, bars, or wire and which may be engaged in the further
manufacture of products made from wire; establishments primarily engaged in
manufacturing steel nails and spikes from purchased materials are also
included in this industry. Rolling mills engaged in the production of
ferrous wire from wire rods or hot-rolled bars produced in the same
establishment are classified in industry 3312.  Establishments primarily
engaged in drawing nonferrous wire are classified in industry group 335.

3316  Cold-Rolled Steel Sheet, Strip, and Bars
Establishments primarily engaged in: (1) cold-rolling steel sheets and
strip from purchased hot-rolled sheets; (2) cold-drawing steel bars and
steel shapes from purchased hot-rolled steel bars; and (3) producing other
cold finished steel. Establishments primarily engaged in the production of
steel, including hot-rolled steel sheets, and further cold-rolling such
sheets are classified in industry 3312.

3317  Steel Pipe and Tubes
Establishments primarily engaged in the production of welded or seamless
steel pipe and tubes and heavy riveted steel pipe from purchased materials.
Establishments primarily engaged in the production of steel, including
steel skelp or steel blanks, tube rounds, or pierced billets, are
classified in industry 3312.

332  IRON AND STEEL FOUNDRIES
This industry group includes establishments primarily engaged in
manufacturing iron and steel castings. These establishments generally
operate on a job or order basis, manufacturing castings for sale to others
or for interplant transfer. Establishments which produce iron and steel
castings and which are also engaged in fabricating operations, such as
machining and assembling, in manufacturing a specified product are
classified in the industry of the specified product. Iron and steel
castings are made, to a considerable extent, by establishments that are
classified in other industries and that operate foundry departments for the
production of castings for incorporation, in the same establishment, into
such products as stoves, furnaces, plumbing fixtures, and motor vehicles.
Establishments primarily engaged in the manufacture and rolling of steel
and also making steel castings are classified in industry 3312.
Establishments primarily engaged in manufacturing nonferrous castings are
classified in industry group 336.

3321  Gray and Ductile Iron Foundries
Establishments primarily engaged in manufacturing gray and ductile iron
castings, including cast iron pressure and soil pipes and fittings.

3322  Malleable Iron Foundries
Establishments primarily engaged in manufacturing malleable iron castings.

3324  Steel Investment Foundries
Establishments primarily engaged in manufacturing steel investment
castings.

3325  Steel Foundries, Not Elsewhere Classified
Establishments primarily engaged in manufacturing steel castings, not
elsewhere classified.

333  PRIMARY SMELTING AND REFINING OF NONFERROUS METALS
This industry group includes establishments primarily engaged in the
primary smelting and refining of copper; primary production of aluminum;
and the primary smelting and refining of nonferrous metals, except copper
and aluminum.

3331  Primary Smelting and Refining of Copper
Establishments primarily engaged in smelting copper from the ore, and in
refining copper by electrolytic or other processes. Establishments
primarily engaged in rolling, drawing, or extruding copper are classified
in industry 3351.

3334  Primary Production of Aluminum
Establishments primarily engaged in producing aluminum from alumina and in
refining aluminum by any process. Establishments primarily engaged in
rolling, drawing, or extruding aluminum are classified in industry group
335.

3339  Primary Smelting & Refining of Nonferrous Metals, Except Copper &
      Aluminum
Establishments primarily engaged in smelting and refining nonferrous
metals, except copper and aluminum. Establishments primarily engaged in
rolling, drawing, and extruding these nonferrous primary metals are
classified in industry 3356, and the production of bullion at the site
of the mine is classified in Division B, Mining.

334  SECONDARY SMELTING AND REFINING OF NONFERROUS METALS
Establishments primarily engaged in recovering nonferrous metals and alloys
from new and used scrap and dross or in producing alloys from purchased
refined metals. This industry includes establishments engaged in both the
recovery and alloying of precious metals. Plants engaged in the recovery of
tin through secondary smelting and refining, as well as by chemical
processes, are included in this industry. Establishments primarily engaged
in assembling, sorting, and breaking up scrap metal, without smelting and
refining, are classified in Wholesale Trade, industry 5093.

3341  Secondary Smelting and Refining of Nonferrous Metals
Establishments primarily engaged in recovering nonferrous metals and alloys
from new and used scrap and dross or in producing alloys from purchased
refined metals. This industry includes establishments engaged in both the
recovery and alloying of precious metals. Plants engaged in the recovery of
tin through secondary smelting and refining, as well as by chemical
processes, are included in this industry. Establishments primarily engaged
in assembling, sorting, and breaking up scrap metal, without smelting and
refining, are classified in Wholesale Trade, industry 5093.

335  ROLLING, DRAWING, AND EXTRUDING OF NONFERROUS METALS
This industry group includes establishments primarily engaged in rolling,
drawing, and extruding copper; manufacturing aluminum sheet, plate, and
foil and aluminum extruded products; and aluminum rolling and drawing, not
elsewhere classified; rolling, drawing, and extruding of nonferrous metals
other than copper and aluminum; and drawing and insulating nonferrous wire.

3351  Rolling, Drawing, and Extruding of Copper
Establishments primarily engaged in rolling, drawing, and extruding copper,
brass, bronze, and other copper base alloy basic shapes, such as plate,
sheet, strip, bar, and tubing. Establishments primarily engaged in
recovering copper and its alloys from scrap or dross are classified in
industry 3341.

3353  Aluminum Sheet, Plate, and Foil
Establishments primarily engaged in flat rolling aluminum and aluminum-base
alloy basic shapes, such as sheet, plate, and foil, including
establishments producing welded tube. Also included are establishments
primarily producing similar products by continuous casting.

3354  Aluminum Extruded Products
Establishments primarily engaged in extruding aluminum and aluminum-base
alloy basic shapes, such as rod and bar, pipe and tube, and tube blooms,
including establishments producing tube by drawing.

3355  Aluminum Rolling and Drawing, Not Elsewhere Classified
Establishments primarily engaged in rolling, drawing, and other operations
resulting in the production of aluminum ingot, including extrusion ingot,
and aluminum and aluminum-base alloy basic shapes, not elsewhere
classified, such as rolled and continuous cast rod and bar.  Establishments
primarily engaged in producing aluminum powder, flake, and paste are
classified in industry 3399, and those producing aluminum wire and cable
from purchased wire bars, rods, or wire are classified in industry 3357.

3356  Rolling, Drawing, & Extruding of Nonferrous Metals, Except Copper and
      Aluminum
Establishments primarily engaged in rolling, drawing, and extruding
nonferrous metals other than copper and aluminum. The products of this
industry are in the form of basic shapes, such as plate, sheet, strip, bar,
and tubing. Establishments primarily engaged in recovering nonferrous
metals and alloys from scrap or dross are classified in industry 3341;
those manufacturing gold, silver, tin, and other foils, except aluminum,
are classified in industry 3497; and those manufacturing aluminum foil are
classified in industry 3353.

3357  Drawing and Insulating of Nonferrous Wire
Establishments primarily engaged in drawing, drawing and insulating, and
insulating wire and cable of nonferrous metals from purchased wire bars,
rods, or wire. Also included are establishments primarily engaged in
manufacturing insulated fiber optic cable. Establishments primarily engaged
in manufacturing glass fiber optic materials are classified in industry
3229, and those manufacturing fabricated wire products from purchased wire
are classified in industry 3496.

336  NONFERROUS FOUNDRIES (CASTINGS)
This industry group includes establishments primarily engaged in
manufacturing castings and die-castings of aluminum, brass, bronze, and
other nonferrous metals and alloys. These establishments generally operate
on a job or order basis, manufacturing castings for sale to others or for
interplant transfer. Establishments which produce nonferrous castings and
which are also engaged in fabricating operations, such as machining and
assembling, in manufacturing a specified product are classified in the
industry of the specified product. Nonferrous castings are made to a
considerable extent by establishments classified in other industries that
operate foundry departments for the production of castings for
incorporation, in the same establishment, into such products as machinery
and motor vehicles.  Establishments primarily engaged in manufacturing iron
and steel castings are classified in industry group 332.

3363  Aluminum Die-Castings
Establishments primarily engaged in manufacturing die-castings of aluminum
(including alloys).

3364  Nonferrous Die-Castings, Except Aluminum
Establishments primarily engaged in manufacturing nonferrous metal die-
castings, except aluminum.

3365  Aluminum Foundries
Establishments primarily engaged in manufacturing aluminum (including
alloys) castings, except die-castings.

3366  Copper Foundries
Establishments primarily engaged in manufacturing copper (including alloys)
castings, except die-castings.

3369  Nonferrous Foundries, Except Aluminum and Copper
Establishments primarily engaged in manufacturing nonferrous metal castings
(including alloys), except all die-castings and other castings of aluminum
or copper.

339  MISCELLANEOUS PRIMARY METAL PRODUCTS
This industry group includes establishments primarily engaged in metal heat
treating, and in manufacturing primary metal products, not elsewhere
classified.

3398  Metal Heat Treating
Establishments primarily engaged in heat treating of metal for the trade.

3399  Primary Metal Products, Not Elsewhere Classified
Establishments primarily engaged in manufacturing primary metal products,
not elsewhere classified, such as nonferrous nails, brads, and spikes, and
metal powder, flakes, and paste.

=>34  FABRICATED METAL PRODUCTS, EXCEPT MACHINERY & TRANSPORTATION EQUIP.
This major group includes establishments engaged in fabricating ferrous and
nonferrous metal products, such as metal cans, tinware, handtools, cutlery,
general hardware, nonelectric heating apparatus, fabricated structural
metal products, metal forgings, metal stampings, ordnance (except vehicles
and guided missiles), and a variety of metal and wire products, not
elsewhere classified. Certain important segments of the metal fabricating
industries are classified in other major groups, such as machinery in major
groups 35 and 36; transportation equipment, including tanks, in major group
37; professional scientific and controlling instruments, watches, and
clocks in major group 38; and jewelry and silverware in major group 39.
Establishments primarily engaged in producing ferrous and nonferrous metals
and their alloys are classified in major group 33.

341  METAL CANS AND SHIPPING CONTAINERS
This industry group includes establishments primarily engaged in
manufacturing metal cans, and metal shipping barrels, drums, kegs, and
pails.

3411  Metal Cans
Establishments primarily engaged in manufacturing metal cans from purchased
materials. Establishments primarily engaged in manufacturing foil
containers are classified in industry 3497.

3412  Metal Shipping Barrels, Drums, Kegs, and Pails
Establishments primarily engaged in manufacturing metal shipping barrels,
drums, kegs, and pails.

342  CUTLERY, HANDTOOLS, AND GENERAL HARDWARE
This industry group includes establishments primarily engaged in
manufacturing cutlery; hand and edge tools, except machine tools; saw
blades and handsaws; and hardware, not elsewhere classified.

3421  Cutlery
Establishments primarily engaged in manufacturing safety razors, razor
blades, scissors, shears, and other cutlery of metal, except precious metal
and table cutlery with handles of metal. Establishments primarily engaged
in manufacturing precious metal cutlery and table cutlery with handles of
metal are classified in industry 3914; those manufacturing electric razors,
knives, or scissors are classified in industry 3634; those manufacturing
hair clippers for human use are classified in industry 3999 and for animal
use in industry 3523; and those manufacturing power hedge shears and
trimmers are classified in industry 3524.

3423  Hand and Edge Tools, Except Machine Tools and Handsaws
Establishments primarily engaged in manufacturing files and other hand and
edge tools for metalworking, woodworking, and general maintenance.
Establishments primarily engaged in manufacturing handsaws and saw
blades are classified in industry 3425; and those manufacturing metal
cutting dies, power driven handtools, and attachments and accessories
for machine tools are classified in major group 35.

3425  Saw Blades and Handsaws
Establishments primarily engaged in manufacturing handsaws and saw blades
for hand and power driven saws. Establishments primarily engaged in
manufacturing power driven sawing machines are classified in major group
35.

3429  Hardware, Not Elsewhere Classified
Establishments primarily engaged in manufacturing miscellaneous metal
products usually termed hardware, not elsewhere classified.  Establishments
primarily engaged in manufacturing bolts and nuts are classified in
industry 3452; those manufacturing nails and spikes are classified in major
group 33; those manufacturing cutlery are classified in industry 3421;
those manufacturing handtools are classified in industry 3423; and those
manufacturing pole line and transmission hardware are classified in
industry group 364.

343  HEATING EQUIPMENT, EXCEPT ELECTRIC AND WARM AIR; AND PLUMBING FIXTURES
This industry group includes establishments primarily engaged in
manufacturing enameled iron and metal sanitary ware; plumbing fixture
fittings and trim; and heating equipment, except electric and warm air
furnaces.

3431  Enameled Iron and Metal Sanitary Ware
Establishments primarily engaged in manufacturing enameled iron, cast iron,
or pressed metal sanitary ware. Establishments primarily engaged in
manufacturing plastics plumbing fixtures are classified in industry 3088;
those manufacturing vitreous and semivitreous pottery sanitary ware are
classified in industry 3261; and those manufacturing porcelain enameled
kitchen, household, and hospital ware are classified in industry 3469.

3432  Plumbing Fixture Fittings and Trim
Establishments primarily engaged in manufacturing metal plumbing fixture
fittings and trim. Also included in this industry are establishments
engaged in the assembly of plastics components into plumbing fixture
fittings. Establishments primarily engaged in the manufacture of stream or
water line valves are classified in industry group 349. Establishments
primarily engaged in manufacturing china and earthenware plumbing fixture
fittings are classified in industry 3261, and those manufacturing plastics
plumbing fixture components are classified in industry 3089.

3433  Heating Equipment, Except Electric and Warm Air Furnaces
Establishments primarily engaged in manufacturing heating equipment, except
electric and warm air furnaces, including gas, oil, and stoker coal fired
equipment for the automatic utilization of gaseous, liquid, and solid
fuels. Establishments primarily engaged in manufacturing warm air furnaces
are classified in industry 3585; cooking stoves and ranges are classified
in industry 3631; boiler shops primarily engaged in the production of
industrial, power, and marine boilers are classified in industry 3443; and
those manufacturing industrial process furnaces and ovens are classified in
industry 3567.

344  FABRICATED STRUCTURAL METAL PRODUCTS
This industry group includes establishments primarily engaged in
fabricating structural metal; manufacturing metal doors, sash, frames,
molding, and trim; fabricated plate work (boiler shops); sheet metalwork;
architectural and ornamental metalwork; prefabricated metal buildings and
components; and in manufacturing miscellaneous structural metalwork.

3441  Fabricated Structural Metal
Establishments primarily engaged in fabricating iron and steel or other
metal for structural purposes, such as bridges, buildings, and sections for
ships, boats, and barges. Establishments primarily engaged in manufacturing
metal doors, sash, frames, molding, and trim are classified in industry
3442; and establishments doing fabrication work at the site of construction
are classified in Division C, Construction.

3442  Metal Doors, Sash, Frames, Molding, and Trim
Establishments primarily engaged in manufacturing ferrous and nonferrous
metal doors, sash, window and door frames and screens, molding, and trim.
Establishments primarily engaged in manufacturing metal covered wood doors,
windows, sash, door frames, molding, and trim are classified in industry
2431.

3443  Fabricated Plate Work (Boiler Shops)
Establishments primarily engaged in manufacturing power and marine boilers,
pressure and nonpressure tanks, processing and storage vessels, heat
exchangers, weldments and similar products, by the process of cutting,
forming and joining metal plates, shapes, bars, sheet, pipe mill products
and tubing to custom or standard design, for factory or field assembly.
Establishments primarily engaged in manufacturing warm air heating furnaces
are classified in industry 3585; those manufacturing other nonelectric
heating apparatus, except power boilers, are classified in industry 3433;
those manufacturing household cooking apparatus are classified in industry
3631; and those manufacturing industrial process furnaces and ovens are
classified in industry 3567.

3444  Sheet Metalwork
Establishments primarily engaged in manufacturing sheet metalwork for
buildings (not including fabrication work done by construction contractors
at the place of construction), and manufacturing stovepipes, light tanks,
and other products of sheet metal.

3446  Architectural and Ornamental Metalwork
Establishments primarily engaged in manufacturing architectural and
ornamental metalwork, such as stairs and staircases, open steel flooring
(grating), fire escapes, grilles, railings, and fences and gates, except
those made from wire. Establishments primarily engaged in manufacturing
fences and gates from purchased wire are classified in industry 3496; those
manufacturing prefabricated metal buildings and parts are classified in
industry 3448; and those manufacturing miscellaneous metalwork are
classified in industry 3449.

3448  Prefabricated Metal Buildings and Components
Establishments primarily engaged in manufacturing portable and other
prefabricated metal buildings and parts and prefabricated exterior metal
panels.

3449  Miscellaneous Structural Metalwork
Establishments primarily engaged in manufacturing miscellaneous structural
metalwork, such as metal plaster bases, fabricated bar joists, and concrete
reinforcing bars. Also included in this industry are establishments
primarily engaged in custom roll forming of metal.

345  SCREW MACHINE PRODUCTS, AND BOLTS, NUTS, SCREWS, RIVETS, AND WASHERS
This industry group includes establishments primarily engaged in
manufacturing screw machine products; and manufacturing bolts, nuts,
screws, rivets, and washers.

3451  Screw Machine Products
Establishments primarily engaged in manufacturing automatic or hand screw
machine products from rod, bar, or tube stock of metal, fiber, plastics or
other material. The products of this industry consist of a wide variety of
unassembled parts and are usually manufactured on a job or order basis.
Establishments included in this industry may perform assembly of some parts
manufactured in the same establishment, but establishments primarily
engaged in producing assembled components are classified according to the
nature of the components. Establishments primarily engaged in manufacturing
standard bolts, nuts, rivets, screws, and other industrial fasteners on
headers, threaders, and nut forming machines are classified in industry
3452.

3452  Bolts, Nuts, Screws, Rivets, and Washers
Establishments primarily engaged in manufacturing metal bolts, nuts,
screws, rivets, washers, formed and threaded wire goods, and special
industrial fasteners. Rolling mills engaged in manufacturing similar
products are classified in major group 33; establishments primarily engaged
in manufacturing screw machine products are classified in industry 3451;
and those manufacturing plastics fasteners are classified in industry 3089.

346  METAL FORGINGS AND STAMPINGS
This industry group includes establishments primarily engaged in
manufacturing metal forgings or metal stampings. These establishments
generally operate on a job or order basis, manufacturing metal stampings or
forgings for sale to others or for interplant transfer.  Establishments
which produce metal stampings or forgings for incorporation in end products
produced in the same establishment are classified on the basis of the end
product. Establishments further processing forgings or stampings are
classified according to the particular product or process.

3462  Iron and Steel Forgings
Establishments primarily engaged in manufacturing iron and steel forgings,
with or without the use of dies.

3463  Nonferrous Forgings
Establishments primarily engaged in manufacturing nonferrous forgings, with
or without the use of dies.

3465  Automotive Stampings
Establishments primarily engaged in manufacturing automotive stampings,
such as body parts, hubs, and trim.

3466  Crowns and Closures
Establishments primarily engaged in manufacturing metal crowns and
closures.

3469  Metal Stampings, Not Elsewhere Classified
Establishments primarily engaged in manufacturing metal stampings and spun
products, not elsewhere classified, including porcelain enameled products.
Products of this industry include household appliance housings and parts;
cooking and kitchen utensils; and other nonautomotive job stampings.

347  COATING, ENGRAVING, AND ALLIED SERVICES
This industry group includes establishments primarily engaged in
electroplating, plating, polishing, anodizing, and coloring; and coating,
engraving, and allied services, not elsewhere classified.

3471  Electroplating, Plating, Polishing, Anodizing, and Coloring
Establishments primarily engaged in all types of electroplating, plating,
anodizing, coloring, and finishing of metals and formed products for the
trade. Also included in this industry are establishments which perform
these types of activities, on their own account, on purchased metals or
formed products. Establishments that both manufacture and finish products
are classified according to the products.

3479  Coating, Engraving, and Allied Services, Not Elsewhere Classified
Establishments primarily engaged in performing the following types of
services on metals, for the trade: (1) enameling, lacquering, and
varnishing metal products; (2) hot dip galvanizing of mill sheets,
plates and bars, castings, and formed products fabricated of iron and
steel; hot dip coating such items with aluminum, lead, or zinc;
retinning cans and utensils; (3) engraving, chasing and etching
jewelry, silverware, notarial and other seals, and other metal products for
purposes other than printing; and (4) other metal services, not elsewhere
classified. Also included in this industry are establishments which perform
these types of activities on their own account on purchased metals or
formed products. Establishments that both manufacture and finish products
are classified according to the products.

348  ORDNANCE AND ACCESSORIES, EXCEPT VEHICLES AND GUIDED MISSILES
This industry group includes establishments primarily engaged in
manufacturing small arms and other ammunition; small arms; and ordnance and
accessories, not elsewhere classified.

3482  Small Arms Ammunition
Establishments primarily engaged in manufacturing ammunition for small arms
having a bore of 30 mm. (or 1.18 inch) or less. Establishments primarily
engaged in manufacturing ammunition, except for small arms, are classified
in industry 3483; those manufacturing blasting and detonating caps and
safety fuses are classified in industry 2892; and those manufacturing
fireworks are classified in industry 2899.

3483  Ammunition, Except for Small Arms
Establishments primarily engaged in manufacturing ammunition, not elsewhere
classified, or in loading and assembling ammunition more than 30 mm. (or
more than 1.18 inch), including component parts. This industry also
includes establishments primarily engaged in manufacturing bombs, mines,
torpedoes, grenades, depth charges, chemical warfare projectiles, and their
component parts. Establishments primarily engaged in manufacturing small
arms ammunition are classified in industry 3482; those manufacturing
explosives are classified in industry 2892; and those manufacturing
military pyrotechnics are classified in industry 2899.

3484  Small Arms
Establishments primarily engaged in manufacturing small firearms having a
bore 30 mm. (or 1.18 inch) or less, and parts for small firearms.  Also
included in this industry are establishments primarily engaged in
manufacturing certain weapons more than 30 mm. which are carried and
employed by the individual, such as grenade launchers and heavy field
machine guns. Establishments primarily engaged in manufacturing artillery
and mortars having a bore more than 30 mm. (or more than 1.18 inch), and
component parts, are classified in industry 3489.

3489  Ordnance and Accessories, Not Elsewhere Classified
Establishments primarily engaged in manufacturing ordnance and accessories,
not elsewhere classified, such as naval, aircraft, antiaircraft, tank,
coast, and field artillery having a bore more than 30 mm. (or more than
1.18 inch), and components. Establishments primarily engaged in
manufacturing small arms and parts 30 mm. (or 1.18 inch) or less are
classified in industry 3484; those manufacturing tanks are classified in
industry 3795; and those manufacturing guided missiles are classified in
industry group 376.

349  MISCELLANEOUS FABRICATED METAL PRODUCTS
This industry group includes establishments primarily engaged in
manufacturing industrial valves; fluid power valves and hose fittings;
steel springs, including wire; valves and pipe fittings, not elsewhere
classified; miscellaneous fabricated wire products; metal foil and leaf;
fabricated pipe and pipe fittings; and fabricated metal products, not
elsewhere classified.

3491  Industrial Valves
Establishments primarily engaged in manufacturing industrial valves.
Establishments primarily engaged in manufacturing fluid power valves
are classified in industry 3492; those manufacturing plumbing fixture
fittings and trim are classified in industry 3432; and those manufacturing
plumbing and heating valves are classified in industry 3494.

3492  Fluid Power Valves and Hose Fittings
Establishments primarily engaged in manufacturing hydraulic and pneumatic
valves, hose and tube fittings, and hose assemblies for fluid power
systems. Establishments primarily engaged in manufacturing fluid power
cylinders are classified in industry 3593; those manufacturing fluid power
pumps are classified in industry 3594; and those manufacturing hydraulic
intake and exhaust motor vehicle valves are classified in industry 3592.

3493  Steel Springs, Except Wire
Establishments primarily engaged in manufacturing leaf springs, hot wound
springs, and coiled flat springs. Establishments primarily engaged in
manufacturing wire springs are classified in industry 3495.

3494  Valves and Pipe Fittings, Not Elsewhere Classified
Establishments primarily engaged in manufacturing metal valves and pipe
fittings, not elsewhere classified, such as plumbing and heating valves,
and pipe fittings, flanges, and unions, except from purchased pipes.
Establishments primarily engaged in manufacturing plastics pipe fittings
are classified in industry 3089; those manufacturing plumbing fixture
fittings and trim are classified in industry 3432; and those manufacturing
fittings and couplings for garden hose are classified in industry 3429.
Establishments primarily engaged in manufacturing fluid power valves are
classified in industry 3492, and those manufacturing other industrial
valves are classified in industry 3491. Establishments primarily engaged in
fabricating pipe fittings from purchased metal pipe by processes such as
cutting, threading, and bending are classified in industry 3498.

3495 Wire Springs
Establishments primarily engaged in manufacturing wire springs from
purchased wire. Establishments primarily engaged in assembling wire
bedsprings or seats are classified in major group 25.

3496  Miscellaneous Fabricated Wire Products
Establishments primarily engaged in manufacturing miscellaneous fabricated
wire products from purchased wire, such as noninsulated wire rope and
cable; fencing; screening, netting, paper machine wire cloth; hangers,
paper clips, kitchenware, and wire carts. Rolling mills engaged in
manufacturing wire products are classified in major group 33.
Establishments primarily engaged in manufacturing steel nails and spikes
from purchased wire or rod are classified in industry 3315; those
manufacturing nonferrous wire nails and spikes from purchased wire or rod
are classified in industry 3399; those drawing and insulating nonferrous
wire are classified in industry 3357; and those manufacturing wire springs
are classified in industry 3495.


3497  Metal Foil and Leaf
Establishments primarily engaged in manufacturing gold, silver, tin, and
other metal foil (including converted metal foil) and leaf. Also included
are establishments primarily engaged in converting metal foil (including
aluminum) into wrappers, cookware, dinnerware, and containers, except bags
and liners. Establishments primarily engaged in manufacturing plain
aluminum foil are classified in industry 3353.

3498  Fabricated Pipe and Pipe Fittings
Establishments primarily engaged in fabricating pipe and pipe fittings from
purchased metal pipe, by processes such as cutting, threading, and bending.
Establishments primarily engaged in manufacturing cast iron pipe and
fittings, including cast and forged pipe fittings which have been machined
and threaded, are classified in industry 3321; those manufacturing welded
and heavy riveted pipe and seamless steel pipe are classified in industry
3317; and those manufacturing products such as banisters, railings, and
guards from pipe are classified in industry 3446.

3499  Fabricated Metal Products, Not Elsewhere Classified
Establishments primarily engaged in manufacturing fabricated metal
products, not elsewhere classified, such as fire or burglary resistive
steel safes and vaults and similar fire or burglary resistive products; and
collapsible tubes of thin flexible metal. Also included are establishments
primarily engaged in manufacturing metal boxes, metal ladders, and metal
household articles, such as ice cream freezers and ironing boards.
Establishments primarily engaged in manufacturing concrete burial vaults
are classified in industry 3272, and metal burial vaults are classified in
industry 3995. Establishments primarily engaged in manufacturing
advertising novelties are classified in industry 3993.

=>35  INDUSTRIAL AND COMMERCIAL MACHINERY AND COMPUTER EQUIPMENT
This major group includes establishments engaged in manufacturing
industrial and commercial machinery and equipment and computers.  Included
are the manufacture of engines and turbines; farm and garden machinery;
construction, mining, and oil field machinery; elevators and conveying
equipment; hoists, cranes, monorails, and industrial trucks and tractors;
metalworking machinery; special industry machinery; general industrial
machinery; computer and peripheral equipment and office machinery; and
refrigeration and service industry machinery.  Machines powered by built-in
or detachable motors ordinarily are included in this major group, with the
exception of electrical household appliances. Power-driven handtools are
included in this major group, whether electric or otherwise driven.
Establishments primarily engaged in manufacturing electrical equipment are
classified in major group 36, and those manufacturing handtools, except
powered, are classified in major group 34.

351  ENGINES AND TURBINES
This industry group includes establishments primarily engaged in
manufacturing steam, gas, and hydraulic turbines, and turbine generator set
units; and internal combustion engines, not elsewhere classified.

3511  Steam, Gas, and Hydraulic Turbines, and Turbine Generator Set Units
Establishments primarily engaged in manufacturing steam turbines; hydraulic
turbines; gas turbines, except aircraft; and complete steam, gas, and
hydraulic turbine generator set units. Also included in this industry are
the manufacture of wind and solar powered turbine generators and windmills
for generating electric power. Establishments primarily engaged in
manufacturing nonautomotive type generators are classified in industry
3621; those manufacturing aircraft turbines are classified in industry
3724; and those manufacturing windmill heads and towers for pumping water
for agricultural use are classified in industry 3523.

3519  Internal Combustion Engines, Not Elsewhere Classified
Establishments primarily engaged in manufacturing diesel, semidiesel, or
other internal combustion engines, not elsewhere classified, for
stationary, marine, traction, and other uses. Establishments primarily
engaged in manufacturing aircraft engines are classified in industry 3724,
and those manufacturing automotive engines, except diesel, are classified
in industry 3714.

352  FARM AND GARDEN MACHINERY AND EQUIPMENT
This industry group includes establishments primarily engaged in
manufacturing farm machinery and equipment; and lawn and garden tractors,
and home lawn and garden equipment.

3523  Farm Machinery and Equipment
Establishments primarily engaged in manufacturing farm machinery and
equipment, including wheel tractors, for use in the preparation and
maintenance of the soil; planting and harvesting of the crop; preparing
crops for market on the farm; or for use in performing other farm
operations and processes. Included in this industry are establishments
primarily engaged in manufacturing commercial mowing and other turf and
grounds care equipment. Establishments primarily engaged in manufacturing
farm handtools are classified in industry group 342, and those
manufacturing garden tractors, lawnmowers and other lawn and garden
equipment are classified in industry 3524.

3524  Lawn and Garden Tractors and Home Lawn and Garden Equipment
Establishments primarily engaged in manufacturing lawnmowers, lawn and
garden tractors, and other lawn and garden equipment used for home lawn and
garden care. Also included are establishments primarily engaged in
manufacturing snowblowers and throwers for residential use.  Establishments
primarily engaged in manufacturing farm machinery and equipment (including
commercial mowing and other turf and grounds care equipment) are classified
in industry 3523; those manufacturing hand lawn and garden shears and
pruners are classified in industry 3421; and those manufacturing other
garden handtools are classified in industry 3423.

353  CONSTRUCTION, MINING, AND MATERIALS HANDLING MACHINERY AND EQUIPMENT
This industry group includes establishments primarily engaged in
manufacturing construction machinery and equipment; mining machinery and
equipment; oil and gas field machinery and equipment; elevators and moving
stairways; conveyors and conveying equipment; overhead traveling cranes,
hoists, and monorail systems; and industrial trucks, tractors, trailers,
and stackers.

3531  Construction Machinery and Equipment
Establishments primarily engaged in manufacturing heavy machinery and
equipment of a type used primarily by the construction industries, such as
bulldozers; concrete mixers; cranes, except industrial plant overhead and
truck-type cranes; dredging machinery; pavers; and power shovels. Also
included in this industry are establishments primarily engaged in
manufacturing forestry equipment and certain specialized equipment, not
elsewhere classified, similar to that used by the construction industries,
such as elevating platforms, ship cranes and capstans, aerial work
platforms, and automobile wrecker hoists.  Establishments primarily engaged
in manufacturing mining equipment are classified in industry 3532; those
manufacturing well-drilling machinery are classified in industry 3533;
those manufacturing industrial plant overhead traveling cranes are
classified in industry 3536; and those manufacturing industrial truck-type
cranes are classified in industry 3537.

3532  Mining Machinery & Equipment, Except Oil & Gas Field Mach & Equip
Establishments primarily engaged in manufacturing heavy machinery and
equipment used by the mining industries, such as coal breakers, mine cars,
mineral cleaning machinery, concentration machinery, core drills, coal
cutters, portable rock drills, and rock crushing machinery.  Establishments
primarily engaged in manufacturing construction machinery are classified in
industry 3531; those manufacturing welldrilling machinery are classified in
industry 3533; and those manufacturing coal and ore conveyors are
classified in industry 3535.

3533  Oil and Gas Field Machinery and Equipment
Establishments primarily engaged in manufacturing machinery and equipment
for use in oil and gas fields or for drilling water wells, including
portable drilling rigs. Establishments primarily engaged in manufacturing
offshore oil and gas well drilling and production platforms are classified
in industry 3731.

3534  Elevators and Moving Stairways
Establishments primarily engaged in manufacturing passenger or freight
elevators, automobile lifts, dumbwaiters, and moving stairways.
Establishments primarily engaged in manufacturing commercial conveyor
systems and equipment are classified in industry 3535, and those
manufacturing farm elevators are classified in industry 3523.

3535  Conveyors and Conveying Equipment
Establishments primarily engaged in manufacturing conveyors and conveying
equipment for installation in factories, warehouses, mines, and other
industrial and commercial establishments. Establishments primarily engaged
in manufacturing farm elevators and conveyors are classified in industry
3523; those manufacturing passenger or freight elevators, dumbwaiters, and
moving stairways are classified in industry 3534; and those manufacturing
overhead traveling cranes and monorail systems are classified in industry
3536.

3536  Overhead Traveling Cranes, Hoists, and Monorail Systems
Establishments primarily engaged in manufacturing overhead traveling
cranes, hoists, and monorail systems for installation in factories,
warehouses, marinas, and other industrial and commercial establishments.
Establishments primarily engaged in manufacturing cranes except industrial
types, automobile wrecker hoists, and aerial work platforms are classified
in industry 3531, and those manufacturing aircraft loading hoists are
classified in industry 3537.

3537  Industrial Trucks, Tractors, Trailers, and Stackers
Establishments primarily engaged in manufacturing industrial trucks,
tractors, trailers, stackers (truck type), and related equipment, used for
handling materials on floors and paved surfaces in and around industrial
and commercial plants, depots, docks, airports, and terminals.
Establishments primarily engaged in manufacturing motor vehicles and motor
vehicle type trailers are classified in industry group 371; those
manufacturing farm type wheel tractors are classified in industry 3523;
those manufacturing tractor shovel loaders and tracklaying tractors are
classified in industry 3531; and those manufacturing wood pallets and skids
are classified in industry 2448.

354  METALWORKING MACHINERY AND EQUIPMENT
This industry group includes establishments primarily engaged in
manufacturing metal cutting type machine tools; metal forming type machine
tools; industrial patterns; special dies and tools, die sets, jigs and
fixtures, and industrial molds; cutting tools, machine tool accessories,
and machinists' precision measuring devices; power-driven handtools;
rolling mill machinery and equipment; electric and gas welding and
soldering equipment; and metalworking machinery, not elsewhere classified.

3541  Machine Tools, Metal Cutting Types
Establishments primarily engaged in manufacturing metal cutting type
machine tools, not supported in the hands of an operator when in use, that
shape metal by cutting or use of electrical techniques; the rebuilding of
such machine tools, and the manufacture of replacement parts for them. Also
included in this industry are metalworking machine tools designed primarily
for home workshops. Establishments primarily engaged in the manufacture of
electric and gas welding and soldering equipment are classified in industry
3548, and those manufacturing portable power-driven handtools are
classified in industry 3546.

3542  Machine Tools, Metal Forming Types
Establishments primarily engaged in manufacturing metal forming machine
tools, not supported in the hands of an operator while in use, for
pressing, hammering, extruding, shearing, diecasting, or otherwise forming
metal into shape. This industry also includes the rebuilding of such
machine tools and the manufacture of repair parts for them.  Establishments
primarily engaged in the manufacture of electric and gas welding equipment
and soldering equipment are classified in industry 3548; those
manufacturing portable power-driven handtools are classified in industry
3546; and those manufacturing rolling mill machinery and equipment are
classified in industry 3547.

3543  Industrial Patterns
Establishments primarily engaged in manufacturing industrial patterns.

3544  Special Dies & Tools, Die Sets, Jigs & Fixtures, & Industrial Molds
Establishments commonly known as contract tool and die shops and primarily
engaged in manufacturing, on a job or order basis, special tools and
fixtures for use with machine tools, hammers, die-casting machines, and
presses. The products of establishments classified in this industry include
a wide variety of special toolings, such as dies; punches; diesets and
components, and subpresses; jigs and fixtures; and special checking
devices. Establishments primarily engaged in manufacturing molds for die-
casting and foundry casting; metal molds for plaster working, rubber
working, plastics working, glass working and similar machinery are also
included. Establishments primarily engaged in manufacturing molds for heavy
steel ingots are classified in industry 3321, and those manufacturing
cutting dies, except metal cutting, are classified in industry 3423.

3545  Cutting Tools, Machine Tool Accessories, & Machinists' Precision
      Measuring Devices
Establishments primarily engaged in manufacturing cutting tools,
machinists' precision measuring tools, and attachments and accessories for
machine tools and for other metalworking machinery, not elsewhere
classified. Establishments primarily engaged in manufacturing handtools,
except power-driven types, are classified in industry group 342.

3546  Power-Driven Handtools
Establishments primarily engaged in manufacturing power-driven handtools,
such as drills and drilling tools, pneumatic and snagging grinders, and
electric hammers. Establishments primarily engaged in manufacturing metal
cutting type and metal forming type machines (including home workshop
tools) which are not supported in the hands of an operator are classified
in industries 3541 and 3542; and those primarily manufacturing power-driven
heavy construction or mining handtools are classified in industry group
353.

3547  Rolling Mill Machinery and Equipment
Establishments primarily engaged in manufacturing rolling mill machinery
and processing equipment for metal production, such as cold forming mills,
structural mills, and finishing equipment.

3548  Electric and Gas Welding and Soldering Equipment
Establishments primarily engaged in manufacturing electric and gas welding
and soldering equipment and accessories. Also included are establishments
primarily engaged in coating welding wire from purchased wire or from wire
drawn in the same establishment. Establishments primarily engaged in
manufacturing handheld soldering irons are classified in industry 3423, and
those manufacturing electron beam, ultrasonic, and laser welding equipment
are classified in industry 3699.

3549  Metalworking Machinery, Not Elsewhere Classified
Establishments primarily engaged in manufacturing metalworking machinery,
not elsewhere classified. Establishments primarily engaged in manufacturing
automotive maintenance equipment are classified in industry 3559.

355  SPECIAL INDUSTRY MACHINERY, EXCEPT METALWORKING MACHINERY
This industry group includes establishments primarily engaged in
manufacturing textile machinery; woodworking machinery; paper industries
machinery; printing trades machinery and equipment; food products
machinery; and special industry machinery, not elsewhere classified.

3552  Textile Machinery
Establishments primarily engaged in manufacturing machinery for the textile
industries, including parts, attachments, and accessories.  Establishments
primarily engaged in manufacturing industrial sewing machines are
classified in industry 3559, and those manufacturing household sewing
machines are classified in industry 3639.

3553  Woodworking Machinery
Establishments primarily engaged in manufacturing machinery for sawmills,
for making particleboard and similar products, and for otherwise working or
producing wood products. Establishments primarily engaged in manufacturing
handtools such as planes, axes, drawknives, and handsaws are classified in
industry group 342, and those manufacturing portable power-driven handtools
in industry 3546.

3554  Paper Industries Machinery
Establishments primarily engaged in manufacturing machinery for the pulp,
paper, and paper product industries. Establishments primarily engaged in
manufacturing printing trades machinery are classified in industry 3555.

3555  Printing Trades Machinery and Equipment
Establishments primarily engaged in manufacturing machinery and equipment
used by the printing and bookbinding trades. Establishments primarily
engaged in manufacturing textile printing machinery are classified in
industry 3552.

3556  Food Products Machinery
Establishments primarily engaged in manufacturing machinery for use by the
food products and beverage manufacturing industries and similar machinery
for use in manufacturing animal foods. Establishments primarily engaged in
manufacturing food packaging machinery are classified in industry 3565, and
those manufacturing industrial refrigeration machinery are classified in
industry group 358.

3559  Special Industry Machinery, Not Elsewhere Classified
Establishments primarily engaged in manufacturing special industry
machinery, not elsewhere classified, such as smelting and refining
equipment, cement making, clayworking, cotton ginning, glass making,
hat making, incandescent lamp making, leather working, paint making, rubber
working, cigar and cigarette making, tobacco working, shoe making, and
stone working machinery, and industrial sewing machines, and automotive
maintenance machinery and equipment.

356  GENERAL INDUSTRIAL MACHINERY AND EQUIPMENT
This industry group includes establishments primarily engaged in
manufacturing pumps and pumping equipment; ball and roller bearings; air
and gas compressors; industrial and commercial fans and blowers and air
purification equipment; packaging machinery; speed changers, industrial
high-speed drives, and gears; industrial process furnaces and ovens;
mechanical power transmission equipment, not elsewhere classified; and
general industrial machinery and equipment, not elsewhere classified.

3561 Pumps and Pumping Equipment
Establishments primarily engaged in manufacturing pumps and pumping
equipment for general industrial, commercial, or household use, except
fluid power pumps and motors. Included are establishments primarily engaged
in manufacturing domestic water and sump pumps. Establishments primarily
engaged in manufacturing fluid power pumps and motors are classified in
industry 3594; those manufacturing measuring and dispensing pumps for
gasoline service station use are classified in industry 3586; those
manufacturing vacuum pumps, except laboratory, are classified in industry
3563; those manufacturing laboratory vacuum pumps are classified in
industry 3821; and those manufacturing pumps for motor vehicles are
classified in industry 3714.

3562  Ball and Roller Bearings
Establishments primarily engaged in manufacturing ball and roller bearings
(including ball or roller bearing pillow block, flange, takeup cartridge
and hangar units) and parts. Establishments primarily engaged in
manufacturing plain bearings are classified in industry 3568.

3563  Air and Gas Compressors
Establishments primarily engaged in manufacturing air and gas compressors
for general industrial use, and in manufacturing nonagricultural spraying
and dusting equipment. Establishments primarily engaged in manufacturing
refrigeration and air-conditioning compressors and compressing units are
classified in industry 3585; those manufacturing pneumatic pumps and motors
for fluid power transmission are classified in industry 3594; those
manufacturing agricultural spraying and dusting equipment are classified in
industry 3523; and those manufacturing laboratory vacuum pumps are
classified in industry 3821.

3564  Industrial & Commercial Fans & Blowers & Air Purification Equipment
Establishments primarily engaged in manufacturing industrial and commercial
blowers, industrial and commercial exhaust and ventilating fans, and attic
fans, or in manufacturing dust collection and other air purification
equipment for heating, ventilating and air-conditioning systems or for
industrial gas cleaning systems. Establishments primarily engaged in
manufacturing air-conditioning units are classified in industry 3585; those
manufacturing free air-circulating fans for use on desks, pedestals, or
wall brackets as well as household window-type fans and roll-abouts, and
kitchen and household ventilating and exhaust electric fans, except attic,
are classified in industry 3634.

3565  Packaging Machinery
Establishments primarily engaged in manufacturing packaging machinery,
including wrapping and bottling machinery.

3566  Speed Changers, Industrial High-Speed Drives, and Gears
Establishments primarily engaged in manufacturing speed changers,
industrial high-speed drives, except hydrostatic drives, and gears.
Establishments primarily engaged in manufacturing automotive power
transmission equipment are classified in industry 3714; those manufacturing
aircraft power transmission equipment are classified in industry 3728; and
those manufacturing industrial hydrostatic drives (transmissions) are
classified in industry 3594.

3567  Industrial Process Furnaces and Ovens
Establishments primarily engaged in manufacturing industrial process
furnaces, ovens, induction and dielectric heating equipment, and related
devices. Establishments primarily engaged in manufacturing bakery ovens are
classified in industry 3556; those manufacturing cement, wood, and chemical
kilns are classified in industry 3559; those manufacturing cremating ovens
are classified in industry 3569; and those manufacturing laboratory
furnaces and ovens are classified in industry 3821.

3568  Mechanical Power Transmission Equipment, Not Elsewhere Classified
Establishments primarily engaged in manufacturing mechanical power
transmission equipment and parts, for industrial machinery.  Establishments
primarily engaged in manufacturing motor vehicle power transmission
equipment are classified in industry 3714; those manufacturing aircraft
power transmission equipment are classified in industry 3728; those
manufacturing ball and roller bearings are classified in industry 3562; and
those manufacturing speed changers, industrial high-speed drives, and gears
are classified in industry 3566.

3569  General Industrial Machinery and Equipment, Not Elsewhere Classified
Establishments primarily engaged in manufacturing machinery, equipment, and
components for general industrial use, and for which no special
classification is provided. Machine shops primarily engaged in producing
machine and equipment parts, usually on a job or order basis, are
classified in industry 3599.

357  COMPUTER AND OFFICE EQUIPMENT
This industry group includes establishments primarily engaged in
manufacturing electronic computers; computer storage devices; computer
terminals; computer peripheral equipment, not elsewhere classified;
calculating and accounting machines, except electronic computers; and
office machines, not elsewhere classified.

3571  Electronic Computers
Establishments primarily engaged in manufacturing electronic computers.
Electronic computers are machines which: (1) store the processing
program or programs and the data immediately necessary for execution of the
program; (2) can be freely programmed in accordance with the requirements
of the user; (3) perform arithmetical computations specified by the user;
and (4) execute, without human intervention, a processing program which
requires them to modify their execution by logical decision during the
processing run. Included in this industry are digital computers, analog
computers, and hybrid digital/analog computers. Establishments primarily
engaged in manufacturing machinery or equipment which incorporate computers
or a central processing unit for the purpose of performing functions such
as measuring, displaying, or controlling process variables are classified
based on the manufactured end product.

3572  Computer Storage Devices
Establishments primarily engaged in manufacturing computer storage devices.

3575  Computer Terminals
Establishments primarily engaged in manufacturing computer terminals.
Establishments primarily engaged in manufacturing point-of-sale, funds
transfer, and automatic teller machines are classified in industry 3578.

3577  Computer Peripheral Equipment, Not Elsewhere Classified
Establishments primarily engaged in manufacturing computer peripheral
equipment, not elsewhere classified, including printers, plotters, and
graphic displays. Establishments primarily engaged in manufacturing modems
and other communications interface equipment are classified in industry
3661.

3578  Calculating and Accounting Machines, Except Electronic Computers
Establishments primarily engaged in manufacturing point-of-sale devices,
funds transfer devices, and other calculating and accounting machines,
except electronic computers. Included are electronic calculating and
accounting machines which must be paced by operator intervention, even when
augmented by attachments. These machines may include program control or
have input/output capabilities.

3579  Office Machines, Not Elsewhere Classified
Establishments primarily engaged in manufacturing office machines and
devices, not elsewhere classified, including typewriters and word
processing equipment. Establishments primarily engaged in manufacturing
photocopy and microfilm equipment are classified in industry 3861.

358  REFRIGERATION AND SERVICE INDUSTRY MACHINERY
This industry group includes establishments primarily engaged in
manufacturing automatic vending machines; commercial laundry, drycleaning,
and pressing machines; air-conditioning and warm air heating equipment and
commercial and industrial refrigeration equipment; measuring and dispensing
pumps; and service industry machinery, not elsewhere classified.

3581  Automatic Vending Machines
Establishments primarily engaged in manufacturing automatic vending
machines and coin-operated mechanisms for such machines.

3582  Commercial Laundry, Drycleaning, and Pressing Machines
Establishments primarily engaged in manufacturing laundry and drycleaning
equipment and pressing machines for commercial and industrial use.
Establishments primarily engaged in manufacturing household laundry
equipment, including coin-operated washers and dryers, are classified in
industry 3633.

3585  Air-Conditioning & Warm Air Heating Equipment & Commercial &
      Industrial Refrigeration Equipment
Establishments primarily engaged in manufacturing refrigeration equipment
and systems and similar equipment for commercial and industrial use;
complete air-conditioning units for domestic, commercial, and industrial
use; and warm air furnaces. Establishments primarily engaged in
manufacturing soda fountains and beer dispensing equipment and humidifiers
and dehumidifiers, except portable, are also classified in this industry.
Establishments primarily engaged in manufacturing household refrigerators
and home and farm freezers are classified in industry 3632, and those
manufacturing electric airspace heaters and portable humidifiers and
dehumidifiers are classified in industry 3634.

3586  Measuring and Dispensing Pumps
Establishments primarily engaged in manufacturing measuring and dispensing
pumps commonly used in service stations for dispensing gasoline, oil, and
grease, including grease guns. Establishments primarily engaged in
manufacturing pumps and pumping equipment for general industrial use are
classified in industry group 356.

3589  Service Industry Machinery, Not Elsewhere Classified
Establishments primarily engaged in manufacturing machines and equipment,
not elsewhere classified, for use in service industries, such as floor
sanding machines, industrial vacuum cleaners, scrubbing machines,
commercial cooking and food warming equipment, and commercial dishwashing
machines. Establishments primarily engaged in manufacturing household
electrical appliances are classified in industry group 363.

359  MISCELLANEOUS INDUSTRIAL AND COMMERCIAL MACHINERY AND EQUIPMENT
This industry group includes establishments primarily engaged in
manufacturing carburetors, pistons, piston rings, and valves; fluid power
cylinders and actuators; fluid power pumps and motors; scales and balances,
except laboratory; and industrial and commercial machinery and equipment,
not elsewhere classified.

3592  Carburetors, Pistons, Piston Rings, and Valves
Establishments primarily engaged in manufacturing carburetors, pistons,
piston rings, and engine intake and exhaust valves. Establishments
primarily engaged in manufacturing metallic packing are classified in
industry 3053, and those primarily engaged in manufacturing machine repair
and equipment parts (except electric), on a job or order basis for others,
are classified in industry 3599.

3593  Fluid Power Cylinders and Actuators
Establishments primarily engaged in manufacturing hydraulic and pneumatic
cylinders and actuators for use in fluid power systems.

3594  Fluid Power Pumps and Motors
Establishments primarily engaged in manufacturing hydraulic and pneumatic
fluid power pumps and motors, including hydrostatic transmissions.
Establishments primarily engaged in manufacturing pumps for motor vehicles
are classified in industry 3714.

3596  Scales and Balances, Except Laboratory
Establishments primarily engaged in manufacturing weighing and force-
measuring machines and devices of all types, except those regarded as
scientific apparatus for laboratory work which are classified in industry
3821.

3599  Industrial and Commercial Machinery and Equipment, N.E.C.
Establishments primarily engaged in manufacturing machinery and equipment
and parts, not elsewhere classified, such as amusement park equipment and
flexible metal hose and tubing. This industry also includes establishments
primarily engaged in producing or repairing machinery and equipment parts,
not elsewhere classified, on a job or order basis for others.
Establishments primarily engaged in manufacturing motor vehicle engine
filters are classified in industry 3714, and those manufacturing coin-
operated amusement machines are classified in industry 3999.


=>36  ELECTRONIC & OTHER ELECTRICAL EQUIP. & COMP., EXC COMPUTER EQUIP.
This major group includes establishments engaged in manufacturing
machinery, apparatus, and supplies for the generation, storage,
transmission, transformation, and utilization of electrical energy.
Included are the manufacturing of electricity distribution equipment;
electrical industrial apparatus; household appliances; electrical lighting
and wiring equipment; radio and television receiving equipment;
communications equipment; electronic components and accessories; and other
electrical equipment and supplies. The manufacture of household appliances
is included in this group, but industrial machinery and equipment powered
by built-in or detachable electric motors is classified in major group 35.
Establishments primarily engaged in manufacturing instruments are
classified in major group 38.

361  ELECTRIC TRANSMISSION AND DISTRIBUTION EQUIPMENT
This industry group includes establishments primarily engaged in
manufacturing power, distribution, and specialty transformers, and
switchgear and switchboard apparatus.

3612  Power, Distribution, and Specialty Transformers
Establishments primarily engaged in manufacturing power, distribution,
instrument, and specialty transformers. Establishments primarily
engaged in manufacturing radio frequency or voice frequency electronic
transformers, coils, or chokes are classified in industry 3677, and
those manufacturing resistance welder transformers are classified in
industry 3548.

3613  Switchgear and Switchboard Apparatus
Establishments primarily engaged in manufacturing switchgear and
switchboard apparatus. Important products of this industry include
power switches, circuit breakers, power switching equipment, and
similar switchgear for general industrial application; switchboards and
cubicles, control and metering panels, fuses and fuse mountings, and
similar switchboard apparatus and supplies. Establishments primarily
engaged in manufacturing relays are classified in industry 3625.
Establishments manufacturing switches other than switchgear type are
classified in industry 3625 if the switches are of the type used as
industrial controls, in industry 3679 if the switches are of the type used
in electronic devices, and in industry 3643 if the switches are of other
types used in wiring circuits.

362  ELECTRICAL INDUSTRIAL APPARATUS
This industry group includes establishments primarily engaged in
manufacturing motors and generators; carbon and graphite products; relays
and industrial controls; and electrical industrial apparatus, not elsewhere
classified.

3621  Motors and Generators
Establishments primarily engaged in manufacturing electric motors (except
engine starting motors) and power generators; motor generator sets; railway
motors and control equipment; and motors, generators, and control equipment
for gasoline, electric, and oil-electric buses and trucks. Establishments
primarily engaged in manufacturing turbogenerators are classified in
industry 3511; those manufacturing starting motors and battery charging
generators for internal combustion engines are classified in industry 3694;
and those manufacturing generators for welding equipment are classified in
industry 3548.

3624  Carbon and Graphite Products
Establishments primarily engaged in manufacturing carbon, graphite, and
metal-graphite brushes and brush stock; carbon or graphite electrodes
for thermal and electrolytic uses; carbon and graphite fibers; and other
carbon, graphite, and metal-graphite products.

3625  Relays and Industrial Controls
Establishments primarily engaged in manufacturing relays; motor starters
and controllers; and other industrial controls and control accessories.
Establishments primarily engaged in manufacturing automatic temperature
controls are classified in industry 3822, and those manufacturing
industrial process control instruments are classified in industry 3823.

3629  Electrical Industrial Apparatus, Not Elsewhere Classified
Establishments primarily engaged in manufacturing industrial and commercial
electric apparatus and equipment, not elsewhere classified, such as fixed
and variable capacitors and rectifiers for industrial applications.
Establishments primarily engaged in manufacturing electronic capacitors and
rectifiers are classified in industry group 367.

363  HOUSEHOLD APPLIANCES
This industry group includes establishments primarily engaged in
manufacturing household cooking equipment; household refrigerators and home
and farm freezers; household laundry equipment; electric housewares and
fans; household vacuum cleaners; and household appliances, not elsewhere
classified.

3631  Household Cooking Equipment
Establishments primarily engaged in manufacturing household electric and
nonelectric cooking equipment, such as stoves, ranges, and ovens, except
portable electric appliances. This industry includes establishments
primarily engaged in manufacturing microwave and convection ovens,
including portable. Establishments primarily engaged in manufacturing other
electric household cooking appliances, such as portable ovens, hot plates,
grills, percolators, and toasters, are classified in industry 3634.
Establishments primarily engaged in manufacturing commercial cooking
equipment are classified in industry 3589.

3632  Household Refrigerators and Home and Farm Freezers
Establishments primarily engaged in manufacturing household refrigerators
and home and farm freezers. Establishments primarily engaged in
manufacturing commercial and industrial refrigeration equipment, packaged
room coolers, and all refrigeration compressor and condenser units are
classified in industry 3585, and those manufacturing portable room
dehumidifiers are classified in industry 3634.

3633  Household Laundry Equipment
Establishments primarily engaged in manufacturing laundry equipment, such
as washing machines, dryers, and ironers, for household use, including
coin-operated. Establishments primarily engaged in manufacturing commercial
laundry equipment are classified in industry 3582, and those manufacturing
portable electric irons are classified in industry 3634.

3634  Electric Housewares and Fans
Establishments primarily engaged in manufacturing electric housewares for
heating, cooking, and other purposes; and electric household fans, except
attic fans. Important products of this industry include household-type
ventilation and exhaust fans; portable household cooking appliances, except
convection and microwave ovens; electric space heaters; electrically heated
bedcoverings, electric scissors; and portable humidifiers and
dehumidifiers. Establishments primarily engaged in manufacturing attic fans
and industrial and commercial exhaust and ventilation fans are classified
in industry 3564; and those manufacturing room air-conditioners and
humidifying and dehumidifying equipment, except portable, are classified in
industry 3585.

3635  Household Vacuum Cleaners
Establishments primarily engaged in manufacturing vacuum cleaners for
household use. Establishments primarily engaged in manufacturing vacuum
cleaners for industrial use are classified in industry 3589. Establishments
primarily engaged in installation of central vacuum cleaner systems are
classified in Construction, industry 1796.

3639  Household Appliances, Not Elsewhere Classified
Establishments primarily engaged in manufacturing household appliances, not
elsewhere classified, such as water heaters, dishwashers, food waste
disposal units, and household sewing machines.

364  ELECTRIC LIGHTING AND WIRING EQUIPMENT
This industry group includes establishments primarily engaged in
manufacturing electric lamp bulbs and tubes; current-carrying wiring
devices; noncurrent-carrying wiring devices; residential electric lighting
fixtures; commercial, industrial, and institutional electric lighting
fixtures; vehicular lighting equipment; and lighting equipment, not
elsewhere classified.

3641  Electric Lamp Bulbs and Tubes
Establishments primarily engaged in manufacturing electric bulbs, tubes,
and related light sources. Important products of this industry include
incandescent filament lamps, vapor and fluorescent lamps, photoflash and
photoflood lamps, and electrotherapeutic lamp units for ultraviolet and
infrared radiation. Establishments primarily engaged in manufacturing glass
blanks for bulbs are classified in industry 3229.

3643  Current-Carrying Wiring Devices
Establishments primarily engaged in manufacturing current-carrying wiring
devices.

3644  Noncurrent-Carrying Wiring Devices
Establishments primarily engaged in manufacturing noncurrent-carrying
wiring devices. Important products of this industry include conduits
and fittings; electrical insulators, except porcelain and other ceramic
insulators and glass insulators; outlet, switch, and fuse boxes; and
pole line hardware. Establishments primarily engaged in manufacturing
ceramic insulators are classified in industry 3264, and those manufacturing
glass insulators are classified in industry 3229.

3645  Residential Electric Lighting Fixtures
Establishments primarily engaged in manufacturing residential electric
lighting fixtures and equipment, fixed or portable. Establishments
primarily engaged in producing glassware for lighting fixtures are
classified in major group 32; those manufacturing electric light bulbs,
tubes, and related light sources are classified in industry 3641; those
manufacturing lamp shades, except glass and metal, are classified in
industry 3999; and those manufacturing nonelectric fixtures and portable
electric flashlights, lanterns, and similar lamps are classified in
industry 3648.

3646  Commercial, Industrial, and Institutional Electric Lighting Fixtures
Establishments primarily engaged in manufacturing commercial, industrial,
and institutional electric lighting fixtures.  Establishments primarily
engaged in producing glassware for lighting fixtures are classified in
major group 32; those manufacturing residential lighting fixtures are
classified in industry 3645; and those manufacturing vehicular lighting
fixtures are classified in industry 3647.

3647  Vehicular Lighting Equipment
Establishments primarily engaged in manufacturing vehicular lighting
equipment. Establishments primarily engaged in manufacturing sealed-beam
lamps are classified in industry 3641.

3648  Lighting Equipment, Not Elsewhere Classified
Establishments primarily engaged in manufacturing lighting fixtures and
equipment, electric and nonelectric, not elsewhere classified, including
flashlights and similar portable lamps, searchlights, ultraviolet lamp
fixtures, and infrared lamp fixtures. Establishments primarily engaged in
manufacturing electric light bulbs, tubes, and related light sources are
classified in industry 3641; those producing glassware for lighting
fixtures are classified in major group 32; and those manufacturing traffic
signals are classified in industry 3669.

365  HOUSEHOLD AUDIO AND VIDEO EQUIPMENT, AND AUDIO RECORDINGS
This industry group includes establishments primarily engaged in
manufacturing household audio and video equipment, and phonograph records
and prerecorded audio tapes and disks.

3651  Household Audio and Video Equipment
Establishments primarily engaged in manufacturing electronic audio and
video equipment for home entertainment (including automotive), such as
television sets, radio broadcast receivers, tape players, phonographs, and
video recorders and players. This industry also includes establishments
primarily engaged in manufacturing public address systems and music
distribution apparatus. Establishments primarily engaged in manufacturing
phonograph records and prerecorded audio tapes are classified in industry
3652; those manufacturing telephone answering machines are classified in
industry 3661; those manufacturing motion picture reproduction equipment
are classified in industry 3861; and those manufacturing phonograph needles
and cartridges are classified in industry 3679. Establishments primarily
engaged in manufacturing separate cabinets for home electronic equipment
are classified in major group 25.

3652  Phonograph Records and Prerecorded Audio Tapes and Disks
Establishments primarily engaged in manufacturing phonograph records and
prerecorded audio tapes and disks. Establishments primarily engaged in the
design, development, and production of prepackaged computer software are
classified in Services, industry group 737; and those reproducing
prerecorded video tape cassettes and disks are classified in Services,
major group 78.

366  COMMUNICATIONS EQUIPMENT
This industry group includes establishments primarily engaged in
manufacturing telephone and telegraph apparatus; radio and television
broadcasting and communications equipment; and communications equipment,
not elsewhere classified.

3661  Telephone and Telegraph Apparatus
Establishments primarily engaged in manufacturing wire telephone and
telegraph equipment. Included are establishments manufacturing modems
and other telephone and telegraph communications interface equipment.
Establishments primarily engaged in manufacturing cellular radio telephones
are classified in industry 3663.

3663  Radio and Television Broadcasting and Communications Equipment
Establishments primarily engaged in manufacturing radio and television
broadcasting and communications equipment. Important products of this
industry are closed-circuit and cable television equipment; studio
equipment; light communications equipment; transmitters, transceivers
and receivers (except household and automotive); cellular radio telephones;
communication antennas; receivers; RF power amplifiers; and fixed and
mobile radio systems. Establishments primarily engaged in manufacturing
household audio and video equipment are classified in industry 3651; those
manufacturing intercommunication equipment are classified in industry 3669;
and those manufacturing consumer radio and television receiving antennas
are classified in industry 3679.

3669  Communications Equipment, Not Elsewhere Classified
Establishments primarily engaged in manufacturing communications and
related equipment, not elsewhere classified. Important products of this
industry are intercommunication equipment, traffic signaling equipment, and
fire and burglar alarm apparatus.

367  ELECTRONIC COMPONENTS AND ACCESSORIES
This industry group includes establishments primarily engaged in
manufacturing electron tubes; printed circuit boards; semiconductors and
related devices; electronic capacitors; electronic resistors; electronic
coils, transformers, and other inductors; electronic connectors; and
electronic components, not elsewhere classified.

3671  Electron Tubes
Establishments primarily engaged in manufacturing electron tubes and tube
parts. Establishments primarily engaged in manufacturing X-ray tubes and
parts are classified in industry 3844.

3672  Printed Circuit Boards
Establishments primarily engaged in manufacturing printed circuit boards.

3674  Semiconductors and Related Devices
Establishments primarily engaged in manufacturing semiconductors and
related solidstate devices. Important products of this industry are
semiconductor diodes and stacks, including rectifiers, integrated
microcircuits (semiconductor networks), transistors, solar cells, and light
sensing and emitting semiconductor (solid-state) devices.

3675  Electronic Capacitors
Establishments primarily engaged in manufacturing electronic capacitors.
Establishments primarily engaged in manufacturing electrical capacitors are
classified in industry 3629.

3676  Electronic Resistors
Establishments primarily engaged in manufacturing electronic resistors.
Establishments primarily engaged in manufacturing resistors for telephone
and telegraph apparatus are classified in industry 3661.

3677  Electronic Coils, Transformers, and Other Inductors
Establishments primarily engaged in manufacturing electronic coils,
transformers, and inductors. Establishments primarily engaged in
manufacturing electrical transformers are classified in industry 3612;
those manufacturing transformers and inductors for telephone and telegraph
apparatus are classified in industry 3661, and those manufacturing
semiconductors and related devices are classified in industry 3674.

3678  Electronic Connectors
Establishments primarily engaged in manufacturing electronic connectors.
Establishments primarily engaged in manufacturing electrical connectors are
classified in industry 3643; those manufacturing electronic capacitors are
classified in industry 3675; and those manufacturing electronic coils,
transformers, and other inductors are classified in industry 3677.

3679  Electronic Components, Not Elsewhere Classified
Establishments primarily engaged in manufacturing electronic components,
not elsewhere classified, such as receiving antennas, switches, and
waveguides. Establishments primarily engaged in manufacturing radio and
television transmitting antennas are classified in industry 3663.

369  MISCELLANEOUS ELECTRICAL MACHINERY, EQUIPMENT, AND SUPPLIES
This industry group includes establishments primarily engaged in
manufacturing storage batteries; dry and wet primary batteries; electrical
equipment for internal combustion engines; magnetic and optical recording
media; and electrical machinery, equipment, and supplies, not elsewhere
classified.

3691  Storage Batteries
Establishments primarily engaged in manufacturing storage batteries.

3692  Primary Batteries, Dry and Wet
Establishments primarily engaged in manufacturing primary batteries, dry or
wet.

3694  Electrical Equipment For Internal Combustion Engines
Establishments primarily engaged in manufacturing electrical equipment for
internal combustion engines. Important products of this industry include
armatures, starting motors, alternators, and generators for automobiles and
aircraft; and ignition apparatus for internal combustion engines, including
spark plugs, magnetos, coils, and distributors.

3695  Magnetic And Optical Recording Media
Establishments primarily engaged in manufacturing blank tape, disk, and
cassette magnetic and optical recording media for use in recording
audio, video, and digital signals. Establishments primarily engaged in
manufacturing blank or recorded records and prerecorded audio tapes are
classified in industry 3652; those manufacturing prepackaged computer
software are classified in Services, industry 7372; and those manufacturing
prerecorded video tape cassettes and disks are classified in Services,
major group 78.

3699  Electrical Machinery, Equipment, and Supplies, N.E.C.
Establishments primarily engaged in manufacturing electrical machinery,
equipment, and supplies, not elsewhere classified, including high energy
particle acceleration systems and equipment, electronic simulators,
appliance and extension cords, bells and chimes, and insect traps.

=>37  TRANSPORTATION EQUIPMENT
This major group includes establishments engaged in manufacturing equipment
for transportation of passengers and cargo by land, air, and water.
Important products produced by establishments classified in this major
group include motor vehicles, aircraft, guided missiles and space vehicles,
ships, boats, railroad equipment, and miscellaneous transportation
equipment, such as motorcycles, bicycles, and snowmobiles. Establishments
primarily engaged in manufacturing mobile homes are classified in industry
2451. Establishments primarily engaged in manufacturing equipment used for
moving materials on farms; in mines and on construction sites; in
individual plants; in airports; or on other locations off the highway are
classified in major group 35.

371  MOTOR VEHICLES AND MOTOR VEHICLE EQUIPMENT
This industry group includes establishments primarily engaged in
manufacturing or assembling motor vehicles and passenger car bodies; truck
and bus bodies; motor vehicle parts and accessories; truck trailers; and
motor homes.

3711  Motor Vehicles and Passenger Car Bodies
Establishments primarily engaged in manufacturing or assembling complete
passenger automobiles, trucks, commercial cars and buses, and special
purpose motor vehicles which are for highway use. This industry also
includes establishments primarily engaged in manufacturing chassis and
passenger car bodies. Such establishments may also manufacture motor
vehicle parts, but establishments primarily engaged in manufacturing motor
vehicle parts except chassis and passenger car bodies are classified in
industry 3714. Establishments primarily engaged in manufacturing truck and
bus bodies and in assembling them on purchased chassis are classified in
industry 3713; those manufacturing motor homes on purchased chassis are
classified in industry 3716; those manufacturing motorcycles are classified
in industry 3751; those manufacturing industrial tractors are classified in
industry 3537; those manufacturing other wheel tractors, except contractors
off-highway types, are classified in industry 3523; those manufacturing
tracklaying and contractors' off-highway type tractors are classified
in industry 3531; those manufacturing combat tanks and self-propelled
weapons are classified in industry 3795; and those manufacturing
stamped body parts for passenger cars are classified in industry 3465.

3713  Truck and Bus Bodies
Establishments primarily engaged in manufacturing truck and bus bodies and
cabs for sale separately or for assembly on purchased chassis, or in
assembling truck and bus bodies on purchased chassis. Establishments
primarily engaged in manufacturing complete trucks and buses are classified
in industry 3711; those manufacturing stamped body parts for trucks and
buses are classified in industry 3465; those manufacturing truck trailers
and demountable cargo containers are classified in industry 3715; those
manufacturing cabs for agricultural tractors are classified in industry
3523; those manufacturing cabs for industrial trucks are classified in
industry 3537; and those manufacturing cabs for off-highway construction
trucks are classified in industry 3531.

3714  Motor Vehicle Parts and Accessories
Establishments primarily engaged in manufacturing motor vehicle parts and
accessories, but not engaged in manufacturing complete motor vehicles or
passenger car bodies. Establishments primarily engaged in manufacturing or
assembling complete automobiles and trucks are classified in industry 3711;
those manufacturing tires and tubes are classified in industry 3011; those
manufacturing automobile glass are classified in major group 32; those
manufacturing automobile stampings are classified in industry 3465; those
manufacturing vehicular lighting equipment are classified in industry 3647;
those manufacturing ignition systems are classified in industry 3694; those
manufacturing storage batteries are classified in industry 3691; and those
manufacturing carburetors, pistons, piston rings, and engine intake and
exhaust valves are classified in industry 3592.

3715  Truck Trailers
Establishments primarily engaged in manufacturing truck trailers, truck
trailer chassis for sale separately, detachable trailer bodies (cargo
containers) for sale separately, and detachable trailer (cargo container)
chassis, for sale separately.

3716  Motor Homes
Establishments primarily engaged in manufacturing self-contained motor
homes on purchased chassis. Establishments engaged in manufacturing self-
contained motor homes on chassis manufactured in the same establishment are
classified in industry 3711. Establishments primarily engaged in
manufacturing mobile homes are classified in industry 2451; and those
manufacturing travel trailers and pickup campers are classified in industry
3792. Establishments primarily engaged in van conversion on a custom basis
are classified in Services, industry 7532.

372  AIRCRAFT AND PARTS
This industry group includes establishments primarily engaged in
manufacturing or assembling aircraft; aircraft engines and engine parts;
and aircraft parts and auxiliary equipment, not elsewhere classified.

3721  Aircraft
Establishments primarily engaged in manufacturing or assembling complete
aircraft. This industry also includes establishments owned by aircraft
manufacturers and primarily engaged in research and development on
aircraft, whether from enterprise funds or on a contract or fee basis. Also
included are establishments engaged in repairing and rebuilding aircraft on
a factory basis. Establishments primarily engaged in manufacturing engines
and other aircraft parts and auxiliary equipment are classified in
industries 3724 and 3728; and those manufacturing guided missiles and space
vehicles and parts are classified in industry group 376. Establishments
primarily engaged in the repair of aircraft, except on a factory basis, are
classified in Transportation, industry 4581; and research and development
on aircraft by establishments not owned by aircraft manufacturers are
classified in Services, industry 8731.

3724  Aircraft Engines and Engine Parts
Establishments primarily engaged in manufacturing aircraft engines and
engine parts. This industry also includes establishments owned by aircraft
engine manufacturers and primarily engaged in research and development on
aircraft engines and engine parts whether from enterprise funds or on a
contract or fee basis. Also included are establishments engaged in
repairing and rebuilding aircraft engines on a factory basis.
Establishments primarily engaged in manufacturing guided missile and space
vehicle propulsion units and parts are classified in industry 3764; those
manufacturing aircraft intake and exhaust valves and pistons are classified
in industry 3592; and those manufacturing aircraft internal combustion
engine filters are classified in industry 3714. Establishments primarily
engaged in the repair of aircraft engines, except on a factory basis, are
classified in Transportation, industry 4581; and research and development
on aircraft engines on a contract or fee basis by establishments not owned
by aircraft engine manufacturers are classified in Services, industry 8731.

3728  Aircraft Parts and Auxiliary Equipment, Not Elsewhere Classified
Establishments primarily engaged in manufacturing aircraft parts and
auxiliary equipment, not elsewhere classified. This industry also includes
establishments owned by manufacturers of aircraft parts and auxiliary
equipment and primarily engaged in research and development on aircraft
parts, whether from enterprise funds or on a contract or fee basis.
Establishments primarily engaged in manufacturing or assembling complete
aircraft are classified in industry 3721; those manufacturing aircraft
engines and parts are classified in industry 3724; those manufacturing
aeronautical instruments are classified in industry 3812; those
manufacturing aircraft engine electrical (aeronautical electrical)
equipment are classified in industry 3694; and those manufacturing guided
missile and space vehicle parts and auxiliary equipment are classified in
industry 3769. Establishments not owned by manufacturers of aircraft parts
but primarily engaged in research and development on aircraft parts on a
contract or fee basis are classified in Services, industry 8731.

373  SHIP AND BOAT BUILDING AND REPAIRING
This industry group includes establishments primarily engaged in ship and
boat building and repairing.

3731  Ship Building and Repairing
Establishments primarily engaged in building and repairing ships, barges,
and lighters, whether self-propelled or towed by other craft.  This
industry also includes the conversion and alteration of ships and the
manufacture of offshore oil and gas well drilling and production platforms
(whether or not self-propelled). Establishments primarily engaged in
fabricating structural assemblies or components for ships, or
subcontractors engaged in ship painting, joinery, carpentry work, and
electrical wiring installation, are classified in other industries.

3732  Boat Building and Repairing
Establishments primarily engaged in building and repairing boats.
Establishments primarily engaged in manufacturing rubber and nonrigid
plastics boats are classified in major group 30. Establishments
primarily engaged in operating marinas and which perform incidental
boat repair are classified in Transportation, industry 4493; membership
yacht clubs are classified in Services, industry 7997; and those performing
outboard motor repair are classified in Services, industry 7699.

374  RAILROAD EQUIPMENT
Establishments primarily engaged in building and rebuilding locomotives
(including frames and parts, not elsewhere classified) of any type or
gauge; and railroad, street, and rapid transit cars and car equipment
for operation on rails for freight and passenger service.  Establishments
primarily engaged in manufacturing mining cars are classified in industry
3532. Repair shops, owned and operated by railroads or local transit
companies, repairing locomotives or cars for their own use are classified
in Transportation, major groups 40 and 41.  Establishments primarily
engaged in repairing railroad cars on a contract or fee basis are
classified in Transportation, industry 4789; and those repairing locomotive
engines on a contract or fee basis are classified in Services, industry
7699.

3743  Railroad Equipment
Establishments primarily engaged in building and rebuilding locomotives
(including frames and parts, not elsewhere classified) of any type or
gauge; and railroad, street, and rapid transit cars and car equipment
for operation on rails for freight and passenger service.  Establishments
primarily engaged in manufacturing mining cars are classified in industry
3532. Repair shops, owned and operated by railroads or local transit
companies, repairing locomotives or cars for their own use are classified
in Transportation, major groups 40 and 41.  Establishments primarily
engaged in repairing railroad cars on a contract or fee basis are
classified in Transportation, industry 4789; and those repairing locomotive
engines on a contract or fee basis are classified in Services, industry
7699.

375  MOTORCYCLES, BICYCLES, AND PARTS
Establishments primarily engaged in manufacturing motorcycles, bicycles,
and similar equipment, and parts. Establishments primarily engaged in
manufacturing children's vehicles, except bicycles, are classified in
industry 3944. Establishments primarily engaged in manufacturing golf carts
and other similar personnel carriers are classified in industry 3799.

3751  Motorcycles, Bicycles, and Parts
Establishments primarily engaged in manufacturing motorcycles, bicycles,
and similar equipment, and parts. Establishments primarily engaged in
manufacturing children's vehicles, except bicycles, are classified in
industry 3944. Establishments primarily engaged in manufacturing golf carts
and other similar personnel carriers are classified in industry 3799.

376  GUIDED MISSILES AND SPACE VEHICLES AND PARTS
This industry group includes establishments primarily engaged in
manufacturing guided missiles and space vehicles; guided missile and space
vehicle propulsion units and propulsion unit parts; and guided missile and
space vehicle parts and auxiliary equipment, not elsewhere classified.

3761  Guided Missiles and Space Vehicles
Establishments primarily engaged in manufacturing complete guided missiles
and space vehicles. This industry also includes establishments owned by
guided missile and space vehicle manufacturers and primarily engaged in
research and development on these products, whether from enterprise funds
or on a contract or fee basis. Establishments primarily engaged in
manufacturing guided missile and space vehicle propulsion units and
propulsion unit parts are classified in industry 3764; those manufacturing
space satellites are classified in industry 3669; those manufacturing
guided missile and space vehicle airborne and ground guidance, checkout,
and launch electronic systems and components are classified in industry
3812; and those manufacturing guided missile and space vehicle airframes,
nose cones, and space capsules are classified in industry 3769. Research
and development on guided missiles and space vehicles, on a contract or fee
basis, by establishments not owned by guided missile or space vehicle
manufacturers are classified in Services, industry 8731.

3764  Guided Missile & Space Vehicle Propulsion Units & Propulsion Unit
  Parts
Establishments primarily engaged in manufacturing guided missile propulsion
units and propulsion unit parts. This industry also includes establishments
owned by manufacturers of guided missile and space vehicle propulsion units
and parts and primarily engaged in research and development on such
products, whether from enterprise funds or on a contract or fee basis.
Research and development on guided missile and space propulsion units, on a
contract or fee basis by establishments not owned by manufacturers of
guided missile and space vehicle propulsion units and parts, are classified
in Services, industry 8731.

3769  Guided Missile and Space Vehicle Parts and Auxiliary Equipment, NEC
Establishments primarily engaged in manufacturing guided missile and space
vehicle parts and auxiliary equipment, not elsewhere classified.  This
industry also includes establishments owned by manufacturers of guided
missile and space vehicle parts and auxiliary equipment, not elsewhere
classified, and primarily engaged in research and development on such
products, whether from enterprise funds or on a contract or fee basis.
Establishments primarily engaged in manufacturing navigational and guidance
systems are classified in industry 3812. Research and development on guided
missile and space vehicle parts, on a contract or fee basis by
establishments not owned by manufacturers of such products, are classified
in Services, industry 8731.

379  MISCELLANEOUS TRANSPORTATION EQUIPMENT
This industry group includes establishments primarily engaged in
manufacturing travel trailers and campers; tanks and tank components; and
transportation equipment, not elsewhere classified.

3792  Travel Trailers and Campers
Establishments primarily engaged in manufacturing travel trailers and
campers for attachment to passenger cars or other vehicles, pickup coaches
(campers) and caps (covers) for mounting on pickup trucks.  Travel trailers
are generally 35 feet long or less, 8 feet wide or less, and have storage
facilities for water and waste. Establishments primarily engaged in
manufacturing mobile homes are classified in industry 2451.

3795  Tanks and Tank Components
Establishments primarily engaged in manufacturing complete tanks,
specialized components for tanks, and self-propelled weapons.
Establishments primarily engaged in manufacturing military vehicles, except
tanks and self-propelled weapons, are classified in industry group 371, and
those manufacturing tank engines are classified in industry group 351.

3799  Transportation Equipment, Not Elsewhere Classified
Establishments primarily engaged in manufacturing transportation equipment,
not elsewhere classified. Establishments primarily engaged in manufacturing
industrial trucks, tractors, trailers, and stackers are classified in
industry 3537, and those manufacturing children's vehicles except bicycles
are classified in industry 3944.

=>38  MEASURING, ANALYZING & CONTROLLING INSTRUMENTS; PHOTOGRAPHIC, MEDICAL
      & OPTICAL GOODS; WATCHES & CLOCKS
This major group includes establishments engaged in manufacturing
instruments (including professional and scientific) for measuring, testing,
analyzing, and controlling, and their associated sensors and accessories;
optical instruments and lenses; surveying and drafting instruments;
hydrological, hydrographic, meteorological, and geophysical equipment;
search, detection, navigation, and guidance systems and equipment;
surgical, medical, and dental instruments, equipment, and supplies;
ophthalmic goods; photographic equipment and supplies; and watches and
clocks.

381  SEARCH, DETECTION, NAVIGATION, GUIDANCE, AERONAUTICAL, AND NAUTICAL
     SYSTEMS, INSTRUMENTS, AND EQUIPMENT
Establishments primarily engaged in manufacturing search, detection,
navigation, guidance, aeronautical, and nautical systems and instruments.
Important products of this industry are radar systems and equipment; sonar
systems and equipment; navigation systems and equipment; countermeasures
equipment; aircraft and missile control systems and equipment; flight and
navigation sensors, transmitters, and displays; gyroscopes; airframe
equipment instruments; and speed, pitch, and roll navigational instruments
and systems. Establishments primarily engaged in manufacturing aircraft
engine instruments or meteorological systems and equipment, including
weather tracking equipment, are classified in industry 3829.

3812  Search, Detection, Navigation, Guidance, Aeronautical, and Nautical
      Systems and Instruments
Establishments primarily engaged in manufacturing search, detection,
navigation, guidance, aeronautical, and nautical systems and instruments.
Important products of this industry are radar systems and equipment; sonar
systems and equipment; navigation systems and equipment; countermeasures
equipment; aircraft and missile control systems and equipment; flight and
navigation sensors, transmitters, and displays; gyroscopes; airframe
equipment instruments; and speed, pitch, and roll navigational instruments
and systems. Establishments primarily engaged in manufacturing aircraft
engine instruments or meteorological systems and equipment, including
weather tracking equipment, are classified in industry 3829.

382  LABORATORY APPARATUS & ANALYTICAL, OPTICAL, MEASURING, & CONTROLLING
     INSTRUMENTS
This industry group includes establishments primarily engaged in
manufacturing laboratory apparatus and furniture; automatic controls for
regulating residential and commercial environments and appliances;
industrial instruments for measurement, display, and control of process
variables, and related products; totalizing fluid meters and counting
devices; instruments for measuring and testing of electricity and
electrical signals; laboratory analytical instruments; optical instruments
and lenses; and measuring and controlling devices, not elsewhere
classified.

3821  Laboratory Apparatus and Furniture
Establishments primarily engaged in manufacturing laboratory apparatus and
furniture. Important products of this industry include laboratory balances
and scales, laboratory furnaces and ovens, laboratory centrifuges, and
various components, parts, and accessories for laboratory apparatus.
Laboratory instruments are classified elsewhere, generally in other
industries of industry group 382.

3822  Automatic Controls for Regulating Residential & Commercial
      Environments & Appliances
Establishments primarily engaged in manufacturing temperature and related
controls for heating and air-conditioning installations and refrigeration
applications, which are electrically, electronically, or pneumatically
actuated, and which measure and control variables such as temperature and
humidity; and automatic regulators used as components of household
appliances. Establishments primarily engaged in manufacturing industrial
process controls are classified in industry 3823; those manufacturing motor
control switches are classified in industry 3625; those manufacturing
switches for household appliances are classified in industry 3643; and
those manufacturing appliance timers are classified in industry 3873.

3823  Industrial Instruments for Measurement, Display, and Control of
      Process Variables; and Related Products
Establishments primarily engaged in manufacturing industrial instruments
and related products for measuring, displaying (indicating and/or
recording), transmitting, and controlling process variables in
manufacturing, energy conversion, and public service utilities. These
instruments operate mechanically, pneumatically, electronically, or
electrically to measure process variables, such as temperature, humidity,
pressure, vacuum, combustion, flow, level, viscosity, density, acidity,
alkalinity, specific gravity, gas and liquid concentration, sequence, time
interval, mechanical motion, and rotation. Establishments primarily engaged
in manufacturing electrical integrating meters are classified in industry
3825; those manufacturing residential and commercial comfort controls are
classified in industry 3822; those manufacturing all liquid-in-glass and
bimetal thermometers and glass hydrometers are classified in industry 3829;
those manufacturing recorder charts are classified in industry group 275;
and those manufacturing analytical and optical instruments are classified
in industries 3826 and 3827.

3824  Totalizing Fluid Meters and Counting Devices
Establishments primarily engaged in manufacturing totalizing (registering)
meters monitoring fluid flows, such as watermeters and gasmeters; and
producers of mechanical and electromechanical counters and associated
metering devices. Establishments primarily engaged in manufacturing
electricity integrating meters and electronic frequency counters are
classified in industry 3825, and those manufacturing industrial process
instruments are classified in industry 3823.

3825  Instruments for Measuring & Testing of Electricity & Electrical
      Signals
Establishments primarily engaged in manufacturing instruments for measuring
the characteristics of electricity and electrical signals, such as
voltmeters, ammeters, wattmeters, watt-hour meters, demand meters, and
equipment for testing the electrical characteristics of electrical, radio,
and communication circuits and of internal combustion engines.
Establishments primarily engaged in the manufacturing of electronic
checkout, monitoring, evaluating, and other electronic support equipment
for electronic navigational, radar, and sonar systems are classified in
industry 3812, and those manufacturing similar equipment for communications
systems classified in industry group 366.

3826  Laboratory Analytical Instruments
Establishments primarily engaged in manufacturing laboratory instruments
and instrumentation systems for chemical or physical analysis of the
composition or concentration of samples of solid, fluid, gaseous, or
composite material. Establishments primarily engaged in manufacturing
instruments for monitoring and analyzing continuous samples from medical
patients are classified in industry 3845, and from industrial process
streams are classified in industry 3823.

3827  Optical Instruments and Lenses
Establishments primarily engaged in manufacturing instruments and apparatus
that measure an optical property and optically project, measure, or magnify
an image, such as binoculars, microscopes, prisms, and lenses.  Included
are establishments primarily engaged in manufacturing optical sighting and
fire control equipment.

3829  Measuring and Controlling Devices, Not Elsewhere Classified
Establishments primarily engaged in manufacturing measuring and controlling
devices, not elsewhere classified, including meteorological instruments.
Important products of this industry are physical properties testing
equipment, nuclear radiation detection and monitoring instrumentation,
aircraft engine instruments (except flight), and liquid-in-glass and
bimetal thermometers. Also included in this industry are establishments
primarily engaged in manufacturing surveying and drafting instruments, such
as alidades, transits, sextants, theodolites, slide rules, and T-squares.

384  SURGICAL, MEDICAL, AND DENTAL INSTRUMENTS AND SUPPLIES
This industry group includes establishments primarily engaged in
manufacturing surgical and medical instruments and apparatus; orthopedic,
prosthetic, and surgical appliances and supplies; dental equipment and
supplies; x-ray apparatus and tubes and related irradiation apparatus; and
electromedical and electrotherapeutic apparatus.

3841  Surgical and Medical Instruments and Apparatus
Establishments primarily engaged in manufacturing medical, surgical,
ophthalmic, and veterinary instruments and apparatus. Establishments
primarily engaged in manufacturing surgical and orthopedic appliances
are classified in industry 3842; those manufacturing electrotherapeutic and
electromedical apparatus are classified in industry 3845; and those
manufacturing X-ray apparatus are classified in industry 3844.

3842  Orthopedic, Prosthetic, and Surgical Appliances and Supplies
Establishments primarily engaged in manufacturing orthopedic, prosthetic,
and surgical appliances and supplies, arch supports and other foot
appliances; fracture appliances, elastic hosiery, abdominal supporters,
braces, and trusses; bandages; surgical gauze and dressings; sutures;
adhesive tapes and medicated plasters; and personal safety appliances and
equipment. Establishments primarily engaged in manufacturing surgical and
medical instruments are classified in industry 3841. Establishments
primarily engaged in manufacturing orthopedic or prosthetic appliances and
in the personal fitting to the individual prescription by a physician are
classified in Retail Trade, industry 5999.

3843  Dental Equipment and Supplies
Establishments primarily engaged in manufacturing artificial teeth, dental
metals, alloys, and amalgams, and a wide variety of equipment, instruments,
and supplies used by dentists, dental laboratories, and dental colleges.
Dental laboratories constructing artificial dentures, bridges, inlays, and
other dental restorations on specifications from dentists are classified in
Services, industry 8072.

3844  X-Ray Apparatus and Tubes and Related Irradiation Apparatus
Establishments primarily engaged in manufacturing radiographic X-ray,
fluoroscopic X-ray, and therapeutic X-ray apparatus and tubes for medical,
industrial, research, and control applications, or in manufacturing other
irradiation equipment, including gamma and beta-ray equipment.

3845  Electromedical and Electrotherapeutic Apparatus
Establishments primarily engaged in manufacturing electromedical and
electrotherapeutic apparatus. Establishments primarily engaged in
manufacturing electrotherapeutic lamp units for ultraviolet and infrared
radiation are classified in industry 3641.

385  OPHTHALMIC GOODS
Establishments primarily engaged in manufacturing ophthalmic frames,
lenses, and sunglass lenses. Establishments primarily engaged in
manufacturing molded glass blanks are classified in industry 3229.
Establishments primarily engaged in grinding lenses and fitting glasses to
prescription are classified in Retail Trade, industry 5995.

3851  Ophthalmic Goods
Establishments primarily engaged in manufacturing ophthalmic frames,
lenses, and sunglass lenses. Establishments primarily engaged in
manufacturing molded glass blanks are classified in industry 3229.
Establishments primarily engaged in grinding lenses and fitting glasses to
prescription are classified in Retail Trade, industry 5995.

386  PHOTOGRAPHIC EQUIPMENT AND SUPPLIES
Establishments primarily engaged in manufacturing: (1) photographic
apparatus, equipment, parts, attachments, and accessories, such as still
and motion picture camera and projection apparatus; photocopy and microfilm
equipment; blueprinting and diazotype (white printing) apparatus and
equipment; and other photographic equipment; and (2) sensitized film,
paper, cloth, and plates, and prepared photographic chemicals for use
therewith. Establishments primarily engaged in manufacturing photographic
paper stock (unsensitized), and paper mats, mounts, easels, and folders for
photographic use, are classified in major group 26; those manufacturing
photographic lenses are classified in industry 3827; those manufacturing
photographic glass are classified in major group 32; those manufacturing
chemicals for technical purposes, not specifically prepared and packaged
for use in photography, are classified in major group 28; and those
manufacturing photographic flash, flood, enlarger, and projection lamp
bulbs are classified in industry 3641.

3861  Photographic Equipment and Supplies
Establishments primarily engaged in manufacturing: (1) photographic
apparatus, equipment, parts, attachments, and accessories, such as still
and motion picture camera and projection apparatus; photocopy and microfilm
equipment; blueprinting and diazotype (white printing) apparatus and
equipment; and other photographic equipment; and (2) sensitized film,
paper, cloth, and plates, and prepared photographic chemicals for use
therewith. Establishments primarily engaged in manufacturing photographic
paper stock (unsensitized), and paper mats, mounts, easels, and folders for
photographic use, are classified in major group 26; those manufacturing
photographic lenses are classified in industry 3827; those manufacturing
photographic glass are classified in major group 32; those manufacturing
chemicals for technical purposes, not specifically prepared and packaged
for use in photography, are classified in major group 28; and those
manufacturing photographic flash, flood, enlarger, and projection lamp
bulbs are classified in industry 3641.

387  WATCHES, CLOCKS, CLOCKWORK OPERATED DEVICES, AND PARTS
Establishments primarily engaged in manufacturing clocks (including
electric), watches, watchcases, mechanisms for clockwork operated devices,
and clock and watch parts. This industry includes establishments primarily
engaged in assembling clocks and watches from purchased movements and
cases. Establishments primarily engaged in manufacturing timeclocks are
classified in industry 3579; those manufacturing glass crystals are
classified in industry 3231; and those manufacturing plastics crystals are
classified in industry 3089.

3873  Watches, Clocks, Clockwork Operated Devices, and Parts
Establishments primarily engaged in manufacturing clocks (including
electric), watches, watchcases, mechanisms for clockwork operated devices,
and clock and watch parts. This industry includes establishments primarily
engaged in assembling clocks and watches from purchased movements and
cases. Establishments primarily engaged in manufacturing timeclocks are
classified in industry 3579; those manufacturing glass crystals are
classified in industry 3231; and those manufacturing plastics crystals are
classified in industry 3089.

=>39  MISCELLANEOUS MANUFACTURING INDUSTRIES
This major group includes establishments primarily engaged in manufacturing
products not classified in any other manufacturing major group. Industries
in this group fall into the following categories: jewelry, silverware, and
plated ware; musical instruments; dolls, toys, games, and sporting and
athletic goods; pens, pencils, and artists' materials; buttons, costume
novelties, miscellaneous notions; brooms and brushes; caskets; and other
miscellaneous manufacturing industries.

391  JEWELRY, SILVERWARE, AND PLATED WARE
This industry group includes establishments primarily engaged in
manufacturing precious metal jewelry; silverware, plated ware, and
stainless steel ware; and jewelers' findings and materials, and lapidary
work.

3911  Jewelry, Precious Metal
Establishments primarily engaged in manufacturing jewelry and other
articles worn on or carried about the person, made of precious metals
(including base metals clad or rolled with precious metals), with or
without stones. Products of this industry include cigarette cases and
lighters, vanity cases and compacts; trimmings for umbrellas and canes; and
jewel settings and mountings. Establishments primarily engaged in
manufacturing costume jewelry from nonprecious metals and other materials
are classified in industry 3961.

3914  Silverware, Plated Ware, and Stainless Steel Ware
Establishments primarily engaged in manufacturing flatware (including
knives, forks, and spoons), hollowware, ecclesiastical ware, trophies,
trays, and related products made of sterling silver; of metal plated
with silver, gold, or other metal; of nickel silver; of pewter; or of
stainless steel. Also included are establishments primarily engaged in
manufacturing table flatware with blades and handles of metal.
Establishments primarily engaged in manufacturing other metal cutlery
are classified in industry 3421, and those manufacturing metal trophies,
trays and toilet ware, other than silver, nickel silver, pewter, stainless
steel, and plated, are classified in industry 3499.

3915  Jewelers' Findings and Materials, and Lapidary Work
Establishments primarily engaged in manufacturing unassembled jewelry parts
and stock shop products, such as sheet, wire, and tubing; and
establishments of lapidaries primarily engaged in cutting, slabbing,
tumbling, carving, engraving, polishing or faceting stones from natural or
manmade precious or semiprecious gem raw materials, either for sale
or on a contract basis for the trade; in recutting, repolishing, and
setting gem stones; or in cutting, drilling, and otherwise preparing jewels
for instruments, dies, watches, chronometers, and other industrial uses.
This industry includes the drilling, sawing, and peeling of real or
cultured pearls. Establishments primarily engaged in manufacturing
synthetic stones for gem stones and industrial use are classified in
industry 3299, and those manufacturing artificial pearls are classified in
industry 3961.

393  MUSICAL INSTRUMENTS
Establishments primarily engaged in manufacturing pianos, with or without
player attachments; organs; other musical instruments; and parts and
accessories for musical instruments.

3931  Musical Instruments
Establishments primarily engaged in manufacturing pianos, with or without
player attachments; organs; other musical instruments; and parts and
accessories for musical instruments.

394  DOLLS, TOYS, GAMES AND SPORTING AND ATHLETIC GOODS
This industry group includes establishments primarily engaged in
manufacturing dolls and stuffed toys; games, toys, and children's vehicles,
except bicycles; and sporting and athletic goods, not elsewhere classified.

3942  Dolls and Stuffed Toys
Establishments primarily engaged in manufacturing dolls, doll parts, and
doll clothing, except doll wigs. Establishments primarily engaged in
manufacturing stuffed toys are also included in this industry. Doll wigs
are classified in industry 3999.

3944  Games, Toys, and Children's Vehicles, Except Dolls and Bicycles
Establishments primarily engaged in manufacturing games and game sets for
adults and children, and mechanical and nonmechanical toys.  Important
products of this industry include games; toy furniture; doll carriages and
carts; construction sets; mechanical trains; toy guns and rifles; baby
carriages and strollers; children's tricycles, coaster wagons, play cars,
sleds, and other children's outdoor wheel goods and vehicles, except
bicycles. Included are establishments primarily engaged in manufacturing
electronic board games; electronic toys; and electronic game machines,
except coin-operated. Establishments primarily engaged in manufacturing
dolls and stuffed toys are classified in industry 3942; those manufacturing
bicycles are classified in industry 3751; those manufacturing sporting and
athletic goods for children and adults are classified in industry 3949;
those manufacturing coin-operated game machines are classified in industry
3999; those manufacturing electronic video game cartridges are classified
in Services, industry 7372; and those manufacturing rubber toys, except
dolls, are classified in industry 3069.

3949  Sporting and Athletic Goods, Not Elsewhere Classified
Establishments primarily engaged in manufacturing sporting and athletic
goods, not elsewhere classified, such as fishing tackle; golf and tennis
goods; baseball, football, basketball, and boxing equipment; roller skates
and ice skates; gymnasium and playground equipment; billiard and pool
tables; and bowling alleys and equipment.  Establishments primarily engaged
in manufacturing athletic apparel are classified in major group 23; those
manufacturing athletic footwear are classified in industries 3021 and 3149;
those manufacturing small arms ammunition are classified in industry 3482;
and those manufacturing small arms are classified in industry 3484.

395  PENS, PENCILS, AND OTHER ARTISTS' MATERIALS
This industry group includes establishments primarily engaged in
manufacturing pens, mechanical pencils, and parts; lead pencils, crayons,
and artists' materials; marking devices; and carbon paper and inked
ribbons.

3951  Pens, Mechanical Pencils, and Parts
Establishments primarily engaged in manufacturing pens (including ball
point pens), refill cartridges, mechanical pencils, fine and broad tipped
markers, and parts.

3952  Lead Pencils, Crayons, and Artists' Materials
Establishments primarily engaged in manufacturing lead pencils, pencil
leads, and crayons; and materials and equipment for artwork, such as
airbrushes, drawing tables and boards, palettes, sketch boxes, pantographs,
artists' colors and waxes, pyrography goods, drawing inks, and drafting
materials. Establishments primarily engaged in manufacturing mechanical
pencils are classified in industry 3951, and those manufacturing drafting
instruments are classified in industry 3829.

3953  Marking Devices
Establishments primarily engaged in manufacturing rubber and metal hand-
stamps, dies, and seals; steel letters and figures; and stencils for use in
painting or marking. Establishments primarily engaged in manufacturing felt
tip markers are classified in industry 3951.

3955  Carbon Paper and Inked Ribbons
Establishments primarily engaged in manufacturing carbon paper; spirit or
gelatin process and other stencil paper; and inked or carbon ribbons for
business machines.

396  COSTUME JEWELRY, COSTUME NOVELTIES, BUTTONS, & MISC NOTIONS, EXCEPT
     PRECIOUS METAL
This industry group includes establishments primarily engaged in
manufacturing costume jewelry and costume novelties, except precious metal;
and fasteners, buttons, needles, and pins.

3961  Costume Jewelry and Costume Novelties, Except Precious Metal
Establishments primarily engaged in manufacturing costume jewelry, costume
novelties, and ornaments made of all materials, except precious metal,
precious or semiprecious stones, and rolled goldplate and gold-filled
materials. Establishments primarily engaged in manufacturing jewelry of
precious and semiprecious metal are classified in 3911; those manufacturing
leather compacts and vanity cases are classified in industry 3172; and
those manufacturing synthetic stones for gem stone and industrial use are
classified in industry 3299.

3965  Fasteners, Buttons, Needles, and Pins
Establishments primarily engaged in manufacturing notions, such as slide
and snap fasteners and zippers, machine and hand needles, pins, hooks and
eyes, buckles, buttons, button parts, and button blanks.  Establishments
primarily engaged in manufacturing these products from precious metals or
from precious or semiprecious stones are classified in industry 3911.

399  MISCELLANEOUS MANUFACTURING INDUSTRIES
This industry group includes establishments primarily engaged in
manufacturing brooms and brushes; signs and advertising specialties; burial
caskets; linoleum, asphalted-felt-base, and other hard surface floor
coverings, not elsewhere classified; and manufacturing industries, not
elsewhere classified.

3991  Brooms and Brushes
Establishments primarily engaged in manufacturing household, industrial,
and street sweeping brooms; and brushes, such as paintbrushes,
toothbrushes, toilet brushes, and household and industrial brushes.

3993  Signs and Advertising Specialties
Establishments primarily engaged in manufacturing electrical, mechanical,
cutout, or plate signs and advertising displays, including neon signs, and
advertising specialties. Sign painting shops doing business on a custom
basis are classified in Services, industry 7389.  Establishments primarily
engaged in manufacturing electric signal equipment are classified in
industry 3669, and those manufacturing commercial lighting fixtures are
classified in industry 3646.

3995  Burial Caskets
Establishments primarily engaged in manufacturing burial caskets and cases,
including shipping cases, of wood or other material except concrete.

3996  Linoleum, Asphalted-Felt-Base, & Other Hard Surface Floor Coverings,
      N.E.C.
Establishments primarily engaged in manufacturing linoleum, asphalted-felt-
base, and other hard surface floor coverings, not elsewhere classified.
Establishments primarily engaged in manufacturing rubber floor coverings
are classified in industry 3069, and those manufacturing cork floor and
wall tile are classified in industry 2499.

3999  Manufacturing Industries, Not Elsewhere Classified
Establishments primarily engaged in manufacturing miscellaneous fabricated
products, including beauty shop and barber shop equipment; hair work;
tobacco pipes and cigarette holders; coin-operated amusement machines;
matches; candles; lamp shades; feathers; artificial trees and flowers made
from all materials, except glass; dressed and dyed furs; umbrellas,
parasols, and canes; and other articles, not elsewhere classified.


9999  All Manufacturing Industries Auxiliary Establishments
Manufacturing requires a wide range of diverse support activities.  These
activities include movement to the manufacturing plant, storage, operation
and maintenance of plant and equipment, design of flow of work through the
production process, and necessary arrangements for shipment of output to
customers.  Also included is a host of subsidiary activities associated
with the operation of an establishment (for example, management and policy
formation, product and market accounting, physical security of the plant
and equipment, etc.)

Support and subsidiary activities may be performed by personnel located at
the manufacturing establishments or at a separate location serving one
manufacturing location or more of the same company.  These separate
locations are referred to as auxilliaries.  Where these activities are
carried on at a differnt physical location or are performed for more than
one plant, they are excluded from the figures for operating manufacturing
establishments and are included in the data shown for auxilliaries.



 
