Description of the Annual Survey of Manufactures and M3 Benchmark Data

=> GENERAL

The estimates for the 1994 Annual Survey of Manufactures are based on
reports from a representative sample of approximately 58,000 manufacturing
establishments and administrative-record information for approximately
170,000 establishments. These estimates represent the portion of the
manufacturing population accounted for by establishments with paid
employees. Nonemployers are defined as out-of-scope of the ASM. The results
of the survey provide estimates for employment, plant hours, payrolls,
value added by manufacture, capital expenditures, cost of materials,
inventories, value of industry shipments, and fuels and electric energy
consumed for most manufacturing industries.  Establishments are classified
in manufacturing industries by industry definitions described in the 1987
edition of the Standard Industrial Classification (SIC) Manual.

=> SCOPE AND USE OF ANNUAL SURVEY

The 1994 ASM is the 37th survey of this type conducted by the Bureau of the
Census to provide the key measures of manufacturing activity for industry
groups and important industries for intercensal years. These key measures,
as well as other detailed statistics for manufacturing, were collected in
the censuses of manufactures; the three most recent censuses covered the
years 1992, 1987, and 1982. An annual survey was conducted for each of the
years between censuses starting with 1949.

During intercensal periods, these annual surveys provide a continuous
series of basic statistics for industries and furnish benchmarks for
current business indicators and for measures of industrial production
and productivity. The survey also provides significant data in connection
with planning for industrial mobilization.

=> DESCRIPTION OF THE SURVEY SAMPLE

In 1992, there were approximately 370,000 individual manufacturing
establishments. For sample efficiency and cost considerations, the 1992
manufacturing population was partitioned into two components for developing
estimates within the ASM; a mail stratum and a nonmail stratum.

-> Mail stratum.

The mail stratum of the survey is comprised of larger single-location
manufacturing companies and all manufacturing establishments of multiunit
companies (companies that operate at more than one physical location).
Approximately 230,000 of the 370,000 establishments in the 1992 census were
assigned to the mail stratum.

On an annual basis, the mail stratum is supplemented with larger, newly
active single-location companies identified from a list provided by the
Internal Revenue Service (IRS) and new manufacturing locations of multiunit
companies identified from the Census Bureau's Company Organization Survey
(COS).

For the 1994 survey, a new sample of approximately 58,000 individual
establishments was selected from the mail stratum assembled from the 1992
census. Supplemental samples representing both 1993 and 1994 births (newly
active establishments that were not included in the 1992 census) were also
selected. Establishments selected for the sample will be mailed an ASM
survey questionnaire for each year through 1998.

The 1994-98 ASM sample design is similar to the one used since 1984.
Companies in the 1992 Census of Manufactures with manufacturing shipments
of at least $500 million were defined as company certainties.  For these
large companies, each manufacturing establishment is included in the mail
sample. For the 1994-98 sample, there are approximately 650 certainty
companies collectively accounting for over 18,000 establishments.

For the remaining portion of the mail component of the survey, the
establishment was defined as the sample unit. All establishments with
250 employees or more were defined as employment certainties. In addition,
all establishments producing products in SIC 3571 (Electronic Computers)
were defined as certainties. Across these three arbitrary certainty
classes, there were approximately 25,000 establishments included in the
sample with certainty. Collectively, these certainty establishments
accounted for approximately 80 percent of the total value of shipments in
the 1992 Census of Manufactures.

Smaller establishments in the remaining portion of the mail stratum were
sampled with probabilities ranging from .02 to 1.00. The initial
probabilities of selection assigned to these establishments were
proportionate to a measure-of-size determined for each establishment.  The
measure-of-size was a function of the establishment's 1992 industry
classification, it's 1992 product class data, and the historical
variability of the year-to-year estimates of the product class estimates.
For each product class (1,755) and four-digit industry (459), a desired
reliability constraint was specified. Using a technique developed by Dr.
James R. Chromy of the Research Triangle Institute, the initial
establishment probabilities were optimized such that the expected sample
satisfied all industry and product class reliability constraints while the
sample size was minimized. This technique reduces the likelihood of
selecting nonrepresentative samples for individual product classes or
industries.

This method of assigning probabilities based on product class shipments is
motivated by our primary desire to produce reliable estimates of both
product class and industry shipments. The high correlation between
shipments and employment, value-added, and other general statistics assures
that these variables will also be well represented by the sample. The
actual sample selectionprocedure uses an independent chance of selection
method (Poisson sampling) which permits us to prevent small establishments
from being selected in consecutive samples without introducing a bias into
the survey estimates.

-> Nonmail component.

The initial nonmail component of the survey was comprised of approximately
140,000 small, single-establishment companies that were tabulated as
administrative records in the 1992 Census of Manufactures. The nonmail
stratum is also supplemented annually using the list of newly active
single-location companies provided by the IRS and payroll cutoffs.
Companies with payroll below the payroll cutoff are added to the nonmail
stratum.

For this portion of the population, sampling is not used. The data for this
group are estimated based on selected information obtained annually from
the administrative records of the IRS and Social Security Administration
(SSA). This administrative information, which includes payroll, total
employment, industry classification, and physical location, is obtained
under conditions which safeguard the confidentiality of both tax and census
records.

=> DESCRIPTION OF THE ESTIMATING PROCEDURE

Most of the ASM estimates derived for the mail stratum are computed using a
difference estimator. At the establishment level, there is a strong
correlation between the current year data values and the corresponding 1992
(base) data values. Therefore, within the mailed stratum, for each item at
each level of aggregation, an estimate of the "difference" between the
current year and the base year is computed from sample cases and added to
the corresponding base year values.  For the 1993-1997 ASM estimates, the
1992 Census of Manufactures values serve as the base year. For the 1998
ASM, the base will be updated to be the 1997 Census of Manufactures.

Due to the positive year-to-year correlation, estimates derived using this
methodology are generally more reliable than comparable estimates developed
from the current sample data alone. Estimates for the capital expenditures
variables are not generated using the difference estimator because the
year-to-year correlations are considerably weaker. The standard linear
estimator is used for these variables.

For the nonmail stratum, estimates for payroll and employment are directly
tabulated from the administrative- record data provided by IRS and SSA.
Estimates of data other than payroll and employment are developed from
industry averages. Although the nonmail stratum contains approximately
170,000 individual establishments in 1994, it accounts for less than 2
percent of the estimate for total value of shipments at the total
manufacturing level.

Corresponding estimates for the mail and nonmail components are combined to
produce the estimates included in this publication.

Call 301-457-4769 with questions regarding the annual survey of
manufactures.
