New;
library maxlik,FSA2;
maxset;
#include c:\gauss\src\Pp1.src;

/* If the data matrix can not be read in a global matrix
{ thetaopt } =
FSA(theta0,&snp,yscale,maxi,bysamp,t0,stt,nriret,pstop,Iret,f1,n,pf);
{Theta0,phi0,grd,cov,retcode} = MAXPRT(maxlik(data,yvar|xvar,&snp,thetaopt));
{ retcode,iret }= PDM(thetaopt,&hesnp,iret,f1,&snp);
*/

disable;

DATA ="JAGGIAI";
OUTFILE = "c:\\GAUSS\\COLIN\\jaggia\\SNP1.OUT";
output file = ^OUTFILE reset;


LET YVAR = NUMBIDS;
LET XVAR = ONE LEGLREST REALREST FINREST WHTKNGHT BIDPREM INSTHOLD
SIZE SIZESQ REGULATN;

PARNM = XVAR|"a1";

SP =0;  @ 0 = Poisson ML initial skattning @
    /* Controll the data generation process */
kp = 1;  @ order of the polynomial @
m = 1;             @ Number of dependent variables @
k = rows(xvar);
nobs = 126;        @ Maximum number of rows to read in dataset @
pstop =  0.00001;    @ Convergence criteria for Newton Raphson and annealing @
nest  = 1;          @ nr of estimations    @

          @ ------------ Annealing parameters ------------- @
Maxi = 250;       @ Maximum number of annealing iterations @
bysamp = 0;       @ Calculate initial Temperature by sampling if 1 @
stt = .1;         @ for the initial calculating of the temperature @
nriret = 5;      @ Number of Anealings, if Hessian is not pd. @
yscale = (ones(k,1)|ones(kp,1));
                @ Scale parameters for the Cauchy density @
         /* Affect the values of the paramaeters in the annealing.
            The larger value the larger variance for the parameter.
            The variance is for a cauchy distribution */

pf     = 0;     @ Pause when printing within iterations (seconds)     @
s = 0;      @ 0 = no printout 1 = printout @

/**************       End Main Program       ****************/

{f1,n,indy,indx} = opendat(data,yvar,xvar,&indices,m);
{nror, rest }    =  rad(nobs,n);

 { y,x } = Readdat(f1,1,nobs,indy,indx);
/* the data are read into memory one time, Nobs must be equal to number of
observations in the data set */

z = y~x;
clear y,x;

output on;
" Dataset                            ";;Data;
" Nr of observations                 ";;n;
" Nr of times data is read           ";;nror;
" Nr of obs. read last chew          ";;rest;
" Maximum nr. of annealings          ";;Maxi;
" Nr of annealing tries if newt fail ";;Nriret;
" Stopping critera                   ";;pstop;
" Dependent variable                 ";;$yvar;
" Parameters (Variables)  ";
$parnm';
"";
" SNP ";;kp;;" estimation";
output off;

          if sp == 0;
/***    Poisson ML is used in calculation of starting values ****/
_mlhsprc = &pohess;  @ analytisk hessian @
_mlgdprc=  &pogrd;   @ analytisk gradient @
_mlditer = 40;
_mlalgr = 5;         @ Newton Raphson = 5 BFGS = 2 (def) @

_mlparnm = xvar;
_mlmiter = 250;
_mlmtime = 1e+5;    @ 1e+5 = default @
_mlcovp = 3;         @ 1 (default) kovariansmatris from the second derivatives @
_mlgtol = pstop;    @ 1e-5 = default @

__output = 2;   @ 0 = inget p skrmen frn ML 2 = default @

start = (0.01*rndn(k,1));
output on;
{bp,phi0,grdp,covp,retcode} = MAXPRT(maxlik(data,yvar|xvar,&polli,start));
         endif;

                @-----------------------@


ki = 1;
bsnp = zeros(k+kp,nest);
covsnp= zeros(k+kp,nest);

    do while ki <= nest;
T0 =    0.5;          @ Initial Temperatur @

NEWS:
Iret = 0;         @ deflating the temeratur with nr of iterations. 0 in start @
theta0 =  (bp|0) + ((rndn(k,1))|(rndn(kp,1)));
output on;
"";
"iteration   ";;ki;
"Starting Values ";
theta0';
"";
output off;

FSAITER:

{ thetaopt } =
FSA(theta0,&snp,yscale,maxi,bysamp,t0,stt,nriret,pstop,Iret,z,n,pf,s);

 if sumc(thetaopt) == 0;
    goto NEWS;
    endif;

    if iret <= nriret;
{ retcode,iret }= PDM(thetaopt,&hesnp,iret,z,&snp,0);
        if retcode == 1;
        theta0 = thetaopt;
        goto fsaiter;        @ non-negative hessian @
        elseif retcode == 0;
        goto maxl;
         endif;
    elseif iret == nriret+1;
output on;
"";
"Parameter Values after annealing step ";
thetaopt';
"";
output off;

MAXl:
_mlhsprc = &hesnp;  @ analytisk hessian @
_mlgdprc=  &grdsnp;   @ analytisk gradient @
/*
_mlstmth = "BFGS STEPBT EYE";
_mlmdmth = "BFGS";
_mlndmth = "Newton";
_mlditer = 40;
*/
_mlalgr = 2;         @ Newton Raphson = 5 BFGS = 2 (def) @
_mlcovp = 3;         @ 1 (default) kovariansmatris from the second derivatives @

_mlparnm = parnm;
_mlmiter = 250;
_mlmtime = 1e+5;    @ 1e+5 = default @
_mlgtol = pstop;    @ 1e-5 = default @
_mlparnm = parnm;

__output = 2;   @ 0 = inget p skrmen frn ML 2 = default @

output on;
{Theta0,phi0,grd,cov,retcode} = MAXPRT(maxlik(z,0,&snp,thetaopt));
output off;

        if ki==1;
y = seekr(f1,1);
lngy =0;
        do until eof(f1);
    z = readr(f1,nobs);
    y = z[.,indy];
lngy = lngy -sumc(ln(gamma(y+1)));
        endo;
    endif;

Output On;
"Phiopt ";
Phi0;
logl = n*phi0 +lngy;
"";
"loglikelihood SNP ";;
logl;
"";
    endif;
/* The expectation, variance, Ratio, calculaded and empirical
distribution for the SNP estimator */

{ E, V, R, psnp, f } = mvrp(theta0,indy,indx,f1,nobs);
"";
qas=cumsumc(f~psnp);
"The empirical and estimated distribution ";
qas
"";
"Mean Expectition, variance and ration ";
E~V~R;

/* The derivative with respect to x, for the SNP1 estimator */
{ Sb } = Marg(Theta0,indy,indx,f1,nobs);
" The mean Marginal effect of the differnt x's ";
"";
(Sb./n)';
"";

p = rows(indx);
b = theta0[1:p];
a = theta0[p+1];
x= z[.,indx];
l = exp(x*b);
m2 = l.*(1+l);

hn = 1 + 2.*a.*l +(a^2).*m2;
"meanc(eta)";meanc(hn);

output off;
bsnp[.,ki] = theta0;
    ki = ki+1;
endo;
f1 = close(f1);
