%% Solve the Iacoviello 2005 model using Dynare. Then store results.

%----------------------------------------------------------------
% 0. Housekeeping
%----------------------------------------------------------------

close all
clear all

addpath C:\dynare\4.2.2\matlab
nsimul = 500

%----------------------------------------------------------------
% 0. Solve Model
%----------------------------------------------------------------
nv = 4;  %Variables for IRFs
H  = 40; % Periods for IRFs

% Writing Simulations options in Simulation.mod
fid=fopen('Simulation.mod','w');
fprintf(fid,'%s\n',['options_.simul=',int2str(0),';']);
fclose(fid);

% Writing calibration in Parameterization.mod
fid=fopen('Parameterization.mod','w');
fprintf(fid,'%s\n','rpi = 3;');
fprintf(fid,'%s\n','sigmaj = 0.2489;');
fclose(fid);

i_var_str_irfs = char('Output','Inflation','Interest Rate','House Prices');

dynare iacoviello_small.mod noclearall

% Store IRFs to Fringe Capacity Shock (Omega in N.P.)
% scalef      = 1/(50*oo_.irfs.qhat_ejhat(1));
scalef      = 1;
IRFsq       = zeros(nv,H);
IRFsq(1,:)  = 100*oo_.irfs.Yhat_ejhat*scalef;
IRFsq(2,:)  = 400*oo_.irfs.pihat_ejhat*scalef;
IRFsq(3,:)  = 400*oo_.irfs.Rhat_ejhat*scalef;
IRFsq(4,:)  = 100*oo_.irfs.qhat_ejhat*scalef;

% Writing alternative calibration in Parameterization.mod
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Writing calibration in Parameterization.mod
fid=fopen('Parameterization.mod','w');
fprintf(fid,'%s\n','rpi = 2.25;');
fprintf(fid,'%s\n','sigmaj = 0.2489;');
fclose(fid);

dynare iacoviello_small.mod noclearall
IRFsqalt1       = zeros(nv,H);
IRFsqalt1(1,:)  = 100*oo_.irfs.Yhat_ejhat*scalef;
IRFsqalt1(2,:)  = 400*oo_.irfs.pihat_ejhat*scalef;
IRFsqalt1(3,:)  = 400*oo_.irfs.Rhat_ejhat*scalef;
IRFsqalt1(4,:)  = 100*oo_.irfs.qhat_ejhat*scalef;

% Writing alternative calibration in Parameterization.mod
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Writing calibration in Parameterization.mod
fid=fopen('Parameterization.mod','w');
fprintf(fid,'%s\n','rpi = 1.5;');
fprintf(fid,'%s\n','sigmaj = 0.2489;');
fclose(fid);

dynare iacoviello_small.mod noclearall
IRFsqalt2       = zeros(nv,H);
IRFsqalt2(1,:)  = 100*oo_.irfs.Yhat_ejhat*scalef;
IRFsqalt2(2,:)  = 400*oo_.irfs.pihat_ejhat*scalef;
IRFsqalt2(3,:)  = 400*oo_.irfs.Rhat_ejhat*scalef;
IRFsqalt2(4,:)  = 100*oo_.irfs.qhat_ejhat*scalef;

% Plot IRFs for different calibrations
name_fig    = 'Figure2';
shock_name  = 'House Preference Shock';
pplot_irfs_alt(IRFsq,IRFsqalt1,i_var_str_irfs,path_root,name_fig,shock_name,graph_opt,IRFsqalt2)

save IRFs_true IRFsq IRFsqalt1 IRFsqalt2

%% Writing Simulations options in Simulation.mod
fid=fopen('Simulation.mod','w');
fprintf(fid,'%s\n',['options_.simul=',int2str(nsimul),';']);
fclose(fid);

fid=fopen('Parameterization.mod','w');
fprintf(fid,'%s\n','rpi = 3;');
fprintf(fid,'%s\n','sigmaj = 0.2489;');
fclose(fid);

dynare iacoviello_small.mod noclearall

burn = 0;
i_var_str = char('Rhat','pihat','qhat','hhat','Yhat','chat','c1hat','bhat');  
[check,i_var] = ismember(i_var_str,M_.endo_names,'rows');
nobs = size(oo_.endo_simul,2);
Rhat =  oo_.endo_simul(i_var(1),round(nobs*burn)+1:end)';
pihat =  oo_.endo_simul(i_var(2),round(nobs*burn)+1:end)';
qhat =  oo_.endo_simul(i_var(3),round(nobs*burn)+1:end)';
hhat =  oo_.endo_simul(i_var(4),round(nobs*burn)+1:end)';
Yhat = oo_.endo_simul(i_var(5),round(nobs*burn)+1:end)';
chat = oo_.endo_simul(i_var(6),round(nobs*burn)+1:end)';
c1hat = oo_.endo_simul(i_var(7),round(nobs*burn)+1:end)';
bhat = oo_.endo_simul(i_var(8),round(nobs*burn)+1:end)';
% 
% save simuldataIaco.mat Rhat pihat ...
%     qhat hhat Yhat chat c1hat bhat