//% This is a model for analyzing the transmission mechanism with emphasis 
//% on the credit channels and the role of house prices along the line of 
//% Iacoviello (AER, 2005).

//% The basic model


//% Declaration of endogenous variable
Var 
//% basic endogeneous variables
Yhat, 
chat,
c1hat,
Xhat,
qhat,
hhat,
pihat,
Rhat,
bhat,

//% Defined variable(s)
rrhat,

//% Endogenous variables with exogenous dynamics

jhat,
Ahat,
uhat;

//% Declaration of exogeneous variables (shocks)
Varexo
ejhat,
euhat,
eAhat,
eRhat;


parameters
//% deep parameters
beta,
gamma,
j,
eta,
ypsilon,
X,
theta,
m,
rhou,
rhoj,
rhoA,
sigmau,
sigmaj,
sigmaA,
sigmaR,
rR,
rpi,
rY;

@# include "Parameterization.mod"
//% Setting of numerical values for parameters
beta = 0.99;  //patient households discount rate
gamma = 0.98; //entrepreneurs' discount rate
j = 0.1;      //weight on housing in the utility function for unconstrained
eta = 1.01;  //inverse of labou supply elasticity
ypsilon = 0.03; // ELASTICITY OF GDP TO REAL ESTATE
X = 1.05;    //markup
theta = 0.75; //probability of not changing prices
m = 0.89;    // loand to value rate
rhou = 0.59;  //AR coefficient for u shock
rhoj = 0.85;  //AR coefficient for j shock
rhoA = 0.5;  //AR coefficient for A shock
sigmau = 0.0015; //sd for u shock
sigmaA = 0.0274;  //sd for A shock
sigmaR = 0.0029;  //sd for R shock
rR = 0.6;  //Monetary policy rule
rY = 0.5;//Monetary policy rule

//% Model equations
model;

# gammae = (1-m)*gamma + m*beta;
# kappa = (1-theta)*(1-beta*theta)/theta; //PC curve
# ctoY = ypsilon*(1-gamma)*(1-beta*m)/(1-gammae)/X;
# c1toY= (X-ypsilon+gamma*ypsilon*(1-beta)*m/(1-gammae))/X;
# qhtoY = gamma*ypsilon/(X*(1-gammae));
# btoY = beta*m*qhtoY;
# s1 = ypsilon/X;
# R = 1/beta;
# hH=gamma*ypsilon*(1-beta)/(gamma*ypsilon*(1-beta)+j*((X-ypsilon)*(1-gammae)+gamma*ypsilon*(1-beta)*m));
# Htoh=1/hH;
# inv_i=Htoh-1;
# i=1/inv_i;

Yhat = ctoY*chat+c1toY*c1hat;

c1hat = c1hat(+1)-rrhat;

btoY*bhat = ctoY*chat+qhtoY*(hhat-hhat(-1))+R*btoY*(Rhat(-1)+bhat(-1)-pihat)-s1*(Yhat-Xhat); 

qhat = gammae*qhat(+1)+(1-gammae)*(Yhat(+1)-Xhat(+1)-hhat)-m*beta*rrhat-(1-m*beta)*(chat(+1)-chat);

bhat = qhat(+1)+hhat-rrhat;

Yhat = eta*(Ahat+ypsilon*hhat(-1))/(eta-(1-ypsilon))-(1-ypsilon)*(Xhat+c1hat)/(eta-(1-ypsilon));

qhat = beta*qhat(+1)+(1-beta)*jhat+(1-beta)*i*hhat+c1hat-beta*c1hat(+1);

pihat = beta*pihat(+1)-kappa*Xhat+uhat;

Rhat = (1-rR)*rpi*pihat+rY*(1-rR)*Yhat+rR*Rhat(-1)+eRhat;

//% Defined variable(s)
rrhat = Rhat-pihat(+1);

//% equations for variables with exogenous AR(1)-dynamics
jhat = rhoj*jhat(-1)+ejhat; //housing shock
uhat = rhou*uhat(-1)+euhat; //markup shock
Ahat = rhoA*Ahat(-1)+eAhat; //productivity shock
end;                        //% End of model block


//% caluclulation of steady state


steady;

check;


shocks;
var eRhat;
stderr sigmaR;
var euhat;
stderr sigmau;
var ejhat;
stderr sigmaj;
var eAhat;
stderr sigmaA;
end;

@# include "Simulation.mod"

if options_.simul == 1
    //stoch_simul(PERIODS = 50000, nograph, irf = 0, order = 1, drop = 0) 
    //            Rhat pihat qhat hhat Yhat chat c1hat bhat Xhat;
    stoch_simul;
elseif options_.simul == 0
    stoch_simul(PERIODS = 0, irf = 40, print, graph, nomoments, order = 1)
                Rhat pihat qhat Yhat;
end
