//% This is the augmented policy model with unobserved factors.


//% Declaration of endogenous variable
Var 
//% basic endogeneous variables
Yhat,
c1hat,
Xhat,
pihat,
Rhat,

//% Defined variable(s)
rrhat,

//% Endogenous variables with exogenous dynamics
Ahat,
uhat
qhat
uhat_tilde
Ahat_tilde
Rhat_tilde
ufactor
Afactor
Rfactor
f1
f2;

//% Declaration of exogeneous variables (shocks)
Varexo
euhat,
eAhat,
eRhat,
eqhat;

parameters
//% deep parameters
beta,
gamma,
eta,
X,
theta,
rhou,
rhoA,
sigmau,
sigmaA,
sigmaR,
sigmaq,
rR,
rpi,
rY,
lambdau,
lambdaA,
lambdaR,
lambdau2,
lambdaA2,
lambdaR2,
rhoq1,
rhoq2,
Xi11,
Xi12
phi11
phi12
phi21
phi22;


//kappa;
//R;


//% Setting of numerical values for parameters
beta = 0.99;  //patient households discount rate
gamma = 0.98; //entrepreneurs' discount rate
eta = 1.01;  //inverse of labour supply elasticity
X = 1.05;    //markup
theta = 0.87; //probability of not changing prices
rhou = 0.47;  //AR coefficient for u shock
rhoA = 0.80;  //AR coefficient for A shock
sigmau = 0.23; //sd for u shock
sigmaA = 0.20;  //sd for A shock
sigmaR = 0.28;  //sd for R shock
sigmaq = 0.2;

rR = 0.62;  //Monetary policy rule
rpi = 2.90;//Monetary policy rule
rY = 0.46;//Monetary policy rule
lambdau = 0;
lambdaA = 0;
lambdaR = 1;
lambdau2 = 0;
lambdaA2 = 1;
lambdaR2 = 0;

rhoq1 = 0.82;
rhoq2 = 0;
phi11 = 1.07;
phi12 = 0.41;
phi21 = -0.11;
phi22 = 0.72;
Xi11 = -2.64571988083457e-006;
Xi12 = -1.45171659894066e-006;


//% Model equations
model;

# kappa = (1-theta)*(1-beta*theta)/theta; //PC curve
# R = 1/beta;

Yhat = c1hat;

c1hat = c1hat(+1)-rrhat;

Yhat = Ahat_tilde-(Xhat+c1hat)/eta;

pihat = beta*pihat(+1)+kappa*(-eta*Ahat_tilde+eta*Yhat)+uhat_tilde;

Rhat = (1-rR)*rpi*pihat+rY*(1-rR)*Yhat+rR*Rhat(-1)+Rhat_tilde;

//% Defined variable(s)
rrhat = Rhat-pihat(+1);

//% equations for variables with exogenous AR(1)-dynamics

ufactor = lambdau*f1 + lambdau2*f2;
Afactor = lambdaA*f1 + lambdaA2*f2;
Rfactor = lambdaR*f1 + lambdaR2*f2;


Rhat_tilde = (sigmaR/100)*eRhat + (sigmaR/sigmaq)*Rfactor;
uhat_tilde = uhat + (sigmau/sigmaq)*ufactor;
Ahat_tilde = Ahat + (sigmaA/sigmaq)*Afactor;

uhat = rhou*uhat(-1)+(sigmau/100)*euhat; //markup shock
Ahat = rhoA*Ahat(-1)+ (sigmaA/100)*eAhat; //productivity shock
qhat = rhoq1*(1-rhoq2)*qhat(-1)+rhoq2*qhat(-2)+(sigmaq/100)*eqhat; //housing shock

f1 = phi11*f1(-1) + phi12*f2(-1) + Xi11/100*eqhat;
f2 = phi21*f1(-1) + phi22*f2(-1) + Xi12/100*eqhat;

end; 
//% End of model block

//% calculation of steady state

steady;

shocks;
var eRhat    = 1;
var euhat    = 1;
var eAhat    = 1;
var eqhat    = 1;
end;

estimated_params;

/*
theta, BETA_PDF, 0.5, 0.2;
rR, BETA_PDF, 0.5, 0.1;
rpi, NORMAL_PDF, 2.5, 0.4;
rY, NORMAL_PDF, 0.5, 0.1;
rhou, BETA_PDF, 0.5, 0.2;
rhoA, BETA_PDF, 0.5, 0.2;
*/

lambdau, NORMAL_PDF, 0.0, 2;
lambdau2, NORMAL_PDF, 0.0, 2;
rhoq1, BETA_PDF, 0.5, 0.1;
sigmau, INV_GAMMA_PDF, 0.5, 2;
sigmaA, INV_GAMMA_PDF, 0.5, 2;
sigmaR, INV_GAMMA_PDF, 0.5, 2;
sigmaq, INV_GAMMA_PDF, 0.5, 2;
Xi11, NORMAL_PDF, 0.0, 1;
Xi12, NORMAL_PDF, 0.0, 1;
phi11, NORMAL_PDF, 0.80, 0.5;
phi12, NORMAL_PDF, 0.00, 0.2;
phi21, NORMAL_PDF, 0.00, 0.2;
phi22, NORMAL_PDF, 0.80, 0.5;
end;

%----------------------------------------------------------------
% 1. Observable variables
%----------------------------------------------------------------

varobs Yhat Rhat pihat qhat;

estimation(datafile=simuldataIaco, nobs=500, mh_replic=300000, mh_nblocks=1,
            mh_drop = 0.1, mh_jscale =0.3, mode_compute=4,order=1,moments_varendo,
            bayesian_irf, irf = 20) Yhat Rhat pihat rrhat uhat Ahat qhat Afactor ufactor Rfactor;


