//% This is the augmented policy model without unobserved factors.

//% Declaration of endogenous variable
Var 
//% basic endogeneous variables
Yhat,
c1hat,
Xhat,
pihat,
Rhat,

//% Defined variable(s)
rrhat,

//% Endogenous variables with exogenous dynamics
Ahat,
uhat
qhat
uhat_tilde
Ahat_tilde
Rhat_tilde;

//% Declaration of exogeneous variables (shocks)
Varexo
euhat,
eAhat,
eRhat,
eqhat;

parameters
//% deep parameters
beta,
gamma,
eta,
X,
theta,
rhou,
rhoA,
rhoq,
sigmau,
sigmaA,
sigmaR,
sigmaq,
rR,
rpi,
rY,
lambdau,
lambdaA,
lambdaR;


//% Setting of numerical values for parameters
beta = 0.99;  //patient households discount rate
gamma = 0.98; //entrepreneurs' discount rate
eta = 1.01;  //inverse of labour supply elasticity
X = 1.05;    //markup
theta = 0.90; //probability of not changing prices
rhou = 0.44;  //AR coefficient for u shock
rhoA = 0.80;  //AR coefficient for A shock
rhoq = 0.8;
sigmau = 0.2506; //sd for u shock
sigmaA = 0.262;  //sd for A shock
sigmaR = 0.2849;  //sd for R shock
//sigmaq = 0.2;
sigmaq = 1;
rR = 0.63;  //Monetary policy rule
rpi = 2.93;//Monetary policy rule
rY = 0.46;//Monetary policy rule
lambdau = 0;
lambdaA = 0;
lambdaR = 0;

//% Model equations
model;

# kappa = (1-theta)*(1-beta*theta)/theta; //PC curve
# R = 1/beta;

Yhat = c1hat;

c1hat = c1hat(+1)-rrhat;

Yhat = Ahat_tilde-(Xhat+c1hat)/eta;

pihat = beta*pihat(+1)+kappa*(-eta*Ahat_tilde+eta*Yhat)+uhat_tilde;

Rhat = (1-rR)*rpi*pihat+rY*(1-rR)*Yhat+rR*Rhat(-1)+Rhat_tilde;

//% Defined variable(s)
rrhat = Rhat-pihat(+1);

//% equations for variables with exogenous AR(1)-dynamics
Rhat_tilde = (sigmaR/100)*eRhat + lambdaR*(sigmaR/sigmaq)*qhat;
uhat_tilde = uhat + lambdau*(sigmau/sigmaq)*qhat;
Ahat_tilde = Ahat + lambdaA*(sigmaA/sigmaq)*qhat;

uhat = rhou*uhat(-1)+(sigmau/100)*euhat; //markup shock
Ahat = rhoA*Ahat(-1)+ (sigmaA/100)*eAhat; //productivity shock
qhat = rhoq*qhat(-1)+(sigmaq/100)*eqhat; //markup shock
end;                        //% End of model block


//% calculation of steady state


steady;

shocks;
var eRhat    = 1;
var euhat    = 1;
var eAhat    = 1;
var eqhat    = 1;
end;

estimated_params;

/*
theta, BETA_PDF, 0.5, 0.2;
rR, BETA_PDF, 0.5, 0.1;
rpi, NORMAL_PDF, 2.5, 0.4;
rY, NORMAL_PDF, 0.5, 0.1;
rhou, BETA_PDF, 0.5, 0.2;
rhoA, BETA_PDF, 0.5, 0.2;
*/

lambdaA, NORMAL_PDF, 0.0, 1;
lambdau, NORMAL_PDF, 0.0, 1;
lambdaR, NORMAL_PDF, 0.0, 1;

rhoq, BETA_PDF, 0.6, 0.2;

sigmau, INV_GAMMA_PDF, 0.5, 2;
sigmaA, INV_GAMMA_PDF, 0.5, 2;
sigmaR, INV_GAMMA_PDF, 0.5, 2;
sigmaq, INV_GAMMA_PDF, 0.5, 2;
end;

%----------------------------------------------------------------
% 1. Observable variables
%----------------------------------------------------------------

varobs Yhat Rhat pihat qhat;

estimation(datafile=simuldataIaco, nobs=500, mh_replic=300000, mh_nblocks=1,
            mh_drop = 0.2, mh_jscale =0.7, mode_compute=4,order=1,moments_varendo,
            bayesian_irf, irf = 40) Yhat Rhat pihat rrhat uhat Ahat qhat;


