//% This is the  model in iacoviello_small.mod with no housing sector.

//% Declaration of endogenous variable
Var 
//% basic endogeneous variables
Yhat, 
c1hat,
pihat,
Rhat,

//% Defined variable(s)
rrhat,

//% Endogenous variables with exogenous dynamics
Ahat,
uhat;

//% Declaration of exogeneous variables (shocks)
Varexo
euhat,
eAhat,
eRhat;

parameters
//% deep parameters
beta,
gamma,
eta,
X,
theta,
rhou,
rhoA,
sigmau,
sigmaA,
sigmaR,
rR,
rpi,
rY;

//% Setting of numerical values for parameters
beta = 0.99;  //patient households discount rate
gamma = 0.98; //entrepreneurs' discount rate
eta = 1.01;  //inverse of labour supply elasticity
X = 1.05;    //markup
theta = 0.75; //probability of not changing prices
rhou = 0.59;  //AR coefficient for u shock
rhoA = 0.5;  //AR coefficient for A shock
sigmau = 0.017; //sd for u shock
sigmaA = 0.224;  //sd for A shock
sigmaR = 0.0029;  //sd for R shock
rR = 0.6;  //Monetary policy rule
rpi = 3.5;//Monetary policy rule
rY = 0.5;//Monetary policy rule

//% Model equations
model;

# kappa = (1-theta)*(1-beta*theta)/theta; //PC curve
# R = 1/beta;

Yhat = c1hat;

c1hat = c1hat(+1)-rrhat;

pihat = beta*pihat(+1)+kappa*(-eta*Ahat+eta*Yhat)+uhat;

Rhat = (1-rR)*rpi*pihat+rY*(1-rR)*Yhat+rR*Rhat(-1)+(sigmaR/100)*eRhat;

//% Defined variable(s)
rrhat = Rhat-pihat(+1);

//% equations for variables with exogenous AR(1)-dynamics
uhat = rhou*uhat(-1)+(sigmau/100)*euhat; //markup shock
Ahat = rhoA*Ahat(-1)+ (sigmaA/10)*eAhat; //productivity shock
end;                        //% End of model block


//% calculation of steady state


steady;

shocks;
var eRhat    = 1;
var euhat    = 1;
var eAhat    = 1;
end;

estimated_params;

theta, BETA_PDF, 0.55, 0.2;

rR, BETA_PDF, 0.5, 0.1;
rpi, NORMAL_PDF, 3, 0.2;
rY, NORMAL_PDF, 0.4, 0.2;

rhou, BETA_PDF, 0.5, 0.2;
rhoA, BETA_PDF, 0.5, 0.2;

sigmau, INV_GAMMA_PDF, 0.5, 2;
sigmaA, INV_GAMMA_PDF, 0.5, 2;
sigmaR, INV_GAMMA_PDF, 0.5, 2;
end;

%----------------------------------------------------------------
% 1. Observable variables
%----------------------------------------------------------------

varobs Yhat Rhat pihat;

estimation(datafile=simuldataIaco, nobs=500, mh_replic=100000, mh_nblocks=2,
            mh_drop = 0.2, mh_jscale =0.45, mode_compute=4,order=1,moments_varendo,
            bayesian_irf, irf = 20) Yhat Rhat pihat rrhat uhat Ahat;


