var y, rr_e, pi, a, mko, i, ye, yl y_g;

varexo ea, emko, er;

parameters   teta, psi, beta, epsilon, s_k, s_l, miu,
             fi_i, fi_pi, fi_y, 
             ro_a, ro_mko, stderrea, stderremko, stderrer;

% Fixed Parameters


beta        = 0.9926;               //discount factor
epsilon     = 7.66;                 //elasticity of substitution between varieties
miu         = epsilon/(epsilon-1);  //markup
s_k         = 0.63;                 //capital elasticity of gross output
s_l         = 1-s_k;                //labour elasticity of gross output

% Calibration EJ Subsample 2
%%%%%%%%%%%%%%%%%%%%%%%%%%%%

teta        = 0.447;                //Calvo parameter (frequency of price adjustment)
psi         = 1.009;                //inverse of Frisch elasticity of labour supply

fi_i        = 0.691;                //smoothing parameter Taylor rule
fi_pi       = 3;                  //Short-run inflation coefficient Taylor Rule
fi_y        = 0.5385;                 //Short-run output gap coefficient Taylor Rule

ro_a        = 0.9829;
ro_mko      = 0.9;

stderrea    = 0.62;
stderremko  = 0.26;
stderrer    = 0.212;


model(linear);

# lambda      =(1+psi)*(1-teta)*(1-beta*teta)/(s_l*teta);
//IS curve
y    = y(+1) - (i - pi(+1) - rr_e);

//efficient real interest rate
rr_e = - (1 - ro_a)*a;

//Phillips curve
pi   = beta*pi(+1)+ lambda*(y + mko);

//monetary policy
i    =fi_i*i(-1) + (1-fi_i)*(fi_pi*pi + fi_y*y) + stderrer/100*er;

//AR processes of shocks

// TFP
a    =ro_a*a(-1) + stderrea/100*ea;

// Maruk-up shock
mko    =ro_mko*mko(-1) - stderremko/1000*emko;

//efficient output
ye   =a;

//level of output
yl   = y + ye;

// output growth

y_g = yl - yl(-1);

end;

shocks;
var ea    = 1;
var emko  = 1;
var er    = 1;
end;

%----------------------------------------------------------------
% 1. Declare Priors
%----------------------------------------------------------------
estimated_params;

teta , BETA_PDF, 0.5, 0.2;

psi, GAMMA_PDF, 1, 0.25;

fi_i, BETA_PDF, 0.5, 0.2;
fi_pi, NORMAL_PDF, 2, 0.5;
fi_y, NORMAL_PDF, 0.4, 0.1;

ro_a, BETA_PDF, 0.5, 0.2;
ro_mko, BETA_PDF, 0.5, 0.2;

stderrea, INV_GAMMA_PDF, 0.5, 4;
stderremko, INV_GAMMA_PDF, 0.5, 4;
stderrer, INV_GAMMA_PDF, 0.5, 4;
end;

%----------------------------------------------------------------
% 1. Observable variables
%----------------------------------------------------------------

varobs y_g pi i;

estimation(datafile=simuldataNakovZonly, nobs=500, mh_replic=100000, mh_nblocks=2,
            mh_drop = 0.2, mh_jscale =0.5, mode_compute=4,order=1,moments_varendo,
            bayesian_irf, irf = 20) y y_g pi i mko;
/*
estimation(mode_file = policy_model_est_mode, mode_compute = 0, datafile=simuldataNakov480, mh_replic=0, mh_nblocks=1,
           load_mh_file);

conditional_forecast_paths;
var b;
periods 1:2;
values 0.0004;
end;
conditional_forecast(parameter_set = posterior_mode, controlled_varexo = (eb), replic = 3000);
plot_conditional_forecast(periods=20) y yl pi i;

*/