var y, rr_e, pi, a, mko, i, ye, yl y_g po_g po 
            r mkotilde atilde rtilde;

varexo ea, emko, er, epo;

parameters   teta, psi, beta, epsilon, s_k, s_l, miu,
             fi_i, fi_pi, fi_y, 
             ro_a, ro_mko, stderrea, stderreb, stderremko, stderrer
             ro_po stderrepo LAMBDA1, LAMBDA2 LAMBDA3;

% Fixed Parameters


beta        = 0.9926;               //discount factor
epsilon     = 7.66;                 //elasticity of substitution between varieties
miu         = epsilon/(epsilon-1);  //markup
s_k         = 0.63;                 //capital elasticity of gross output
s_l         = 1-s_k;                //labour elasticity of gross output

% Calibration EJ Subsample 2
%%%%%%%%%%%%%%%%%%%%%%%%%%%%

teta        = 0.58;                //Calvo parameter (frequency of price adjustment)
psi         = 0.98;                //inverse of Frisch elasticity of labour supply

fi_i        = 0.69;                //smoothing parameter Taylor rule
fi_pi       = 2.84;                  //Short-run inflation coefficient Taylor Rule
fi_y        = 0.31;                 //Short-run output gap coefficient Taylor Rule

ro_a        = 0.9825;
ro_mko      = 0.9202;
//ro_po      = 0.8;
//ro_po      = 0.8814;
ro_po      = 0.8619;

stderrea    = 0.86;
stderremko  = 0.3937;
stderrer    = 0.21;
stderrepo    = 1;
stderrepo    = 0.2166;
LAMBDA1 = 0;
LAMBDA2 = 0;
LAMBDA3 = 0;

//LAMBDA1 = 0.075606;
//LAMBDA2 = 4.949/100;
//LAMBDA3 = 1.0033;

//LAMBDA1 = -0.0138;
//LAMBDA2 = -0.0406;
//LAMBDA3 = 1.0033/10;


model(linear);

# lambda      =(1+psi)*(1-teta)*(1-beta*teta)/(s_l*teta);
//IS curve
y    = y(+1) - (i - pi(+1) - rr_e);

//efficient real interest rate

rr_e = atilde(+1) - atilde;

//Phillips curve
pi   = beta*pi(+1)+ lambda*(y + mkotilde);

//monetary policy
i    =fi_i*i(-1) + (1-fi_i)*(fi_pi*pi + fi_y*y) + rtilde;

//AR processes of shocks

// TFP
a    =ro_a*a(-1) + stderrea/100*ea;

// Maruk-up shock
mko    =ro_mko*mko(-1) - stderremko/1000*emko;

// Monetary Shock

r =  stderrer/100*er;

// oil prices
po   = ro_po*po(-1) + stderrepo*epo;

mkotilde = mko + LAMBDA1*(stderremko/(stderrepo*1000))*po;
atilde = a + LAMBDA2*(stderrea/(stderrepo*100))*po;
rtilde = r + LAMBDA3*(stderrer/(stderrepo*100))*po;

/*
mkotilde = mko + LAMBDA1*po;
atilde = a + LAMBDA2*po;
rtilde = r + LAMBDA3*(stderrer/(stderrepo*100))*po;
*/

//efficient output
ye   =atilde;

//level of output
yl   = y + ye;

// output growth

y_g = yl - yl(-1);

// oil price growth
po_g = po - po(-1);


end;

shocks;
var ea    = 1;
var emko  = 1;
var er    = 1;
var epo   = 1;

end;

%----------------------------------------------------------------
% 1. Declare Priors
%----------------------------------------------------------------
estimated_params;
/*
teta , BETA_PDF, 0.5, 0.2;

psi, GAMMA_PDF, 1, 0.25;

fi_i, BETA_PDF, 0.5, 0.2;
fi_pi, NORMAL_PDF, 2, 0.5;
fi_y, NORMAL_PDF, 0.4, 0.1;

ro_a, BETA_PDF, 0.5, 0.2;
ro_mko, BETA_PDF, 0.5, 0.2;

*/

LAMBDA1, NORMAL_PDF, 0.0, 1.0;
LAMBDA2, NORMAL_PDF, 0.0, 1.0;
LAMBDA3, NORMAL_PDF, 0.0, 1.0;

ro_po, BETA_PDF, 0.5, 0.2;
stderrepo, INV_GAMMA_PDF, 0.5, 4;

stderrea, INV_GAMMA_PDF, 0.5, 4;
stderremko, INV_GAMMA_PDF, 0.5, 4;
stderrer, INV_GAMMA_PDF, 0.5, 4;
end;

%----------------------------------------------------------------
% 1. Observable variables
%----------------------------------------------------------------

varobs y_g pi i po_g;

@# include "Estimation.mod"

if options_.estim == 1
    estimation(datafile=simuldataNakovZonlyME, nobs=500, mh_replic=200000, mh_nblocks=1,
            mh_drop = 0.2, mh_jscale =0.5, mode_compute=4,order=1,moments_varendo,
            bayesian_irf, irf = 40) y y_g pi i mko po yl;

elseif options_.estim == 0

    estimation(mode_file = policy_model_augZ_mode, mode_compute = 0, datafile=simuldataNakovZonly, mh_replic=0, mh_nblocks=1,
           load_mh_file);

    conditional_forecast_paths;
    var r;
    periods 1:2;
    values 0.4508;
    end;
    conditional_forecast(parameter_set = posterior_mode, controlled_varexo = (epo), replic = 3000);
    plot_conditional_forecast(periods=20) y yl pi i;
end