%% Solve the Nakov Pescatori Model in Dynare. Then store results.

%----------------------------------------------------------------
% 0. Housekeeping
%----------------------------------------------------------------

close all
clear all

addpath C:\dynare\4.2.2\matlab

%----------------------------------------------------------------
% 0. Solve Model
%----------------------------------------------------------------
nv = 6;  %Variables for IRFs
H  = 40; % Periods for IRFs

% Writing Simulations options in Simulation.mod
fid=fopen('Simulation.mod','w');
fprintf(fid,'%s\n',['options_.simul=',int2str(0),';']);
fclose(fid);

% Writing calibration in Parameterization.mod
fid=fopen('Parameterization.mod','w');
fprintf(fid,'%s\n','fi_pi  =	3.0;');
fprintf(fid,'%s\n','stderrez   = 0.15177 ;');
fprintf(fid,'%s\n','stderreom   = 0.10397 ;'); 
fclose(fid);
dynare bench_oil.mod noclearall

% Rescale shocks to obtain a theoretical 10% increase in oil prices
scale_om = 1/oo_.dr.ghu(13,3);
scale_z = 1/oo_.dr.ghu(13,2);
% Writing calibration in Parameterization.mod
fid=fopen('Parameterization.mod','w');
fprintf(fid,'%s\n','fi_pi  =	3.0;');
fprintf(fid,'%s\n',['stderreom   =',num2str(0.1*scale_om),';']);
fprintf(fid,'%s\n',['stderrez   =',num2str(0.1*scale_z),';']);
fclose(fid);

i_var_str_irfs = char('Output Gap','Output','Inflation','Interest Rate',...
                        'Oil Price','Output Growth');
                    
dynare bench_oil.mod noclearall

% Store IRFs to Fringe Capacity Shock (Omega in N.P.)
IRFsX       = zeros(nv,H);
IRFsX(1,:)  = 100*oo_.irfs.y_eom;
IRFsX(2,:)  = 100*oo_.irfs.yl_eom;
IRFsX(3,:)  = 400*oo_.irfs.pi_eom;
IRFsX(4,:)  = 400*oo_.irfs.i_eom;
IRFsX(5,:)  = 100*oo_.irfs.po_eom;
IRFsX(6,:)  = 400*oo_.irfs.y_g_eom;

% Store IRFs to Oil Productivity Shock
IRFsZ       = zeros(nv,H);
IRFsZ(1,:)  = 100*oo_.irfs.y_ez;
IRFsZ(2,:)  = 100*oo_.irfs.yl_ez;
IRFsZ(3,:)  = 400*oo_.irfs.pi_ez;
IRFsZ(4,:)  = 400*oo_.irfs.i_ez;
IRFsZ(5,:)  = 100*oo_.irfs.po_ez;
IRFsZ(6,:)  = 400*oo_.irfs.y_g_ez;

% Writing alternative calibration in Parameterization.mod
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

fid=fopen('Parameterization.mod','w');
fprintf(fid,'%s\n','fi_pi  =	2.25;');
fprintf(fid,'%s\n',['stderreom   =',num2str(0.1*scale_om),';']);
fprintf(fid,'%s\n',['stderrez   =',num2str(0.1*scale_z),';']);
fclose(fid);
dynare bench_oil.mod noclearall

% Store IRFs to Fringe Capacity Shock (Omega in N.P.)
IRFsXalt1       = zeros(nv,H);
IRFsXalt1(1,:)  = 100*oo_.irfs.y_eom;
IRFsXalt1(2,:)  = 100*oo_.irfs.yl_eom;
IRFsXalt1(3,:)  = 400*oo_.irfs.pi_eom;
IRFsXalt1(4,:)  = 400*oo_.irfs.i_eom;
IRFsXalt1(5,:)  = 100*oo_.irfs.po_eom;
IRFsXalt1(6,:)  = 400*oo_.irfs.y_g_eom;

% Store IRFs to Oil Productivity Shock
IRFsZalt1       = zeros(nv,H);
IRFsZalt1(1,:)  = 100*oo_.irfs.y_ez;
IRFsZalt1(2,:)  = 100*oo_.irfs.yl_ez;
IRFsZalt1(3,:)  = 400*oo_.irfs.pi_ez;
IRFsZalt1(4,:)  = 400*oo_.irfs.i_ez;
IRFsZalt1(5,:)  = 100*oo_.irfs.po_ez;
IRFsZalt1(6,:)  = 400*oo_.irfs.y_g_ez;


% Writing alternative calibration in Parameterization.mod
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

fid=fopen('Parameterization.mod','w');
fprintf(fid,'%s\n','fi_pi  =	1.5;');
fprintf(fid,'%s\n',['stderreom   =',num2str(0.1*scale_om),';']);
fprintf(fid,'%s\n',['stderrez   =',num2str(0.1*scale_z),';']);
fclose(fid);
dynare bench_oil.mod noclearall
% Store IRFs to Fringe Capacity Shock (Omega in N.P.)
IRFsXalt2       = zeros(nv,H);
IRFsXalt2(1,:)  = 100*oo_.irfs.y_eom;
IRFsXalt2(2,:)  = 100*oo_.irfs.yl_eom;
IRFsXalt2(3,:)  = 400*oo_.irfs.pi_eom;
IRFsXalt2(4,:)  = 400*oo_.irfs.i_eom;
IRFsXalt2(5,:)  = 100*oo_.irfs.po_eom;
IRFsXalt2(6,:)  = 400*oo_.irfs.y_g_eom;

% Store IRFs to Oil Productivity Shock
IRFsZalt2       = zeros(nv,H);
IRFsZalt2(1,:)  = 100*oo_.irfs.y_ez;
IRFsZalt2(2,:)  = 100*oo_.irfs.yl_ez;
IRFsZalt2(3,:)  = 400*oo_.irfs.pi_ez;
IRFsZalt2(4,:)  = 400*oo_.irfs.i_ez;
IRFsZalt2(5,:)  = 100*oo_.irfs.po_ez;
IRFsZalt2(6,:)  = 400*oo_.irfs.y_g_ez;

save IRFs_true IRFsZ IRFsZalt1 IRFsZalt2 IRFsX IRFsXalt1 IRFsXalt2 
%% --------------------------------------------------------------
% 0. Simulation of the Model
%----------------------------------------------------------------
params_true.f_a = f_a;
params_true.f_om = f_om;
params_true.f_y = f_y;
params_true.f_z = f_z;
params_true.ro_z = ro_z;
params_true.ro_a = ro_a;
params_true.ro_z = ro_z;
params_true.ro_omega = ro_omega;
params_true.stderrea = stderrea;
params_true.s_o = s_o;

% Writing Simulations options in Simulation.mod
fid=fopen('Simulation.mod','w');
fprintf(fid,'%s\n',['options_.simul=',int2str(1),';']);
fclose(fid);

% Writing calibration in Parameterization.mod
% Benchmark calibration
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

fid=fopen('Parameterization.mod','w');
fprintf(fid,'%s\n','fi_pi  =	3.0;');
fprintf(fid,'%s\n','stderreom   = 0.10397 ;');
fprintf(fid,'%s\n','stderrez   = 0.15177 ;');
fprintf(fid,'%s\n','stderreb   = 0.0 ;');
% fprintf(fid,'%s\n','stderrez   = 0.0 ;');
% fprintf(fid,'%s\n','stderreom   = 0.0 ;');
fclose(fid);
stderrez   = 0.15177;
stderreom   = 0.10397;
stderreb  = 0.0;
params_true.stderrez = stderrez;
params_true.stderreom = stderreom;
params_true.stderreb = stderreb;


dynare bench_oil.mod noclearall

burn = 0.5;
i_var_str = char('y_g','pi','i','po_g');  
[~,i_var] = ismember(i_var_str,M_.endo_names,'rows');
nobs = size(oo_.endo_simul,2);
y_g =  oo_.endo_simul(i_var(1),round(nobs*burn)+1:end)';
pi =  oo_.endo_simul(i_var(2),round(nobs*burn)+1:end)';
i =  oo_.endo_simul(i_var(3),round(nobs*burn)+1:end)';
po_g = oo_.endo_simul(i_var(4),round(nobs*burn)+1:end)';
a_true = a(round(nobs*burn)+1:end);
z_true = z(round(nobs*burn)+1:end);
y_true = y(round(nobs*burn)+1:end);
omega_true = omega(round(nobs*burn)+1:end);
save simuldataNakov_al.mat y_g pi i po_g a_true z_true y_true omega_true...
                            params_true

% Writing calibration in Parameterization.mod
% Fringe Capacity Shock only
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

fid=fopen('Parameterization.mod','w');
fprintf(fid,'%s\n','fi_pi  =	3.1;');
fprintf(fid,'%s\n','stderreom   = 0.10397 ;');
% fprintf(fid,'%s\n','stderrez   = 0.15177 ;');
fprintf(fid,'%s\n','stderrez   = 0.0 ;');
% fprintf(fid,'%s\n','stderreom   = 0.0 ;');
fprintf(fid,'%s\n','stderrez   = 0.0 ;');
fprintf(fid,'%s\n','stderreb   = 0.0 ;');
fclose(fid);
stderrez   = 0.0;
stderreom   = 0.10397;
stderreb  = 0.0;
params_true.stderrez = stderrez;
params_true.stderreom = stderreom;
params_true.stderreb = stderreb;


dynare bench_oil.mod noclearall

nobs = size(oo_.endo_simul,2);
y_g =  oo_.endo_simul(i_var(1),round(nobs*burn)+1:end)';
pi =  oo_.endo_simul(i_var(2),round(nobs*burn)+1:end)';
i =  oo_.endo_simul(i_var(3),round(nobs*burn)+1:end)';
po_g = oo_.endo_simul(i_var(4),round(nobs*burn)+1:end)';
a_true = a(round(nobs*burn)+1:end);
z_true = z(round(nobs*burn)+1:end);
y_true = y(round(nobs*burn)+1:end);
omega_true = omega(round(nobs*burn)+1:end);
save simuldataNakovXonlyLong.mat y_g pi i po_g a_true z_true y_true omega_true...
                            params_true
% Writing calibration in Parameterization.mod
% Oil Productivity Shock only
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

fid=fopen('Parameterization.mod','w');
fprintf(fid,'%s\n','fi_pi  =	3.0;');
% fprintf(fid,'%s\n','stderreom   = 0.10397 ;');
fprintf(fid,'%s\n','stderrez   = 0.15177 ;');
% fprintf(fid,'%s\n','stderrez   = 0.0 ;');
fprintf(fid,'%s\n','stderreom  = 0.0 ;');
fprintf(fid,'%s\n','stderreb   = 0.0 ;');
fclose(fid);
stderrez   = 0.15177;
stderreom  = 0.0;
stderreb  = 0.0;
params_true.stderrez = stderrez;
params_true.stderreom = stderreom;
params_true.stderreb = stderreb;

dynare bench_oil.mod noclearall
nobs = size(oo_.endo_simul,2);
y_g =  oo_.endo_simul(i_var(1),round(nobs*burn)+1:end)';
pi =  oo_.endo_simul(i_var(2),round(nobs*burn)+1:end)';
i =  oo_.endo_simul(i_var(3),round(nobs*burn)+1:end)';
po_g = oo_.endo_simul(i_var(4),round(nobs*burn)+1:end)';
a_true = a(round(nobs*burn)+1:end);
z_true = z(round(nobs*burn)+1:end);
y_true = y(round(nobs*burn)+1:end);
omega_true = omega(round(nobs*burn)+1:end);
er_true = oo_.exo_simul(round(nobs*burn)+1:end,4);
mko_true = mko(round(nobs*burn)+1:end);

save simuldataNakovZonlyLong.mat y_g pi i po_g a_true z_true y_true omega_true...
                            mko_true er_true params_true