var y, rr_e, pi, a, z, mko, omega, i, ye, yl, po, y_g, po_g, c, mc;

varexo ea, ez, eom, er;

parameters   lambda, teta, h, psi, beta, epsilon, s_k, s_o, s_l, miu, x_o, f_a, f_z, f_om, fi_i, fi_pi, fi_y, ro_a, ro_z, ro_omega, stderrea, stderreb, stderreom, stderrer, f_y, g1, g2;

@# include "Parameterization.mod"

teta        = 0.4773;    //Calvo parameter (frequency of price adjustment)
h           = 0;        //external habits
psi         = 1.0089;    //inverse of Frisch elasticity of labour supply
beta        = 0.9926;  //discount factor
epsilon     = 7.66;    //elasticity of substitution between varieties
miu         = epsilon/(epsilon-1); //markup
s_k         = 1/3;    //capital elasticity of gross output
s_o         = 0.0264;  //oil elasticity of output (1984-2007)
s_l         = 1-s_k-s_o; //labour elasticity of gross output
x_o         = 1.254176905631884;  //relative capacity of non-OPEC to OPEC (to match 40% share of OPEC)
cf          = 1-s_o/miu;
fi_i     = 0.6909;
fi_y     = 0.5385;

ro_a     = 0.9829;
ro_z     = 0.8815;
ro_omega = 0.9597;

stderrea = 0.00820;
//stderrea = 0.00620;
stderrer = 0.00212;


pars        =[psi epsilon s_l s_k x_o];
//oil markup
[f_a1, f_z1, f_om1, f_y1]=opt_oil_price(pars);

f_a=f_a1;
f_z=f_z1;
f_om=f_om1;
f_y=f_y1;

lambda      =(1+psi)*(miu-s_o)*(1-teta)*(1-beta*teta)/((miu*s_l+(miu-1)*(1+psi)*s_o)*teta);  //PC slope
g1          = (1-s_o)*(miu-s_o)*(1+psi)/(s_l*miu+s_o*(miu-s_o)*(1+psi));
g2          = s_o*(miu-s_o)*(1+psi)/(s_l*miu+s_o*(miu-s_o)*(1+psi));

//calculated ss
lbar    = (s_l/(miu-s_o))^(1/(1+psi));
ponbar  = (1+(1+s_k+s_l)*x_o)/(s_o+(1+s_l+s_k)*x_o);
onbar   = ((1-s_k-s_l)*lbar^s_l/(miu*ponbar))^(1/(s_l+s_k))/(1+x_o);
omegabar= x_o*onbar;


model(linear);

//IS curve
c    = c(+1)-(i-pi(+1)-rr_e);

//efficient real interest rate
rr_e = -(1-ro_a)/(1-s_o)*a-(s_o*(1-ro_z))/(1-s_o)*z;

//Phillips curve
pi   = beta*pi(+1)+(1-s_o)*lambda*c+s_o*lambda*mko;

//optimal oil markup
mko=f_a*a+f_z*z+f_om*omega+f_y*y;

//monetary policy
i    =fi_i*i(-1)+(1-fi_i)*(fi_pi*pi+fi_y*c)-er;

//relation btw consumption and output gap
y    =c+s_o/(miu-s_o)*mc;

//marginal cost
mc = g1*y+g2*mko;

//AR processes of shocks
// TFP
a    =ro_a*a(-1)+ea;
// oil sector productivity
z    =ro_z*z(-1)-ez;
//competitive fringe capacity
omega=ro_omega*omega(-1)-eom;

//efficient output
ye   =a+s_o*z;

//level of output
yl   =y+ye;

//real price of oil
po   =mko-z;

//growth rate of output
y_g=yl-yl(-1);

//growth rate of real oil prices
po_g=po-po(-1);
end;
shocks;
var ea  = stderrea^2;
var ez  = stderrez^2;
var eom = stderreom^2;
var er  = stderrer^2;
end;

@# include "Simulation.mod"

if options_.simul == 1
    stoch_simul(PERIODS = 1000, nograph, noprint, irf = 0, order = 1, drop = 0) 
                pi y c ye i po_g po y_g omega mko yl a z omega; //noprint,
elseif options_.simul == 0
    stoch_simul(PERIODS = 0, irf = 40, order = 1, nograph) 
                pi y c ye i po_g po y_g omega mko yl;
end