/* This is same as M232AVG.SAS except E101 are added
   The timing variables are updated and correct.  
   The result of the first stage LIMDEP regression from the total 232 sample
   (490 observations) are used here.
   Only the sure ECON major students are included.
   1/28/93
*/
libname a v5 'tmp3:[finegtar.data]';
libname a66  'tmp3:[finegtar.data.ecmajor.e232]';
libname a6  'tmp3:[finegtar.data]';
filename a1 'm2326_23.dat';
*filename a2 'm232avg2.dat';
 
data b1;
  merge a.e232(keep=id t100 grad100 def100 grad101 def101 t101
                       t232 grad232 def232 size232 enter in=x)
        a.ecmajor(keep=id majorac1 majorac2 in=y)
        a6.cs232(keep=id course scale1 scale2
           math1700 math1711 math1712 math1721 math1722 math2211 math2212
           grad1700 grad1711 grad1712 grad1721 grad1722 grad2211 grad2212
           avg1712 avg1722 avg2212 math200 avg200)
        a.timings(keep=id time12 timeeq time21 so232 sr232 t231)
        a.frgpa232(keep=id frgpa)
        a.dem1232(keep=id sex expecon exposs expns exphum expno)
        a.sat(keep=id satmath satverb)
        a.fl232(keep=id floach)
        a.hs232(keep=id advm0 advm1 advm2 advm3 phys0 phys1 phys2
                        chem0 chem1 chem2); by id;

  if x and y;
  if majorac1='ECON' or majorac2='ECON';
  if grad232<0 then delete;
  if id=lag(id) then delete;
  if satmath<=0 or satverb<=0 then delete;

  if sex='F' then sex1=1; else
  if sex='M' then sex1=0;  
  if course='NO MATH' then delete;
*  if gpamath=9 or scale=0 or satverb=0 or satmath=0 then delete;
  scale11=scale1-1;
  scale21=scale2-1;
  if grad100=. or grad101=. then delete;
/*
proc sort data=b1 out=b11; by scale11;
proc sort data=b1 out=b21; by scale21;
*/

* calculating the indicator for the math courses PRDSCALE, using the limdep
  ordered probit results (E232_616.OUT);
* the coefficients and the thresholds are from limdep results;
  scal1est=-2.62465 + .00477686 * satmath + .225457 * floach
        + .217954 * sex1  - .175984 * expecon - .268749 * exposs
        + .317814 * expns - .394677 * exphum  + .00351948 * advm1
        + .666656 * advm2 + .281822 * advm3   + .270598 * phys1
        - .113062 * phys2 - .176226 * chem1   + .200783 * chem2;
*  scal2est=-1.17719 + .00378906 * satmath + .144466 * floach
        + .241086 * sex1  - .0915065 * expecon - .231147 * exposs
        + .307887 * expns - .550560 * exphum  + .0506397 * advm1
        + .663422 * advm2 + .404085 * advm3   + .259382 * phys1
        + .0598876 * phys2 - .0431704 * chem1  + .248450 * chem2;
*  scaleest=-3.31562 + .00543557 * satmath -.0213181 * floach
        + .255960 * sex1  - .108913 * expecon - .338983 * exposs
        + .392225 * expns - .393263 * exphum  + .244786 * advm1
        + .926827 * advm2 + .752293 * advm3   + .213379 * phys1
        + .398186 * phys2 - .137130 * chem1   + .182118 * chem2;
*  residual=scaleest-scale2;
  if scale11=0 then do; mu_low1=-.10e34;  mu_up1=0.00;    end; else
  if scale11=1 then do; mu_low1=0.00;     mu_up1=.210361; end; else
  if scale11=2 then do; mu_low1=.210361;  mu_up1=.269266; end; else
  if scale11=3 then do; mu_low1=.269266;  mu_up1=1.55340; end; else
  if scale11=4 then do; mu_low1=1.55340;  mu_up1=1.88231; end; else
  if scale11=5 then do; mu_low1=1.88231;  mu_up1=2.15164; end; else
  if scale11=6 then do; mu_low1=2.15164;  mu_up1=.10e34; end;
 
/*
  if scale21=0 then do; mu_low2=-.10e34;  mu_up2=0.00;    end; else
  if scale21=1 then do; mu_low2=0.00;     mu_up2=1.19751; end; else
  if scale21=2 then do; mu_low2=1.19751;  mu_up2=1.25443; end; else
  if scale21=3 then do; mu_low2=1.25443;  mu_up2=2.51809; end; else
  if scale21=4 then do; mu_low2=2.51809;  mu_up2=2.83144; end; else
  if scale21=5 then do; mu_low2=2.83144;  mu_up2=3.07707; end; else
  if scale21=6 then do; mu_low2=3.07707;  mu_up2=.10e34; end;
 */

  if scale11=0 then den21=0; else
    den21=(1.0/sqrt(2.0*3.14159))*exp(((mu_low1 - scal1est)**2)/(-2.0));
  
  if scale11=6 then den11=0; else
    den11=(1.0/sqrt(2.0*3.14159))*exp(((mu_up1 - scal1est)**2)/(-2.0));

  prob11=probnorm(mu_up1 - scal1est);
  prob21=probnorm(mu_low1 - scal1est);
  prdscal1=-1.0 * (den11-den21)/(prob11 - prob21);

proc sort; by id;

proc print;
var grad232 majorac1 majorac2 prdscal1 time12 timeeq so232 sr232
                  math1711 math1721 math1712 math1722 math2211 math2212  
                  grad100 grad101 def232 def100 def101 size232 frgpa sex1   
                  satmath satverb;

/*
proc reg data=b1;
    model grad232=prdscal1 time12 timeeq so232 sr232 
                  math1711 math1721 math1712 math1722 math2211 math2212
                  grad100 grad101 def232 def100 def101 size232 frgpa sex1 
                  satmath satverb;
     title 'estimation for e232 performance using IVs with scale1 w/econ majors';
*/

proc reg data=b1;
    model grad232=prdscal1 time12 timeeq so232 sr232
                  math1711 math1721 math1712 math1722 math2211 math2212
                  grad1700 grad1711 grad1721 grad1712 grad1722 grad2211 grad2212
                  grad100 grad101 def232 def100 def101 size232 frgpa sex1 
                  satmath satverb/covb;
     title 'estimation for e232 performance using IVs with scale1 w/econ majors';

/*
proc reg data=b1;
    model grad232=prdscal1 time12 timeeq so232 sr232
                  math1711 math1721 math1712 math1722 math200
                  grad1700 grad1711 grad1721 avg1712 avg1722 avg200
                  grad100 grad101 def232 def100 def101 size232 frgpa sex1
                  satmath satverb;
     title 'estimation for e232 average performance using IVs with scale1 w/econ majors';
*/

data b2; set b1;
  if timeeq=1 then timing='timeeq'; else
  if time12=1 then timing='time12'; else
  if time21=1 then timing='time21';
  if math1700=0 then do; math1700=.; grad1700=.; end;
  if math1711=0 then do; math1711=.; grad1711=.; end;
  if math1712=0 then do; math1712=.; grad1712=.; end;
  if math1721=0 then do; math1721=.; grad1721=.; end;
  if math1722=0 then do; math1722=.; grad1722=.; end;
  if math2211=0 then do; math2211=.; grad2211=.; end;
  if math2212=0 then do; math2212=.; grad2212=.; end;
  proc corr data=b2(drop=id mu_low1 mu_up1);

  proc sort; by timing;

  proc means; var grad232 prdscal1 so232 sr232 timeeq time12 time21
                  math1700 math1711 math1721 math1712 math1722 math200
                  math2211 math2212
                  grad1700 grad1711 grad1721 grad1712 grad1722  
                  grad2211 grad2212 avg1712 avg1722 avg200
                  grad100 def100 grad101 def232 def101 size232 frgpa sex1 
                  satmath satverb floach 
                  expecon exposs expns exphum expno 
                  advm1 advm2 advm3 phys1 phys2 chem1 chem2;
    by timing;
     title 'request of 4. for e232 w/econ majors sample';

endsas;



    










