/*This program runs the main regression for econ232 for the calculus
  Project, where the selection bias are taken cared by the predicted 
  highest math course grade before taking e232, the course difficulty 
  level is taken cared by the limdep ordered probit program.  This
  version is nothing but to include E101 and SO232 SR232 in the regression.
  Otherwise, the program is same as REG232.SAS April, 1992 
  This is a rerun of E232 after the timing variables are corrected by TIMINGS.SAS
  12/22/1992 */


/*This version replaces breaksf by break*/
libname a  '[]';
libname a1 v5 'tmp3:[finegtar.data]';

data b1; set a.e2321222;
*  infile a1;
*   input ser ids scale1 scale2 res;

* calculating the indicator for the math courses PRDSCALE, using the limdep
  ordered probit results (E232_616.OUT);
* the coefficients and the thresholds are from limdep results;
  scal1est=-2.62465 + .00477686 * satmath + .225457 * floach
        + .217954 * sex1  - .175984 * expecon - .268749 * exposs
        + .317814 * expns - .394677 * exphum  + .00351948 * advm1
        + .666656 * advm2 + .281822 * advm3   + .270598 * phys1
        - .113062 * phys2 - .176226 * chem1   + .200783 * chem2;
*  scal2est=-1.17719 + .00378906 * satmath + .144466 * floach
        + .241086 * sex1  - .0915065 * expecon - .231147 * exposs
        + .307887 * expns - .550560 * exphum  + .0506397 * advm1
        + .663422 * advm2 + .404085 * advm3   + .259382 * phys1
        + .0598876 * phys2 - .0431704 * chem1  + .248450 * chem2;
*  scaleest=-3.31562 + .00543557 * satmath -.0213181 * floach
        + .255960 * sex1  - .108913 * expecon - .338983 * exposs
        + .392225 * expns - .393263 * exphum  + .244786 * advm1
        + .926827 * advm2 + .752293 * advm3   + .213379 * phys1
        + .398186 * phys2 - .137130 * chem1   + .182118 * chem2;
*  residual=scaleest-scale2;
  if scale11=0 then do; mu_low1=-.10e34;  mu_up1=0.00;    end; else
  if scale11=1 then do; mu_low1=0.00;     mu_up1=.210361; end; else
  if scale11=2 then do; mu_low1=.210361;  mu_up1=.269266; end; else
  if scale11=3 then do; mu_low1=.269266;  mu_up1=1.55340; end; else
  if scale11=4 then do; mu_low1=1.55340;  mu_up1=1.88231; end; else
  if scale11=5 then do; mu_low1=1.88231;  mu_up1=2.15164; end; else
  if scale11=6 then do; mu_low1=2.15164;  mu_up1=.10e34; end;
 
/*
  if scale21=0 then do; mu_low2=-.10e34;  mu_up2=0.00;    end; else
  if scale21=1 then do; mu_low2=0.00;     mu_up2=1.19751; end; else
  if scale21=2 then do; mu_low2=1.19751;  mu_up2=1.25443; end; else
  if scale21=3 then do; mu_low2=1.25443;  mu_up2=2.51809; end; else
  if scale21=4 then do; mu_low2=2.51809;  mu_up2=2.83144; end; else
  if scale21=5 then do; mu_low2=2.83144;  mu_up2=3.07707; end; else
  if scale21=6 then do; mu_low2=3.07707;  mu_up2=.10e34; end;
 */

  if scale11=0 then den21=0; else
    den21=(1.0/sqrt(2.0*3.14159))*exp(((mu_low1 - scal1est)**2)/(-2.0));
  
  if scale11=6 then den11=0; else
    den11=(1.0/sqrt(2.0*3.14159))*exp(((mu_up1 - scal1est)**2)/(-2.0));

  prob11=probnorm(mu_up1 - scal1est);
  prob21=probnorm(mu_low1 - scal1est);
  prdscal1=-1.0 * (den11-den21)/(prob11 - prob21);

/*
  if scale21=0 then den22=0; else
    den22=(1.0/sqrt(2.0*3.14159))*exp(((mu_low2 - scal2est)**2)/(-2.0));
  
  if scale21=6 then den12=0; else
    den12=(1.0/sqrt(2.0*3.14159))*exp(((mu_up2 - scal2est)**2)/(-2.0));

  prob12=probnorm(mu_up2 - scal2est);
  prob22=probnorm(mu_low2 - scal2est);
  prdscal2=-1.0 * (den12-den22)/(prob12 - prob22);

  lprob1=log(probnorm(mu_up1 - scal1est) - probnorm(mu_low1 - scal1est));
  lprob2=log(probnorm(mu_up2 - scal2est) - probnorm(mu_low2 - scal2est));
*/

proc sort; by id;

proc print;
var grad232 prdscal1 time12 timeeq so232 sr232
                  math1711 math1721 math1712 math1722 math2211 math2212      
                  grad100 grad101 def232 def100 def101 size232 frgpa sex1    
                  satmath satverb;

proc reg data=b1;
    model grad232=prdscal1 time12 timeeq so232 sr232 
                  math1711 math1721 math1712 math1722 math2211 math2212
                  grad100 grad101 def232 def100 def101 size232 frgpa sex1 
                  satmath satverb;
     title 'estimation for e232 performance using IVs with scale1';

proc reg data=b1;
    model grad232=prdscal1 time12 timeeq so232 sr232
                  math1711 math1721 math1712 math1722 math2211 math2212
                  grad1700 grad1711 grad1721 grad1712 grad1722 grad2211 grad2212
                  grad100 grad101 def232 def100 def101 size232 frgpa sex1 
                  satmath satverb;
     title 'estimation for e232 performance using IVs with scale1';

proc reg data=b1;
    model grad232=prdscal1 time12 timeeq so232 sr232
                  math1711 math1721 math1712 math1722 math200
                  grad1700 grad1711 grad1721 avg1712 avg1722 avg200
                  grad100 grad101 def232 def100 def101 size232 frgpa sex1
                  satmath satverb;
     title 'estimation for e232 average performance using IVs with scale1';


data b2; merge b1(in=x) a1.ecmajor(in=y); by id;
  if x;
  if y then ecmajor=1; else ecmajor=0;
  if timeeq=1 then timing='timeeq'; else
  if time12=1 then timing='time12'; else
  if time21=1 then timing='time21';
  proc sort; by timing;

  proc means; var grad232 prdscal1 so232 sr232 timeeq time12 time21
                  math1700 math1711 math1721 math1712 math1722 math200
                  math2211 math2212
                  grad1700 grad1711 grad1721 grad1712 grad1722  
                  grad2211 grad2212 avg1712 avg1722 avg200
                  grad100 def100 grad101 def232 def101 size232 frgpa sex1 
                  satmath satverb floach 
                  expecon exposs expns exphum expno ecmajor
                  advm1 advm2 advm3 phys1 phys2 chem1 chem2;
     title 'request of 4. for e232 universal sample';

  proc means; var grad232 prdscal1 so232 sr232 timeeq time12 time21
                  math1700 math1711 math1721 math1712 math1722 math200
                  math2211 math2212
                  grad1700 grad1711 grad1721 grad1712 grad1722  
                  grad2211 grad2212 avg1712 avg1722 avg200
                  grad100 def100 grad101 def232 def101 size232 frgpa sex1 
                  satmath satverb floach 
                  expecon exposs expns exphum expno ecmajor
                  advm1 advm2 advm3 phys1 phys2 chem1 chem2;
    by timing;
     title 'request of 4. for e232 universal sample';

data b1700; set b2; 
  if math1700=1;
  proc means; var grad1700;
    title 'grad1700 if final is 1700';

data b1711; set b2; 
  if math1711=1;
  proc means; var grad1711;
    title 'grad1711 if final is 1711';

data b1721; set b2; 
  if math1721=1;
  proc means; var grad1721;
    title 'grad1721 if final is 1721';

data b1712; set b2; 
  if math1712=1;
  proc means; var grad1712;
    title 'grad1712 if final is 1712';

data b1722; set b2; 
  if math1722=1;
  proc means; var grad1722;
    title 'grad1722 if final is 1722';

data b2211; set b2; 
  if math2211=1;
  proc means; var grad2211;
    title 'grad2211 if final is 2211';

data b2212; set b2; 
  if math2212=1;
  proc means; var grad2212;
    title 'grad2212 if final is 2212';

data b3; set b2; 
  proc sort; by ecmajor;
  proc means; var grad232 prdscal1 so232 sr232 timeeq time12 time21
                  math1700 math1711 math1721 math1712 math1722 math200
                  math2211 math2212
                  grad1700 grad1711 grad1721 grad1712 grad1722  
                  grad2211 grad2212 avg1712 avg1722 avg200
                  grad100 def100 grad101 def232 def101 size232 frgpa sex1 
                  satmath satverb floach 
                  expecon exposs expns exphum expno ecmajor
                  advm1 advm2 advm3 phys1 phys2 chem1 chem2;
    by ecmajor;
     title 'request of 4. for e232 universal sample';

  proc corr;  var grad232 prdscal1 so232 sr232 timeeq time12 time21
                  math1700 math1711 math1721 math1712 math1722 math200
                  math2211 math2212
                  grad1700 grad1711 grad1721 grad1712 grad1722  
                  grad2211 grad2212 avg1712 avg1722 avg200
                  grad100 def100 grad101 def232 def101 size232 frgpa sex1 
                  satmath satverb floach 
                  expecon exposs expns exphum expno ecmajor
                  advm1 advm2 advm3 phys1 phys2 chem1 chem2;
     title 'request of 4. for e232 universal sample';

endsas;
