/*This is the same regression preparation as E231AVG.SAS in April, 1992 
  except that E100 students and the deflators are added by the request of
  Al of June 23, 1992.
  This time, subset of data is used in the regression, trying to test if
  the textbook used would be effective.
  Jan. 18, 1993*/
libname s 'tmp3:[finegtar.data.try231]';
libname a v5 'tmp3:[finegtar.data]';
libname a66  'tmp3:[finegtar.data.e231avg]';
libname a6  'tmp3:[finegtar.data]';
libname aa  'tmp3:[finegtar.data.e231avg]';
filename a1 'e2316_23.dat';
filename a2 'e2316_23.dat';
 

data b;
  merge a.e231(keep=id t101 grad101 def101 grad100 def100
                       t231 grad231 def231 size231 enter e231sect)
        a6.cs231(keep=id course scale1 scale2
           math1700 math1711 math1712 math1721 math1722 math2211 math2212
           grad1700 grad1711 grad1712 grad1721 grad1722 grad2211 grad2212
           avg1712 avg1722 avg2212 math200 avg200)
        a.timings(keep=id breaksf breakfs break brkother frsh231 so231 jr231
                      sr231)
        a.frgpa231(keep=id frgpa)
        a.dem1231(keep=id sex expecon exposs expns exphum expno)
        a.sat(keep=id satmath satverb)
        a.fl231(keep=id floach)
        a.hs231(keep=id advm0 advm1 advm2 advm3 phys0 phys1 phys2
                        chem0 chem1 chem2); by id;
  if grad231<0 then delete;
  if id=lag(id) then delete;
  if satmath<=0 or satverb<=0 then delete;

  if sex='F' then sex1=1; else
  if sex='M' then sex1=0;  
  if course='NO MATH' then delete;
*  if gpamath=9 or scale=0 or satverb=0 or satmath=0 then delete;
  if grad101=. or grad100=. then delete; 
  scale11=scale1-1;
  scale21=scale2-1;

* calculating the indicator for the math courses PRDSCALE, using the limdep
  ordered probit results (E231AVG.OUT);
* the coefficients and the thresholds are from limdep results;
  scal1est=-3.09316 + .00496926 * satmath +.0196256 * floach
        + .248804 * sex1  - .105558 * expecon - .293868 * exposs
        + .427304 * expns - .365003 * exphum  + .242088 * advm1
        + .932441 * advm2 + .770237 * advm3   + .262484 * phys1
        + .384695 * phys2 - .124865 * chem1   + .170398 * chem2;
  scal2est=-1.81461 + .00437708 * satmath -.0586709 * floach
        + .282834 * sex1  - .0763769 * expecon - .316715 * exposs
        + .317709 * expns - .374579 * exphum  + .224395 * advm1
        + .878178 * advm2 + .872736 * advm3   + .196733 * phys1
        + .459885 * phys2 - .0427034 * chem1  + .187512 * chem2;
*  scaleest=-3.31562 + .00543557 * satmath -.0213181 * floach
        + .255960 * sex1  - .108913 * expecon - .338983 * exposs
        + .392225 * expns - .393263 * exphum  + .244786 * advm1
        + .926827 * advm2 + .752293 * advm3   + .213379 * phys1
        + .398186 * phys2 - .137130 * chem1   + .182118 * chem2;
*  residual=scaleest-scale2;
  if scale11=0 then do; mu_low1=-.10e34;  mu_up1=0.00;    end; else
  if scale11=1 then do; mu_low1=0.00;     mu_up1=.272747; end; else
  if scale11=2 then do; mu_low1=.272747;  mu_up1=.330359; end; else
  if scale11=3 then do; mu_low1=.330359;  mu_up1=1.51686; end; else
  if scale11=4 then do; mu_low1=1.51686;  mu_up1=1.79307; end; else
  if scale11=5 then do; mu_low1=1.79307;  mu_up1=2.03586; end; else
  if scale11=6 then do; mu_low1=2.03586;  mu_up1=.10e34; end;
 
  if scale11=0 then den21=0; else
    den21=(1.0/sqrt(2.0*3.14159))*exp(((mu_low1 - scal1est)**2)/(-2.0));
  
  if scale11=6 then den11=0; else
    den11=(1.0/sqrt(2.0*3.14159))*exp(((mu_up1 - scal1est)**2)/(-2.0));

  prob11=probnorm(mu_up1 - scal1est);
  prob21=probnorm(mu_low1 - scal1est);
  prdscal1=-1.0 * (den11-den21)/(prob11 - prob21);

proc print; 
var grad231 prdscal1 so231 sr231 break breakfs   
                  math1711 math1721 math1712 math1722 math2211 math2212
                  grad1700 grad1711 grad1721 grad1712 grad1722 grad2211 grad2212
                  grad100 def100 grad101 def231 def101 size231 frgpa sex1    
                  satmath satverb t231 e231sect;                          

data lowmath highmath; set b;
  if (t231=843 and e231sect=1) or (t231=853 and e231sect=1) or
     (t231=853 and e231sect=4) or (t231=851 and e231sect=2) or
     (t231=861 and e231sect=1) or (t231=861 and e231sect=3) or
     (t231=861 and e231sect=4) or (t231=873 and e231sect=2) or
     (t231=873 and e231sect=3) or
     (t231=873 and e231sect=4) or (t231=873 and e231sect=5) or
     (t231=871 and e231sect=2) or (t231=871 and e231sect=3) or
     (t231=883 and e231sect=4) or (t231=881 and e231sect=1) or
     (t231=881 and e231sect=2) or (t231=881 and e231sect=4) or
     (t231=891 and e231sect=1) or (t231=891 and e231sect=3) or
     (t231=901 and e231sect=3) then output lowmath;

  if (t231=843 and e231sect=6) or (t231=853 and e231sect=2) or
     (t231=863 and e231sect=1) or (t231=863 and e231sect=3) or
     (t231=873 and e231sect=1) or (t231=871 and e231sect=1) or
     (t231=871 and e231sect=4) or (t231=883 and e231sect=1) or
     (t231=883 and e231sect=2) or (t231=881 and e231sect=3) or
     (t231=893 and e231sect=5) or (t231=891 and e231sect=2) or
     (t231=891 and e231sect=4) or (t231=901 and e231sect=1) then output highmath;

  proc freq data=lowmath; table t231* e231sect;
    title 'low math group';  
  proc freq data=highmath; table t231* e231sect;
    title 'high math group';
  proc freq data=b; table t231* e231sect;
    title 'total 609 sample group';

* low-math group regressions;
proc reg data=lowmath;
    model grad231=prdscal1 so231 sr231 break breakfs 
                  math1711 math1721 math1712 math1722 math2211 math2212
                  grad1700 grad1711 grad1721 grad1712 grad1722 grad2211 grad2212
                  grad100 def100 grad101 def231 def101 size231 frgpa sex1 
                  satmath satverb/covb;
     title1 'estimation for e231 performance using IVs with scale1, math course and grade';
     title2 'low math level group';


* high-math group regressions;
proc reg data=highmath;
  where math1721=0;                           * get rid of the math1721 groups;
    model grad231=prdscal1 so231 sr231 break breakfs 
                  math1711 math1712 math1722 math2211 math2212
                  grad1700 grad1711 grad1712 grad1722 grad2211 grad2212
                  grad100 def100 grad101 def231 def101 size231 frgpa sex1 
                  satmath satverb/covb;
     title1 'estimation for e231 performance using IVs with scale1, math course and grade';
     title2 'high math level group';

* original total sample;
proc reg data=b;
    model grad231=prdscal1 so231 sr231 break breakfs 
                  math1711 math1721 math1712 math1722 math2211 math2212
                  grad1700 grad1711 grad1721 grad1712 grad1722 grad2211 grad2212
                  grad100 def100 grad101 def231 def101 size231 frgpa sex1 
                  satmath satverb/covb;
     title1 'estimation for e231 performance using IVs with scale1, math course and grade';
     title2 'total 609 sample group';

data low; set lowmath;
  if math1700=0 then do; math1700=.; grad1700=.; end;
  if math1711=0 then do; math1711=.; grad1711=.; end;
  if math1712=0 then do; math1712=.; grad1712=.; end;
  if math1721=0 then do; math1721=.; grad1721=.; end;
  if math1722=0 then do; math1722=.; grad1722=.; end;
  if math2211=0 then do; math2211=.; grad2211=.; end;
  if math2212=0 then do; math2212=.; grad2212=.; end;
  proc corr data=low(drop=id mu_low1 mu_up1);
    title 'covariance matrix for low math gruop';

data high; set higmath;
  if math1700=0 then do; math1700=.; grad1700=.; end;
  if math1711=0 then do; math1711=.; grad1711=.; end;
  if math1712=0 then do; math1712=.; grad1712=.; end;
  if math1721=0 then do; math1721=.; grad1721=.; end;
  if math1722=0 then do; math1722=.; grad1722=.; end;
  if math2211=0 then do; math2211=.; grad2211=.; end;
  if math2212=0 then do; math2212=.; grad2212=.; end;
  proc corr data=high(drop=id mu_low1 mu_up1);
    title 'covariance matrix for high math gruop';

data bb; set b;
  if math1700=0 then do; math1700=.; grad1700=.; end;
  if math1711=0 then do; math1711=.; grad1711=.; end;
  if math1712=0 then do; math1712=.; grad1712=.; end;
  if math1721=0 then do; math1721=.; grad1721=.; end;
  if math1722=0 then do; math1722=.; grad1722=.; end;
  if math2211=0 then do; math2211=.; grad2211=.; end;
  if math2212=0 then do; math2212=.; grad2212=.; end;
  proc corr data=bb(drop=id mu_low1 mu_up1);
    title 'covariance matrix for 609 sample gruop';

  endsas;
