*Table 3: Poverty IV estimates
*---------------------------------------------------------------------------
*---------------------------------------------------------------------------
local table3 "h1 h2 head lrwagenew lsalpw"

*Column 1: OLS with one regressor: 
*Number branches opened in rural unbanked locations per capita
*---------------------------------------------------------------------------
reg h1 runbfor stdum* yrdum*, cluster(state)
	
outreg2 using "table_3.tex", se keep(runbfor) coefastr  paren /// 
bdec(2) adjr2 symbol(***, **, *) nolabel nocons /// 
addtext(State and year dummies, YES, Other controls, YES) replace

*Column 2: OLS with additional controls 
*---------------------------------------------------------------------------
reg h1 runbfor $iv $controls stdum* yrdum*, cluster(state)
	
outreg2 using "table_3.tex", se  ///
keep(runbfor $iv)    ///
addtext(State and year dummies, YES, Other controls, YES) ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons append

*Columns 3, 4, 5  - IV: Rural, Urban & Aggraget Headcount Ratio 
*& Columns 9, 10  - IV: Agricultural & Factory wages
*---------------------------------------------------------------------------
foreach v of local table3{
reg `v'  runbfor $iv $controls stdum* yrdum* ///
($main $controls stdum* yrdum*), cluster(state)

outreg2 using "table_3.tex", se ///
keep(runbfor $iv) ///
addtext(State and year dummies, YES, Other controls, YES) ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons append
 
capture drop resinc
predict resinc, res
reg resinc $ubt, noc robust  
capture drop sargan
ge sargan=_result(7)*_result(1)
capture drop prob
ge prob=chiprob(3,sargan)
disp sargan prob
}

*Columns 6, 7, 8 -- *restricted sample for h1 
*---------------------------------------------------------------------------
*column 6, earlier then 1990
*---------------------------------------------------------------------------
reg h1 runbfor  $iv $controls stdum* yrdum* ///
($main $controls stdum* yrdum*) if year<1990, cluster(state) 

outreg2 using "table_3.tex", se ///
keep(runbfor $iv)  ///
addtext(State and year dummies, YES, Other controls, YES) ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons append

*column 7, earlier then treatment year (BP05 1976)
*---------------------------------------------------------------------------
*Tr set in file 0_master.do
reg h1 runbfor  $iv $controls stdum* yrdum* ///
($main $controls stdum* yrdum*) if year>Tr, cluster(state) 

outreg2 using "table_3.tex", se ///
keep(runbfor $iv)  ///
addtext(State and year dummies, YES, Other controls, YES) ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons append

*column 8, survey years
*---------------------------------------------------------------------------
reg h1 runbfor $iv $controls stdum* yrdum* ///
($main $controls stdum* yrdum*) if round~=.,cluster(state)

outreg2 using "table_3.tex", se /// 
keep(runbfor $iv) ///
addtext(State and year dummies, YES, Other controls, YES) ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nolabel nocons append 

capture drop resinc
predict resinc, res
reg resinc $ubt, noc robust  
capture drop sargan
ge sargan=_result(7)*_result(1)
capture drop prob
ge prob=chiprob(3,sargan)
disp sargan prob



