

* generate the coefficients for the Figure 1
	drop if year>2000
*Figure 1: rural branches in unbanked locations (with controls)
	areg runbfor unbk62-unbk00 rshare62-rshare00 popn62-popn00 stin62-stin00 stdum*, absorb(year) cluster(state)
*Start NB
	mata: b=st_matrix("e(b)")'
	getmata b, force
	gen temp=b[_n-1]
	replace b=temp
	replace b=. if _n==_N
	replace b = . if state > 1
	label variable b "rural branches in unbanked locations (with controls)"

*summarize these trend reversals by a linear trend break model:
	reg runbfor $main $controls stdum* yrdum*,cluster(state)
	mata: coef=st_matrix("e(b)")'
	getmata coef, force
	replace coef=. if _n> 2*n+1
	
	mkmat $main, matrix(X) 
	mkmat coef if coef < . , matrix(B) 
	matrix tr1 = X*B
	svmat tr1, names(trd)
			
	egen trend_m = mean(trd), by (year)
	gen mtrend = trend_m if state == 1
	gen trend = mtrend - mtrend[1]
		
	label variable trend "rural branches in unbanked locations (trend break)"
#delimit ;
line b trend year, 
legend(size(small) cols(1) symxsize(7)) 

lpattern(solid longdash_dot) 
lcolor(black black) 
graphregion(color(white)) 

xlabel(, labsize(small))
ylabel(, labsize(small) angle(horizontal)) 

xtitle("") 
ytitle("Initial financial development X year - coefficient {it}{&gamma}{subscript:t}", 
size(small));
#delimit cr

 