*==========================================
* Date : Novermber 2021
* Paper: Do Rural Banks Matter That Much? Burgess and Pande (2005) Reconsidered
* The original code is from:
*		 Burgess, R., & Pande, R. (2005). 
*		"Do rural banks matter? 
*					evidence from the Indian social banking experiment."
*		American Economic Review, 95(3)
* This code replicates Burgess and Pande (2005) with different cut-years in
* addition to 1977. 
*==========================================

clear all 
*set more off
use "burgesspandeaerfinal.dta"
*------------------------------
*==========================================
*==========================================
*							 SECTION 1: replicate FIGURE 1 
*								for different cut-years. 
*==========================================
*==========================================

* generate the coefficients for the Figures
drop if year>2000

*Figure 1: rural branches in unbanked locations (with controls)
quietly areg runbfor unbk62-unbk00 rshare62-rshare00 popn62-popn00 stin62-stin00 stdum*, absorb(year) cluster(state)

*Save coeff of ubks
	quietly mata: b=st_matrix("e(b)")'
	quietly getmata b, force
	quietly gen temp=b[_n-1]
	quietly replace b=temp
	quietly replace b=. if _n==_N
	quietly replace b = . if state > 1
	quietly label variable b "rural branches in unbanked locations (with controls)"

local graphs ""

forvalues i = 1965(1)1990 {
gen T`i' = `i'

	gen trend`i' = year - (T`i'-1)
	replace trend`i' =0 if year < T`i'
	gen dum`i' =0
	replace dum`i' =1 if year>(T`i'-1)
	gen ubt`i' =unb61*trend`i' *dum`i' 
	gen ubdum`i' =unb61*dum`i' 
	gen popt`i' =((pop61)/larea)*trend`i' *dum`i' 
	gen popd`i' =((pop61)/larea)*dum`i' 
	gen stint`i' =stinc61*trend`i' 
	gen stind`i' =stinc61*dum`i' 
	gen rursht`i' =rursh61*trend`i' *dum`i' 
	gen rurshd`i' =rursh61*dum`i' 
	
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubt`i' ubt90  ubdum77 ubdum`i' ubdum90"

quietly reg runbfor $main $controls stdum* yrdum*,cluster(state)

	quietly mata: coef`i'=st_matrix("e(b)")'
	quietly getmata coef`i', force
 	quietly replace coef`i'=. if _n>7
	
	mkmat $main, matrix(X) 
	mkmat coef`i' if coef`i' < . , matrix(B`i') 
	matrix tr`i' = X*B`i'
	svmat tr`i', names(trd`i')
	
 	quietly egen trend_m`i' = mean(trd`i'), by(year)
	quietly gen mtrend`i' = trend_m`i' if state == 1
	quietly gen mytrend`i' = mtrend`i' - mtrend`i'[1]

	quietly label variable mytrend`i' "rural branches in unbanked locations (trend break)"

		quietly line b mytrend`i' year, ///
		legend(size(small) cols(1)) ///
		lpattern(solid longdash_dot) lcolor(black black) ///
		ylabel(, labsize(small) angle(horizontal)) ///
		xlabel(, labsize(small)) ///
		xtitle(Additional cut-year in `i', size(small)) ///
		saving(Figure1_`i', replace) nodraw
 }


local all_long " Figure1_1971.gph Figure1_1972.gph Figure1_1973.gph Figure1_1974.gph	Figure1_1975.gph Figure1_1976.gph Figure1_1977.gph Figure1_1978.gph Figure1_1979.gph	Figure1_1980.gph Figure1_1981.gph Figure1_1982.gph Figure1_1983.gph Figure1_1984.gph Figure1_1985.gph"

grc1leg2 `all_long', col(3) l1("Initial financial development X year - coefficient {it}{&gamma}{subscript:t}", size(v.small))
graph export all.eps, replace 



*==========================================
*==========================================
*							 SECTION 2: TABLES 
*==========================================
*==========================================
* generate the coefficients for the Figures
drop if year > 2000
*For the regressions we drop Haryana before 1965
drop if state == 5 & year < 1965


*==========================================
*
*Table 1: Banking as a Function of Initial financial development
*
*==========================================
*macro define iv "ubt61 ubdum77 ubdum`i' ubdum90"

*==========================================
*Column 1: Branches in rural unbanked locations
*==========================================
eststo clear

forvalues i = 1965(1)1990 {
*------------------------------

*Define Macro
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubt`i' ubt90  ubdum77 ubdum`i' ubdum90"


quietly reg runbfor $main $controls stdum* yrdum*, cluster(state)

estimates store m11_`i'

		quietly test ubt61+ubt`i'=0
		local F1 = r(F) 
		local p1 = r(p) 
	    test ubdum`i' ubt`i'
		local F2 = r(F) 
		local p2 = r(p) 
		quietly test ubt61+ubt77+ubt`i'+ubt90=0	
		
quietly	eststo, add(Ftest1 `F1'  P1  `p1' Ftest2 r(F)  P2 r(p) Ftest3 `F2'  P3  `p2'   )

/*
outreg2 using "table_1_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/
}

 # delimit;
 esttab using "table_111.tex", 
 keep ( ubt61 ubt77 ubdum77 ubt90 ubdum90
 
		ubt1965  
		ubt1966 ubt1967  ubt1968  ubt1969  ubt1970  
		ubt1971  ubt1972  ubt1973  ubt1974  ubt1975 
		ubt1976  ubt1977  ubt1978  ubt1979	ubt1980
		ubt1981  ubt1982  ubt1983  ubt1984  ubt1985 
		ubt1986  ubt1987  ubt1988  ubt1989  ubt1990 
		
		ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 ) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N Ftest1 P1 Ftest2 P2 Ftest3 P3, labels("Adj. R-Square" "Observations" "F-test 1" "" "F-test 2" "")) replace ;
 #delimit cr
 
*==========================================
*Column 2: Rural Bank Credit share
*==========================================
eststo clear

forvalues i = 1965(1)1990 {
*------------------------------
*Define Macro
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubdum77 ubt90 ubdum90 ubt`i' ubdum`i' "

*------------------------------

quietly reg rurcrsh $main $controls stdum* yrdum*, cluster(state)

estimates store m12_`i'

		quietly test ubt61+ubt`i'=0
		local F1 = r(F) 
		local p1 = r(p) 
		quietly test ubt61+ubt77+ubt`i'+ubt90=0
		
quietly	eststo, add(Ftest1 `F1'  P1  `p1' Ftest2 r(F)  P2 r(p)  )

/*
outreg2 using "table_1_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/

}

# delimit;
 esttab using "table_12.tex", 
 keep ( ubt61 ubt77 ubdum77 ubt90  ubdum90   ubt1965  
		ubt1966  ubt1967  ubt1968  ubt1969  ubt1970  
		ubt1971  ubt1972  ubt1973  ubt1974  ubt1975 
		ubt1976  ubt1977  ubt1978  ubt1979	ubt1980
		ubt1981  ubt1982  ubt1983  ubt1984  ubt1985 
		ubt1986  ubt1987  ubt1988  ubt1989  ubt1990 ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 ) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N Ftest1 P1 Ftest2 P2, labels("Adj. R-Square" "Observations" "F-test 1" "" "F-test 2" "")) replace ;
 #delimit cr
 


*==========================================
*Column 3: Rural Bank Saving Share
*==========================================
eststo clear
	
forvalues i = 1965(1)1990 {
*------------------------------
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubdum77 ubt90 ubdum90 ubt`i' ubdum`i' "

*------------------------------
 quietly reg rursavsh $main $controls stdum* yrdum*, cluster(state)

estimates store m13`i'

		quietly test ubt61+ubt`i'=0
		local F1 = r(F) 
		local p1 = r(p) 
		quietly test ubt61+ubt77+ubt`i'+ubt90=0
		
quietly	eststo, add(Ftest1 `F1'  P1  `p1' Ftest2 r(F)  P2 r(p)  )

/*
outreg2 using "table_1_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/
}

# delimit;
 esttab using "table_13.tex", 
 keep ( ubt61 ubt77 ubdum77 ubt90  ubdum90   ubt1965  
		ubt1966  ubt1967  ubt1968  ubt1969  ubt1970  
		ubt1971  ubt1972  ubt1973  ubt1974  ubt1975 
		ubt1976  ubt1977  ubt1978  ubt1979	ubt1980
		ubt1981  ubt1982  ubt1983  ubt1984  ubt1985 
		ubt1986  ubt1987  ubt1988  ubt1989  ubt1990 ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 ) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N Ftest1 P1 Ftest2 P2, labels("Adj. R-Square" "Observations" "F-test 1" "" "F-test 2" "")) replace ;
 #delimit cr


*==========================================
*Column 4: Branches in banked locations
*==========================================
eststo clear

forvalues i = 1965(1)1990 {
*------------------------------
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubdum77 ubt90 ubdum90 ubt`i' ubdum`i' "

*------------------------------

quietly reg bfor $main $controls stdum* yrdum*, cluster(state)

estimates store m14`i'

		quietly test ubt61+ubt`i'=0
		local F1 = r(F) 
		local p1 = r(p) 
		quietly test ubt61+ubt77+ubt`i'+ubt90=0
		
quietly	eststo, add(Ftest1 `F1'  P1  `p1' Ftest2 r(F)  P2 r(p)  )

/*
outreg2 using "table_1_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/
	
}

# delimit;
 esttab using "table_14.tex", 
 keep ( ubt61 	 ubt77 	  ubdum77  ubt90 	ubdum90
	
		ubt1965  
		ubt1966  ubt1967  ubt1968  ubt1969  ubt1970  
		ubt1971  ubt1972  ubt1973  ubt1974  ubt1975 
		ubt1976  ubt1977  ubt1978  ubt1979	ubt1980
		ubt1981  ubt1982  ubt1983  ubt1984  ubt1985 
		ubt1986  ubt1987  ubt1988  ubt1989  ubt1990 
		
		ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 ) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N Ftest1 P1 Ftest2 P2, labels("Adj. R-Square" "Observations" "F-test 1" "" "F-test 2" "")) replace ;
 #delimit cr
 

*==========================================
*Column 5: Priority sector Credit share
*==========================================
eststo clear

forvalues i = 1965(1)1990 {
*------------------------------
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubdum77 ubt90 ubdum90 ubt`i' ubdum`i' "

*------------------------------

quietly reg priorsh $main $controls stdum* yrdum*, cluster(state)

estimates store m1`v'`i'

		quietly test ubt61+ubt`i'=0
		local F1 = r(F) 
		local p1 = r(p) 
		quietly test ubt61+ubt77+ubt`i'+ubt90=0
		
quietly	eststo, add(Ftest1 `F1'  P1  `p1' Ftest2 r(F)  P2 r(p)  )

/*
outreg2 using "table_1_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/

}

# delimit;
 esttab using "table_15.tex", 
 keep ( ubt61 	 ubt77 	  ubdum77  ubt90 	ubdum90
	
		ubt1965  
		ubt1966  ubt1967  ubt1968  ubt1969  ubt1970  
		ubt1971  ubt1972  ubt1973  ubt1974  ubt1975 
		ubt1976  ubt1977  ubt1978  ubt1979	ubt1980
		ubt1981  ubt1982  ubt1983  ubt1984  ubt1985 
		ubt1986  ubt1987  ubt1988  ubt1989  ubt1990 
		
		ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 ) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N Ftest1 P1 Ftest2 P2, labels("Adj. R-Square" "Observations" "F-test 1" "" "F-test 2" "")) replace ;
 #delimit cr
 

*==========================================
*Column 6: Cooperative Credit share
*==========================================
eststo clear

forvalues i = 1965(1)1990 {
*------------------------------
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubdum77 ubt90 ubdum90 ubt`i' ubdum`i' "

*------------------------------

quietly reg pcoopsh $main $controls stdum* yrdum*, cluster(state)

estimates store m1`v'`i'

		quietly test ubt61+ubt`i'=0
		local F1 = r(F) 
		local p1 = r(p) 
		quietly test ubt61+ubt77+ubt`i'+ubt90=0
		
quietly	eststo, add(Ftest1 `F1'  P1  `p1' Ftest2 r(F)  P2 r(p)  )

/*
outreg2 using "table_1_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/

}
 	
# delimit;
 esttab using "table_16.tex", 
 keep ( ubt61 	 ubt77 	  ubdum77  ubt90 	ubdum90
	
		ubt1965  
		ubt1966  ubt1967  ubt1968  ubt1969  ubt1970  
		ubt1971  ubt1972  ubt1973  ubt1974  ubt1975 
		ubt1976  ubt1977  ubt1978  ubt1979	ubt1980
		ubt1981  ubt1982  ubt1983  ubt1984  ubt1985 
		ubt1986  ubt1987  ubt1988  ubt1989  ubt1990 
		
		ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 ) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N Ftest1 P1 Ftest2 P2, labels("Adj. R-Square" "Observations" "F-test 1" "" "F-test 2" "")) replace ;
 #delimit cr
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 

*==========================================
*
*Table 2:  Bank Branch Expansion and Poverty: Reduced Form
*
*==========================================



*==========================================
*Column 2 - Rural Headcount Ratio 
*==========================================
eststo clear

forvalues i = 1965(1)1990 {
*------------------------------
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubdum77 ubt90 ubdum90 ubt`i' ubdum`i' "

*------------------------------
quietly reg h1 $main $controls stdum* yrdum*, cluster(state)

		quietly test ubt61+ubt`i'=0
		local F1 = r(F)
		local p1 = r(p)
		quietly test ubt61+ubt77+ubt`i'+ubt90=0
	
quietly	eststo, add(Ftest1 `F1'  P1  `p1' Ftest2 r(F)  P2 r(p))

/*
outreg2 using "table_2_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/
}

# delimit;
 esttab using "table_22.tex", 
 keep ( ubt61 	 ubt77 	  ubdum77  ubt90 	ubdum90
		ubt1965  
		ubt1966  ubt1967  ubt1968  ubt1969  ubt1970  
		ubt1971  ubt1972  ubt1973  ubt1974  ubt1975 
		ubt1976  ubt1977  ubt1978  ubt1979	ubt1980
		ubt1981  ubt1982  ubt1983  ubt1984  ubt1985 
		ubt1986  ubt1987  ubt1988  ubt1989  ubt1990 
		
		ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 ) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N Ftest1 P1 Ftest2 P2, labels("Adj. R-Square" "Observations" "F-test 1" "" "F-test 2" "")) replace ;
 #delimit cr



*==========================================
*Columns 3: Urban Headcount Ratio 
*==========================================
eststo clear

forvalues i = 1965(1)1990 {
*------------------------------
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubdum77 ubt90 ubdum90 ubt`i' ubdum`i' "

*------------------------------
quietly reg h2 $main $controls stdum* yrdum*, cluster(state)

		quietly test ubt61+ubt`i' = 0
		local F1 = r(F)
		local p1 = r(p)
		quietly test ubt61+ubt77+ubt`i'+ubt90=0

quietly	eststo, add(Ftest1 `F1'  P1  `p1' Ftest2 r(F)  P2 r(p))

/*
outreg2 using "table_2_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/
}

# delimit;
 esttab using "table_23.tex", 
 keep ( ubt61 	 ubt77 	  ubdum77  ubt90 	ubdum90
	
		ubt1965  
		ubt1966  ubt1967  ubt1968  ubt1969  ubt1970  
		ubt1971  ubt1972  ubt1973  ubt1974  ubt1975 
		ubt1976  ubt1977  ubt1978  ubt1979	ubt1980
		ubt1981  ubt1982  ubt1983  ubt1984  ubt1985 
		ubt1986  ubt1987  ubt1988  ubt1989  ubt1990 
		
		ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 ) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N Ftest1 P1 Ftest2 P2, labels("Adj. R-Square" "Observations" "F-test 1" "" "F-test 2" "")) replace ;
 #delimit cr

*==========================================
*Columns 4: Aggregate Headcount Ratio 
*==========================================

eststo clear

forvalues i = 1965(1)1990 {
*------------------------------
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubdum77 ubt90 ubdum90 ubt`i' ubdum`i' "

*------------------------------
quietly reg head $main $controls stdum* yrdum*, cluster(state)

		quietly test ubt61+ubt`i' = 0
		local F1 = r(F)
		local p1 = r(p)
		quietly test ubt61+ubt77+ubt`i'+ubt90=0

quietly	eststo, add(Ftest1 `F1'  P1  `p1' Ftest2 r(F)  P2 r(p))

/*
outreg2 using "table_2_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/
}


# delimit;
 esttab using "table_24.tex", 
 keep ( ubt61 	 ubt77 	  ubdum77  ubt90 	ubdum90
	
		ubt1965  
		ubt1966  ubt1967  ubt1968  ubt1969  ubt1970  
		ubt1971  ubt1972  ubt1973  ubt1974  ubt1975 
		ubt1976  ubt1977  ubt1978  ubt1979	ubt1980
		ubt1981  ubt1982  ubt1983  ubt1984  ubt1985 
		ubt1986  ubt1987  ubt1988  ubt1989  ubt1990 
		
		ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 ) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N Ftest1 P1 Ftest2 P2, labels("Adj. R-Square" "Observations" "F-test 1" "" "F-test 2" "")) replace ;
 #delimit cr







*==========================================
* Columns 5 - Agricultural wages
*==========================================
eststo clear

forvalues i = 1965(1)1990 {
*------------------------------
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubdum77 ubt90 ubdum90 ubt`i' ubdum`i' "

*------------------------------
quietly reg lrwagenew $main $controls stdum* yrdum*, cluster(state)

		quietly test ubt61+ubt`i' = 0
		local F1 = r(F)
		local p1 = r(p)
		quietly test ubt61+ubt77+ubt`i'+ubt90=0

quietly	eststo, add(Ftest1 `F1'  P1  `p1' Ftest2 r(F)  P2 r(p))

/*
outreg2 using "table_2_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/
}


# delimit;
 esttab using "table_25.tex", 
 keep ( ubt61 	 ubt77 	  ubdum77  ubt90 	ubdum90
	
		ubt1965  
		ubt1966  ubt1967  ubt1968  ubt1969  ubt1970  
		ubt1971  ubt1972  ubt1973  ubt1974  ubt1975 
		ubt1976  ubt1977  ubt1978  ubt1979	ubt1980
		ubt1981  ubt1982  ubt1983  ubt1984  ubt1985 
		ubt1986  ubt1987  ubt1988  ubt1989  ubt1990 
		
		ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 ) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N Ftest1 P1 Ftest2 P2, labels("Adj. R-Square" "Observations" "F-test 1" "" "F-test 2" "")) replace ;
 #delimit cr


*==========================================
* Columns  6: Factory wages
*==========================================
eststo clear

forvalues i = 1965(1)1990 {
*------------------------------
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubdum77 ubt90 ubdum90 ubt`i' ubdum`i' "

*------------------------------
quietly reg lsalpw $main $controls stdum* yrdum*, cluster(state)

		quietly test ubt61+ubt`i' = 0
		local F1 = r(F)
		local p1 = r(p)
		quietly test ubt61+ubt77+ubt`i'+ubt90=0

quietly	eststo, add(Ftest1 `F1'  P1  `p1' Ftest2 r(F)  P2 r(p) )

/*
outreg2 using "table_2_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/
}


# delimit;
 esttab using "table_26.tex", 
 keep ( ubt61 	 ubt77 	  ubdum77  ubt90 	ubdum90
	
		ubt1965  
		ubt1966  ubt1967  ubt1968  ubt1969  ubt1970  
		ubt1971  ubt1972  ubt1973  ubt1974  ubt1975 
		ubt1976  ubt1977  ubt1978  ubt1979	ubt1980
		ubt1981  ubt1982  ubt1983  ubt1984  ubt1985 
		ubt1986  ubt1987  ubt1988  ubt1989  ubt1990 
		
		ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 ) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N Ftest1 P1 Ftest2 P2, labels("Adj. R-Square" "Observations" "F-test 1" "" "F-test 2" "")) replace ;
 #delimit cr
 
 

*==========================================

*==========================================



















*==========================================
*
*Table 3: Bank Branch Expansion and Poverty: Instrumental Variables Evidence
*
*==========================================

*Column 1: OLS with one regressor: 
*Number branches opened in rural unbanked locations per capita
*----------------------------------------------------------------
// quietly reg h1 runbfor stdum* yrdum*, cluster(state)


*==========================================
*Column 2: OLS with additional controls 
*==========================================
// eststo clear
//
// forvalues i = 1965(1)1990  {
// *------------------------------
// macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"
//
// macro define main "ubt61 ubt77 ubt`i' ubt90  ubdum77 ubdum`i' ubdum90"
//
// macro define iv "ubt61 ubdum77 ubdum90 ubdum`i' "
// *------------------------------
//
// eststo: quietly reg h1 runbfor $iv $controls  stdum* yrdum*, cluster(state)
//
// }
//
// # delimit;
//  esttab using "table_32.tex", 
//  keep ( runbfor ubt61  	  ubdum77   	ubdum90
//
// 		ubdum1965
// 		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
// 		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
// 		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
// 		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
// 		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 ) 	
//  cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
//  stats(r2_a N , labels("Adj. R-Square" "Observations")) replace ;
//  #delimit cr

*==========================================
*Column 3  - IV: Rural Headcount Ratio 
*==========================================
eststo clear

forvalues i = 1965(1)1990 {
*------------------------------
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubt`i' ubt90  ubdum77 ubdum`i' ubdum90"

macro define iv "ubt61 ubdum77 ubdum90 ubdum`i' "
*------------------------------
eststo:  quietly reg h1  runbfor $iv $controls stdum* yrdum* ///
($main $controls stdum* yrdum* ), cluster(state)

/*
outreg2 using "table_3_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/

}

# delimit;
 esttab using "table_33.tex", 
 keep ( runbfor ubt61  	  ubdum77   	ubdum90 
		ubdum1965
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 ) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N , labels("Adj. R-Square" "Observations")) replace ;
 #delimit cr

*==========================================
*Column 4   - IV: Urban Headcount Ratio 
*==========================================
eststo clear

forvalues i = 1965(1)1990 {
*------------------------------
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubt`i' ubt90  ubdum77 ubdum`i' ubdum90"

macro define iv "ubt61 ubdum77 ubdum90 ubdum`i' "
*------------------------------

eststo: quietly reg h2  runbfor $iv $controls stdum* yrdum* ///
($main $controls stdum* yrdum* ), cluster(state)

/*
outreg2 using "table_3_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/
}

# delimit;
 esttab using "table_34.tex", 
 keep ( runbfor ubt61  	  ubdum77   	ubdum90

		ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 ) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N , labels("Adj. R-Square" "Observations")) replace ;
 #delimit cr
 
*==========================================
*Column 5  - IV: Aggraget Headcount Ratio 
*==========================================
eststo clear

forvalues i = 1965(1)1990 {
*------------------------------
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubt`i' ubt90  ubdum77 ubdum`i' ubdum90"

macro define iv "ubt61 ubdum77 ubdum90 ubdum`i' "
*------------------------------

eststo: quietly reg head  runbfor $iv $controls stdum* yrdum* ///
($main $controls stdum* yrdum* ), cluster(state)

/*
outreg2 using "table_3_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/

}

# delimit;
 esttab using "table_35.tex", 
 keep ( runbfor ubt61  	  ubdum77   	ubdum90

		ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 ) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N , labels("Adj. R-Square" "Observations")) replace ;
 #delimit cr

*==========================================

*Columns 6, 7, 8 -- restricted sample for h1 

*==========================================

*==========================================
*column 6, earlier then 1990
*==========================================

eststo clear

forvalues i = 1965(1)1990 {
*------------------------------
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubt`i' ubt90  ubdum77 ubdum`i' ubdum90"

macro define iv "ubt61 ubdum77 ubdum90 ubdum`i' "
*------------------------------

eststo: quietly reg h1 runbfor $iv $controls stdum* yrdum* /// 
($main $controls stdum* yrdum* ) if year < 1990, cluster(state)

/*
outreg2 using "table_3_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/
}

# delimit;
 esttab using "table_36.tex", 
 keep ( runbfor ubt61  	  ubdum77   	ubdum90

		ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 ) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N , labels("Adj. R-Square" "Observations")) replace ;
 #delimit cr

*==========================================
*column 7, earlier then treatment year (BP05 1976)
*==========================================
eststo clear

forvalues i = 1965(1)1990 {
*------------------------------
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubt`i' ubt90  ubdum77 ubdum`i' ubdum90"

macro define iv "ubt61 ubdum77 ubdum90 ubdum`i' "
*------------------------------

eststo: quietly reg h1 runbfor $iv $controls  stdum* yrdum* ///
($main  $controls stdum* yrdum* ) if year > 1976, cluster(state)

/*
outreg2 using "table_3_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/
}

# delimit;
 esttab using "table_37.tex", 
 keep ( runbfor ubt61  	  ubdum77   	ubdum90

		ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 ) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N , labels("Adj. R-Square" "Observations")) replace ;
 #delimit cr


*==========================================
*column 8: survey years
*==========================================
eststo clear

forvalues i = 1965(1)1990 {
*------------------------------
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubt`i' ubt90  ubdum77 ubdum`i' ubdum90"

macro define iv "ubt61 ubdum77 ubdum90 ubdum`i' "
*------------------------------

eststo: quietly reg h1 runbfor $iv  $controls stdum* yrdum* ///
($main  $controls stdum* yrdum* ) if round~=.,cluster(state)

/*
outreg2 using "table_3_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/
}

# delimit;
 esttab using "table_38.tex", 
 keep ( runbfor ubt61  	  ubdum77   	ubdum90

		ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 ) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N , labels("Adj. R-Square" "Observations")) replace ;
 #delimit cr
 
 
*==========================================
*Column 9. IV: Agricultural wages
*==========================================
eststo clear

forvalues i = 1965(1)1990 {
*------------------------------
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubt`i' ubt90  ubdum77 ubdum`i' ubdum90"

macro define iv "ubt61 ubdum77 ubdum90 ubdum`i' "
*------------------------------

eststo: quietly reg lrwagenew  runbfor $iv $controls stdum* yrdum* ///
($main $controls stdum* yrdum* ), cluster(state)


/*
outreg2 using "table_3_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/
}

# delimit;
 esttab using "table_39.tex", 
 keep ( runbfor ubt61  	  ubdum77   	ubdum90

		ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 ) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N , labels("Adj. R-Square" "Observations")) replace ;
 #delimit cr
 
*==========================================
*Column 10.  - IV: Factory wages
*==========================================
eststo clear

forvalues i = 1965(1)1990 {
*------------------------------
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubt`i' ubt90  ubdum77 ubdum`i' ubdum90"

macro define iv "ubt61 ubdum77 ubdum90 ubdum`i' "
*------------------------------

eststo: quietly reg lsalpw  runbfor $iv $controls stdum* yrdum* ///
($main $controls stdum* yrdum* ), cluster(state)

/*
outreg2 using "table_3_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/
}

# delimit;
 esttab using "table_310.tex", 
 keep ( runbfor ubt61  	  ubdum77   	ubdum90

		ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 ) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N , labels("Adj. R-Square" "Observations")) replace ;
 #delimit cr











*=============================================
*
*Table 4: Rural credit and Savings and Poverty: Instrumental Variables Evidence
*
*=============================================



*==========================================
*Column 1. Rural Headcount Ratio -- with Rural bank credit share
*==========================================
eststo clear

forvalues i = 1965(1)1990 {
*------------------------------
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubt`i' ubt90  ubdum77 ubdum`i' ubdum90"

macro define iv "ubt61 ubdum77 ubdum90 ubdum`i' "
*------------------------------

eststo: quietly reg h1 rurcrsh $iv $controls stdum* yrdum* ///
($main $controls stdum* yrdum* ), cluster(state)

/*
outreg2 using "table_4_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/
}

# delimit;
 esttab using "table_41.tex", 
 keep (rurcrsh ubt61  	  ubdum77   	ubdum90

		ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 ) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N , labels("Adj. R-Square" "Observations")) replace ;
 #delimit cr
 
 
*==========================================
*Column 2. Rural Headcount Ratio -- with Rural bank savings share
*==========================================
eststo clear

forvalues i = 1965(1)1990 {
*------------------------------
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubt`i' ubt90  ubdum77 ubdum`i' ubdum90"

macro define iv "ubt61 ubdum77 ubdum90 ubdum`i' "
*------------------------------

eststo: quietly reg h1 rursavsh $iv $controls stdum* yrdum* ///
($main $controls stdum* yrdum* ), cluster(state)


/*
outreg2 using "table_4_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/
}

# delimit;
 esttab using "table_42.tex", 
 keep (rursavsh  ubt61  	  ubdum77   	ubdum90

		ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 ) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N , labels("Adj. R-Square" "Observations")) replace ;
 #delimit cr
 
*==========================================
*Columns 3. Urban Headcount Ratio -- with Rural bank credit share
*==========================================
eststo clear

forvalues i = 1965(1)1990 {
*------------------------------
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubt`i' ubt90  ubdum77 ubdum`i' ubdum90"

macro define iv "ubt61 ubdum77 ubdum90 ubdum`i' "
*------------------------------

eststo: quietly reg h2 rurcrsh $iv $controls stdum* yrdum* ///
($main  $controls stdum* yrdum* ), cluster(state)

/*
outreg2 using "table_4_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/
}

# delimit;
 esttab using "table_43.tex", 
 keep ( rurcrsh ubt61  	  ubdum77   	ubdum90

		ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 ) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N , labels("Adj. R-Square" "Observations")) replace ;
 #delimit cr
 

*==========================================
*Column 4. Urban Headcount Ratio -- with Rural bank savings share
*==========================================
eststo clear

forvalues i = 1965(1)1990 {
*------------------------------
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubt`i' ubt90  ubdum77 ubdum`i' ubdum90"

macro define iv "ubt61 ubdum77 ubdum90 ubdum`i' "
*------------------------------

eststo: quietly reg h2 rursavsh $iv $controls stdum* yrdum*  ///
($main $controls stdum* yrdum* ), cluster(state)

/*
outreg2 using "table_4_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/

}

# delimit;
 esttab using "table_44.tex", 
 keep ( rursavsh ubt61  	  ubdum77   	ubdum90

		ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 ) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N , labels("Adj. R-Square" "Observations")) replace ;
 #delimit cr
 
 

*==========================================
*Column 5. Aggregate Headcount Ratio -- with Rural bank credit share
*==========================================
eststo clear

forvalues i = 1965(1)1990 {
*------------------------------
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubt`i' ubt90  ubdum77 ubdum`i' ubdum90"

macro define iv "ubt61 ubdum77 ubdum90 ubdum`i' "
*------------------------------

eststo: quietly reg head rurcrsh $iv $controls stdum* yrdum* ///
($main  $controls stdum* yrdum* ), cluster(state)

/*
outreg2 using "table_4_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/
}

# delimit;
 esttab using "table_45.tex", 
 keep ( rurcrsh ubt61  	  ubdum77   	ubdum90

		ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 ) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N , labels("Adj. R-Square" "Observations")) replace ;
 #delimit cr
 
 
*==========================================
*Columns 6. Aggregate Headcount Ratio -- with Rural bank savings share
*==========================================
eststo clear

forvalues i = 1965(1)1990 {
*------------------------------
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubt`i' ubt90  ubdum77 ubdum`i' ubdum90"

macro define iv "ubt61 ubdum77 ubdum90 ubdum`i' "
*------------------------------

eststo: quietly reg head rursavsh $iv $controls stdum* yrdum*  ///
($main $controls stdum* yrdum* ), cluster(state)

/*
outreg2 using "table_4_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/
}


# delimit;
 esttab using "table_46.tex", 
 keep ( rursavsh ubt61  ubdum77   	ubdum90

		ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 ) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N , labels("Adj. R-Square" "Observations")) replace ;
 #delimit cr






















*==========================================
*
*Table 5: Bank Branch Expansion And Poverty Reduction: Robustness Checks
*
*==========================================



*==========================================
*Column 1. Rural Headcount Ratio -- with policy variables
*==========================================
eststo clear

macro define policy "clre hcapsh2 odevsh2"
macro define politics "pcona pjan phdlft preg phind"

forvalues i = 1965(1)1990 {
*------------------------------
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubt`i' ubt90  ubdum77 ubdum`i' ubdum90"

macro define iv "ubt61 ubdum77 ubdum90 ubdum`i' "
*------------------------------

eststo: quietly reg h1  runbfor  $policy $iv $controls stdum* yrdum* ///
($policy $main $controls stdum* yrdum* ), cluster(state)

/*
outreg2 using "table_5_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/
}


# delimit;
 esttab using "table_51.tex", 
 keep ( runbfor ubt61  ubdum77   	ubdum90

		ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 
		$policy
		) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N , labels("Adj. R-Square" "Observations")) replace ;
 #delimit cr
*==========================================
*Column 2. Rural Headcount Ratio -- with policy and political variables 
*==========================================
eststo clear

macro define policy "clre hcapsh2 odevsh2"
macro define politics "pcona pjan phdlft preg phind"
forvalues i = 1965(1)1990 {
*------------------------------
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubt`i' ubt90  ubdum77 ubdum`i' ubdum90"


macro define iv "ubt61 ubdum77 ubdum90 ubdum`i' "
*------------------------------

eststo: quietly reg h1 runbfor $policy  $politics $iv $controls stdum* yrdum* ///
($policy $politics $main $controls stdum* yrdum* ), cluster(state)

/*
outreg2 using "table_5_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/
}

# delimit;
 esttab using "table_52.tex", 
 keep ( runbfor ubt61  	  ubdum77   	ubdum90

		ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 
		$policy  $politics ) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N , labels("Adj. R-Square" "Observations")) replace ;
 #delimit cr
*==========================================
*Column 3. Urban Headcount Ratio -- with policy variables
*==========================================
eststo clear

macro define policy "clre hcapsh2 odevsh2"
macro define politics "pcona pjan phdlft preg phind"
forvalues i = 1965(1)1990 {
*------------------------------
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubt`i' ubt90  ubdum77 ubdum`i' ubdum90"

macro define iv "ubt61 ubdum77 ubdum90 ubdum`i' "
*------------------------------

eststo: quietly reg h2  runbfor $policy  $iv $controls stdum* yrdum* ///
($policy $main $controls stdum* yrdum* ), cluster(state)

/*
outreg2 using "table_5_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/
}

# delimit;
 esttab using "table_53.tex", 
 keep ( runbfor ubt61  	  ubdum77   	ubdum90

		ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 
		 $policy ) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N , labels("Adj. R-Square" "Observations")) replace ;
 #delimit cr
 
 
*==========================================
*Column 4. Urban Headcount Ratio -- with policy and political variables 
*==========================================
eststo clear

macro define policy "clre hcapsh2 odevsh2"
macro define politics "pcona pjan phdlft preg phind"
forvalues i = 1965(1)1990 {
*------------------------------
macro define controls "popt61 popt77 popd77 popt`i' popd`i' popt90 popdum90 rursht61 rursht77 rurshd77 rursht`i' rurshd`i' rursht90 rurshd90 stint61 stint77 stin77d stint`i' stind`i' stint90 stindum90"

macro define main "ubt61 ubt77 ubt`i' ubt90  ubdum77 ubdum`i' ubdum90"

macro define iv "ubt61 ubdum77 ubdum90 ubdum`i' "
*------------------------------

eststo: quietly reg h2 runbfor $policy $politics $iv $controls stdum* yrdum* ///
($policy $politics $main $controls stdum* yrdum* ), cluster(state)

/*
outreg2 using "table_5_`i'.txt", se ///
addtext(State and year dummies, YES, Other controls, YES) ///
keep($main) ///
addstat(F-test 1,`F1', P1 , `p1', F-test 2,  `r(F)', P2, `r(p)') ///
coefastr paren bdec(2) adjr2 symbol(***, **, *) nocons   replace
*/
}

# delimit;
 esttab using "table_54.tex", 
 keep ( runbfor ubt61  	  ubdum77   	ubdum90

		ubdum1965  
		ubdum1966  ubdum1967  ubdum1968  ubdum1969  ubdum1970  
		ubdum1971  ubdum1972  ubdum1973  ubdum1974  ubdum1975 
		ubdum1976  ubdum1977  ubdum1978  ubdum1979  ubdum1980
		ubdum1981  ubdum1982  ubdum1983  ubdum1984  ubdum1985 
		ubdum1986  ubdum1987  ubdum1988  ubdum1989  ubdum1990 
		$policy $politics) 	
 cells(b(star fmt(3)) se(par fmt(2))) star(* 0.10 ** 0.05 *** 0.01)
 stats(r2_a N , labels("Adj. R-Square" "Observations")) replace ;
 #delimit cr
*-------------------------------
