/* 
 THIS SAS PROGRAM READS MARCH 1986 CURRENT POPULATION SURVEY
 AND PULLS MICRO DATA.
*/ 
LIBNAME SCR '/tmp'; 
OPTIONS LS=80; 
/* OPTIONS OBS=4000; */

FILENAME CPSMAR86 '/tmp/cps86.dat';
 
DATA SCR.CPS86fm; 
 
TITLE1 'MARCH 1986 CPS DATA FOR ALL WOMEN 16-70 YEARS OF AGE';
TITLE2 'CPS DATA COPIED FROM TAPE CPS86 (KEVIN MURPHY)'; 

INFILE CPSMAR86 LRECL=408; 
 
LENGTH 
/* For the household record: */ 
type         3
region       3
division     3 
state        3
mprank       3
msasize      3 
msmsa        3 
numfam       3
numpers      3
/* For the family record: */ 
ftype        3 
fnumper      3
fincws       8
fincse       8
fincfr       8
fincus       8
finctot      8 
fincearn     8 
fincoth      8 
fam18t64     3 
fam65ovr     3 
chld15       3 
chld12       3 
chld9        3 
chld6        3 
chld5        3 
chld3        3 
chld1        3 
chldygst     3
chldolst     3
fundr18      3 
fam5t17      3 
faminlf      3 
famearnr     3 
FAMSRINC     3
/* For the person record: */ 
esr          3 
fullpart     3 
actlw        3 
hrwrklw      3
uhwov35      3 
lwrk2wks     3 
industry     4
occup        4
class        3 
lstwrpay     3 
wantrj       3 
popstat      3 
famrel       3 
marstat      3 
sex          3 
race         3 
age          3
highgrad     3
gradecom     3 
wkslook      3
wkwrkly      3
numempl      3 
hrwkly       3
wknotwrk     3
wkpartim     3
class_ly     3 
ind_ly       4
occ_ly       4
incwgsal     6
incse        7
incfarm      7
inctot       8
incearn      8
incoth       8
rempsta      3 
rwewkrs      3 
rpyrsn       3 
migreg       3 
ruacplds     3 
spouse       3 
rpsinc1      3
stately      3
RES_RES      3
hrswork      3
earnweek     4
paidhour     3 
earnhour     5
UNION        3 
ZZZ          3; 
     
 *START OF LOOP;         
     
INPUT TYPE 7-8 @; 
NEXTHH: ;

IF TYPE GT 0 AND TYPE LT 41 THEN DO;
    GO TO NEXTPER;
    END;
 
ELSE IF TYPE GE 41 THEN DO;
    GO TO NEXTFAM;
    END;
  
 ELSE DO;
    *READ HOUSEHOLD RECORD;
 
    INPUT numpers 9-10 numfam 11-12 region 37 division 38 state 39-40
          mprank 43-44 msasize 55 msmsa 49;
  
    DO IFAM=1 TO NUMFAM;
      INPUT TYPE 7-8 @;
      NEXTFAM:;
      IF TYPE = 0 THEN DO;
           GO TO NEXTHH;
           END;
      ELSE IF TYPE GT 0 AND TYPE LT 41 THEN DO; 
           GO TO NEXTPER; 
           END; 
    *READ FAMILY RECORD; 
 
      ELSE INPUT ftype 10 fnumper 11-12 fincws 20-27 fincse 28-34 
                 fincfr 35-41 fincus 42-49 finctot 105-113 fincearn 114-122
                 fincoth 123-131 fam18t64 148 fam65ovr 149 chld15 154 
                 chld12 155 chld9 156 chld6 157 chld5 158 chld3 159 chld1 160
                 chldygst 161-162 chldolst 163-164 fundr18 165 fam5t17 166
                 faminlf 167 famearnr 169 FAMSRINC 194-195; 
 
      DO IP = 1 TO FNUMPER;   /* LOOP OVER PERSONS IN FAMILY */ 
 
         NEXTPER:;   /*KLUGE: IN CASE OF BAD REC STRUCTURE */ 
 
         INPUT TYPE 7-8 sex 108 AGE 110-111 @; 
 
         IF TYPE =0 THEN DO; 
           GO TO NEXTHH ; 
           END; 
 
         ELSE IF TYPE > 39 THEN DO; 
           IFAM=IFAM+1; 
           GO TO NEXTFAM; 
           END; 
 
         ELSE IF 15<AGE<71 and sex>1 THEN DO; 
           INPUT esr 12 fullpart 14 actlw 15 hrwrklw 16-17 uhwov35 23
           lwrk2wks 48 industry 49-51 occup 56-58 class 59 lstwrpay 60
           wantrj 62 popstat 102 famrel 106 marstat 107 sex 108
           race 109 age 110-111 highgrad 115-116 gradecom 117 
           wkslook 131-132 wkwrkly 134-135 hrwkly 136-137 numempl 138
           wknotwrk 142-143 wkpartim 147-148 class_ly 150 ind_ly 151-153
           occ_ly 154-156 incwgsal 191-195 incse 196-201 incfarm 202-207
           inctot 248-254 incearn 255-261 incoth 262-268 rempsta 296
           rwewkrs 309 rpyrsn 312 migreg 329 ruacplds 330 spouse 335
           rpsinc1 326-327 stately 337-338 RES_RES 341-342 hrswork 362-363
           earnweek 369-371 paidhour 364 earnhour 365-368 UNION 387 ZZZ 90; 
           END; 
           ELSE DO; 
           INPUT; 
           GO TO NEXTPER; 
           END; 
 
           WEIGHT=WEIGHT/100;
 
      DROP TYPE IP IFAM; 
 
         OUTPUT; 
 
      END;  /* END OF PERSON LOOP*/ 
    END;  /* END OF FAMILY LOOP*/ 
END;  /* END OF HOUSEHOLD LOOP */ 
 
PROC CONTENTS DATA = SCR.CPS86fm; 
PROC FREQ DATA = SCR.CPS86fm; TABLES RACE; 
PROC FREQ DATA = SCR.CPS86fm; TABLES AGE;
PROC MEANS DATA = SCR.CPS86fm; 
/* 
