/* 
 THIS SAS PROGRAM READS MARCH 1979 CURRENT POPULATION SURVEY
 AND PULLS MICRO DATA.
*/ 
LIBNAME SCR '/otel1e/cpstemp'; 
OPTIONS LS=80; 
/* OPTIONS OBS=4000; */

FILENAME CPSMAR79 '/otel1e/cpstemp/cps79.dat';
 
DATA SCR.CPS79fm; 
 
TITLE1 'MARCH 1979 CPS DATA FOR ALL WOMEN 16-70 YEARS OF AGE';
TITLE2 'CPS DATA COPIED FROM TAPE CPS79 (KEVIN MURPHY)'; 

INFILE CPSMAR79 LRECL=343; 
 
LENGTH 
/* For the household record: */ 
type         3
region       3
division     3 
state        3
mprank       3
msasize      3 
msmsa        3 
numfam       3
numpers      3
/* For the family record: */ 
ftype        3 
fnumper      3
fincws       8
fincse       8
fincfr       8
fincus       8
finctot      8 
fincearn     8 
fincoth      8 
fam18t64     3 
fam65ovr     3 
chld15       3 
chld12       3 
chld9        3 
chld6        3 
chld5        3 
chld3        3 
chld1        3 
chldygst     3
chldolst     3
fundr18      3 
fam5t17      3 
faminlf      3 
famearnr     3 
FAMSRINC     3
/* For the person record: */ 
esr          3 
fullpart     3 
actlw        3 
hrwrklw      3
uhwov35      3 
lwrk2wks     3 
industry     4
occup        4
class        3 
lstwrpay     3 
wantrj       3 
popstat      3 
famrel       3 
marstat      3 
sex          3 
race         3 
age          3
weight       8 
highgrad     3
gradecom     3 
wkslook      3
wkwrkly      3
numempl      3 
hrwkly       3
wknotwrk     3
wkpartim     3
class_ly     3 
ind_ly       4
occ_ly       4
incwgsal     6
incse        7
incfarm      7
inctot       8
incearn      8
incoth       8
rempsta      3 
rwewkrs      3 
rpyrsn       3 
migreg       3 
ruacplds     3 
spouse       3 
rpsinc1      3
stately      3
RES_RES      3
hrswork      3
earnweek     4
paidhour     3 
earnhour     5
UNION        3 
ZZZ          3; 
     
 *START OF LOOP;         
     
INPUT TYPE 7-8 @; 
NEXTHH: ;

IF TYPE GT 0 AND TYPE LT 41 THEN DO;
    GO TO NEXTPER;
    END;
 
ELSE IF TYPE GE 41 THEN DO;
    GO TO NEXTFAM;
    END;
  
 ELSE DO;
    *READ HOUSEHOLD RECORD;
 
    INPUT numpers 9-10 numfam 11-12 hhtype 13 region 37 division 38 
          state 39-40 stofres 41-42 mprank 43-44 msmsa 49 msasize 51 
          hhstatus 69;
  
    DO IFAM=1 TO NUMFAM;
      INPUT TYPE 7-8 @;
      NEXTFAM:;
      IF TYPE = 0 THEN DO;
           GO TO NEXTHH;
           END;
      ELSE IF TYPE GT 0 AND TYPE LT 41 THEN DO; 
           GO TO NEXTPER; 
           END; 
    *READ FAMILY RECORD; 
 
      ELSE INPUT fkind 9 ftype 10 fnumper 11-12 fincws 20-27 fincse 28-34 
                 fincfr 35-41 fincus 42-49 fincsp 50-57 fincpa 58-65 
                 fincint 66-73 fincdiv 74-80 fincvet 81-88 fincret 89-96 
                 fincchld 97-104 finctot 105-113 fincearn 114-122
                 fincoth 123-131 fdescrip 146 chldprnt 147 fam18t64 148
                 fam65ovr 149 chldun18 150 chld 151 chld25 152 chld18 153
                 chld15 154 chld12 155 chld9 156 chld6 157 chld5 158 
                 chld3 159 chld1 160 chldygst 161-162 chldolst 163-164
                 fundr18 165 fam5t17 166 faminlf 167 famearnr 169 
                 fprctcut 179-180 FAMSRINC 194-195; 
 
      DO IP = 1 TO FNUMPER;   /* LOOP OVER PERSONS IN FAMILY */ 
 
         NEXTPER:;   /*KLUGE: IN CASE OF BAD REC STRUCTURE */ 
 
         INPUT TYPE 7-8 sex 108 AGE 110-111 @; 
 
         IF TYPE =0 THEN DO; 
           GO TO NEXTHH ; 
           END; 
 
         ELSE IF TYPE > 39 THEN DO; 
           IFAM=IFAM+1; 
           GO TO NEXTFAM; 
           END; 
 
         ELSE IF 15<AGE<71 and sex>1 THEN DO; 
           INPUT fmkey 10 subfkey 11 esr 12 explf 13 fullpart 14 actlw 15
           hrwrklw 16-17 uhwov35 23 lookpt 45 lwrk2wks 48 industry 49-51
           occup 56-58 class 59 lstwrpay 60 whylstj 61 wantrj 62 lkintend 63
           weight 91-101 popstat 102 relhead 103 typebox 104 famrel 106
           marstat 107 sex 108 race 109 age 110-111 highgrad 115-116 
           gradecom 117 lookwrly 130 reasnwly 133 wkslook 131-132 reasnwly 133
           wkwrkly 134-135 hrwkly 136-137 numempl 138 wknotwrk 142-143
           wkpartim 147-148 class_ly 150 ind_ly 151-153 occ_ly 154-156
           incwgsal 191-195 incse 196-201 incfarm 202-207 incssrr 208-211
           incsups 212-215 incpuas 216-220 incint 221-225 incdiv 226-231
           incvtwm 232-236 incpen 237-241 incalch 242-246 inctot 247-253
           incearn 254-260 incoth 261-267 RES_RES 287-288 rempsta 296
           relhhr1 297-298 relhhr2 299 rwewkrs 309 rpyrsn 312
           rearner 313 rpsinc1 326-327 migreg 329 ruacplds 330;
           END; 
           ELSE DO; 
           INPUT; 
           GO TO NEXTPER; 
           END; 
 
           WEIGHT=WEIGHT/100;
 
      DROP TYPE IP IFAM; 
 
         OUTPUT; 
 
      END;  /* END OF PERSON LOOP*/ 
    END;  /* END OF FAMILY LOOP*/ 
END;  /* END OF HOUSEHOLD LOOP */ 
 
PROC CONTENTS DATA = SCR.CPS79fm; 
PROC FREQ DATA = SCR.CPS79fm; TABLES RACE; 
PROC FREQ DATA = SCR.CPS79fm; TABLES AGE;
PROC FREQ DATA = SCR.CPS79fm; TABLES WKWRKLY;
PROC MEANS DATA = SCR.CPS79fm; 
/* 
