/* 
 THIS SAS PROGRAM READS MARCH 1968 CURRENT POPULATION SURVEY
 AND PULLS MICRO DATA.
*/ 
LIBNAME SCR '/otel1e/cpstemp'; 
OPTIONS LS=80; 
/* OPTIONS OBS=4000; */

FILENAME CPSMAR68 '/otel1e/cpstemp/cps68.dat';
 
DATA SCR.CPS68fmb; 
 
TITLE1 'MARCH 1968 CPS DATA FOR ALL WOMEN 16-70 YEARS OF AGE';
TITLE2 'CPS DATA COPIED FROM TAPE CPS68 (KEVIN MURPHY)'; 

INFILE CPSMAR68 LRECL=216 END=LASTREC; 
 
/* LENGTH */
/* For the household record: */ 
/* For the family record: */ 
/* For the person record: */ 

serialno=0;

 *START OF LOOP;         
     
startr:;

INPUT TYPE 1 TYPEFAM 27-28 @; 
NEXTFAM: ;

IF TYPE LT 4 THEN GO TO NEXTPER;
IF TYPEFAM EQ 4 THEN DO;
   INPUT;
   GO TO NEXTPER;
END;

ELSE DO;
    *READ FAMILY RECORD;
    serialno=serialno+1;
 
    INPUT NUMREC 35-36 FAMSIZE 53-54 CHLD 59-60;
    CHLD6=0;
    CHLDYGST=999;
    CHLDOLST=0;
    FNUMPER=MAX(NUMREC,FAMSIZE);

    IPEND=FNUMPER+2;
    DO IP=1 TO IPEND;
      NEXTPER:;
      INPUT TYPE 1 TYPEFAM 27-28 @;
      IF TYPE = 4 THEN DO;
         IF TYPEFAM NE 4 THEN DO;
         IF CHLDYGST EQ 999 THEN CHLDYGST=0;
         I=1;
         DROP TYPE IPEND IP AGE RELFAMR TYPE TYPEFAM NUMREC FAMSIZE;
         OUTPUT; 
         GO TO NEXTFAM;
         END;
      ELSE GO TO NEXTFAM;
      END;
      ELSE DO; 
      INPUT  AGE 29-30 RELFAMR 43-44;
      IF 2 < RELFAMR < 6 THEN DO;
         IF AGE<6 THEN CHLD6=CHLD6+1;
         IF AGE>CHLDOLST THEN CHLDOLST=AGE;
         IF AGE<CHLDYGST THEN CHLDYGST=AGE;
      END;
      IF LASTREC EQ 1 THEN GO TO FINISH;
      END;

      END;  /* END OF PERSON LOOP*/ 

      IF CHLDYGST EQ 999 THEN CHLDYGST=0;
      I=2;
      DROP TYPE IPEND IP AGE RELFAMR TYPE TYPEFAM NUMREC FAMSIZE;
      OUTPUT; 
 
    END;  /* END OF FAMILY LOOP*/ 
go to startr;

GO TO FINISHB;

FINISH:;
  IF CHLDYGST EQ 999 THEN CHLDYGST=0;
  I=3;
  DROP TYPE IPEND IP AGE RELFAMR TYPE TYPEFAM NUMREC FAMSIZE;
  OUTPUT; 

FINISHB:; 

PROC CONTENTS DATA = SCR.CPS68fmb; 
PROC MEANS DATA = SCR.CPS68fmb; 
/* 
