/* Bretteville-Jensen, A.L. and Jacobi, L. */
/* "Climbing the Drug Staircase: A Bayesian Analysis of the Initiation of Hard Drug Use" */
/* Journal of Applied Econometrics */


/* Program by Anne Line Bretteville Jensen */


*/Data manipulation for the SIRUS survey of young adults aged 21-30*/

/*Culture*/
gen western1=1
replace western1=0 if v046==3
replace western1=0 if v046==4

gen western2=1
replace western2=0 if v047==3
replace western2=0 if v047==4

gen western3=1
replace western3=0 if v048==3
replace western3=0 if v048==4

gen western4=min(western2, western3)



/*data correction*/
replace v123=0 if v123==3

/*selection variable*/
gen oslodum=0
replace oslodum=1 if v239==0
replace oslodum=1 if v239==1
*drop if oslodum==0


/*dependent variables*/

replace v093=1 if v093==11

gen canfreq1=0
replace canfreq1=1 if v093>1

gen canfreq2=0
replace canfreq2=1 if v093>2
 
gen canfreq3=0
replace canfreq3=1 if v093>3

gen canfreq4=0
replace canfreq4=1 if v093>4

gen canfreq5=0
replace canfreq5=1 if v093>5

gen amfdum1=0
replace amfdum1=1 if v082==1
replace amfdum1=1 if v083==1

gen herodum1=0
replace herodum1=1 if v089==1
replace herodum1=1 if v090==1

gen cocadum1=0
replace cocadum1=1 if v085==1
replace cocadum1=1 if v086==1

gen amfmax=max(v094,v095)
gen cocamax=max(v097,v098)
gen heromax=max(v101,v102)
gen emax=v096
gen maxhard=max(amfmax,cocamax,heromax,emax)
replace maxhard=1 if maxhard==11

**new dependent variables***

gen maxnew1=max(amfmax,cocamax,heromax)
replace maxnew1=1 if maxnew1==11

gen hfreq1=0
replace hfreq1=1 if maxnew1>1
gen hfreq2=0
replace hfreq2=1 if maxnew1>2
gen hfreq3=0
replace hfreq3=1 if maxnew1>3
gen hfreq4=0
replace hfreq4=1 if maxnew1>4
gen hfreq5=0
replace hfreq5=1 if maxnew1>5


replace amfmax=1 if amfmax==11

gen afreq1=0
replace afreq1=1 if amfmax>1
gen afreq2=0
replace afreq2=1 if amfmax>2
gen afreq3=0
replace afreq3=1 if amfmax>3
gen afreq4=0
replace afreq4=1 if amfmax>4
gen afreq5=0
replace afreq5=1 if amfmax>5


replace heromax=1 if heromax==11

gen herofreq1=0
replace herofreq1=1 if heromax>1
gen herofreq2=0
replace herofreq2=1 if heromax>2
gen herofreq3=0
replace herofreq3=1 if heromax>3
gen herofreq4=0
replace herofreq4=1 if heromax>4
gen herofreq5=0
replace herofreq5=1 if heromax>5


replace cocamax=1 if cocamax==11

gen cofreq1=0
replace cofreq1=1 if cocamax>1
gen cofreq2=0
replace cofreq2=1 if cocamax>2
gen cofreq3=0
replace cofreq3=1 if cocamax>3
gen cofreq4=0
replace cofreq4=1 if cocamax>4
gen cofreq5=0
replace cofreq5=1 if cocamax>5


replace emax=1 if emax==11

gen efreq1=0
replace efreq1=1 if emax>1
gen efreq2=0
replace efreq2=1 if emax>2
gen efreq3=0
replace efreq3=1 if emax>3
gen efreq4=0
replace efreq4=1 if emax>4
gen efreq5=0
replace efreq5=1 if emax>5



gen harfreq1=0
replace harfreq1=1 if maxhard>1
gen harfreq2=0
replace harfreq2=1 if maxhard>2
gen harfreq3=0
replace harfreq3=1 if maxhard>3
gen harfreq4=0
replace harfreq4=1 if maxhard>4
gen harfreq5=0
replace harfreq5=1 if maxhard>5

gen harfreq=0
*replace harfreq=1 if maxhard>1
replace harfreq=1 if maxhard>2
replace harfreq=0 if maxhard==11

gen canfreq=0
*replace canfreq=1 if v093>1
replace canfreq=1 if v093>2



***use of drug the previous 6 month***

gen can6use=0
replace can6use=1 if v105>1

gen amf6use=0
replace amf6use=1 if v106>1
replace amf6use=1 if v107>1

gen coca6use=0
replace coca6use=1 if v109>1
replace coca6use=1 if v110>1

gen e6use=0
replace e6use=1 if v108>1

gen hero6use=0
replace hero6use=1 if v113>1
replace hero6use=1 if v114>1

gen hard6use=max(hero6use,e6use,amf6use,coca6use)


***Used drugs more than 26 times during the previous 6 months***

gen can6use4=0
replace can6use4=1 if v105>4

gen amf6use4=0
replace amf6use4=1 if v106>4
replace amf6use4=1 if v107>4

gen coca6use4=0
replace coca6use4=1 if v109>4
replace coca6use4=1 if v110>4

gen e6use4=0
replace e6use4=1 if v108>4

gen hero6use4=0
replace hero6use4=1 if v113>4
replace hero6use4=1 if v114>4

gen hard6use4=max(hero6use4,e6use4,amf6use4,coca6use4)



***Used drugs more than 26 times during the previous 6 months***

gen can6use5=0
replace can6use5=1 if v105>5

gen amf6use5=0
replace amf6use5=1 if v106>5
replace amf6use5=1 if v107>5

gen coca6use5=0
replace coca6use5=1 if v109>5
replace coca6use5=1 if v110>5

gen e6use5=0
replace e6use5=1 if v108>5

gen hero6use5=0
replace hero6use5=1 if v113>5
replace hero6use5=1 if v114>5

gen hard6use5=max(hero6use5,e6use5,amf6use5,coca6use5)




/*starting ages for the different drugs*/

rename v117 start_age
replace start_age =. if start_age==0
drop if start_age<9

replace v133=99 if v133==0
replace v135=99 if v135==0
replace v125=99 if v125==0
replace v127=99 if v127==0
replace v119=99 if v119==0
replace v121=99 if v121==0
replace v123=99 if v123==0


gen h_start_age = min(v133,v135)
replace h_start_age=. if h_start_age==99
 
gen c_start_age = min(v125,v127)
replace c_start_age=. if c_start_age==99

gen a_start_age = min(v119,v121)
replace a_start_age=. if a_start_age==99

gen e_start_age =v123
replace e_start_age=. if e_start_age==99

gen hard_start_age=min(h_start_age, a_start_age, c_start_age, e_start_age)
gen hard_start_age2=min(h_start_age, a_start_age, c_start_age)
gen hard_start_age3=min(a_start_age, c_start_age)


gen ill_start_age=min(hard_start_age, start_age)

gen firstpot=hard_start_age-start_age
gen firstpot2=hard_start_age2-start_age
gen firstpot3=hard_start_age3-start_age



/* personal characteristics*/

gen male=1
replace male=0 if v005==2

rename v006 age
gen age2=age*age

gen age2123=0
replace age2123=1 if age>20 & age<24

gen age2124=0
replace age2124=1 if age>20 & age<25


gen y10=0
replace y10=1 if v039==1

gen potyoung=0
replace potyoung=1 if start_age<16 & start_age>0



/*Smoking habits*/
gen nonsmoke=0
replace nonsmoke=1 if v149==1

gen smoker=0
replace smoker=1 if nonsmoke==0

gen currsmoke=0
replace currsmoke=1 if v149==4
replace currsmoke=1 if v149==5

gen dailysmoke=0
replace dailysmoke=1 if v149==5

gen daysmoker=0
replace daysmoker=1 if v149==3
replace daysmoker=1 if v149==5


replace v093=0 if v093==11
replace v094=0 if v094==11
replace v095=0 if v095==11
replace v096=0 if v096==11
replace v097=0 if v097==11
replace v098=0 if v098==11
replace v101=0 if v101==11
replace v102=0 if v102==11



/*proneness*/

gen parents=0
replace parents=1 if v042==1

gen school=0
replace school=1 if v043==1

gen friends=0
replace friends=1 if v044==1

gen police=0
replace police=1 if v045==1

gen problems=parents+school+friends+police

gen probdum=0
replace probdum=1 if problems>0


replace v168=. if v168==0
replace v170=. if v170==0
replace v172=. if v172==0

gen alcomin=min(v168, v170, v172)

gen alcoyoung=0
replace alcoyoung=1 if alcomin<13

gen alcouse=0
replace alcouse=1 if alcomin!=.




/*Accessibility*/
/*prices, CPI-adjusted*/

/*mean starting age in 2006=18, in 2002=19*/
gen canpr=.
replace canpr=109 if age>29 
replace canpr=106 if age==29
replace canpr=105 if age==28 
replace canpr=102 if age==27 
replace canpr=100 if age==26 
replace canpr=98 if age==25 
replace canpr=95 if age==24 
replace canpr=92 if age==23 
replace canpr=91 if age==22 
replace canpr=90 if age==21 

gen lncanpr=ln(canpr)


/*mean starting age in 2006=19, in 2002=20*/
gen amfpr=.
replace amfpr=717 if age>29 
replace amfpr=630 if age==29 
replace amfpr=613 if age==28 
replace amfpr=600 if age==27 
replace amfpr=513 if age==26 
replace amfpr=427 if age==25 
replace amfpr=414 if age==24 
replace amfpr=409 if age==23 
replace amfpr=399 if age==22 
replace amfpr=371 if age==21 

gen lnamfpr=ln(amfpr)



gen canobt=0
replace canobt=1 if v054==1

gen amfobt=0
replace amfobt=1 if v055==1

gen cocaobt=0
replace cocaobt=1 if v057==1

gen heroobt=0
replace heroobt=1 if v060==1

gen eobt=0
replace eobt=1 if v056==1

gen hardobt=0
gen hardmobt=max(amfobt,cocaobt,heroobt,eobt)
replace hardobt=1 if hardmobt==1

/*Geography*/

gen citydum=0
replace citydum=1 if kommunen==301
replace citydum=1 if kommunen==1201
replace citydum=1 if kommunen==1601



/*Regions*/
gen counties=1
replace counties=2 if kommunen>201
replace counties=3 if kommunen>300
replace counties=4 if kommunen>400
replace counties=5 if kommunen>500
replace counties=6 if kommunen>600
replace counties=7 if kommunen>700
replace counties=8 if kommunen>800
replace counties=9 if kommunen>900
replace counties=10 if kommunen>1000
replace counties=11 if kommunen>1100
replace counties=12 if kommunen>1200
replace counties=13 if kommunen>1300
replace counties=14 if kommunen>1400
replace counties=15 if kommunen>1500
replace counties=16 if kommunen>1600
replace counties=17 if kommunen>1700
replace counties=18 if kommunen>1800
replace counties=19 if kommunen>1900
replace counties=20 if kommunen>2000


/*Accessibility*/
gen obtainca=0.58
replace obtainca=0.54 if counties==2
replace obtainca=0.57 if counties==3
replace obtainca=0.50 if counties==4
replace obtainca=0.44 if counties==5
replace obtainca=0.51 if counties==6
replace obtainca=0.49 if counties==7
replace obtainca=0.60 if counties==8
replace obtainca=0.51 if counties==9
replace obtainca=0.46 if counties==10
replace obtainca=0.48 if counties==11
replace obtainca=0.57 if counties==12
replace obtainca=0.55 if counties==14
replace obtainca=0.41 if counties==15
replace obtainca=0.50 if counties==16
replace obtainca=0.46 if counties==17
replace obtainca=0.45 if counties==18
replace obtainca=0.47 if counties==19
replace obtainca=0.39 if counties==20

gen obtainha=0.46
replace obtainha=0.42 if counties==2
replace obtainha=0.45 if counties==3
replace obtainha=0.41 if counties==4
replace obtainha=0.42 if counties==5
replace obtainha=0.42 if counties==6
replace obtainha=0.42 if counties==7
replace obtainha=0.48 if counties==8
replace obtainha=0.46 if counties==9
replace obtainha=0.30 if counties==10
replace obtainha=0.38 if counties==11
replace obtainha=0.42 if counties==12
replace obtainha=0.31 if counties==14
replace obtainha=0.34 if counties==15
replace obtainha=0.33 if counties==16
replace obtainha=0.32 if counties==17
replace obtainha=0.31 if counties==18
replace obtainha=0.33 if counties==19
replace obtainha=0.28 if counties==20



*/New accessibility based on county averages*/

gen prevcan=0.18
replace prevcan=0.17 if counties==2
replace prevcan=0.29 if counties==3
replace prevcan=0.09 if counties==4
replace prevcan=0.10 if counties==5
replace prevcan=0.16 if counties==6
replace prevcan=0.25 if counties==7
replace prevcan=0.23 if counties==8
replace prevcan=0.15 if counties==9
replace prevcan=0.18 if counties==10
replace prevcan=0.17 if counties==11
replace prevcan=0.21 if counties==12
replace prevcan=0.18 if counties==14
replace prevcan=0.12 if counties==15
replace prevcan=0.20 if counties==16
replace prevcan=0.10 if counties==17
replace prevcan=0.14 if counties==18
replace prevcan=0.16 if counties==19
replace prevcan=0.18 if counties==20



gen prevhar=0.059
replace prevhar=0.073 if counties==2
replace prevhar=0.099 if counties==3
replace prevhar=0.031 if counties==4
replace prevhar=0.052 if counties==5
replace prevhar=0.069 if counties==6
replace prevhar=0.125 if counties==7
replace prevhar=0.082 if counties==8
replace prevhar=0.073 if counties==9
replace prevhar=0.043 if counties==10
replace prevhar=0.061 if counties==11
replace prevhar=0.061 if counties==12
replace prevhar=0.077 if counties==14
replace prevhar=0.030 if counties==15
replace prevhar=0.057 if counties==16
replace prevhar=0.052 if counties==17
replace prevhar=0.071 if counties==18
replace prevhar=0.087 if counties==19
replace prevhar=0.071 if counties==20


*/Average of hero+amph seizure for 1994-98 per 100.000 inhabitants*/

gen harseiz=89
replace harseiz=84 if counties==2
replace harseiz=521 if counties==3
replace harseiz=58 if counties==4
replace harseiz=42 if counties==5
replace harseiz=102 if counties==6
replace harseiz=129 if counties==7
replace harseiz=132 if counties==8
replace harseiz=53 if counties==9
replace harseiz=113 if counties==10
replace harseiz=85 if counties==11
replace harseiz=96 if counties==12
replace harseiz=12 if counties==14
replace harseiz=21 if counties==15
replace harseiz=85 if counties==16
replace harseiz=25 if counties==17
replace harseiz=36 if counties==18
replace harseiz=65 if counties==19
replace harseiz=31 if counties==20



/* checking the initiation pattern*/
gen cannamf=a_start_age-start_age
gen canncoca=c_start_age-start_age
gen cannhero=h_start_age-start_age
gen cannecst=e_start_age-start_age



/* restricted sample*/
drop if potyoung>0 & canfreq1==0
drop if v093>1 & start_age==.
drop if maxhard>1 & hard_start_age==.

