clear

global root "C:/Users/gutierfh/Dropbox/DID/DID_JUNTOS/data_and_codes"


* ================================================================================= *
*   Regressions for paper:
*
*	 Botosaru I. and Gutierrez F. (2017), Difference-in-differences when treatment
*           status is observed in only one period
*
*			(by Federico H. Gutierrez, federico.h.gutierrez@vanderbilt.edu)	
* ================================================================================ *

*-- Log file
capture log close
log using "$root/c2_results_code_for_online_appendix.log", replace

* ======================================= *
* >>>>>>>>>>> Women Sample <<<<<<<<<<<<<<<
* ======================================= *
*-- Open data
use "$root/b1_women.dta", replace

* ======================================= *
* >>>>>>>>>>> Generate variables <<<<<<<<<
* ======================================= *

* -- dummy years
tab ysurv, gen(yr)

* -- post and pre treatment observations
gen postyears = 1 if  ysurvey>=2006
gen preyears = 1 if ysurvey<=2005

* -- cluster indicator
egen cvar = group(ubigeo ptime)

* -- program
run "$root/p1_gmmdidm.do"


* ======================================= *
* >>>>>>>>>>> Robustness <<<<<<<<<<<<<<<<<<
* ======================================= *
* It compute GMM for Figure 5(a), 5(c) and Figures 6-8  
local sample " male==0 & age>=15 & age<=45 & ysurvey~=2006 & ysurvey~=2007 & ysurvey<=2011"

local instlist1 "floor1 floor2 wall1 wall2 wall3 maxyedu"
local instlist2 "roof1 roof2 wall1 wall2 wall3 maxyedu"
local instlist3 "roof1 roof2 floor1 floor2 maxyedu"
local instlist4 "roof1 roof2 floor1 floor2 wall1 wall2 wall3"
local instlist5 "roof1 roof2 floor1 floor2 wall1 wall2 wall3 maxyedu"

local depvarlist "nodoc  cfamiliar contraceptive"
local firstst = "ols probit logit"


forvalue j = 1/5 				{
foreach fst in `firstst'		{
foreach depvar in `depvarlist' 	{

di ""
di ""
di ""
di ""
di ">>>>>>>>>>> <<<<<<<<<<<<<"
di in yellow "sample: `sample'"
di ""
di in yellow "depvar: `depvar'"
di ""
di in yellow "prop. score method: `fst'"
di ""
di in yellow "instruments: `instlist`j'' "
di ">>>>>>>>>>> <<<<<<<<<<<<<"

 capture timer clear 1
 timer on 1
 
gmmdidm `depvar' hjuntos [aw=fac] if `sample', inst(`instlist`j'') time(ptime) yfirst( 2008 2009 2010 2011 ) ysecond( 2004 2005 2008 2009 2010 2011) ref(2005) max(10) first(`fst') new cluster(cvar)

timer off 1
timer list 1
 
matrix M`depvar'_1 = [_b[/did2004],_b[/did2004] - invnorm(0.975)*_se[/did2004] , _b[/did2004] + invnorm(0.975)*_se[/did2004] , _b[/did2004] - invnorm(0.95)*_se[/did2004] , _b[/did2004] + invnorm(0.95)*_se[/did2004]]
matrix M`depvar'_2 = [0,0,0,0,0]
matrix M`depvar'_3 = [_b[/did2008],_b[/did2008] - invnorm(0.975)*_se[/did2008] , _b[/did2008] + invnorm(0.975)*_se[/did2008] , _b[/did2008] - invnorm(0.95)*_se[/did2008] , _b[/did2008] + invnorm(0.95)*_se[/did2008]]
matrix M`depvar'_4 = [_b[/did2009],_b[/did2009] - invnorm(0.975)*_se[/did2009] , _b[/did2009] + invnorm(0.975)*_se[/did2009] , _b[/did2009] - invnorm(0.95)*_se[/did2009] , _b[/did2009] + invnorm(0.95)*_se[/did2009]]
matrix M`depvar'_5 = [_b[/did2010],_b[/did2010] - invnorm(0.975)*_se[/did2010] , _b[/did2010] + invnorm(0.975)*_se[/did2010] , _b[/did2010] - invnorm(0.95)*_se[/did2010] , _b[/did2010] + invnorm(0.95)*_se[/did2010]]
matrix M`depvar'_6 = [_b[/did2011],_b[/did2011] - invnorm(0.975)*_se[/did2011] , _b[/did2011] + invnorm(0.975)*_se[/did2011] , _b[/did2011] - invnorm(0.95)*_se[/did2011] , _b[/did2011] + invnorm(0.95)*_se[/did2011]]
matrix M`depvar' = [M`depvar'_1 \M`depvar'_2 \M`depvar'_3 \M`depvar'_4 \M`depvar'_5 \M`depvar'_6]

matrix list M`depvar'

* >> post treatment indicators <<

* -- propensity score F and correlation
if "`fst'"=="ols"	{
di in y "---------- Propensity score ------------"
di ""
di in y "F-stat = " r(F)
di in y "corr(D,Dhat) = " r(corrDD)
di ""
di in y "----------------------------------------"	
}
* -- overid test
di in y "---------- Overid test -----------------"
di ""
estat overid
di ""
di in y "----------------------------------------"

								}
								}
								}

* ================================================================ *
* >>>>>>>>>>> Each DID estimated separately <<<<<<<<<<<<<<<<<<
* ================================================================ *
* -- Figure 5(b) and Figures 11-13
* ----------------------------------
* -- women in reproductive age
* ----------------------------------

local sample " male==0 & age>=15 & age<=45 & ysurvey~=2006 & ysurvey~=2007 & ysurvey<=2011"
local instlist9 "roof1 roof2 floor1 floor2 wall1 wall2 wall3 maxyedu"
local depvarlist "nodoc  cfamiliar contraceptive "


foreach depvar in `depvarlist' 	{

di ""
di ""
di ""
di ""
di ">>>>>>>>>>> <<<<<<<<<<<<<"
di ""
di "///// (Women) Separate regressions for each year /////////"
di ""
di in yellow "sample: `sample'"
di ""
di in yellow "depvar: `depvar'"
di ""
di in yellow "instruments: `instlist9'"
di ">>>>>>>>>>> <<<<<<<<<<<<<"

 
matrix M`depvar'_2 = [0,0,0,0,0]

gmmdidm `depvar' hjuntos [aw=fac] if `sample', inst(`instlist9') time(ptime) yfirst( 2008 ) ysecond( 2005 2008 ) ref(2005) max(10) new cluster(cvar)
estat overid
 	matrix M`depvar'_3 = [_b[/did2008],_b[/did2008] - invnorm(0.975)*_se[/did2008] , _b[/did2008] + invnorm(0.975)*_se[/did2008] , _b[/did2008] - invnorm(0.95)*_se[/did2008] , _b[/did2008] + invnorm(0.95)*_se[/did2008]]
		reg hjuntos `instlist9' [aw=fac] if `sample' & `depvar'~=. & ptime==2008
		capture drop Dhat
		predict Dhat if e(sample)
		corr Dhat hjuntos

gmmdidm `depvar' hjuntos [aw=fac] if `sample', inst(`instlist9') time(ptime) yfirst( 2009 ) ysecond( 2005 2009 ) ref(2005) max(10) new cluster(cvar)
estat overid
 	matrix M`depvar'_4 = [_b[/did2009],_b[/did2009] - invnorm(0.975)*_se[/did2009] , _b[/did2009] + invnorm(0.975)*_se[/did2009] , _b[/did2009] - invnorm(0.95)*_se[/did2009] , _b[/did2009] + invnorm(0.95)*_se[/did2009]]
		reg hjuntos `instlist9' [aw=fac] if `sample' & `depvar'~=. & ptime==2009
		capture drop Dhat
		predict Dhat if e(sample)
		corr Dhat hjuntos

gmmdidm `depvar' hjuntos [aw=fac] if `sample', inst(`instlist9') time(ptime) yfirst( 2010 ) ysecond( 2005 2010 ) ref(2005) max(10) new cluster(cvar)
estat overid
 	matrix M`depvar'_5 = [_b[/did2010],_b[/did2010] - invnorm(0.975)*_se[/did2010] , _b[/did2010] + invnorm(0.975)*_se[/did2010] , _b[/did2010] - invnorm(0.95)*_se[/did2010] , _b[/did2010] + invnorm(0.95)*_se[/did2010]]
		reg hjuntos `instlist9' [aw=fac] if `sample' & `depvar'~=. & ptime==2010
		capture drop Dhat
		predict Dhat if e(sample)
		corr Dhat hjuntos

gmmdidm `depvar' hjuntos [aw=fac] if `sample', inst(`instlist9') time(ptime) yfirst( 2011 ) ysecond( 2005 2011 ) ref(2005) max(10) new cluster(cvar)
estat overid
 	matrix M`depvar'_6 = [_b[/did2011],_b[/did2011] - invnorm(0.975)*_se[/did2011] , _b[/did2011] + invnorm(0.975)*_se[/did2011] , _b[/did2011] - invnorm(0.95)*_se[/did2011] , _b[/did2011] + invnorm(0.95)*_se[/did2011]]
		reg hjuntos `instlist9' [aw=fac] if `sample' & `depvar'~=. & ptime==2011
		capture drop Dhat
		predict Dhat if e(sample)
		corr Dhat hjuntos

matrix M`depvar' = [M`depvar'_2 \M`depvar'_3 \M`depvar'_4 \M`depvar'_5 \M`depvar'_6]
	matrix list M`depvar'

								}

* ======================================= *
* >>>>>>>>>>> Children Sample <<<<<<<<<<<<<<<
* ======================================= *
*-- Open data
use "$root/b2_children.dta", replace

* ======================================= *
* >>>>>>>>>>> Generate variables <<<<<<<<<
* ======================================= *

* -- dummy years
tab ysurv, gen(yr)

* -- post and pre treatment observations
gen postyears = 1 if  ysurvey>=2006
gen preyears = 1 if ysurvey<=2005

* -- cluster indicator
egen cvar = group(ubigeo ptime)

* -- program
run "$root/p1_gmmdidm.do"


* ======================================= *
* >>>>>>>>>>> Robustness <<<<<<<<<<<<<<<<<<
* ======================================= *
* It compute GMM for Figures 9 and 10  
local sample " age<=5 & ysurvey~=2006 & ysurvey~=2007 & ysurvey<=2011"
local depvarlist "nodoc  cvacunas "


forvalue j = 1/5 				{
foreach fst in `firstst'		{
foreach depvar in `depvarlist' 	{

di ""
di ""
di ""
di ""
di ">>>>>>>>>>> <<<<<<<<<<<<<"
di in yellow "sample: `sample'"
di ""
di in yellow "depvar: `depvar'"
di ""
di in yellow "first stage: `fst'"
di ""
di in yellow "instruments: `instlist`j'' "
di ">>>>>>>>>>> <<<<<<<<<<<<<"

capture timer clear 1
timer on 1
  
gmmdidm `depvar' hjuntos [aw=fac] if `sample', inst(`instlist`j'')  time(ptime) yfirst( 2008 2009 2010 2011 ) ysecond( 2004 2005 2008 2009 2010 2011) ref(2005) max(10) first(`fst') new cluster(cvar) 

timer off 1
timer list 1

matrix M`depvar'_1 = [_b[/did2004],_b[/did2004] - invnorm(0.975)*_se[/did2004] , _b[/did2004] + invnorm(0.975)*_se[/did2004] , _b[/did2004] - invnorm(0.95)*_se[/did2004] , _b[/did2004] + invnorm(0.95)*_se[/did2004]]
matrix M`depvar'_2 = [0,0,0,0,0]
matrix M`depvar'_3 = [_b[/did2008],_b[/did2008] - invnorm(0.975)*_se[/did2008] , _b[/did2008] + invnorm(0.975)*_se[/did2008] , _b[/did2008] - invnorm(0.95)*_se[/did2008] , _b[/did2008] + invnorm(0.95)*_se[/did2008]]
matrix M`depvar'_4 = [_b[/did2009],_b[/did2009] - invnorm(0.975)*_se[/did2009] , _b[/did2009] + invnorm(0.975)*_se[/did2009] , _b[/did2009] - invnorm(0.95)*_se[/did2009] , _b[/did2009] + invnorm(0.95)*_se[/did2009]]
matrix M`depvar'_5 = [_b[/did2010],_b[/did2010] - invnorm(0.975)*_se[/did2010] , _b[/did2010] + invnorm(0.975)*_se[/did2010] , _b[/did2010] - invnorm(0.95)*_se[/did2010] , _b[/did2010] + invnorm(0.95)*_se[/did2010]]
matrix M`depvar'_6 = [_b[/did2011],_b[/did2011] - invnorm(0.975)*_se[/did2011] , _b[/did2011] + invnorm(0.975)*_se[/did2011] , _b[/did2011] - invnorm(0.95)*_se[/did2011] , _b[/did2011] + invnorm(0.95)*_se[/did2011]]
matrix M`depvar' = [M`depvar'_1 \M`depvar'_2 \M`depvar'_3 \M`depvar'_4 \M`depvar'_5 \M`depvar'_6]

matrix list M`depvar'

* >> post treatment indicators <<

* -- propensity score F and correlation
if "`fst'"=="ols"	{
di in y "---------- Propensity score ------------"
di ""
di in y "F-stat = " r(F)
di in y "corr(D,Dhat) = " r(corrDD)
di ""
di in y "----------------------------------------"	
}
* -- overid test
di in y "---------- Overid test -----------------"
di ""
estat overid
di ""
di in y "----------------------------------------"

								}
								}
								}



* ================================================================ *
* >>>>>>>>>>> Each DID estimated separately <<<<<<<<<<<<<<<<<<
* ================================================================ *
* -- Figures 14-15

* ----------------------------------
* -- children less than 5
* ----------------------------------

local sample " age<=5 & ysurvey~=2006 & ysurvey~=2007 & ysurvey<=2011"
local depvarlist "nodoc  cvacunas "

foreach depvar in `depvarlist' 	{

di ""
di ""
di ""
di ""
di ">>>>>>>>>>> <<<<<<<<<<<<<"
di ""
di "///// (Children) Separate regressions for each year /////////"
di ""
di in yellow "sample: `sample'"
di ""
di in yellow "depvar: `depvar'"
di ""
di in yellow "instruments: `instlist9'"
di ">>>>>>>>>>> <<<<<<<<<<<<<"

 
matrix M`depvar'_2 = [0,0,0,0,0]

gmmdidm `depvar' hjuntos [aw=fac] if `sample', inst(`instlist9') time(ptime) yfirst( 2008 ) ysecond( 2005 2008 ) ref(2005) max(10) new cluster(cvar)
estat overid
 	matrix M`depvar'_3 = [_b[/did2008],_b[/did2008] - invnorm(0.975)*_se[/did2008] , _b[/did2008] + invnorm(0.975)*_se[/did2008] , _b[/did2008] - invnorm(0.95)*_se[/did2008] , _b[/did2008] + invnorm(0.95)*_se[/did2008]]
		reg hjuntos `instlist9' [aw=fac] if `sample' & `depvar'~=. & ptime==2008
		capture drop Dhat
		predict Dhat if e(sample)
		corr Dhat hjuntos

gmmdidm `depvar' hjuntos [aw=fac] if `sample', inst(`instlist9') time(ptime) yfirst( 2009 ) ysecond( 2005 2009 ) ref(2005) max(10) new cluster(cvar)
estat overid
 	matrix M`depvar'_4 = [_b[/did2009],_b[/did2009] - invnorm(0.975)*_se[/did2009] , _b[/did2009] + invnorm(0.975)*_se[/did2009] , _b[/did2009] - invnorm(0.95)*_se[/did2009] , _b[/did2009] + invnorm(0.95)*_se[/did2009]]
		reg hjuntos `instlist9' [aw=fac] if `sample' & `depvar'~=. & ptime==2009
		capture drop Dhat
		predict Dhat if e(sample)
		corr Dhat hjuntos

gmmdidm `depvar' hjuntos [aw=fac] if `sample', inst(`instlist9') time(ptime) yfirst( 2010 ) ysecond( 2005 2010 ) ref(2005) max(10) new cluster(cvar)
estat overid
 	matrix M`depvar'_5 = [_b[/did2010],_b[/did2010] - invnorm(0.975)*_se[/did2010] , _b[/did2010] + invnorm(0.975)*_se[/did2010] , _b[/did2010] - invnorm(0.95)*_se[/did2010] , _b[/did2010] + invnorm(0.95)*_se[/did2010]]
		reg hjuntos `instlist9' [aw=fac] if `sample' & `depvar'~=. & ptime==2010
		capture drop Dhat
		predict Dhat if e(sample)
		corr Dhat hjuntos

gmmdidm `depvar' hjuntos [aw=fac] if `sample', inst(`instlist9') time(ptime) yfirst( 2011 ) ysecond( 2005 2011 ) ref(2005) max(10) new cluster(cvar)
estat overid
 	matrix M`depvar'_6 = [_b[/did2011],_b[/did2011] - invnorm(0.975)*_se[/did2011] , _b[/did2011] + invnorm(0.975)*_se[/did2011] , _b[/did2011] - invnorm(0.95)*_se[/did2011] , _b[/did2011] + invnorm(0.95)*_se[/did2011]]
		reg hjuntos `instlist9' [aw=fac] if `sample' & `depvar'~=. & ptime==2011
		capture drop Dhat
		predict Dhat if e(sample)
		corr Dhat hjuntos

matrix M`depvar' = [M`depvar'_2 \M`depvar'_3 \M`depvar'_4 \M`depvar'_5 \M`depvar'_6]
	matrix list M`depvar'
								}




*-- Log file
capture log close

