clear

global root "C:/Users/gutierfh/Dropbox/DID/DID_JUNTOS/data_and_codes"


* ================================================================================= *
*   Regressions for paper:
*
*	 Botosaru I. and Gutierrez F. (2017), Difference-in-differences when treatment
*           status is observed in only one period
*
*			(by Federico H. Gutierrez, federico.h.gutierrez@vanderbilt.edu)	
* ================================================================================ *

*-- Log file
capture log close
log using "$root/c1_results_code_for_paper.log", replace

* ======================================= *
* >>>>>>>>>>> Women Sample <<<<<<<<<<<<<<<
* ======================================= *
*-- Open data
use "$root/b1_women.dta", replace

* ======================================= *
* >>>>>>>>>>> Generate variables <<<<<<<<<
* ======================================= *

* -- local of interest
local instlist9 "roof1 roof2 floor1 floor2 wall1 wall2 wall3 maxyedu"
local depvarlist "nodoc  cfamiliar contraceptive"

* -- dummy years
tab ysurv, gen(yr)

* -- post and pre treatment observations
gen postyears = 1 if  ysurvey>=2006
gen preyears = 1 if ysurvey<=2005

* -- interaction for test
	gen i2008 = ysurvey==2008 if ysurvey>=2008 & ysurvey<=2011 
	gen i2009 = ysurvey==2009 if ysurvey>=2008 & ysurvey<=2011 
	gen i2010 = ysurvey==2010 if ysurvey>=2008 & ysurvey<=2011 
	gen i2011 = ysurvey==2011 if ysurvey>=2008 & ysurvey<=2011 

	foreach v in `instlist9'	{
		gen i2008i`v' = i2008*`v'
		gen i2009i`v' = i2009*`v'
		gen i2010i`v' = i2010*`v'
		gen i2011i`v' = i2011*`v'

		local inter2008 "`inter2008'  i2008i`v'"
		local inter2009 "`inter2009'  i2009i`v'"
		local inter2010 "`inter2010'  i2010i`v'"
		local inter2011 "`inter2011'  i2011i`v'"
	}

	gen i2008D = i2008*hjuntos 
	gen i2009D = i2009*hjuntos 
	gen i2010D = i2010*hjuntos 
	gen i2011D = i2011*hjuntos 

* -- program
run "$root/p1_gmmdidm.do"

* ======================================= *
* >>>>>> Descriptive Women Sample <<<<<<<<
* ======================================= *

* --------------------- Table 1: Descriptive statistics ---------------------
sum hjuntos `depvarlist' `instlist9' preyears postyears [aw=fac] 
* ---------------------------------------------------------------------------

* --------------------- Table 2: propensity scores  -------------------------
reg hjuntos `instlist9' [aw=fac] 
	sum `instlist9' [aw=fac] if hjuntos==1 & e(sample) 
	sum `instlist9' [aw=fac] if hjuntos==0 & e(sample) 

foreach v in `instlist9' {
	reg `v' hjuntos [aw=fac] 
} 
* ---------------------------------------------------------------------------


* ======================================= *
* >>>>> Regressions Women Sample <<<<<<<<<
* ======================================= *
* It computes the GMM to build Figures 2 and 3
egen cvar = group(ubigeo ptime)
local sample " male==0 & age>=15 & age<=45 & ysurvey~=2006 & ysurvey~=2007 & ysurvey<=2011"

foreach depvar in `depvarlist' 	{
local cloop = `cloop' + 1

di ""
di ""
di ""
di ""
di ">>>>>>>>>>> <<<<<<<<<<<<<"
di in yellow "sample: `sample'"
di ""
di in yellow "depvar: `depvar'"
di ""
di in yellow "instruments: `instlist9'"
di ">>>>>>>>>>> <<<<<<<<<<<<<"

 capture timer clear 1
 timer on 1

 gmmdidm `depvar' hjuntos [aw=fac] if `sample', inst(`instlist9') time(ptime) yfirst( 2008 2009 2010 2011 ) ysecond( 2004 2005 2008 2009 2010 2011) ref(2005) max(10) new cluster(cvar) 

 timer off 1
 timer list 1

* -- matrix for graph 
matrix M`depvar'_1 = [_b[/did2004],_b[/did2004] - invnorm(0.975)*_se[/did2004] , _b[/did2004] + invnorm(0.975)*_se[/did2004] , _b[/did2004] - invnorm(0.95)*_se[/did2004] , _b[/did2004] + invnorm(0.95)*_se[/did2004]]
matrix M`depvar'_2 = [0,0,0,0,0]
matrix M`depvar'_3 = [_b[/did2008],_b[/did2008] - invnorm(0.975)*_se[/did2008] , _b[/did2008] + invnorm(0.975)*_se[/did2008] , _b[/did2008] - invnorm(0.95)*_se[/did2008] , _b[/did2008] + invnorm(0.95)*_se[/did2008]]
matrix M`depvar'_4 = [_b[/did2009],_b[/did2009] - invnorm(0.975)*_se[/did2009] , _b[/did2009] + invnorm(0.975)*_se[/did2009] , _b[/did2009] - invnorm(0.95)*_se[/did2009] , _b[/did2009] + invnorm(0.95)*_se[/did2009]]
matrix M`depvar'_5 = [_b[/did2010],_b[/did2010] - invnorm(0.975)*_se[/did2010] , _b[/did2010] + invnorm(0.975)*_se[/did2010] , _b[/did2010] - invnorm(0.95)*_se[/did2010] , _b[/did2010] + invnorm(0.95)*_se[/did2010]]
matrix M`depvar'_6 = [_b[/did2011],_b[/did2011] - invnorm(0.975)*_se[/did2011] , _b[/did2011] + invnorm(0.975)*_se[/did2011] , _b[/did2011] - invnorm(0.95)*_se[/did2011] , _b[/did2011] + invnorm(0.95)*_se[/did2011]]
matrix M`depvar' = [M`depvar'_1 \M`depvar'_2 \M`depvar'_3 \M`depvar'_4 \M`depvar'_5 \M`depvar'_6]

matrix list M`depvar'


* >> post treatment indicators <<

* -- propensity score F and correlation
di in y "---------- Propensity score ------------"
di ""
di in y "F-stat = " r(F)
di in y "corr(D,Dhat) = " r(corrDD)
di ""
di in y "----------------------------------------"
* -- overid test
di in y "---------- Overid test -----------------"
di ""
estat overid
di ""
di in y "----------------------------------------"

* -- Stationarity of propensity score post-treatment ``test''
	reg hjuntos i2008 i2010 i2011 `instlist9' `inter2008' `inter2010' `inter2011'  [aw=fac] if `sample' & ptime~=. & (ysurvey>=2008 & ysurvey<=2011) & `depvar'~=., cluster(cvar)
		test `inter2008' `inter2010' `inter2011'

if "`depvar'"=="nodoc"	{
	reg hjuntos i2008 i2011       `instlist9' `inter2008'             `inter2011'  [aw=fac] if `sample' & ptime~=. & (ysurvey>=2008 & ysurvey<=2011) & ysurvey~=2010 & `depvar'~=., cluster(cvar)
		test `inter2008'  `inter2011'
}

* -- Assumption A6 post-treatment ``test''

	reg `depvar' hjuntos i2008 i2010 i2011 `instlist9' `inter2008' `inter2010' `inter2011'  [aw=fac] if `sample' & ptime~=. & (ysurvey>=2008 & ysurvey<=2011), cluster(cvar)
		test `inter2008' `inter2010' `inter2011'

if "`depvar'"=="nodoc"	{
	reg `depvar' hjuntos i2008       i2011 `instlist9' `inter2008'             `inter2011'  [aw=fac] if `sample' & ptime~=. & (ysurvey>=2008 & ysurvey<=2011) & ysurvey~=2010, cluster(cvar)
		test `inter2008'  `inter2011'	
}

								}


* ======================================= *
* >>>>>>>>>>> Children Sample <<<<<<<<<<<<
* ======================================= *
*-- Open data
clear
use "$root/b2_children.dta", replace

* ======================================= *
* >>>>>>>>>>> Generate variables <<<<<<<<<<
* ======================================= *

* -- locals of interest
local instlist9 "roof1 roof2 floor1 floor2 wall1 wall2 wall3 maxyedu"
local depvarlist "nodoc  cvacunas "

* -- dummy years
tab ysurv, gen(yr)

* -- post and pre treatment observations
gen postyears = 1 if  ysurvey>=2006
gen preyears = 1 if ysurvey<=2005

* -- interaction for test
	gen i2008 = ysurvey==2008 if ysurvey>=2008 & ysurvey<=2011 
	gen i2009 = ysurvey==2009 if ysurvey>=2008 & ysurvey<=2011 
	gen i2010 = ysurvey==2010 if ysurvey>=2008 & ysurvey<=2011 
	gen i2011 = ysurvey==2011 if ysurvey>=2008 & ysurvey<=2011 

	foreach v in `instlist9'	{
		gen i2008i`v' = i2008*`v'
		gen i2009i`v' = i2009*`v'
		gen i2010i`v' = i2010*`v'
		gen i2011i`v' = i2011*`v'
/*
		local inter2008 "`inter2008'  i2008i`v'"
		local inter2009 "`inter2009'  i2009i`v'"
		local inter2010 "`inter2010'  i2010i`v'"
		local inter2011 "`inter2011'  i2011i`v'"
*/		
	}

	gen i2008D = i2008*hjuntos 
	gen i2009D = i2009*hjuntos 
	gen i2010D = i2010*hjuntos 
	gen i2011D = i2011*hjuntos 

* -- program
run "$root/p1_gmmdidm.do"

* ======================================= *
* >>>>> Descriptive Children Sample <<<<<<<
* ======================================= *

* --------------------- Table 1: Descriptive statistics ---------------------
sum hjuntos `depvarlist' `instlist9' preyears postyears [aw=fac] 
* ----------------------------------------------------------------------------

* --------------------- Table 2: propensity scores  ---------------------
reg hjuntos `instlist9' [aw=fac] 
	sum `instlist9' [aw=fac] if hjuntos==1 & e(sample) 
	sum `instlist9' [aw=fac] if hjuntos==0 & e(sample) 

foreach v in `instlist9' {
	reg `v' hjuntos [aw=fac] 
} 
* ----------------------------------------------------------------------------


* ======================================= *
* >>>>>>>>>>> Regressions <<<<<<<<<<<<<<<<<<
* ======================================= *
* It computes the GMM to build Figure 4
egen cvar = group(ubigeo ptime)
local sample "age<=5 & ysurvey~=2006 & ysurvey~=2007 & ysurvey<=2011"

foreach depvar in `depvarlist' 	{

di ""
di ""
di ""
di ""
di ">>>>>>>>>>> <<<<<<<<<<<<<"
di in yellow "sample: `sample'"
di ""
di in yellow "depvar: `depvar'"
di ""
di in yellow "instruments: `instlist9'"
di ">>>>>>>>>>> <<<<<<<<<<<<<"

 capture timer clear 1
 timer on 1
 
 gmmdidm `depvar' hjuntos [aw=fac] if `sample', inst(`instlist9')  time(ptime) yfirst( 2008 2009 2010 2011 ) ysecond( 2004 2005 2008 2009 2010 2011) ref(2005) max(10) new cluster(cvar) 
 
 timer off 1
 timer list 1


* -- matrix for graph 
matrix M`depvar'_1 = [_b[/did2004],_b[/did2004] - invnorm(0.975)*_se[/did2004] , _b[/did2004] + invnorm(0.975)*_se[/did2004] , _b[/did2004] - invnorm(0.95)*_se[/did2004] , _b[/did2004] + invnorm(0.95)*_se[/did2004]]
matrix M`depvar'_2 = [0,0,0,0,0]
matrix M`depvar'_3 = [_b[/did2008],_b[/did2008] - invnorm(0.975)*_se[/did2008] , _b[/did2008] + invnorm(0.975)*_se[/did2008] , _b[/did2008] - invnorm(0.95)*_se[/did2008] , _b[/did2008] + invnorm(0.95)*_se[/did2008]]
matrix M`depvar'_4 = [_b[/did2009],_b[/did2009] - invnorm(0.975)*_se[/did2009] , _b[/did2009] + invnorm(0.975)*_se[/did2009] , _b[/did2009] - invnorm(0.95)*_se[/did2009] , _b[/did2009] + invnorm(0.95)*_se[/did2009]]
matrix M`depvar'_5 = [_b[/did2010],_b[/did2010] - invnorm(0.975)*_se[/did2010] , _b[/did2010] + invnorm(0.975)*_se[/did2010] , _b[/did2010] - invnorm(0.95)*_se[/did2010] , _b[/did2010] + invnorm(0.95)*_se[/did2010]]
matrix M`depvar'_6 = [_b[/did2011],_b[/did2011] - invnorm(0.975)*_se[/did2011] , _b[/did2011] + invnorm(0.975)*_se[/did2011] , _b[/did2011] - invnorm(0.95)*_se[/did2011] , _b[/did2011] + invnorm(0.95)*_se[/did2011]]
matrix M`depvar' = [M`depvar'_1 \M`depvar'_2 \M`depvar'_3 \M`depvar'_4 \M`depvar'_5 \M`depvar'_6]

matrix list M`depvar'

* >> post treatment indicators <<

* -- propensity score F and correlation
di in y "---------- Propensity score ------------"
di ""
di in y "F-stat = " r(F)
di in y "corr(D,Dhat) = " r(corrDD)
di ""
di in y "----------------------------------------"
* -- overid test
di in y "---------- Overid test -----------------"
di ""
estat overid
di ""
di in y "----------------------------------------"

* -- Stationarity of propensity score ``test''
	reg hjuntos i2008 i2010 i2011 `instlist9' `inter2008' `inter2010' `inter2011'  [aw=fac] if `sample' & ptime~=. & (ysurvey>=2008 & ysurvey<=2011) & `depvar'~=., cluster(cvar)
		test `inter2008' `inter2010' `inter2011'

if "`depvar'" == "nodoc"	{
	reg hjuntos i2008             `instlist9' `inter2008'                          [aw=fac] if `sample' & ptime~=. & (ysurvey>=2008 & ysurvey<=2009) & `depvar'~=., cluster(cvar)
		test `inter2008'  	
}
if "`depvar'" == "cvacunas"	{
	reg hjuntos i2008 i2010       `instlist9' `inter2008' `inter2010'              [aw=fac] if `sample' & ptime~=. & (ysurvey>=2008 & ysurvey<=2011) & ysurvey~=2011 & `depvar'~=., cluster(cvar)
		test `inter2008'  `inter2010'	
}


* -- Assumption A6 post-treatment ``test''
	reg `depvar' hjuntos i2008 i2010 i2011 `instlist9' `inter2008' `inter2010' `inter2011'  [aw=fac] if `sample' & ptime~=. & (ysurvey>=2008 & ysurvey<=2011), cluster(cvar)
		test `inter2008' `inter2010' `inter2011'

if "`depvar'" == "nodoc"	{
	reg `depvar' hjuntos i2008             `instlist9' `inter2008'                          [aw=fac] if `sample' & ptime~=. & (ysurvey>=2008 & ysurvey<=2009) , cluster(cvar)
		test `inter2008'  	
}
if "`depvar'" == "cvacunas"	{
	reg `depvar' hjuntos i2008       i2010 `instlist9' `inter2008' `inter2010'              [aw=fac] if `sample' & ptime~=. & (ysurvey>=2008 & ysurvey<=2011) & ysurvey~=2011, cluster(cvar)
		test `inter2008'  `inter2010'
}

								}



*-- Log file
capture log close

