#include <oxstd.h>
#include <oxdraw.h>
#include "rq.ox"
#import <maximize>

sign(const mX)
{
	return (mX.>0) - (mX.<0);
}

kernel0(const vY, dh)
{
	if (dh <= 0)
	{
		decl dRange = double(quantilec(vY,0.75)-quantilec(vY,0.25));
		dh = dRange*(rows(vY)^(-2/5));
	}
	return double(meanc(densn(vY/dh)/dh));
}

lrcov(const mX, const mY, const iBandWidth)
{
	decl ih = int(iBandWidth);
	decl cT = rows(mX);
	decl mCov = mX'mY/cT;
	for (decl i=1; i<ih; ++i)
	{
		mCov += 2*mX[i:][]'mY[:cT-1-i][]*(1 - i/ih)/cT;
	}
	return mCov;
}

lr1sidecov(const mX, const mY, const iBandWidth)
{
	decl ih = int(iBandWidth);
	decl cT = rows(mX);
	decl mCov = mX'mY/cT;
	for (decl i=1; i<ih; ++i)
	{
		mCov += mX[i:][]'mY[:cT-1-i][]*(1 - i/ih)/cT;
	}
	return mCov;
}

fmlad(const vY, const mX, const iBandWidth)
{
	RCI = 0; KCV = 1; // rq parameters
	decl cT = rows(vY);
	decl mXconst = ones(cT,1)~mX;    // regressors with constant
	decl aRQout = rq(mX, vY, .5);
	decl vBeta0 = aRQout[0];	 // LAD regression (constant automatically included)
	decl vU = vY - mXconst*vBeta0;	 // first stage reg. errors
	decl vV = sign(vU);				 // sign of = = =
	decl dh0 = kernel0(vU, 0);		 // Estimated density at 0
	decl mX0 = mX - quantilec(mX);
	decl mInvX0X0 = invertsym(mX0'mX0); //	X'X^{-1}
	decl mDX = diff0(mX, 1);
	decl mXDX = mX0'mDX;	 // X'Diff(X)
	decl iBW = iBandWidth;
	if (iBW < 0) iBW = int(4*(cT/100)^(2/9)); // automatic bandwidth
	decl mOmega_xx = lrcov(mDX, mDX, iBW);
	decl mInvOmega_xx = invertsym(mOmega_xx);
	decl mOmega_xv = lrcov(mDX, vV, iBW);
	decl mOmega_vv = lrcov(vV, vV, iBW);
	decl vVplus = vV - mDX*mInvOmega_xx*mOmega_xv;
	decl mDelta_xvplus = lr1sidecov(mDX, vVplus, iBW);
	decl vBeta1 = vBeta0[1:] - mInvX0X0*(mXDX*mInvOmega_xx*mOmega_xv + cT*mDelta_xvplus)/(2*dh0);
	decl vYplus = vY - mDX*mInvOmega_xx*mOmega_xv;
	vBeta1 = (quantilec(vYplus - mX*vBeta1))|vBeta1;
	decl mCov0 = aRQout[5];
	decl mCov1 = (mOmega_vv - mOmega_xv'mInvOmega_xx*mOmega_xv)*mInvX0X0*(2*dh0)^(-2);
	decl vStErr0 = sqrt(diagonal(mCov0))';
	decl vStErr1 = sqrt(mCov0[0][0]~diagonal(mCov1))';
	decl vTratio0 = vBeta0./vStErr0;
	decl vTratio1 = vBeta1./vStErr1;
	decl vPval0 = 2*probn(-fabs(vTratio0));
	decl vPval1 = 2*probn(-fabs(vTratio1));
	decl vErr1 = vY - mXconst*vBeta1;
	decl dMeanAbsDevMed = meanc(fabs(vY - quantilec(vY))); // mean absolute deviations from the median
	decl dMeanAbsDevReg = meanc(fabs(vErr1));			   // FM-LAD regression mean absolute deviations

	// output
	println("\nLAD regression", "%c", {"Estim.","Std.Err.","t-ratio","p-value"},
			vBeta0~vStErr0~vTratio0~vPval0);
	println("\nFM-LAD regression (Bartlett kernel, Bandwidth = ",iBW,")", "%c", {"Estim.","Std.Err.","t-ratio","p-value"},
			vBeta1~vStErr1~vTratio1~vPval1);
	println("\nPseudo R2       = ", double(1-dMeanAbsDevReg/dMeanAbsDevMed));
	println("Regression MAD  = ", double(dMeanAbsDevReg));
	println("Regression RMSE = ", double(sqrt(meanc(vErr1.^2))));
	println("LAD-AR1 coeff   = ", rq(vErr1[1:],vErr1[:cT-2],.5)[0][1]);
	decl vBetaAR1;
	olsc(vErr1[:cT-2], ones(cT-1,1)~vErr1[1:], &vBetaAR1);
	println("OLS-AR1 coeff   = ",  vBetaAR1[1]);
	DrawTMatrix(0,vY'|(vY-vErr1)', {"Actual","Fitted"});
	DrawTMatrix(1,vErr1',{"Residual"});
	DrawDensity(2, vErr1', {"Residual"});
	ShowDrawWindow();
	return vBeta1;
}

main()
{
	decl asNames;
	decl mData = loadmat("MeanPrices.xls",&asNames)[168:][];
	// indexes: APX = 4, EEX = 5, EXAA = 6, Powernext = 9
	decl iYindex = 9;
	decl vXindex = 5;
	decl vY = mData[][iYindex];
	println("\nY variable : ", asNames[iYindex]);
	decl mX = mData[][vXindex];
	println("X variables: ", asNames[vXindex]);
	fmlad(vY, mX, -1);
}
