/*
**  PlotData
**
**  Purpose:
**    Plot de bmvd_data.txt file
**
**  Date:
**    7/11/2000
**
**  Author:
**    Charles Bos
**
*/
#include <oxstd.h>      // Include the Ox standard library header
#include "include/gnudraw_jae.h"
#include "include/incdata.ox"

main()
{
  decl mYLt, mYt, sDataFile, mDataFMT, vDataFrac, 
       mDMYL, mDMY, mInter, i, mS, vAC, dDW;

  sDataFile= "data/bmvd_data.txt";
  mDataFMT= <6, 3, 4, 5>;
  vDataFrac= <0; 4695>; 
  LoadData(sDataFile, mDataFMT, vDataFrac, 
           &mYLt, &mDMYL, &mInter, 0, 0);
  LoadData(sDataFile, mDataFMT, vDataFrac, 
           &mYt, &mDMY, &mInter, 1, 0);

  DrawTMatrix(0, mYLt, "St", mDMYL, 0, 0);
  DrawTMatrix(1, mYt/100, "st", mDMY, 0, 0);
  DrawCorrelogram(2, mYt, "ACF st", 50);
  DrawAdjust(ADJ_AREA_Y, -0.05, .05);
  DrawCorrelogram(3, sqr(mYt), "ACF st2", 50);
  DrawAdjust(ADJ_AREA_Y, -0.1, .3);
  SaveDrawWindow("excl/dataacfy.plb");
  CloseDrawWindow();

  i= columns(mYt)-522;
  DrawT(0, mYLt[][i+1:], mDMYL[][i+1:], 0, 0);
  DrawT(1, mYt[][i:], mDMY[][i:], 0, 0);
  DrawT(2, mInter[][i:], mDMY[][i:], 0, 0);
  DrawT(3, (mInter[0][i:]-mInter[1][i:])/360, mDMY[][i:], 0, 0);

  SaveDrawWindow("excl/data98y.plb");
  CloseDrawWindow();

  DrawTMatrix(0, mInter[][i:], {"r(BRD)", "r(US)"}, mDMY[][i:], 0, 0);
  DrawTMatrix(1, (mInter[0][i:]-mInter[1][i:])/360, "dr", mDMY[][i:], 0, 0);
  SaveDrawWindow("excl/inter98y.plb");
  CloseDrawWindow();

  DrawTMatrix(0, mInter, {"r(BRD)", "r(US)"}, mDMY, 0, 0);
  DrawTMatrix(1, (mInter[0][]-mInter[1][])/360, "dr", mDMY, 0, 0);
  SaveDrawWindow("excl/intery.plb");
  CloseDrawWindow();

  print ("Mean and sdev return: ", meanr(mYt)~sqrt(varr(mYt)));
  vAC= acf(mYt', 10);
  print ("Autocorrelations", range(0, 10)|vAC');
  dDW= sumsqrc(diff0(mYt', 1)[1:][])/sumsqrc(mYt');
  print ("DW statistic: ", dDW);

  print ("Limits mYt: ", limits(mYt')');
}

