/*
**
**  Program MixPlotUB.Ox
**
**  Purpose:
**    Plot the MixFlex, MHFlex of GGFlex results, bivariate only
**
**  Author:
**    Charles S. Bos
**
**  Date:
**    28/4/2000
**
**  Version:
**    1, using GnuDraw
*/
#include <oxstd.h>
#include <include/gnudraw_jae.h>

#include "simox.dec"

main()
{
  decl mTheta, dFrac, sSimbase, sSimFile, sPlbFile;

  if (g_FreePars == 0)
    g_FreePars= range(0, rows(g_InitVP)-1)';

  sSimbase= sprint(g_OutDir, "/", g_VersFile);
  if ((sizeof(arglist()) > 1) && (arglist()[1] == "old"))
    sSimbase= sprint(sSimbase, "%i", sizerc(g_Flex_nBurnin));
  sSimFile = sprint(sSimbase, ".fmt");
  println ("MixpltUB");
  println ("--------");
  println ("Create univariate and bivariate plots of a sample of drawings");

  mTheta = loadmat(sSimFile, 1);

  dFrac= 1;
  if (dFrac .<= 1)
    dFrac *= rows(mTheta);
  mTheta= thinr(mTheta, dFrac);
  println ("Writing density estimates based on ", rows(mTheta),
           " drawings");

  sPlbFile = sprint(sSimbase, "ua.plb");
  DrawDensity(0, mTheta', g_VarNames[g_FreePars], TRUE, FALSE, FALSE);
  SaveDrawWindow(sPlbFile);
  CloseDrawWindow();

  sPlbFile = sprint(sSimbase, "ba.plb");
  DrawBivDensity(0, mTheta', g_VarNames[g_FreePars], TRUE, FALSE, FALSE);
  SaveDrawWindow(sPlbFile);
  CloseDrawWindow();
}


