/*
**
**  Library TrackTime()
**
**  Purpose:
**    Measure time spent in separate routines
**
**  Date:
**    8/11/99
**
**  Author:
**    Charles Bos
**
*/

// Static declarations
static decl s_TT_Names, s_TT_Time= 0, s_TT_i= -1, s_TT_TimeOld, s_TT_Routine= 0, 
            s_TT_last= 1, s_TT_add= 0;

/*
**  TrackTime(const x)
**
**  Purpose:
**    Measure time spent in separate routines
**
**  Input:
**	x	if array: Series of names of routines. Initializes
**		if integer: Index for routine which is entered
**
**  Output:
**	return value      Integer, previous routine index number
*/
TrackTime(const x)
{
  decl iOld, tim;

  iOld= s_TT_i;
  if (isarray(x))
    {
      s_TT_Names= x;
      s_TT_Time= zeros(sizerc(x), 1);
    }
  else
    {
      // Take Linux timer() bug into account
      if ((timer() < 0) && (s_TT_last))
        s_TT_add += 2*214748+1;
      s_TT_last= (timer() > 0);
      tim= timer() + s_TT_add;

      if ((s_TT_i >= 0) && (s_TT_i < sizerc(s_TT_Time)))
        {
          s_TT_Time[s_TT_i] += tim - s_TT_TimeOld;
          if (s_TT_Routine)
		    if (x >= 0)
              println ("Entering ", s_TT_Names[x]);
		    else
              println ("Leaving ", s_TT_Names[iOld]);
        }
      s_TT_i= x;
      s_TT_TimeOld= tim;
    }

  return iOld;
}

/*
**  TrackRoutine(bTrack)
**
**  Purpose:
**    Indicate if routines which are entered should be tracked
**    through a message on the screen
**
**  Input:
**    bTrack    Boolean, 1 if message is to appear in TrackTime each time
**          a new routine is started, 0 otherwise.
**
*/
TrackRoutine(const bTrack)
{
  s_TT_Routine= bTrack;
}

/*
**  TrackReport()
**
**  Purpose:
**    Report the time spent in the routines
**
**  Inputs:
**    None
**
**  Outputs:
**    Screen	Information on total and fraction of time spent in routines
*/
TrackReport()
{
  decl i, bR;

  // Flush time
  bR= s_TT_Routine;
  TrackRoutine(FALSE);
  i= TrackTime(-1);
  TrackTime(i);
  TrackRoutine(bR);

  println ("Time spent in routines ");
  for (i= 0; i < sizerc(s_TT_Names); ++i)
    print ("%8s", s_TT_Names[i]);
  print ("%8.2f", s_TT_Time'/100|(s_TT_Time' / sumc(s_TT_Time)));
}

