/*
**  PrintMatrix(const fh, const s0, const aPrFmt, const acLabs, const arLabs,
**              const mX, const bHLine)
**
**  Purpose:
**    Print a latex matrix to a file and/or to the screen
**
**  Inputs:
**    fh      File handle (if 0, no writing to file)
**    s0      String, for including in upper left corner of table
**    aPrFmt  Array with printing format, see print(). No & needed
**    acLabs  Array with column labels
**    arLabs  Array with row labels
**    mX      Data matrix
**    bHLine  Boolean indicating if table should start with a hline
**
**  Output:
**    <file>  File pointed to by fh has a latex table appended
**            Same matrix gets printed on the screen
**
**  Author:
**    Charles Bos
** 
**  Date:
**    26/10/2000
*/
PrintMatrix(const fh, const s0, const aPrFmt, const acLabs, const arLabs,
            const mX, const bHLine)
{
  decl aLine, i, j, nC, nR, nF, alPrFmt, alcLabs, alrLabs, iwL;

  nC= sizec(mX);
  nR= sizer(mX);
  alPrFmt= aPrFmt;
  alcLabs= acLabs;
  alrLabs= arLabs;
  if (isstring(aPrFmt))
    alPrFmt= {aPrFmt};
  if (isstring(acLabs))
    alcLabs= {acLabs};
  if (isstring(arLabs))
    alrLabs= {arLabs};
  nF= sizeof(alPrFmt);
  iwL= 0;       // Fix width of row label
  for (i= 0; i < min(nR, sizeof(alrLabs)); ++i)
    iwL= max(iwL, sizeof(alrLabs));

  aLine= s0;
  if (bHLine)
    aLine= "\\hline\n"~s0;
  for (i= 0; i < min(sizeof(alcLabs), nC); ++i)
    aLine~=sprint(" & ", alcLabs[i]);

  if (!(aLine == ""))
    {
      if (isfile(fh))
        fprintln (fh, aLine, " \\\\");
      println (aLine, " \\\\");
    }

  for (i= 0; i < nR; ++i)
    {
      aLine= "";
      if (i < sizeof(alrLabs))
        aLine~= sprint(sprint("%", iwL, "s"), alrLabs[i]);
 
      for (j= 0; j < nC; ++j)
        if (isnan(mX[i][j]))
          aLine~=" & ";
        else
          aLine~= sprint(" & ", alPrFmt[imod(j, nF)], mX[i][j]);
      if (isfile(fh))
        fprintln (fh, aLine, " \\\\");
      println (aLine, " \\\\");
    }
}


