/*
**  info(const it, const nofexps)
**
**  Inputs:
**    it          integer, number of present iteration (0= initialize)
**    nofexps     integer, total number of iterations to go
**
**  Output:
**                Screen info with number of (elapsed) iterations and
**                elapsed/remaining time
**
**  Author:
**    Charles Bos
**
**  Version:
**    3           Using today() instead of timer(), to get clock time
**
**  Date:
**    24/7/2000
*/
static decl s_info_start= -1, s_info_last= 1;

info(const it, const nofexps)
{
    decl meantime, esttime, tim, timt;
    
    if ((s_info_start == -1) .|| (it == 0))
      {
        /* Initialize */
        s_info_start = today();
      }

    tim= today();
    
    println ("-------------------------------------------------------------");
    println ("   Number of elapsed iterations: ", "%9i", int(it));
    println ("   Number of iterations to go:   ", "%9i", int(nofexps - it));
    println ("   Elapsed time:                 ", "%9s", timespan(s_info_start*100, tim*100));
    
    if (it .!= 0)
      {
        meantime = 100*(tim-s_info_start) / it;
        esttime = meantime * (nofexps - it);
        if (meantime .> 50)
            println("   Time per iteration:           ", "%12.2f", double(meantime/100));
        else
            println("   Time per 100 iterations:      ", "%12.2f", double(meantime));
		if (esttime == 0)
          println("   Estimate of remaining time:   ", "%12s", "0.00"); 
		else
          println("   Estimate of remaining time:   ", 
                  "%12s", timespan(esttime, 0));
      }
    else
      {
        println("   Time per iteration:                     .");
        println("   Estimate of remaining time:             .");
      }
    
}
