/*
**
**  IncData
**
**  Purpose:
**    Include file loading the bmvd_data.txt file
**
**  Date:
**    12/5/2000
**
**  Author:
**    Charles Bos
**
*/

/*
**
**  LoadData(const sDataFile, const mDataFMT, vDataFrac, const bDiff, 
**           const dMult, const amY, const amDMY, const amInter)
**
**  Purpose:
**    Read the data file
**
**  Inputs:
**    sDataFile   Name of the datafile
**    mDataFMT    Format of datafile, with number of columns 
**                in datafile, column containing data (0= first column),
**                column with home interest rate and column with foreign
**                interest rate.
**    vDataFrac   Index of first and last row to be used.
**    bDiff       Boolean, indicating if logdifferences should be taken
**    bInv        Boolean, indicating if home-foreign countries should be switched
**
**  Outputs:
**    amYt        1 x n vector with data, with log-differences taken and 
**                multiplied by 100 for compounded returns
**    amDMY       Matrix 3 x n vector with dates, index number or first column
**                of data file, Day, month, year.
**    amInter     2 x n matrix with home and foreign interest rates
**
*/
LoadData(const sDataFile, const mDataFMT, vDataFrac, 
         const amYt, const amDMY, const amInter, const bDiff, const bInv)
{
  decl x, iT;

  x = loadmat(sDataFile, 1);
  x = reshape(x, rows(x) / mDataFMT[0], mDataFMT[0]);

  x= x[vDataFrac[0]:vDataFrac[1]][];
  println ("Using elements ", vDataFrac[0], ":", vDataFrac[1], " of data.");

  print ("I.e., ", rows(x), " datapoints. Data starts at row containing");
  println ("%10.2f", x[0][]);
  print ("and ends at");
  println ("%10.2f", x[rows(x)-1][]);

  // Choose the right column
  amYt[0] = x[][mDataFMT[1]];
  /* Continuously compounded returns */
  if (bDiff)
    {
      amYt[0] = 100*diff0(log(amYt[0]), 1)[1:]';

      amDMY[0]= x[1:][0:2]';   // Skip one date, as it will be lost 
                             // calculating compounded returns
      amInter[0]= (x[1:][mDataFMT[2]]~x[1:][mDataFMT[3]])';
                             // Skip one date, as it will be lost 
                             // calculating compounded returns
	  if (bInv)
	    {
		  amYt[0]= -amYt[0];
		  amInter[0]= amInter[0][<1, 0>][];
		}
    }
  else
    {
      amYt[0] = amYt[0]';
      amDMY[0]= x[][0:2]';
      amInter[0]= (x[][mDataFMT[2]]~x[][mDataFMT[3]])';
	  if (bInv)
	    {
		  amYt[0]= 1 ./ amYt[0];
		  amInter[0]= amInter[0][<1, 0>][];
		}
    }
  // Turn the order around, to days, months and years
  amDMY[0]= amDMY[0][<2,1,0>][];
}


