/*--------------------------------------------------------------------------
 * gnudraw.h - definitions/declarations for GnuPlot drawinglibrary
 *
 *       (C) Jurgen Doornik 1995
 *       Adapted for GnuPlot by Charles Bos, 2000
 *
 *--------------------------------------------------------------------------*/

#ifndef GNUDRAW_INCLUDED
#define GNUDRAW_INCLUDED

SetTextWindow(const sTitle);

SaveDrawWindow(const sFileName, ...);
SetDrawWindow(const sTitle);
ShowDrawWindow();
CloseDrawWindow();
DrawCorrelogram(const iArea, const vY, const sY, const cLag);
DrawSpectrum(const iArea, const vY, const sY, const iOrder);
DrawDensity(const iArea, const vY, const sY, const fDens,
    const fHist, const fNormal, ...);
DrawQQ(const iArea, const vY, const sY, const iDens, const df1, const df2);
DrawBoxPlot(const iArea, const vY, const sY);

DrawMatrix(const iArea, const mYt, const asY,
           const dXfirst, const dXstep, ...);
DrawTMatrix(const iArea, const mYt, const asY, const mnYear, const mnPeriod, const iFreq, ...);
DrawXMatrix(const iArea, const mYt, const asY,
    const vX, const sX, ...);

Draw(const iArea, const mYt, ...);
DrawT(const iArea, const mYt, const mnYear, const mnPeriod, const iFreq);
DrawX(const iArea, const mYt, const vX);
DrawXYZ(const iArea, const vX, const vY, const mZ, ...);

SetDraw(const iOption, ...);
DrawLine(const iArea, const dX1, const dY1, const dX2, const dY2, ...);
DrawPLine(const iArea, const iX1, const iY1, const iX2, const iY2, const iIndex);
DrawSymbol(const iArea, const dX1, const dY1, const dX2, const dY2,
        const iSymType, const iIndex);
DrawPSymbol(const iArea, const iX1, const iY1, const iX2, const iY2,
        const iSymType, const iIndex);
DrawTitle(const iArea, const sText);
DrawPText(const iArea, const sText, const iPx1, const iPy1, ...);
DrawText(const iArea, const sText, const dX1, const dY1, ...);
DrawLegend(const iArea, const iOffsX, const iOffsY, const fHidden);
DrawAxis(const iArea, const fIsXaxis, const dAnchor,
        const dAxmin, const dAxmax, const dFirstLarge, const dLargeStep,
        const dSmallStep, const iFreq);
DrawAxisAuto(const iArea, const fIsXaxis, ...);
DrawAdjust(const iType, ...);
DrawZ(const vZ, ...);


enum
{   QQ_CHI, QQ_F, QQ_N, QQ_T, QQ_U
};
enum
{
        SET_DEFAULT,   SET_MARGIN,     SET_BOX,
        SET_FONT,      SET_AXIS,       SET_AXISLINE,
        SET_GRID,      SET_LEGEND,     SET_LEGENDHIDE,
        SET_HISTOGRAM, SET_COLOR,      SET_SYMBOL,
        SET_LINE,      SET_COLORMODEL, SET_PRINTPAGE
};
enum
{
        PAGE_A4 = 0,       PAGE_LETTER = 1,   PAGE_USER = 2,
        PAGE_PORTRAIT = 0, PAGE_LANDSCAPE = 1
};
enum
{
    PL_FILLBOX,         /* filled box */
    PL_BOX,             /* open box */
    PL_PLUS,            /* plus */
    PL_DASH,            /* dash */
    PL_CIRCLE,          /* dash */
    PL_NOSYMBOL
};
enum
{
        TP_SOLID,
        TP_DOTTED,
        TP_DASHED,
        TP_LDASHED,
        TP_USER
};
enum
{       ANCHOR_MIN, ANCHOR_MAX, ANCHOR_USER
};
enum
{       ZMODE_NONE = 0, ZMODE_SYMBOL, ZMODE_VALUE, ZMODE_BAR, ZMODE_BAND
};
enum
{
        ADJ_COLOR,      ADJ_SYMBOL,       ADJ_INDEX,
        ADJ_SCALE,      ADJ_MINMAX,       ADJ_AXISHIDE,
        ADJ_AXISLINE,   ADJ_AXISGRID,     ADJ_SYMBOLUSE,
        ADJ_AREA_X,     ADJ_AREA_Y,       ADJ_AREA_P,
        ADJ_AREAMATRIX, ADJ_TEXTROTATION, ADJ_AXISROTATION,
	  ADJ_LABEL,      ADJ_ALIGN,        ADJ_AXES2ND
};

// Actual inclusion of code
#include "include/gnudraw_jae.ox"

#endif /* GNUDRAW_INCLUDED */


