set more off
capt log close
log using  "C:\Documents and Settings\alebleb\Desktop\replication_files\table6ss_oecd", replace

/**This specification includes oecd means.**/

use  "C:\Documents and Settings\alebleb\Desktop\replication_files\pwt61&wdi_75.dta", clear

keep if oecd==1
so xyear country
by xyear: egen mgrgdpw=mean(grgdpw)
by xyear: egen mlki=mean(lki)
by xyear: egen mdlki=mean(dlki)
by xyear: egen mdlki1=mean(dlki1)
by xyear: egen mgrgdpw1=mean(grgdpw1)
by xyear: egen mgrgdpw2=mean(grgdpw2)

so country xyear

/******MLKI, MDLKI, MDLKI1, MGRGDPW, MGRGDPW1, MGRGDPW2*********/

egen country2=group(country)
gen growth=.
gen growth_se=.
gen level=.
gen level_se=.
gen sumbeta=.
gen sumbeta_se=.
gen sumalfa=.
gen sumalfa_se=.
gen b_lki=.
gen lki_se=.
gen b_dlki=.
gen dlki_se=.
gen b_dlki1=.
gen dlki1_se=.



forv j=1/20 {
qui ivreg2 grgdpw  grgdpw2 mlki mdlki mdlki1 mgrgdpw mgrgdpw1 mgrgdpw2 (grgdpw1 dlki1 dlki lki= grgdpw3 grgdpw4 lrgdpw5 lrgdpw6 lki2 lki3 lki4 lki5 lki6 ltrade2 ltrade3 lgov2 lgov3 linfl2 linfl3) if country2==`j', bw(2) ro 

nlcom _b[lki]/(1-_b[grgdpw1]-_b[grgdpw2])
mat gg=r(b)
mat ggse=r(V)
replace growth=gg[1,1] if country2==`j' 
replace growth_se=ggse[1,1] if country2==`j' 

nlcom (_b[dlki]+_b[dlki1])/(1-_b[grgdpw1]-_b[grgdpw2])
mat ll=r(b)
mat llse=r(V)
replace level=ll[1,1] if country2==`j' 
replace level_se=llse[1,1] if country2==`j' 

nlcom (_b[dlki]+_b[dlki1])
mat bb=r(b)
mat bbse=r(V)
replace sumbeta=bb[1,1] if country2==`j' 
replace sumbeta_se=bbse[1,1] if country2==`j' 

nlcom (_b[grgdpw1]+_b[grgdpw2]-1)
mat aa=r(b)
mat aase=r(V)
replace sumalfa=aa[1,1] if country2==`j' 
replace sumalfa_se=aase[1,1] if country2==`j' 

mat kk=_b[lki]
mat kkse=_se[lki]
replace b_lki=kk[1,1] if country2==`j' 
replace lki_se=kkse[1,1] if country2==`j' 

}
collapse growth growth_se level level_se sumbeta sumbeta_se sumalfa sumalfa_se b_lki lki_se b_dlki dlki_se b_dlki1 dlki1_se, by(country)


rreg growth, gen(wtgrowth)
egen sumwtgrowth=sum(wtgrowth)
replace wtgrowth=wtgrowth/sumwtgrowth
gen tempvar_growth=(growth_se)*(wtgrowth^2)
egen sumtempvar_growth=sum(tempvar_growth)
gen rse_growth=sqrt(sumtempvar_growth)
su rse_growth
gen coeff_growth=_b[_cons]
gen t_growth=coeff_growth/rse_growth
su t_growth
tabstat growth, st(p50) 


rreg level, gen(wtlevel)
egen sumwtlevel=sum(wtlevel)
replace wtlevel=wtlevel/sumwtlevel
gen tempvar_level=(level_se)*(wtlevel^2)
egen sumtempvar_level=sum(tempvar_level)
gen rse_level=sqrt(sumtempvar_level)
su rse_level
gen coeff_level=_b[_cons]
gen t_level=coeff_level/rse_level
su t_level
tabstat level, st(p50) 




rreg sumalfa, gen(wtalfa)
egen sumwtalfa=sum(wtalfa)
replace wtalfa=wtalfa/sumwtalfa
gen tempvar_alfa=(sumalfa_se)*(wtalfa^2)
egen sumtempvar_alfa=sum(tempvar_alfa)
gen rse_alfa=sqrt(sumtempvar_alfa)
su rse_alfa
gen coeff_alfa=_b[_cons]
gen t_alfa=coeff_alfa/rse_alfa
su t_alfa
tabstat sumalfa, st(p50)


rreg sumbeta, gen(wtbeta)
egen sumwtbeta=sum(wtbeta)
replace wtbeta=wtbeta/sumwtbeta
gen tempvar_beta=(sumbeta_se)*(wtbeta^2)
egen sumtempvar_beta=sum(tempvar_beta)
gen rse_beta=sqrt(sumtempvar_beta)
su rse_beta
gen coeff_beta=_b[_cons]
gen t_beta=coeff_beta/rse_beta
su t_beta
tabstat sumbeta, st(p50)



rreg b_lki, gen(wtlki)
egen sumwtlki=sum(wtlki)
replace wtlki=wtlki/sumwtlki
gen tempvar_lki=(lki_se^2)*(wtlki^2)
egen sumtempvar_lki=sum(tempvar_lki)
gen rse_lki=sqrt(sumtempvar_lki)
su rse_lki
gen coeff_lki=_b[_cons]
gen t_lki=coeff_lki/rse_lki
su t_lki
tabstat b_lki, st(p50)




log close





