set more off
capt log close
log using "C:\Documents and Settings\alebleb\Desktop\replication_files\table5ss_nonoecd", replace



use "C:\Documents and Settings\alebleb\Desktop\replication_files\deviations_nonoecd55.dta", clear


egen country2=group(country)
gen growth=.
gen growth_se=.
gen level=.
gen level_se=.
gen sumbeta=.
gen sumbeta_se=.
gen sumalfa=.
gen sumalfa_se=.
gen lki=.
gen lki_se=.
gen dlki=.
gen dlki_se=.
gen dlki1=.
gen dlki1_se=.


forv j=1/55 {
qui ivreg2 vgrgdpw  vgrgdpw2 (vgrgdpw1 vdlki1 vdlki vlki= vgrgdpw3 vgrgdpw4 vlrgdpw5 vlrgdpw6 vlki2 vlki3 vlki4 vlki5 vlki6 vltrade2 vltrade3 vlgov2 vlgov3 vlinfl2 vlinfl3) if country2==`j', bw(2) ro 

nlcom _b[vlki]/(1-_b[vgrgdpw1]-_b[vgrgdpw2])
mat gg=r(b)
mat ggse=r(V)
replace growth=gg[1,1] if country2==`j' 
replace growth_se=ggse[1,1] if country2==`j' 

nlcom (_b[vdlki]+_b[vdlki1])/(1-_b[vgrgdpw1]-_b[vgrgdpw2])
mat ll=r(b)
mat llse=r(V)
replace level=ll[1,1] if country2==`j' 
replace level_se=llse[1,1] if country2==`j' 

nlcom (_b[vdlki]+_b[vdlki1])
mat bb=r(b)
mat bbse=r(V)
replace sumbeta=bb[1,1] if country2==`j' 
replace sumbeta_se=bbse[1,1] if country2==`j' 

nlcom (_b[vgrgdpw1]+_b[vgrgdpw2]-1)
mat aa=r(b)
mat aase=r(V)
replace sumalfa=aa[1,1] if country2==`j' 
replace sumalfa_se=aase[1,1] if country2==`j' 

mat kk=_b[vlki]
mat kkse=_se[vlki]
replace lki=kk[1,1] if country2==`j' 
replace lki_se=kkse[1,1] if country2==`j' 

mat xx=_b[vdlki]
mat xxse=_se[vdlki]
replace dlki=xx[1,1] if country2==`j' 
replace dlki_se=xxse[1,1] if country2==`j' 

mat qq=_b[vdlki1]
mat qqse=_se[vdlki1]
replace dlki1=qq[1,1] if country2==`j' 
replace dlki1_se=qqse[1,1] if country2==`j' 


}

collapse growth growth_se level level_se sumbeta sumbeta_se sumalfa sumalfa_se lki lki_se dlki dlki_se dlki1 dlki1_se , by(country)

rreg growth, gen(wtgrowth)
egen sumwtgrowth=sum(wtgrowth)
replace wtgrowth=wtgrowth/sumwtgrowth
gen tempvar_growth=(growth_se)*(wtgrowth^2)
egen sumtempvar_growth=sum(tempvar_growth)
gen rse_growth=sqrt(sumtempvar_growth)
su rse_growth
gen coeff_growth=_b[_cons]
gen t_growth=coeff_growth/rse_growth
su t_growth
tabstat growth, st(p50)



rreg level, gen(wtlevel)
egen sumwtlevel=sum(wtlevel)
replace wtlevel=wtlevel/sumwtlevel
gen tempvar_level=(level_se)*(wtlevel^2)
egen sumtempvar_level=sum(tempvar_level)
gen rse_level=sqrt(sumtempvar_level)
su rse_level
gen coeff_level=_b[_cons]
gen t_level=coeff_level/rse_level
su t_level
tabstat level, st(p50)


rreg sumalfa, gen(wtalfa)
egen sumwtalfa=sum(wtalfa)
replace wtalfa=wtalfa/sumwtalfa
gen tempvar_alfa=(sumalfa_se)*(wtalfa^2)
egen sumtempvar_alfa=sum(tempvar_alfa)
gen rse_alfa=sqrt(sumtempvar_alfa)
su rse_alfa
gen coeff_alfa=_b[_cons]
gen t_alfa=coeff_alfa/rse_alfa
su t_alfa
tabstat sumalfa, st(p50)



rreg sumbeta, gen(wtbeta)
egen sumwtbeta=sum(wtbeta)
replace wtbeta=wtbeta/sumwtbeta
gen tempvar_beta=(sumbeta_se)*(wtbeta^2)
egen sumtempvar_beta=sum(tempvar_beta)
gen rse_beta=sqrt(sumtempvar_beta)
su rse_beta
gen coeff_beta=_b[_cons]
gen t_beta=coeff_beta/rse_beta
su t_beta
tabstat sumbeta, st(p50)



rreg lki, gen(wtlki)
egen sumwtlki=sum(wtlki)
replace wtlki=wtlki/sumwtlki
gen tempvar_lki=(lki_se^2)*(wtlki^2)
egen sumtempvar_lki=sum(tempvar_lki)
gen rse_lki=sqrt(sumtempvar_lki)
su rse_lki
gen coeff_lki=_b[_cons]
gen t_lki=coeff_lki/rse_lki
su t_lki
tabstat lki, st(p50)



log close
